/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.jmx;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.JMXActionRenderer;
import io.intino.konos.builder.codegeneration.services.jmx.JMXServerTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Data;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Parameter;
import io.intino.konos.model.Service;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class JMXOperationsServiceRenderer
extends Renderer {
    private final List<Service.JMX> services;

    public JMXOperationsServiceRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext, Target.Owner);
        this.services = graph.serviceList(Service::isJMX).map(Service::asJMX).collect(Collectors.toList());
    }

    @Override
    public void render() throws KonosException {
        for (Service.JMX service : this.services) {
            this.createInterface(service);
            this.createImplementation(service);
            this.createCorrespondingActions(service.operationList());
        }
    }

    private void createInterface(Service.JMX service) {
        FrameBuilder builder = new FrameBuilder(new String[]{"jmx", "interface"}).add("name", (Object)service.name$()).add("package", (Object)this.packageName()).add("box", (Object)this.boxName());
        if (!service.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()));
        }
        for (Service.JMX.Operation operation : service.operationList()) {
            builder.add("operation", (Object)this.frameOf(operation));
        }
        Commons.writeFrame(this.genPackage(), service.name$() + "MBean", this.template().render((Object)builder));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(service), Commons.javaFile(this.genPackage(), service.name$() + "MBean").getAbsolutePath()));
    }

    private void createImplementation(Service.JMX service) {
        FrameBuilder builder = new FrameBuilder(new String[]{"jmx", "implementation"}).add("name", (Object)service.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).add("operation", service.operationList().stream().map(this::frameOf).toArray(Frame[]::new));
        Commons.writeFrame(this.genPackage(), service.name$(), this.template().render((Object)builder));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(service), Commons.javaFile(this.genPackage(), service.name$()).getAbsolutePath()));
    }

    private void createCorrespondingActions(List<Service.JMX.Operation> operations) throws KonosException {
        for (Service.JMX.Operation operation : operations) {
            new JMXActionRenderer(this.context, operation).execute();
        }
    }

    private Frame frameOf(Service.JMX.Operation operation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"operation"}).add("name", (Object)operation.name$()).add("action", (Object)operation.name$()).add("package", (Object)this.packageName()).add("returnType", (Object)this.returnType(operation));
        builder.add("description", (Object)operation.description());
        this.setupParameters(operation.parameterList(), builder);
        return builder.toFrame();
    }

    private Frame returnType(Service.JMX.Operation operation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"returnType"}).add("value", (Object)(operation.response() == null ? "void" : this.formatType(operation.response().asType())));
        if (operation.response() != null && operation.response().i$(Data.List.class)) {
            builder.add("list");
        }
        return builder.toFrame();
    }

    private String formatType(Data.Type typeData) {
        return (String)(typeData.i$(Data.Object.class) ? this.packageName() + ".schemas." : "") + typeData.type();
    }

    private void setupParameters(List<Parameter> parameters, FrameBuilder builder) {
        for (Parameter parameter : parameters) {
            FrameBuilder parameterBuilder = new FrameBuilder(new String[]{"parameter"}).add("name", (Object)parameter.name$()).add("type", (Object)this.formatType(parameter.asType()));
            if (parameter.i$(Data.List.class)) {
                parameterBuilder.add("list");
            }
            builder.add("parameter", (Object)parameterBuilder.toFrame());
        }
    }

    private Template template() {
        return Formatters.customize(new JMXServerTemplate());
    }

    private File genPackage() {
        return new File(this.gen(), "jmx");
    }
}

