/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRendererFactory;
import io.intino.konos.builder.codegeneration.ui.passiveview.PassiveViewRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.CatalogComponents;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.DataComponents;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.Editable;
import io.intino.konos.model.graph.HelperComponents;
import io.intino.konos.model.graph.InteractionComponents;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Multiple;
import io.intino.konos.model.graph.OtherComponents;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.Template;
import io.intino.magritte.framework.Layer;

public abstract class BaseDisplayRenderer<D extends Display>
extends PassiveViewRenderer<D> {
    private static final ComponentRendererFactory factory = new ComponentRendererFactory();

    protected BaseDisplayRenderer(CompilationContext context, D display, TemplateProvider templateProvider, Target target) {
        super(context, display, templateProvider, target);
    }

    @Override
    public void render() {
        if (this.element == null) {
            return;
        }
        String path = this.path((Display)this.element);
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)((Display)this.element).name$());
        this.classes().put("Display#" + ((Display)this.element).name$(), path + "." + newDisplay);
        FrameBuilder result = this.buildFrame();
        this.createPassiveViewFiles(result);
        this.write(result);
        if (((Display)this.element).isAccessible()) {
            this.writeDisplaysFor(((Display)this.element).asAccessible(), this.buildFrame(true));
        }
    }

    @Override
    public FrameBuilder buildFrame() {
        return this.buildFrame(false);
    }

    @Override
    public FrameBuilder buildFrame(boolean accessible) {
        FrameBuilder result = super.buildFrame(accessible);
        result.add("display");
        result.add(this.typeOf(this.element));
        if (accessible) {
            result.add("accessible");
        }
        if (!this.hasAbstractClass(this.element)) {
            result.add("noAbstract");
        }
        this.addParametrized(result, accessible);
        this.addExtends(result, accessible);
        this.addImports(result, accessible);
        this.addImplements(result);
        this.addMethods(result);
        this.addRenderTagFrames(result);
        this.addDecoratedFrames(result);
        this.addAccessibleFrames(result, accessible);
        result.add("notifier", (Object)this.notifierName(this.element));
        result.add("requester", (Object)this.requesterName(this.element));
        result.add("componentType", ((Display)this.element).components().stream().map(this::typeOf).distinct().map(type -> new FrameBuilder().add("componentType", type).toFrame()).toArray(Frame[]::new));
        if (((Display)this.element).parentDisplay() != null) {
            this.addParent((Display)this.element, result);
        }
        if (!((Display)this.element).graph().schemaList().isEmpty()) {
            result.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()));
        }
        if (((Display)this.element).isAccessible()) {
            result.add("parameter", ((Display)this.element).asAccessible().parameters().stream().map(p -> new FrameBuilder(new String[]{"parameter", "accessible"}).add("value", p).toFrame()).toArray(Frame[]::new));
        }
        return result;
    }

    private void addParametrized(FrameBuilder frame, boolean accessible) {
        FrameBuilder result = new FrameBuilder(new String[]{"parametrized"});
        result.add("name", (Object)((Display)this.element).name$());
        result.add("notifier", (Object)(((Display)this.element).i$(Template.class) ? "Template" : ((Display)this.element).name$()));
        this.addGeneric((PassiveView)this.element, result);
        if (!accessible && ((Display)this.element).isAccessible()) {
            result.add("accessible");
        }
        this.addDecoratedFrames(result);
        frame.add("parametrized", (Object)result.toFrame());
    }

    private void addExtends(FrameBuilder frame, boolean accessible) {
        String itemClass;
        FrameBuilder result = new FrameBuilder(new String[]{"displayExtends"});
        if (((Display)this.element).i$(OtherComponents.Dialog.class)) {
            result.add(OtherComponents.Dialog.class.getSimpleName());
        }
        if (((Display)this.element).i$(Template.class)) {
            result.add(Template.class.getSimpleName());
        }
        if (((Display)this.element).i$(CatalogComponents.List.class) || ((Display)this.element).i$(CatalogComponents.Magazine.class) || ((Display)this.element).i$(CatalogComponents.Table.class) || ((Display)this.element).i$(CatalogComponents.Map.class) || ((Display)this.element).i$(CatalogComponents.DynamicTable.class)) {
            result.add("collection");
        }
        if (((Display)this.element).i$(CatalogComponents.Table.class)) {
            result.add(CatalogComponents.Table.class.getSimpleName());
        }
        if (((Display)this.element).i$(CatalogComponents.DynamicTable.class)) {
            result.add(CatalogComponents.DynamicTable.class.getSimpleName());
        }
        if (((Display)this.element).i$(CatalogComponents.Collection.Mold.Item.class)) {
            result.add(CatalogComponents.Collection.Mold.Item.class.getSimpleName());
        }
        if (((Display)this.element).i$(HelperComponents.Row.class)) {
            result.add(HelperComponents.Row.class.getSimpleName());
        }
        if (!accessible && ((Display)this.element).isAccessible()) {
            result.add("accessible");
        }
        this.addGeneric((PassiveView)this.element, result);
        result.add("type", (Object)this.typeOf(this.element));
        this.addDecoratedFrames(result);
        if (((Display)this.element).i$(Template.class)) {
            String modelClass = ((Template)((Display)this.element).a$(Template.class)).modelClass();
            result.add("modelClass", (Object)(modelClass != null ? modelClass : "java.lang.Void"));
        }
        if (((Display)this.element).i$(CatalogComponents.Collection.class)) {
            CatalogComponents.Collection.Mold mold = ((CatalogComponents.Collection)((Display)this.element).a$(CatalogComponents.Collection.class)).mold(0);
            String itemClass2 = ((CatalogComponents.Collection)((Display)this.element).a$(CatalogComponents.Collection.class)).itemClass();
            result.add("componentType", (Object)Formatters.firstUpperCase(this.nameOf(mold.item())));
            result.add("itemClass", (Object)(itemClass2 != null ? itemClass2 : "java.lang.Void"));
        }
        if (((Display)this.element).i$(CatalogComponents.Collection.Mold.Item.class)) {
            itemClass = ((CatalogComponents.Collection)((CatalogComponents.Collection.Mold.Item)((Display)this.element).a$(CatalogComponents.Collection.Mold.Item.class)).core$().ownerAs(CatalogComponents.Collection.class)).itemClass();
            result.add("itemClass", (Object)(itemClass != null ? itemClass : "java.lang.Void"));
        }
        if (((Display)this.element).i$(HelperComponents.Row.class)) {
            itemClass = ((CatalogComponents.Collection)((HelperComponents.Row)((Display)this.element).a$(HelperComponents.Row.class)).items(0).core$().ownerAs(CatalogComponents.Collection.class)).itemClass();
            result.add("itemClass", (Object)(itemClass != null ? itemClass : "java.lang.Void"));
        }
        result.add("name", (Object)this.nameOf(this.element));
        frame.add("displayExtends", (Object)result);
    }

    private void addImports(FrameBuilder frame, boolean accessible) {
        KonosGraph graph = ((Display)this.element).graph();
        if (graph.templateList().size() > 0) {
            frame.add("templatesImport", (Object)this.buildBaseFrame().add("templatesImport"));
        }
        if (graph.blockList().size() > 0) {
            frame.add("blocksImport", (Object)this.buildBaseFrame().add("blocksImport"));
        }
        if (graph.itemsDisplays(this.context.graphName()).size() > 0) {
            frame.add("itemsImport", (Object)this.buildBaseFrame().add("itemsImport"));
        }
        if (graph.rowsDisplays(this.context.graphName()).size() > 0) {
            frame.add("rowsImport", (Object)this.buildBaseFrame().add("rowsImport"));
        }
        if (graph.tablesDisplays(this.context.graphName()).size() > 0) {
            frame.add("tablesImport", (Object)this.buildBaseFrame().add("tablesImport"));
        }
        if (graph.listsDisplays(this.context.graphName()).size() > 0) {
            frame.add("listsImport", (Object)this.buildBaseFrame().add("listsImport"));
        }
        if (graph.magazinesDisplays(this.context.graphName()).size() > 0) {
            frame.add("magazinesImport", (Object)this.buildBaseFrame().add("magazinesImport"));
        }
        if (graph.mapsDisplays(this.context.graphName()).size() > 0) {
            frame.add("mapsImport", (Object)this.buildBaseFrame().add("mapsImport"));
        }
        if (graph.dynamicTablesDisplays(this.context.graphName()).size() > 0) {
            frame.add("dynamicTablesImport", (Object)this.buildBaseFrame().add("dynamicTablesImport"));
        }
        frame.add("notifierImport", (Object)this.notifierImportFrame((Display)this.element, accessible));
        if (!ElementHelper.isRoot(this.componentOf((PassiveView)this.element)) || ((Display)this.element).isAccessible() && accessible) {
            frame.add("displayRegistration", (Object)this.displayRegistrationFrame(accessible));
        }
        frame.add("requesterDirectory", (Object)(this.typeOf(this.element).equalsIgnoreCase("Display") || this.typeOf(this.element).equalsIgnoreCase("Display") ? "." : ".."));
        frame.add("notifierDirectory", (Object)(this.typeOf(this.element).equalsIgnoreCase("Display") ? "." : ".."));
    }

    private FrameBuilder displayRegistrationFrame(boolean accessible) {
        FrameBuilder result = this.buildBaseFrame().add("displayRegistration");
        if (((Display)this.element).isAccessible() && accessible) {
            result.add("accessible");
        }
        return result.add("name", (Object)this.nameOf(this.element));
    }

    protected void addImplements(FrameBuilder frame) {
        if (((Display)this.element).i$(Component.DynamicLoaded.class)) {
            frame.add("implements", (Object)new FrameBuilder(new String[]{"implements", Component.DynamicLoaded.class.getSimpleName()}));
        }
        if (((Display)this.element).i$(CatalogComponents.Collection.Selectable.class)) {
            frame.add("implements", (Object)new FrameBuilder(new String[]{"implements", CatalogComponents.Collection.Selectable.class.getSimpleName()}));
        }
        if (((Display)this.element).i$(Multiple.class)) {
            FrameBuilder result = this.multipleImplements();
            if (((Multiple)((Display)this.element).a$(Multiple.class)).collapsed()) {
                result.add("collapsable");
            }
            frame.add("implements", (Object)result);
        }
        if ((((Display)this.element).i$(InteractionComponents.Actionable.Action.class) || ((Display)this.element).i$(InteractionComponents.Actionable.OpenLayer.class)) && ((Display)this.element).i$(InteractionComponents.Actionable.Addressable.class)) {
            frame.add("implements", (Object)new FrameBuilder(new String[]{"implements", InteractionComponents.Actionable.Action.class.getSimpleName(), InteractionComponents.Actionable.Addressable.class.getSimpleName()}).add("name", (Object)this.nameOf(this.element)));
        }
        if (((Display)this.element).i$(OtherComponents.Selector.Addressable.class)) {
            frame.add("implements", (Object)new FrameBuilder(new String[]{"implements", OtherComponents.Selector.class.getSimpleName(), OtherComponents.Selector.Addressable.class.getSimpleName()}).add("name", (Object)this.nameOf(this.element)));
        }
        if (((Display)this.element).i$(CatalogComponents.SearchBox.Addressable.class)) {
            frame.add("implements", (Object)new FrameBuilder(new String[]{"implements", CatalogComponents.SearchBox.class.getSimpleName(), CatalogComponents.SearchBox.Addressable.class.getSimpleName()}).add("name", (Object)this.nameOf(this.element)));
        }
        if (((Display)this.element).i$(CatalogComponents.Grouping.Addressable.class)) {
            frame.add("implements", (Object)new FrameBuilder(new String[]{"implements", CatalogComponents.Grouping.class.getSimpleName(), CatalogComponents.Grouping.Addressable.class.getSimpleName()}).add("name", (Object)this.nameOf(this.element)));
        }
        if (((Display)this.element).i$(CatalogComponents.Sorting.Addressable.class)) {
            frame.add("implements", (Object)new FrameBuilder(new String[]{"implements", CatalogComponents.Sorting.class.getSimpleName(), CatalogComponents.Sorting.Addressable.class.getSimpleName()}).add("name", (Object)this.nameOf(this.element)));
        }
    }

    private FrameBuilder multipleImplements() {
        FrameBuilder result = new FrameBuilder(new String[]{"implements", Multiple.class.getSimpleName()});
        this.addDecoratedFrames(result);
        String objectType = this.multipleObjectType(this.element);
        result.add("componentType", (Object)this.multipleComponentType(this.element));
        result.add("componentName", (Object)this.multipleComponentName(this.element));
        if (!this.isMultipleSpecificComponent(this.element) && ((Display)this.element).i$(Editable.class)) {
            result.add("componentPrefix", (Object)this.nameOf(this.element));
        }
        if (objectType != null) {
            result.add("objectType", (Object)objectType);
        }
        return result;
    }

    protected String multipleObjectType(Layer element) {
        if (element.i$(DataComponents.Text.Multiple.class)) {
            return "java.lang.String";
        }
        if (element.i$(DataComponents.File.Multiple.class)) {
            return "io.intino.alexandria.ui.File";
        }
        if (element.i$(DataComponents.Image.Multiple.class)) {
            return "io.intino.alexandria.ui.File";
        }
        if (element.i$(OtherComponents.BaseIcon.Multiple.class)) {
            return "java.net.URL";
        }
        if (element.i$(DataComponents.Number.Multiple.class)) {
            return "java.lang.Double";
        }
        if (element.i$(DataComponents.Date.Multiple.class)) {
            return "java.time.Instant";
        }
        if (element.i$(OtherComponents.BaseStamp.Multiple.class)) {
            String modelClass = null;
            if (element.i$(OtherComponents.OwnerTemplateStamp.class)) {
                modelClass = "java.lang.Void";
            } else if (element.i$(OtherComponents.TemplateStamp.class)) {
                modelClass = ((OtherComponents.TemplateStamp)element.a$(OtherComponents.TemplateStamp.class)).template() != null ? ((OtherComponents.TemplateStamp)element.a$(OtherComponents.TemplateStamp.class)).template().modelClass() : null;
            }
            return modelClass != null ? modelClass : "java.lang.Void";
        }
        if (element.i$(Block.Multiple.class)) {
            return "java.lang.Void";
        }
        return null;
    }

    protected String multipleComponentType(Layer element) {
        String prefix = "io.intino.alexandria.ui.displays.components.";
        String name = this.multipleComponentName(element);
        if (name == null) {
            return null;
        }
        return element.i$(OtherComponents.BaseStamp.Multiple.class) || element.i$(Block.Multiple.class) ? name : prefix + name;
    }

    protected String multipleComponentName(Layer element) {
        String editable;
        String string = editable = element.i$(Editable.class) ? "Editable" : "";
        if (element.i$(DataComponents.Text.Multiple.class)) {
            return "Text" + editable;
        }
        if (element.i$(DataComponents.File.Multiple.class)) {
            return "File" + editable;
        }
        if (element.i$(DataComponents.Image.Multiple.class)) {
            return "Image" + editable;
        }
        if (element.i$(OtherComponents.BaseIcon.Multiple.class)) {
            return "Icon" + editable;
        }
        if (element.i$(DataComponents.Number.Multiple.class)) {
            return "Number" + editable;
        }
        if (element.i$(DataComponents.Date.Multiple.class)) {
            return "Date" + editable;
        }
        if (element.i$(OtherComponents.BaseStamp.Multiple.class)) {
            if (element.i$(OtherComponents.OwnerTemplateStamp.class)) {
                OtherComponents.OwnerTemplateStamp stamp = (OtherComponents.OwnerTemplateStamp)element.a$(OtherComponents.OwnerTemplateStamp.class);
                return this.ownerTemplateStampPackage(stamp.owner()) + "." + Formatters.firstUpperCase(stamp.template());
            }
            return element.i$(OtherComponents.TemplateStamp.class) ? Formatters.firstUpperCase(((OtherComponents.TemplateStamp)element.a$(OtherComponents.TemplateStamp.class)).template().name$()) : "io.intino.alexandria.ui.Display";
        }
        if (element.i$(Block.Multiple.class)) {
            return Formatters.firstUpperCase(this.nameOf(element));
        }
        return null;
    }

    protected boolean isMultipleSpecificComponent(Layer element) {
        return element.i$(OtherComponents.BaseStamp.Multiple.class) || element.i$(Block.Multiple.class);
    }

    protected String ownerTemplateStampPackage(Service.UI.Use use) {
        return use.package$() + ".box.ui.displays.templates";
    }

    protected void addMethods(FrameBuilder frame) {
        if (((Display)this.element).i$(Component.DynamicLoaded.class)) {
            frame.add("baseMethod", (Object)"renderDynamicLoaded");
            frame.add("methods", (Object)new FrameBuilder(new String[]{"methods", Component.DynamicLoaded.class.getSimpleName()}).add("loadTime", (Object)((Component.DynamicLoaded)((Display)this.element).a$(Component.DynamicLoaded.class)).loadTime().name()));
        } else if (((Display)this.element).i$(OtherComponents.Dialog.class)) {
            frame.add("baseMethod", (Object)"renderDialog");
        } else if (((Display)this.element).i$(HelperComponents.Row.class)) {
            frame.add("baseMethod", (Object)"renderRow");
        }
    }

    protected void addRenderTagFrames(FrameBuilder frame) {
        FrameBuilder renderTag = new FrameBuilder(new String[]{"renderTag"});
        if (((Display)this.element).i$(Block.class)) {
            ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.context, (Component)((Display)this.element).a$(Block.class), this.templateProvider, this.target);
            renderTag.add(Block.class.getSimpleName());
            renderTag.add("properties", (Object)renderer.properties());
        } else if (((Display)this.element).i$(Template.class)) {
            ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.context, (Component)((Display)this.element).a$(Template.class), this.templateProvider, this.target);
            renderTag.add(Template.class.getSimpleName());
            renderTag.add("properties", (Object)renderer.properties());
        } else if (((Display)this.element).i$(HelperComponents.Row.class)) {
            ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.context, (Component)((Display)this.element).a$(HelperComponents.Row.class), this.templateProvider, this.target);
            renderTag.add(HelperComponents.Row.class.getSimpleName());
            renderTag.add("properties", (Object)renderer.properties());
        } else if (((Display)this.element).i$(CatalogComponents.Collection.Mold.Item.class)) {
            renderTag.add(CatalogComponents.Collection.Mold.Item.class.getSimpleName());
        }
        frame.add("renderTag", (Object)renderTag);
    }

    protected void addDecoratedFrames(FrameBuilder frame) {
        this.addDecoratedFrames(frame, ElementHelper.isRoot(this.element));
    }

    protected void addDecoratedFrames(FrameBuilder frame, boolean decorated) {
        boolean isAbstract;
        boolean bl = isAbstract = decorated && !((Display)this.element).i$(OtherComponents.TemplateStamp.class) && !((Display)this.element).i$(OtherComponents.OwnerTemplateStamp.class) && !((Display)this.element).i$(OtherComponents.ProxyStamp.class);
        if (isAbstract) {
            frame.add("abstract", (Object)"Abstract");
        } else {
            frame.add("notDecorated", (Object)((Display)this.element).name$());
        }
        FrameBuilder abstractBoxFrame = new FrameBuilder().add("box");
        if (isAbstract) {
            abstractBoxFrame.add("decorated");
        }
        abstractBoxFrame.add("box", (Object)this.boxName());
        if (this.belongsToAccessible((Display)this.element)) {
            abstractBoxFrame.add("accessible");
        }
        frame.add("abstractBox", (Object)abstractBoxFrame);
    }

    protected void addAccessibleFrames(FrameBuilder frame, boolean accessibleDisplay) {
        FrameBuilder frameBuilder = this.accessibleNotifierImportFrame();
        if (accessibleDisplay) {
            frame.add("accessibleNotifierImport", (Object)frameBuilder);
            return;
        }
        boolean accessible = ((Display)this.element).isAccessible();
        if (!accessible) {
            frame.add("accessibleNotifierImport", (Object)frameBuilder);
            return;
        }
        frame.add("accessibleNotifier", (Object)this.buildBaseFrame().add("name", (Object)this.nameOf(this.element)));
        frame.add("accessibleNotifierImport", (Object)frameBuilder.add("accessible"));
        frame.add("notifyProxyMethod", (Object)this.buildBaseFrame().add("notifyProxyMethod"));
    }

    private FrameBuilder accessibleNotifierImportFrame() {
        FrameBuilder frameBuilder = this.buildBaseFrame().add("accessibleNotifierImport").add("name", (Object)this.nameOf(this.element));
        frameBuilder.add("notifier", (Object)this.notifierName(this.element));
        if (this.context.webModuleDirectory().exists()) {
            frameBuilder.add("webModuleName", (Object)this.context.webModuleDirectory().getName());
        }
        return frameBuilder;
    }

    protected FrameBuilder componentFrame(Component component, Display virtualParent) {
        ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.context, component, this.templateProvider, this.target);
        renderer.buildChildren(true);
        renderer.decorated(ElementHelper.isRoot(this.element));
        renderer.owner((Display)this.element);
        renderer.virtualParent(virtualParent);
        return renderer.buildFrame();
    }

    protected void addComponent(Component component, Display virtualParent, FrameBuilder builder) {
        builder.add("component", (Object)this.componentFrame(component, virtualParent));
    }

    protected boolean belongsToAccessible(Display element) {
        if (element.isAccessible()) {
            return true;
        }
        Display owner = (Display)element.core$().ownerAs(Display.class);
        while (owner != null) {
            if (owner.isAccessible()) {
                return true;
            }
            owner = (Display)owner.core$().ownerAs(Display.class);
        }
        return false;
    }

    private void writeDisplaysFor(Display.Accessible display, FrameBuilder builder) {
        this.write(builder);
        this.writeNotifier((PassiveView)display.a$(PassiveView.class), builder);
        this.writeRequester((PassiveView)display.a$(PassiveView.class), builder);
    }

    private void addParent(Display display, FrameBuilder builder) {
        String parent = this.parent();
        FrameBuilder parentFrame = new FrameBuilder().add("value", (Object)display.parentDisplay()).add("dsl", (Object)parent).add("package", (Object)parent.substring(0, parent.lastIndexOf(".")));
        builder.add("parent", (Object)parentFrame.toFrame());
    }
}

