/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos;

import io.intino.konos.CompilationInfoExtractor;
import io.intino.konos.CompilerMessage;
import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.builder.KonosCompiler;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.compiler.shared.KonosBuildConstants;
import io.intino.konos.compiler.shared.PostCompileActionMessage;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;

class KonosCompilerRunner {
    private static final Logger LOG = Logger.getGlobal();
    private final boolean verbose;
    private PrintStream out = System.out;

    KonosCompilerRunner(boolean verbose) {
        this.verbose = verbose;
    }

    void run(File argsFile) {
        CompilerConfiguration config = new CompilerConfiguration();
        LinkedHashMap<File, Boolean> sources = new LinkedHashMap<File, Boolean>();
        CompilationInfoExtractor.getInfoFromArgsFile(argsFile, config, sources);
        config.setVerbose(this.verbose);
        config.out(System.out);
        this.out = config.out();
        if (sources.isEmpty()) {
            return;
        }
        if (this.verbose) {
            this.out.println("@#$%@# Presentable:Konosc: loading sources...");
        }
        ArrayList<CompilerMessage> messages = new ArrayList<CompilerMessage>();
        ArrayList<PostCompileActionMessage> postCompileActionMessages = new ArrayList<PostCompileActionMessage>();
        List<OutputItem> compiled = this.compile(config, sources, messages, postCompileActionMessages);
        if (this.verbose) {
            this.report(sources, compiled);
        }
        this.processErrors(messages);
        if (messages.stream().noneMatch(m -> m.getCategory().equalsIgnoreCase("error"))) {
            this.processActions(postCompileActionMessages);
        }
        this.out.println();
        this.out.print("%end%");
    }

    private List<OutputItem> compile(CompilerConfiguration config, Map<File, Boolean> sources, List<CompilerMessage> messages, List<PostCompileActionMessage> postCompileActionMessages) {
        if (!sources.containsValue(false) && config.mode().equals((Object)KonosBuildConstants.Mode.Normal)) {
            KonosCompilerRunner.cleanOut(config);
        }
        return new ArrayList<OutputItem>(this.compileSources(config, sources, messages, postCompileActionMessages));
    }

    private List<OutputItem> compileSources(CompilerConfiguration config, Map<File, Boolean> sources, List<CompilerMessage> messages, List<PostCompileActionMessage> postCompileActionMessages) {
        List<OutputItem> outputItems = new KonosCompiler(config, messages, postCompileActionMessages).compile(new ArrayList<File>(sources.keySet()));
        this.out.println();
        return outputItems;
    }

    private void report(Map<File, Boolean> srcFiles, List<OutputItem> compiled) {
        if (compiled.isEmpty()) {
            this.reportNotCompiledItems(srcFiles);
        } else {
            this.reportCompiledItems(compiled, srcFiles);
        }
        this.out.println();
    }

    private void processErrors(List<CompilerMessage> compilerMessages) {
        int errorCount = 0;
        for (CompilerMessage message : compilerMessages) {
            if (message.getCategory().equals("error")) {
                if (errorCount > 100) continue;
                ++errorCount;
            }
            this.printMessage(message);
        }
    }

    private void processActions(List<PostCompileActionMessage> postCompileActionMessages) {
        if (!postCompileActionMessages.isEmpty()) {
            this.out.print("%%postaction%%");
            postCompileActionMessages.forEach(this::printMessage);
            this.out.print("/%postaction%%");
        }
    }

    private void printMessage(CompilerMessage message) {
        this.out.print("%%m");
        this.out.print(message.getCategory());
        this.out.print("#%%#%%%#%%%%%%%%%#");
        this.out.print(message.getMessage());
        this.out.print("#%%#%%%#%%%%%%%%%#");
        this.out.print(message.getUrl());
        this.out.print("#%%#%%%#%%%%%%%%%#");
        this.out.print(message.getLineNum());
        this.out.print("#%%#%%%#%%%%%%%%%#");
        this.out.print(message.getColumnNum());
        this.out.print("#%%#%%%#%%%%%%%%%#");
        this.out.print("/%m");
        this.out.println();
    }

    private void printMessage(PostCompileActionMessage message) {
        this.out.print("%%action");
        this.out.print(message.toString());
        this.out.print("/%action");
        this.out.println();
    }

    private void reportCompiledItems(List<OutputItem> compiledFiles, Map<File, Boolean> srcFiles) {
        for (OutputItem compiledFile : compiledFiles) {
            this.out.print("%%c");
            this.out.print(compiledFile.getOutputPath());
            this.out.print("#%%#%%%#%%%%%%%%%#");
            this.out.print(new File(compiledFile.getSourcePath()).isFile() ? compiledFile.getSourcePath() : srcFiles.keySet().iterator().next().getAbsolutePath());
            this.out.print("/%c");
            this.out.println();
        }
    }

    private void reportNotCompiledItems(Map<File, Boolean> toRecompile) {
        for (File file : toRecompile.keySet()) {
            this.out.print("%%rc");
            this.out.print(file.getAbsolutePath());
            this.out.print("/%rc");
            this.out.println();
        }
    }

    public static void cleanOut(CompilerConfiguration configuration) {
        String generationPackage = (configuration.generationPackage() == null ? configuration.module() : configuration.generationPackage()).replace(".", File.separator);
        File out = new File(configuration.genDirectory(), generationPackage.toLowerCase());
        if (out.exists()) {
            try {
                FileUtils.deleteDirectory((File)out);
            }
            catch (IOException e) {
                LOG.severe(e.getMessage());
            }
        }
    }
}

