/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.BoxConfigurationTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.magritte.framework.Layer;
import java.util.Set;

public class BoxConfigurationRenderer
extends Renderer {
    private final CompilerConfiguration configuration;
    private final Set<String> params;
    private final boolean isTara;

    BoxConfigurationRenderer(CompilationContext context, boolean isTara, Set<String> params) {
        super(context);
        this.isTara = isTara;
        this.params = params;
        this.configuration = context.configuration();
        this.params.addAll(this.configuration.parameters());
    }

    @Override
    public void render() {
        FrameBuilder builder = new FrameBuilder(new String[]{"boxconfiguration"});
        String boxName = this.fillFrame(builder);
        Commons.writeFrame(this.gen(Target.Server), StringHelper.snakeCaseToCamelCase((String)boxName) + "Configuration", this.template().render((Object)builder.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf((Layer)null), Commons.javaFile(this.gen(Target.Server), StringHelper.snakeCaseToCamelCase((String)boxName) + "Configuration").getAbsolutePath()));
    }

    private String fillFrame(FrameBuilder builder) {
        String boxName = this.context.boxName();
        builder.add("name", (Object)boxName).add("package", (Object)this.packageName());
        if (this.parent() != null && this.configuration != null && this.configuration.model() != null && !this.configuration.model().level().isPlatform()) {
            builder.add("parent", (Object)this.parent());
        }
        if (this.isTara) {
            builder.add("tara", (Object)"");
        }
        this.params.stream().filter(parameter -> !parameter.equalsIgnoreCase("home")).forEach(parameter -> builder.add("parameter", (Object)new FrameBuilder(new String[]{this.isFile((String)parameter) ? "file" : "regular"}).add("name", (Object)this.nameOf((String)parameter)).add("value", parameter)));
        return boxName;
    }

    private boolean isFile(String parameter) {
        return parameter.endsWith("file") || parameter.endsWith("directory") || parameter.endsWith("folder");
    }

    private String nameOf(String parameter) {
        return parameter.replace("-", " ").replace("_", " ");
    }

    private Template template() {
        return Formatters.customize(new BoxConfigurationTemplate());
    }
}

