/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.ui;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.services.ui.UiRendererWriter;
import io.intino.konos.builder.codegeneration.services.ui.templates.AbstractDesktopTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.AbstractDisplayTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.DisplayTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.PassiveViewNotifierTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.PassiveViewPushRequesterTemplate;
import io.intino.konos.builder.codegeneration.services.ui.templates.PassiveViewRequesterTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.PassiveView;
import io.intino.konos.model.Template;
import io.intino.magritte.framework.Layer;
import java.io.File;

public class ServerRendererWriter
extends UiRendererWriter {
    public ServerRendererWriter(CompilationContext context) {
        super(context, Target.Server);
    }

    @Override
    public boolean write(Layer element, String type, FrameBuilder builder) {
        if (this.hasAbstractClass(element)) {
            this.writeSrc(element, type, builder);
        }
        this.writeGen(element, type, builder);
        return true;
    }

    @Override
    public boolean writeNotifier(PassiveView element, FrameBuilder builder) {
        File notifierFile = Commons.javaFile(CodeGenerationHelper.displayNotifierFolder(this.gen(), this.target), this.nameOfPassiveViewFile(element, builder.toFrame(), "Notifier"));
        if (!this.context.cache().isModified(element) && notifierFile.exists()) {
            return true;
        }
        Frame frame = builder.toFrame();
        String name = this.nameOfPassiveViewFile(element, frame, "Notifier");
        if (!this.hasConcreteNotifier(element)) {
            return false;
        }
        this.writeFrame(CodeGenerationHelper.displayNotifierFolder(this.gen(), this.target), element, name, this.notifierTemplate(element, builder).render((Object)frame));
        this.registerClass(builder, CodeGenerationHelper.displayNotifierFolder(this.gen(), this.target), element, "Notifier");
        return true;
    }

    @Override
    public boolean writeRequester(PassiveView element, FrameBuilder builder) {
        File requesterFile = Commons.javaFile(CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), this.nameOfPassiveViewFile(element, builder.toFrame(), "Requester"));
        if (!this.context.cache().isModified(element) && requesterFile.exists()) {
            return true;
        }
        Frame frame = builder.toFrame();
        String name = this.nameOfPassiveViewFile(element, frame, "Requester");
        if (!this.hasConcreteRequester(element)) {
            return false;
        }
        this.writeFrame(CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), element, name, this.requesterTemplate(element, builder).render((Object)frame));
        this.registerClass(builder, CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), element, "Requester");
        return true;
    }

    @Override
    public boolean writePushRequester(PassiveView element, FrameBuilder builder) {
        File pushRequesterFile = Commons.javaFile(CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), this.nameOfPassiveViewFile(element, builder.toFrame(), "PushRequester"));
        if (!this.context.cache().isModified(element) && pushRequesterFile.exists()) {
            return true;
        }
        Frame frame = builder.toFrame();
        Template template = this.pushRequesterTemplate(element, builder);
        boolean accessible = this.isAccessible(frame);
        if (accessible || template == null) {
            return false;
        }
        String name = this.nameOfPassiveViewFile(element, frame, "PushRequester");
        if (!this.hasConcreteRequester(element)) {
            return false;
        }
        this.writeFrame(CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), element, name, template.render((Object)frame));
        this.registerClass(builder, CodeGenerationHelper.displayRequesterFolder(this.gen(), this.target), element, "PushRequester");
        return true;
    }

    private void writeSrc(Layer element, String type, FrameBuilder builder) {
        String newDisplay = CodeGenerationHelper.displayFilename(element.name$(), builder.is("accessible") ? "Proxy" : "");
        Template template = this.srcTemplate(element, builder);
        if (template == null) {
            return;
        }
        File sourceFile = CodeGenerationHelper.displayFile(this.src(), newDisplay, type, this.target);
        if (sourceFile.exists()) {
            return;
        }
        this.writeFrame(CodeGenerationHelper.displayFolder(this.src(), type, this.target), element, newDisplay, template.render((Object)builder.toFrame()));
    }

    private void writeGen(Layer element, String type, FrameBuilder builder) {
        Template template = this.genTemplate(element, builder);
        String newDisplay = this.displayName(element, this.isAccessible(builder));
        this.writeFrame(CodeGenerationHelper.displayFolder(this.gen(), type, this.target), element, newDisplay, template.render((Object)builder.add("gen").toFrame()));
    }

    private Template srcTemplate(Layer layer, FrameBuilder builder) {
        if (builder.is("accessible")) {
            return null;
        }
        if (!ElementHelper.isRoot(layer)) {
            return null;
        }
        return this.setup(new DisplayTemplate());
    }

    private Template genTemplate(Layer layer, FrameBuilder builder) {
        if (layer.i$(Template.Desktop.class)) {
            return this.setup(new AbstractDesktopTemplate());
        }
        return this.setup(new AbstractDisplayTemplate());
    }

    private Template notifierTemplate(PassiveView element, FrameBuilder builder) {
        return this.setup(new PassiveViewNotifierTemplate());
    }

    private Template requesterTemplate(PassiveView element, FrameBuilder builder) {
        return this.setup(new PassiveViewRequesterTemplate());
    }

    private Template pushRequesterTemplate(PassiveView element, FrameBuilder builder) {
        return this.setup(new PassiveViewPushRequesterTemplate());
    }

    private void registerClass(FrameBuilder builder, File folder, PassiveView element, String suffix) {
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(element), Commons.javaFile(folder, this.nameOfPassiveViewFile(element, builder.toFrame(), suffix)).getAbsolutePath()));
    }
}

