/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.analytic;

import io.intino.alexandria.logger.Logger;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.accessor.analytic.AnalyticBuilderTemplate;
import io.intino.konos.builder.codegeneration.accessor.analytic.CubeWithColumnsTemplate;
import io.intino.konos.builder.codegeneration.analytic.AxisInterfaceRenderer;
import io.intino.konos.builder.codegeneration.analytic.CategoricalAxisRenderer;
import io.intino.konos.builder.codegeneration.analytic.ContinuousAxisRenderer;
import io.intino.konos.builder.codegeneration.facts.FactRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Axis;
import io.intino.konos.model.Cube;
import io.intino.konos.model.KonosGraph;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;

public class AnalyticBuilderRenderer
extends Renderer {
    private final KonosGraph graph;
    private final File srcDestination;
    private final File resDestination;
    private final String packageName;
    private final FactRenderer factRenderer;
    private final CategoricalAxisRenderer categoricalAxisRenderer;
    private final ContinuousAxisRenderer continuousAxisRenderer;

    public AnalyticBuilderRenderer(CompilationContext compilationContext, KonosGraph graph, File srcDestination, File resDestination) {
        super(compilationContext);
        this.graph = graph;
        this.srcDestination = srcDestination;
        this.resDestination = resDestination;
        this.srcDestination.mkdirs();
        this.packageName = compilationContext.packageName();
        this.factRenderer = new FactRenderer();
        File res = this.context.res(Target.Server).getAbsoluteFile();
        this.categoricalAxisRenderer = new CategoricalAxisRenderer(this.context, srcDestination, res);
        this.continuousAxisRenderer = new ContinuousAxisRenderer(this.context, srcDestination);
    }

    @Override
    public void render() {
        this.renderAxes(this.graph.axisList());
        this.renderCubes(this.graph);
        this.renderBuilder(this.graph);
        this.copyResourcesToDestination();
    }

    private void copyResourcesToDestination() {
        File resources = new File(this.context.res(Target.Server).getAbsoluteFile(), "analytic");
        try {
            FileUtils.copyDirectory((File)resources, (File)new File(this.resDestination, resources.getName()));
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void renderAxes(List<Axis> axes) {
        if (axes.isEmpty()) {
            return;
        }
        axes.stream().filter(Axis::isCategorical).map(Axis::asCategorical).forEach(this.categoricalAxisRenderer::render);
        axes.stream().filter(Axis::isContinuous).map(Axis::asContinuous).forEach(this.continuousAxisRenderer::render);
        AxisInterfaceRenderer.render(this.srcDestination, this.context, axes);
    }

    private void renderCubes(KonosGraph graph) {
        graph.cubeList().stream().filter(c -> !c.isVirtual()).forEach(cube -> Commons.writeFrame(new File(this.destinationDirectory(), "cubes"), cube.name$() + "Schema", this.cubeTemplate().render((Object)this.renderCube((Cube)((Object)cube)).toFrame())));
    }

    private FrameBuilder renderCube(Cube cube) {
        String className = StringUtils.capitalize((String)cube.name$()) + "Schema";
        FrameBuilder fb = new FrameBuilder(new String[]{"cube"}).add("package", (Object)this.packageName).add("cube", (Object)StringUtils.capitalize((String)cube.name$())).add("name", (Object)className);
        this.factRenderer.render(className, cube, fb);
        return fb;
    }

    private void renderBuilder(KonosGraph graph) {
        FrameBuilder builder = new FrameBuilder(new String[]{"builder"}).add("package", (Object)this.packageName).add("name", (Object)(this.context.boxName() + "AnalyticBuilder"));
        graph.cubeList().stream().filter(c -> !c.isVirtual()).forEach(cube -> builder.add("cube", (Object)new FrameBuilder(new String[]{"cube"}).add("name", (Object)cube.name$())));
        Commons.writeFrame(this.destinationDirectory(), this.context.boxName() + "AnalyticBuilder", this.builderTemplate().render((Object)builder.toFrame()));
    }

    private File destinationDirectory() {
        return new File(this.srcDestination, this.packageName.replace(".", "/") + "/analytic");
    }

    private Template builderTemplate() {
        return Formatters.customize(new AnalyticBuilderTemplate());
    }

    private Template cubeTemplate() {
        return Formatters.customize(new CubeWithColumnsTemplate());
    }
}

