/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.resource;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.action.AccessibleDisplayActionRenderer;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.services.ui.templates.ResourceTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.Display;
import java.util.List;
import java.util.stream.Collectors;

public class AccessibleDisplayRenderer
extends UIRenderer {
    private final Display.Accessible display;
    private final Target target;

    public AccessibleDisplayRenderer(CompilationContext compilationContext, Display.Accessible display, Target target) {
        super(compilationContext);
        this.display = display;
        this.target = target;
    }

    @Override
    public void render() throws KonosException {
        FrameBuilder builder = this.buildFrame().add("accessibleDisplay").add("name", (Object)this.display.name$());
        builder.add("resource");
        builder.add(((Object)((Object)this.display)).getClass().getSimpleName());
        builder.add("render", (Object)this.renderFrame());
        builder.add("parameter", (Object)this.parameters(this.display));
        if (this.target == Target.Server) {
            Commons.writeFrame(CodeGenerationHelper.resourceFolder(this.gen(this.target), this.target), CodeGenerationHelper.resourceFilename(this.display.name$(), "ProxyResource"), this.setup(new ResourceTemplate()).render((Object)builder.toFrame()));
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.display), Commons.javaFile(CodeGenerationHelper.resourceFolder(this.gen(this.target), this.target), CodeGenerationHelper.resourceFilename(this.display.name$(), "ProxyResource")).getAbsolutePath()));
        }
        new AccessibleDisplayActionRenderer(this.context, this.display, this.target).execute();
    }

    private FrameBuilder renderFrame() {
        FrameBuilder result = this.buildBaseFrame().add("render");
        if (this.display.confidential()) {
            result.add("confidential");
        }
        return result;
    }

    private FrameBuilder[] parameters(Display.Accessible display) {
        List<FrameBuilder> result = display.parameters().stream().map(parameter -> new FrameBuilder(new String[]{"parameter"}).add("name", parameter)).collect(Collectors.toList());
        result.add(new FrameBuilder(new String[]{"parameter"}).add("name", (Object)"personifiedDisplay"));
        return result.toArray(new FrameBuilder[0]);
    }
}

