/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.soap;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.action.SoapOperationActionRenderer;
import io.intino.konos.builder.codegeneration.services.soap.SoapOperationTemplate;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Schema;
import io.intino.konos.model.Service;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class SoapOperationRenderer
extends Renderer {
    private static final String OPERATIONS_PACKAGE = "soap/operations";
    private final List<Service.Soap> services;

    public SoapOperationRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext);
        this.services = graph.serviceList(Service::isSoap).map(Service::asSoap).collect(Collectors.toList());
    }

    @Override
    public void render() throws KonosException {
        for (Service.Soap service : this.services) {
            this.processService(service);
        }
    }

    private void processService(Service.Soap service) throws KonosException {
        for (Service.Soap.Operation operation : service.operationList()) {
            this.processOperation(operation);
        }
    }

    private void processOperation(Service.Soap.Operation operation) throws KonosException {
        Frame frame = this.frameOf(operation);
        String className = StringHelper.snakeCaseToCamelCase((String)operation.name$()) + "Operation";
        File operationsPackage = new File(this.gen(Target.Server), OPERATIONS_PACKAGE);
        Commons.writeFrame(operationsPackage, className, this.template().render((Object)frame));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(operation), Commons.javaFile(operationsPackage, className).getAbsolutePath()));
        this.createCorrespondingAction(operation);
    }

    private void createCorrespondingAction(Service.Soap.Operation operation) throws KonosException {
        new SoapOperationActionRenderer(this.context, operation).execute();
    }

    private Frame frameOf(Service.Soap.Operation operation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"operation"});
        this.addCommons(operation.name$(), builder);
        if (operation.input() != null) {
            builder.add("input", (Object)this.input(operation.input().asObject().type(), this.type(operation.input().asObject().schema()), operation.input().xmlns()));
        }
        if (operation.output() != null) {
            builder.add("returnType", (Object)new FrameBuilder().add("value", (Object)this.type(operation.output().asObject().schema())).add("xmlns", (Object)operation.output().xmlns()));
        }
        return builder.toFrame();
    }

    private Frame input(String name, String type, String xmlns) {
        return new FrameBuilder(new String[]{"input"}).add("name", (Object)name).add("type", (Object)type).add("xmlns", (Object)xmlns).toFrame();
    }

    private void addCommons(String name, FrameBuilder builder) {
        builder.add("package", (Object)this.packageName());
        builder.add("name", (Object)name);
        builder.add("box", (Object)this.boxName());
    }

    private String type(Schema schema) {
        return String.join((CharSequence)".", this.packageName(), "schemas") + "." + Commons.firstUpperCase(schema.name$());
    }

    private Template template() {
        return Formatters.customize(new SoapOperationTemplate());
    }
}

