/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.Block;
import io.intino.konos.model.CatalogComponents;
import io.intino.konos.model.Component;
import io.intino.konos.model.Display;
import io.intino.konos.model.HelperComponents;
import io.intino.konos.model.InteractionComponents;
import io.intino.konos.model.OtherComponents;
import io.intino.konos.model.PassiveView;
import io.intino.konos.model.Service;
import io.intino.konos.model.VisualizationComponents;
import io.intino.magritte.framework.Layer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class UIRenderer
extends Renderer {
    protected UIRenderer(CompilationContext compilationContext) {
        super(compilationContext);
    }

    public FrameBuilder buildFrame() {
        return this.buildBaseFrame();
    }

    @Override
    protected String parent() {
        return this.context.parent();
    }

    @Override
    protected Map<String, String> classes() {
        return this.context.classes();
    }

    protected Template setup(Template template) {
        return this.addFormats(template);
    }

    protected String path(Display display, Target target) {
        return CodeGenerationHelper.displayPath(null, this.typeOf(display), target);
    }

    protected Template addFormats(Template template) {
        return Formatters.customize(template);
    }

    protected String typeOf(Layer element) {
        return this.elementHelper.typeOf(element);
    }

    protected String nameOf(Layer element) {
        return this.elementHelper.nameOf(element);
    }

    protected String shortId(Layer element) {
        return this.elementHelper.shortId(element);
    }

    protected String shortId(Layer element, String suffix) {
        return this.elementHelper.shortId(element, suffix);
    }

    protected <D extends PassiveView> boolean isBaseType(D element) {
        String type = this.typeOf(element);
        return type.equalsIgnoreCase("display") || type.equalsIgnoreCase("component") || type.equalsIgnoreCase("template") || type.equalsIgnoreCase("table") || type.equalsIgnoreCase("dynamictable") || type.equalsIgnoreCase("list") || type.equalsIgnoreCase("map") || type.equalsIgnoreCase("magazine") || type.equalsIgnoreCase("block") || type.equalsIgnoreCase("item") || type.equalsIgnoreCase("row");
    }

    protected String patternOf(Service.UI.Resource resource) {
        if (resource.path().isEmpty()) {
            return "\\\\/";
        }
        Stream<String> split = Stream.of(resource.path().split("/"));
        return split.map(s -> s.startsWith(":") ? "([^\\\\/]*)" : s).collect(Collectors.joining("\\\\/"));
    }

    protected List<Component> components(PassiveView passiveView) {
        ArrayList<Component> components = new ArrayList<Component>();
        if (passiveView.i$(ElementHelper.conceptOf(Block.class))) {
            components.addAll(((Block)passiveView.a$(Block.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(io.intino.konos.model.Template.class))) {
            components.addAll(((io.intino.konos.model.Template)passiveView.a$(io.intino.konos.model.Template.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Snackbar.class))) {
            components.addAll(((OtherComponents.Snackbar)passiveView.a$(OtherComponents.Snackbar.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(VisualizationComponents.Stepper.class))) {
            components.addAll(((VisualizationComponents.Stepper)passiveView.a$(VisualizationComponents.Stepper.class)).stepList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(VisualizationComponents.Stepper.Step.class))) {
            components.addAll(((VisualizationComponents.Stepper.Step)passiveView.a$(VisualizationComponents.Stepper.Step.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(VisualizationComponents.Header.class))) {
            components.addAll(((VisualizationComponents.Header)passiveView.a$(VisualizationComponents.Header.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.class))) {
            if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Selector.CollectionBox.class)) && ((OtherComponents.Selector.CollectionBox)passiveView.a$(OtherComponents.Selector.CollectionBox.class)).source() != null) {
                components.add(((OtherComponents.Selector.CollectionBox)passiveView.a$(OtherComponents.Selector.CollectionBox.class)).source());
            } else {
                components.addAll(((OtherComponents.Selector)passiveView.a$(OtherComponents.Selector.class)).componentList());
            }
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.User.class))) {
            components.addAll(((OtherComponents.User)passiveView.a$(OtherComponents.User.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.Table.class))) {
            components.addAll(((CatalogComponents.Table)passiveView.a$(CatalogComponents.Table.class)).moldList().stream().filter(m -> m.heading() != null).map(CatalogComponents.Moldable.Mold::heading).collect(Collectors.toList()));
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class))) {
            components.addAll(((CatalogComponents.DynamicTable)passiveView.a$(CatalogComponents.DynamicTable.class)).moldList().stream().filter(m -> m.heading() != null).map(CatalogComponents.Moldable.Mold::heading).collect(Collectors.toList()));
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Heading.class))) {
            components.addAll(((CatalogComponents.Moldable.Mold.Heading)passiveView.a$(CatalogComponents.Moldable.Mold.Heading.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class))) {
            components.addAll(((CatalogComponents.Moldable.Mold.Item)passiveView.a$(CatalogComponents.Moldable.Mold.Item.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(InteractionComponents.Toolbar.class))) {
            components.addAll(((InteractionComponents.Toolbar)passiveView.a$(InteractionComponents.Toolbar.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.Dialog.class))) {
            components.addAll(((OtherComponents.Dialog)passiveView.a$(OtherComponents.Dialog.class)).componentList());
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.DecisionDialog.class))) {
            components.add(((OtherComponents.DecisionDialog)passiveView.a$(OtherComponents.DecisionDialog.class)).selector());
        }
        if (passiveView.i$(ElementHelper.conceptOf(OtherComponents.CollectionDialog.class))) {
            components.add(((OtherComponents.CollectionDialog)passiveView.a$(OtherComponents.CollectionDialog.class)).collection());
        }
        return components;
    }

    protected boolean hasConcreteNotifier(PassiveView element) {
        if (element.i$(ElementHelper.conceptOf(Display.Accessible.class))) {
            return true;
        }
        return !element.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class)) && !element.i$(ElementHelper.conceptOf(CatalogComponents.Table.class)) && !element.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class)) && !element.i$(ElementHelper.conceptOf(HelperComponents.Row.class)) && !element.i$(ElementHelper.conceptOf(io.intino.konos.model.Template.class));
    }

    protected boolean hasConcreteRequester(PassiveView element) {
        if (element.i$(ElementHelper.conceptOf(Display.Accessible.class))) {
            return true;
        }
        return !element.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class)) && !element.i$(ElementHelper.conceptOf(CatalogComponents.Table.class)) && !element.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class)) && !element.i$(ElementHelper.conceptOf(HelperComponents.Row.class)) && !element.i$(ElementHelper.conceptOf(io.intino.konos.model.Template.class));
    }

    protected String notifierName(Layer element) {
        return this.passiveViewName(element);
    }

    protected String requesterName(Layer element) {
        return this.passiveViewName(element);
    }

    private String passiveViewName(Layer element) {
        if (element.i$(ElementHelper.conceptOf(io.intino.konos.model.Template.class))) {
            return "Template";
        }
        if (element.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class))) {
            return "Item";
        }
        if (element.i$(ElementHelper.conceptOf(HelperComponents.Row.class))) {
            return "Row";
        }
        if (element.i$(ElementHelper.conceptOf(CatalogComponents.Table.class))) {
            return "Table";
        }
        if (element.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class))) {
            return "DynamicTable";
        }
        return Commons.firstUpperCase(element.name$());
    }

    protected String requesterTypeOf(Display display) {
        if (display.i$(ElementHelper.conceptOf(io.intino.konos.model.Template.class))) {
            return "io.intino.alexandria.ui.displays.requesters.Template";
        }
        if (display.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class))) {
            return "io.intino.alexandria.ui.displays.requesters.Item";
        }
        if (display.i$(ElementHelper.conceptOf(HelperComponents.Row.class))) {
            return "io.intino.alexandria.ui.displays.requesters.Row";
        }
        if (display.i$(ElementHelper.conceptOf(CatalogComponents.Table.class))) {
            return "io.intino.alexandria.ui.displays.requesters.Table";
        }
        if (display.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class))) {
            return "io.intino.alexandria.ui.displays.requesters.DynamicTable";
        }
        return Commons.firstUpperCase(this.nameOf(display));
    }

    protected FrameBuilder notifierImportFrame(Display element, boolean accessible) {
        FrameBuilder result = this.buildBaseFrame().add("notifierImport");
        result.add("name", (Object)element.name$());
        if (element.i$(ElementHelper.conceptOf(io.intino.konos.model.Template.class))) {
            result.add("template");
        }
        if (element.i$(ElementHelper.conceptOf(HelperComponents.Row.class))) {
            result.add("row");
        }
        if (element.i$(ElementHelper.conceptOf(CatalogComponents.Moldable.Mold.Item.class))) {
            result.add("item");
        }
        if (element.i$(ElementHelper.conceptOf(CatalogComponents.Table.class))) {
            result.add("table");
        }
        if (element.i$(ElementHelper.conceptOf(CatalogComponents.DynamicTable.class))) {
            result.add("dynamictable");
        }
        if (!accessible && element.isAccessible()) {
            result.add("accessible");
        }
        return result;
    }
}

