/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.codegeneration.services.ui.Updater;
import io.intino.konos.builder.codegeneration.ui.RendererWriter;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.magritte.framework.Layer;
import java.io.File;

public abstract class ElementRenderer<C extends Layer>
extends UIRenderer {
    protected final C element;
    protected final RendererWriter writer;

    protected ElementRenderer(CompilationContext compilationContext, C element, RendererWriter rendererWriter) {
        super(compilationContext);
        this.element = element;
        this.writer = rendererWriter;
    }

    @Override
    public void execute() throws KonosException {
        File displayFile = CodeGenerationHelper.fileOf(CodeGenerationHelper.displayFolder(this.gen(this.writer.target()), this.typeOf((Layer)this.element), this.writer.target()), this.displayName(false), this.writer.target());
        if (this.isRendered((Layer)this.element) && displayFile.exists()) {
            return;
        }
        super.execute();
    }

    protected String targetPackageName() {
        return this.targetPackageName(this.writer.target());
    }

    protected String targetPackageName(Target target) {
        if (target == Target.Android) {
            return "mobile.android";
        }
        if (target == Target.MobileShared) {
            return "mobile";
        }
        return "ui";
    }

    protected final void write(FrameBuilder builder) {
        this.writer.write((Layer)this.element, this.typeOf((Layer)this.element), builder);
    }

    private String displayName(boolean accessible) {
        String suffix;
        String string = suffix = accessible ? "Proxy" : "";
        String abstractValue = accessible ? "" : (ElementHelper.isRoot(this.element) && CodeGenerationHelper.hasAbstractClass(this.element, this.writer.target()) ? "Abstract" : "");
        return CodeGenerationHelper.displayFilename(StringHelper.snakeCaseToCamelCase((String)(abstractValue + Commons.firstUpperCase(this.element.name$()))), suffix);
    }

    protected abstract Updater updater(String var1, File var2);
}

