/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.AbstractBoxTemplate;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.services.ui.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.compiler.shared.PostCompileActionMessage;
import io.intino.konos.compiler.shared.PostCompileConfigurationParameterActionMessage;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Sentinel;
import io.intino.konos.model.Service;
import io.intino.konos.model.Subscriber;
import io.intino.magritte.framework.Node;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class AbstractBoxRenderer
extends Renderer {
    private final KonosGraph graph;
    private final CompilerConfiguration configuration;
    private final Set<String> konosParameters;

    AbstractBoxRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext);
        this.graph = graph;
        this.configuration = compilationContext.configuration();
        this.konosParameters = new LinkedHashSet<String>();
    }

    @Override
    public void render() {
        FrameBuilder root = new FrameBuilder(new String[]{"box"});
        root.add("name", (Object)this.boxName()).add("package", (Object)this.packageName());
        this.parent(root);
        this.connector(root);
        this.services(root);
        this.sentinels(root);
        this.terminal(root);
        this.workflow(root);
        Commons.writeFrame(this.context.gen(Target.Server), "AbstractBox", this.template().render((Object)root.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.sourceFileOf(this.graph), Commons.javaFile(this.gen(Target.Server), "AbstractBox").getAbsolutePath()));
        this.notifyNewParameters();
    }

    private String sourceFileOf(KonosGraph graph) {
        if (!graph.serviceList().isEmpty()) {
            return this.context.sourceFileOf(graph.serviceList().get(0));
        }
        if (!graph.schemaList().isEmpty()) {
            return this.context.sourceFileOf(graph.schemaList().get(0));
        }
        if (!graph.datamartList().isEmpty()) {
            return this.context.sourceFileOf(graph.datamartList().get(0));
        }
        List nodes = graph.core$().rootList();
        return nodes.isEmpty() ? "" : this.context.sourceFileOf((Node)nodes.get(0));
    }

    Set<String> customParameters() {
        return this.konosParameters;
    }

    private void notifyNewParameters() {
        this.konosParameters.forEach(p -> this.context.postCompileActionMessages().add((PostCompileActionMessage)new PostCompileConfigurationParameterActionMessage(this.context.module(), p)));
    }

    private void sentinels(FrameBuilder builder) {
        if (!this.graph.sentinelList().isEmpty()) {
            FrameBuilder frame = new FrameBuilder(new String[]{"sentinel"}).add("configuration", (Object)this.boxName());
            if (this.graph.sentinelList().stream().anyMatch(Sentinel::isWebHook)) {
                frame.add("hasWebhook", (Object)",");
            }
            builder.add("sentinel", (Object)frame);
        }
        this.konosParameters.addAll(this.graph.sentinelList().stream().filter(Sentinel::isFileListener).map(s -> s.asFileListener().file()).map(Commons::extractParameters).flatMap(Collection::stream).collect(Collectors.toList()));
    }

    private void terminal(FrameBuilder root) {
        CompilationContext.DataHubManifest manifest = this.context.dataHubManifest();
        if (manifest == null) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"terminal"}).add("name", (Object)manifest.terminal).add("qn", (Object)manifest.qn).add("package", (Object)this.packageName()).add("box", (Object)this.boxName());
        Frame[] subscriber = (Frame[])this.graph.subscriberList().stream().filter(s -> manifest.tankClasses.containsKey(s.event())).map(s -> this.subscriberFrameOf((Subscriber)((Object)s), manifest)).toArray(Frame[]::new);
        if (subscriber.length != 0) {
            builder.add("subscriber", (Object)subscriber);
        }
        root.add("terminal", (Object)builder.toFrame());
    }

    private Frame subscriberFrameOf(Subscriber subscriber, CompilationContext.DataHubManifest manifest) {
        String tankClass = manifest.tankClasses.get(subscriber.event());
        FrameBuilder builder = this.subscriberFrame(subscriber, manifest);
        if (!subscriber.splits().isEmpty()) {
            subscriber.splits().forEach(s -> this.splitFrame(tankClass, builder, (String)s));
        } else if (manifest.messageContexts.get(subscriber.event()).size() > 1) {
            List<String> strings = manifest.messageContexts.get(subscriber.event());
            strings.sort(String::compareTo);
            for (String context : strings) {
                this.splitFrame(tankClass, builder, context);
            }
        }
        return builder.toFrame();
    }

    private FrameBuilder subscriberFrame(Subscriber subscriber, CompilationContext.DataHubManifest manifest) {
        FrameBuilder builder = new FrameBuilder(new String[]{"subscriber", "terminal"}).add("package", (Object)this.packageName()).add("name", (Object)subscriber.name$()).add("box", (Object)this.boxName()).add("terminal", (Object)manifest.qn).add("eventQn", (Object)subscriber.event().replace(".", "")).add("event", (Object)subscriber.event());
        if (subscriber.isDurable()) {
            builder.add("durable").add("subscriberId", (Object)subscriber.asDurable().subscriberId());
            if (subscriber.asDurable().subscriptionMode().equals((Object)Subscriber.Durable.SubscriptionMode.ReceiveAfterLastSeal)) {
                builder.add("filtered");
            }
        }
        return builder;
    }

    private void splitFrame(String tankClass, FrameBuilder builder, String context) {
        builder.add("split", (Object)new FrameBuilder(new String[]{"split"}).add("value", (Object)Formatters.snakeCaseToCamelCase().format((Object)context.replace(".", "-")).toString()).add("type", (Object)tankClass).toFrame());
    }

    private void connector(FrameBuilder root) {
        if (this.graph.messagingServiceList().isEmpty() && this.context.dataHubManifest() == null) {
            return;
        }
        String[] parameters = new String[]{"datahub_url", "datahub_user", "datahub_password", "datahub_clientId", "datahub_outbox_directory"};
        FrameBuilder builder = new FrameBuilder(new String[]{"connector"});
        for (String p : parameters) {
            builder.add("parameter", (Object)this.parameter(p, "conf", p.contains("directory") ? "file" : "standard"));
        }
        builder.add("package", (Object)this.packageName());
        builder.add("box", (Object)this.boxName());
        root.add("connector", (Object)builder.toFrame());
        Collections.addAll(this.konosParameters, parameters);
    }

    private void workflow(FrameBuilder root) {
        if (this.graph.workflow() == null || this.graph.workflow().processList().isEmpty()) {
            return;
        }
        root.add("workflow", (Object)this.buildBaseFrame().add("workflow"));
    }

    private FrameBuilder parameter(String parameter, String ... types) {
        return new FrameBuilder(types).add("parameter").add(this.isCustom(parameter) ? "custom" : "standard").add("value", (Object)parameter);
    }

    private Frame parameter(Service.SlackBot service) {
        return new FrameBuilder(new String[]{this.isCustom(service.token()) ? "custom" : "standard"}).add("value", (Object)service.token()).toFrame();
    }

    private void services(FrameBuilder builder) {
        if (!this.graph.messagingServiceList().isEmpty()) {
            builder.add("jms", (Object)"");
        }
        if (!(this.graph.subscriberList().isEmpty() && this.graph.uiServiceList().isEmpty() && this.graph.restServiceList().isEmpty())) {
            builder.add("logger", (Object)new FrameBuilder(new String[]{"logger"}));
        }
        this.soap(builder);
        this.messaging(builder);
        this.jmx(builder);
        this.agenda(builder);
        this.slackServices(builder);
        this.ui(builder);
        this.rest(builder);
        this.cli(builder);
        if (!(this.graph.soapServiceList().isEmpty() && this.graph.restServiceList().isEmpty() && this.graph.uiServiceList().isEmpty())) {
            builder.add("spark", (Object)"stop");
        }
    }

    private void rest(FrameBuilder frame) {
        List<Service.REST> services = this.graph.restServiceList();
        services.sort(Comparator.comparingInt(r -> r.notificationList().size()).reversed());
        for (Service.REST service : services) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "rest"}).add("name", (Object)service.name$()).add("configuration", (Object)this.boxName()).add("parameter", (Object)this.parameter(service.port(), new String[0])).toFrame());
        }
    }

    private void cli(FrameBuilder frame) {
        List<Service.CLI> services = this.graph.cliServiceList();
        for (Service.CLI service : services) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "cli"}).add("name", (Object)service.name$()).add("configuration", (Object)this.boxName()).add("parameter", (Object)this.parameter(service.port(), new String[0])).toFrame());
        }
    }

    private void soap(FrameBuilder frame) {
        for (Service.Soap service : this.graph.soapServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "soap"}).add("name", (Object)service.name$()).add("configuration", (Object)this.boxName()).add("parameter", (Object)this.parameter(service.port(), new String[0])).toFrame());
        }
    }

    private void messaging(FrameBuilder frame) {
        for (Service.Messaging service : this.graph.messagingServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "messaging"}).add("name", (Object)service.name$()).add("configuration", (Object)this.boxName()));
        }
    }

    private void jmx(FrameBuilder frame) {
        for (Service.JMX service : this.graph.jmxServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "jmx"}).add("name", (Object)service.name$()).add("configuration", (Object)this.boxName()).toFrame());
        }
    }

    private void agenda(FrameBuilder frame) {
        if (this.graph.agendaServiceList().isEmpty() || this.graph.agendaServiceList().get(0).futureList().isEmpty()) {
            return;
        }
        Service.Agenda service = this.graph.agendaServiceList().get(0);
        frame.add("service", (Object)new FrameBuilder(new String[]{"service", "agenda"}).add("name", (Object)service.name$()).add("configuration", (Object)this.boxName()).toFrame());
    }

    private void slackServices(FrameBuilder frame) {
        for (Service.SlackBot service : this.graph.slackBotServiceList()) {
            frame.add("service", (Object)new FrameBuilder(new String[]{"service", "slack"}).add("name", (Object)service.name$()).add("configuration", (Object)this.boxName()).add("parameter", (Object)this.parameter(service)).toFrame());
        }
    }

    private void ui(FrameBuilder builder) {
        if (!this.graph.uiServiceList().isEmpty()) {
            FrameBuilder uiFrame = this.uiFrame();
            if (this.context.parent() != null) {
                uiFrame.add("parent", (Object)this.context.parent());
            }
            builder.add("hasUi", (Object)uiFrame);
            builder.add("uiAuthentication", (Object)uiFrame);
            builder.add("uiEdition", (Object)uiFrame);
            builder.add("service", this.graph.uiServiceList().stream().map(s -> this.ui((Service.UI)((Object)s), this.boxName())).toArray(Frame[]::new));
        }
    }

    private FrameBuilder uiFrame() {
        FrameBuilder result = new FrameBuilder().add("package", (Object)this.packageName());
        this.graph.uiServiceList().forEach(service -> service.useList().forEach(use -> result.add("useDictionaries", (Object)this.dictionariesOf((Service.UI.Use)((Object)((Object)use))))));
        return result;
    }

    private Frame ui(Service.UI service, String name) {
        FrameBuilder builder = new FrameBuilder(new String[]{"service", "ui"}).add("name", (Object)service.name$()).add("configuration", (Object)name).add("parameter", (Object)this.parameter(service.port(), new String[0]).toFrame()).add("package", (Object)this.packageName());
        if (service.authentication() != null) {
            builder.add("authentication", (Object)this.parameter(service.authentication().by(), new String[0]).toFrame());
        }
        if (service.edition() != null) {
            builder.add("edition", (Object)new FrameBuilder(new String[]{this.isCustom(service.edition().by()) ? "custom" : "standard"}).add("value", (Object)service.edition().by()).toFrame());
        }
        service.useList().forEach(use -> builder.add("use", (Object)this.serviceNameOf((Service.UI.Use)((Object)use))));
        return builder.toFrame();
    }

    private String serviceNameOf(Service.UI.Use use) {
        return use.package$() + ".box.ui." + Formatters.firstUpperCase(use.service()) + "Service";
    }

    private String dictionariesOf(Service.UI.Use use) {
        return use.package$() + ".box.I18n.dictionaries()";
    }

    private boolean isCustom(String value) {
        boolean custom;
        boolean bl = custom = value != null && value.startsWith("{");
        if (custom) {
            this.konosParameters.add(value.substring(1, value.length() - 1));
        }
        return custom;
    }

    private void parent(FrameBuilder builder) {
        if (this.parent() != null && this.configuration != null && this.configuration.model() != null && !this.configuration.model().level().isPlatform()) {
            builder.add("parent", (Object)this.parent()).add("hasParent", (Object)"");
        } else {
            builder.add("hasntParent", (Object)"");
        }
    }

    private Template template() {
        return Formatters.customize(new AbstractBoxTemplate());
    }
}

