/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder;

import io.intino.alexandria.logger.Logger;
import io.intino.konos.CompilerMessage;
import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.builder.Manifest;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.FullRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.context.WarningMessage;
import io.intino.konos.builder.utils.GraphLoader;
import io.intino.konos.compiler.shared.PostCompileActionMessage;
import io.intino.konos.compiler.shared.PostCompileConfigurationDependencyActionMessage;
import io.intino.konos.model.KonosGraph;
import io.intino.konos.model.Sentinel;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class KonosCompiler {
    private final CompilerConfiguration configuration;
    private final List<CompilerMessage> collector;
    private final List<PostCompileActionMessage> postCompileActionMessages;

    public KonosCompiler(CompilerConfiguration configuration, List<CompilerMessage> collector, List<PostCompileActionMessage> postCompileActionMessages) {
        this.configuration = configuration;
        this.collector = collector;
        this.postCompileActionMessages = postCompileActionMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OutputItem> compile(List<File> sources) {
        GraphLoader graphLoader;
        KonosGraph graph;
        List<OutputItem> compiledFiles = Collections.synchronizedList(new ArrayList());
        if (this.configuration.isVerbose()) {
            this.configuration.out().println("@#$%@# Presentable:Konosc: Compiling model...");
        }
        if ((graph = (graphLoader = new GraphLoader()).loadGraph(this.configuration, sources)) == null) {
            return compiledFiles;
        }
        if (this.configuration.isVerbose()) {
            this.configuration.out().println("@#$%@# Presentable:Konosc: Rendering classes...");
        }
        CompilationContext context = new CompilationContext(this.configuration, this.postCompileActionMessages, sources, compiledFiles);
        try {
            context.loadCache(graph, graphLoader.stashes());
            this.render(graph, context);
            boolean needRebuild = this.updateDependencies(this.requiredDependencies(graph, context));
            if (needRebuild) {
                this.addRebuildNeededMessage(new KonosException("The build has required an updated of dependencies. Please rebuild module for complete compilation"));
            }
            List<OutputItem> list = compiledFiles;
            return list;
        }
        catch (Exception e) {
            this.processCompilationException(e);
        }
        finally {
            this.addWarnings(context.warningMessages());
        }
        return compiledFiles;
    }

    private boolean updateDependencies(Map<String, String> requiredDependencies) {
        if (this.configuration.groupId().equals("io.intino.alexandria")) {
            return false;
        }
        Map<String, String> currentDependencies = this.configuration.currentDependencies().stream().collect(Collectors.toMap(d -> d.split(":")[0] + ":" + d.split(":")[1], d -> d.split(":")[2]));
        List toAdd = requiredDependencies.entrySet().stream().filter(entry -> !this.contains(currentDependencies, (Map.Entry<String, String>)entry)).map(entry -> new PostCompileConfigurationDependencyActionMessage(this.configuration.module(), (String)entry.getKey() + ":" + (String)entry.getValue())).collect(Collectors.toList());
        this.postCompileActionMessages.addAll(toAdd);
        return !toAdd.isEmpty();
    }

    private boolean contains(Map<String, String> deps, Map.Entry<String, String> entry) {
        return deps.containsKey(entry.getKey()) && deps.get(entry.getKey()).compareTo(entry.getValue()) >= 0;
    }

    private Map<String, String> requiredDependencies(KonosGraph graph, CompilationContext context) {
        Map<String, String> dependencies = Manifest.load().dependencies;
        if (graph.jmxServiceList().isEmpty()) {
            this.remove(dependencies, "jmx");
        }
        if (graph.messagingServiceList().isEmpty()) {
            this.remove(dependencies, ":jms");
        }
        if (graph.sentinelList().isEmpty()) {
            this.remove(dependencies, "scheduler");
        }
        if (graph.messagingServiceList().isEmpty() || context.dataHubManifest() != null) {
            this.remove(dependencies, "terminal-jms");
        }
        if (graph.uiServiceList().isEmpty()) {
            this.remove(dependencies, "ui");
        }
        if (graph.restServiceList().isEmpty()) {
            this.remove(dependencies, "rest");
        }
        if (graph.soapServiceList().isEmpty()) {
            this.remove(dependencies, "soap");
        }
        if (graph.workflow() == null) {
            this.remove(dependencies, "bpm");
        }
        if (graph.slackBotServiceList().isEmpty()) {
            this.remove(dependencies, "slack");
        }
        if (graph.visualizationComponents() == null || graph.visualizationComponents().chartList(c -> c.isAbsolute() || c.isRelative()).isEmpty()) {
            this.remove(dependencies, "driver-r");
        }
        if (graph.visualizationComponents() == null || graph.visualizationComponents().dashboardList(d -> d.isAbsolute() || d.isRelative()).isEmpty()) {
            this.remove(dependencies, "driver-shiny");
        }
        if (graph.sentinelList().stream().noneMatch(Sentinel::isWebHook) || !graph.restServiceList().isEmpty() || !graph.soapServiceList().isEmpty() || !graph.uiServiceList().isEmpty()) {
            this.remove(dependencies, "http");
        }
        return dependencies;
    }

    private void remove(Map<String, String> dependencies, String type) {
        String toRemove = null;
        for (String dep : dependencies.keySet()) {
            if (!dep.contains(type)) continue;
            toRemove = dep;
        }
        if (toRemove != null) {
            dependencies.remove(toRemove);
        }
    }

    private void render(KonosGraph graph, CompilationContext context) throws KonosException {
        try {
            new FullRenderer(graph, context).execute();
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String exceptionAsString = sw.toString();
                throw new KonosException(exceptionAsString, e);
            }
            throw new KonosException(e.getMessage(), e);
        }
    }

    private void processCompilationException(Exception e) {
        if (e instanceof KonosException) {
            this.addErrorMessage((KonosException)e);
            return;
        }
        Logger.error((String)e.getMessage());
        this.addMessageWithoutLocation(e.getMessage(), true);
    }

    private void addMessageWithoutLocation(String message, boolean error) {
        this.collector.add(new CompilerMessage(error ? "error" : "warning", message, null, -1, -1));
    }

    private void addErrorMessage(KonosException exception) {
        this.collector.add(new CompilerMessage("error", exception.getMessage(), "null", -1, -1));
    }

    private void addRebuildNeededMessage(KonosException exception) {
        this.collector.add(new CompilerMessage("rebuild_needed", exception.getMessage(), "null", -1, -1));
    }

    private void addWarnings(List<WarningMessage> warningMessages) {
        warningMessages.forEach(w -> this.collector.add(new CompilerMessage("warning", w.message(), w.owner() == null ? "null" : w.owner().getAbsolutePath(), w.line(), w.column())));
    }
}

