/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.context;

import com.google.gson.Gson;
import cottons.utils.StringHelper;
import io.intino.Configuration;
import io.intino.alexandria.logger.Logger;
import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.cache.CacheReader;
import io.intino.konos.builder.codegeneration.cache.CacheWriter;
import io.intino.konos.builder.codegeneration.cache.LayerCache;
import io.intino.konos.builder.context.WarningMessage;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.compiler.shared.KonosBuildConstants;
import io.intino.konos.compiler.shared.PostCompileActionMessage;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.io.Stash;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class CompilationContext {
    private final List<File> sources;
    private final ArrayList<WarningMessage> warningMessages;
    private final List<OutputItem> compiledFiles;
    private final List<PostCompileActionMessage> postCompileActionMessages;
    private CompilerConfiguration configuration;
    private DataHubManifest dataHubManifest;
    private File webModuleDirectory;
    private String parent;
    private String boxName = null;
    private Map<String, String> classes = new HashMap<String, String>();
    private LayerCache cache = null;

    public CompilationContext(CompilerConfiguration configuration, List<PostCompileActionMessage> postCompileActionMessages, List<File> sources, List<OutputItem> compiledFiles) {
        this.sources = sources;
        this.postCompileActionMessages = postCompileActionMessages;
        this.compiledFiles = compiledFiles;
        this.configuration(configuration);
        this.loadManifest();
        sources.sort(Comparator.comparing(File::getName));
        this.warningMessages = new ArrayList();
    }

    public KonosBuildConstants.Mode mode() {
        return this.configuration.mode();
    }

    public String project() {
        return this.configuration.project();
    }

    public String module() {
        return this.configuration.module();
    }

    public File webModuleDirectory() {
        return this.configuration.webModuleDirectory();
    }

    public void webModuleDirectory(File file) {
        this.configuration.webModuleDirectory(file);
    }

    public String parent() {
        return this.configuration.parentInterface();
    }

    public CompilationContext parent(String parent) {
        this.parent = parent;
        return this;
    }

    public List<OutputItem> compiledFiles() {
        return this.compiledFiles;
    }

    public void addWarning(WarningMessage message) {
        this.warningMessages.add(message);
    }

    public List<WarningMessage> warningMessages() {
        return this.warningMessages;
    }

    public File root(Target target) {
        String rootDir = target == Target.Owner ? this.configuration.moduleDirectory().getAbsolutePath() : this.configuration.webModuleDirectory().getAbsolutePath();
        return CodeGenerationHelper.createIfNotExists(new File(rootDir));
    }

    public File res(Target target) {
        return CodeGenerationHelper.createIfNotExists(target == Target.Owner ? this.configuration.resDirectory() : this.accessorRes());
    }

    public File src(Target target) {
        return CodeGenerationHelper.createIfNotExists(target == Target.Owner ? new File(this.configuration.srcDirectory(), this.packageName().replace(".", File.separator)) : this.accessorSrc());
    }

    public File gen(Target target) {
        return CodeGenerationHelper.createIfNotExists(target == Target.Owner ? new File(this.configuration.genDirectory(), this.packageName().replace(".", File.separator)) : this.accessorGen());
    }

    public String packageName() {
        return this.configuration.generationPackage();
    }

    public String boxName() {
        if (this.boxName == null) {
            this.boxName = StringHelper.snakeCaseToCamelCase((String)(this.configuration != null ? this.configuration.artifactId() : Configuration.Artifact.Model.Level.Solution.name()));
        }
        return this.boxName;
    }

    public CompilerConfiguration configuration() {
        return this.configuration;
    }

    public DataHubManifest dataHubManifest() {
        return this.dataHubManifest;
    }

    public Map<String, String> classes() {
        return this.classes;
    }

    public CompilationContext classes(Map<String, String> classes) {
        this.classes = classes;
        return this;
    }

    private void configuration(CompilerConfiguration configuration) {
        this.configuration = configuration;
    }

    private File accessorRes() {
        return CodeGenerationHelper.createIfNotExists(new File(this.root(Target.Accessor) + File.separator + "res"));
    }

    private File accessorSrc() {
        return CodeGenerationHelper.createIfNotExists(new File(this.root(Target.Accessor) + File.separator + "src"));
    }

    private File accessorGen() {
        return CodeGenerationHelper.createIfNotExists(new File(this.root(Target.Accessor) + File.separator + "gen"));
    }

    public LayerCache cache() {
        return this.cache;
    }

    public void loadCache(KonosGraph graph, Stash[] stashes) {
        this.cache = new CacheReader(this.configuration.configurationDirectory()).load(graph, stashes);
    }

    public void saveCache() {
        new CacheWriter(this.configuration.configurationDirectory()).save(this.cache);
    }

    private void loadManifest() {
        this.dataHubManifest = this.configuration() != null ? this.loadManifest(this.configuration().datahubLibrary()) : null;
    }

    private DataHubManifest loadManifest(File jar) {
        if (jar == null || !jar.exists()) {
            return null;
        }
        try {
            ZipFile zipFile = new ZipFile(jar);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().equals("terminal.mf")) continue;
                return (DataHubManifest)new Gson().fromJson(new String(zipFile.getInputStream(entry).readAllBytes()), DataHubManifest.class);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return null;
    }

    public CompilationContext clone() {
        CompilationContext result = new CompilationContext(this.configuration, this.postCompileActionMessages, this.sources, this.compiledFiles);
        result.webModuleDirectory = this.webModuleDirectory;
        result.parent = this.parent;
        result.classes = this.classes;
        return result;
    }

    public String graphName() {
        Object result = this.project() != null ? this.project() : "";
        result = (String)result + (this.module() != null ? this.module() : "");
        return !((String)result).isEmpty() ? result : "test";
    }

    public List<PostCompileActionMessage> postCompileActionMessages() {
        return this.postCompileActionMessages;
    }

    public String sourceFileOf(Layer layer) {
        if (layer == null) {
            return this.sources.get(0).getAbsolutePath();
        }
        Node node = layer.core$();
        return this.sourceFileOf(node);
    }

    public String sourceFileOf(Node node) {
        String stash = node.stash();
        File file = this.sources.stream().filter(f -> f.getName().replace(".konos", "").equals(stash)).findFirst().orElse(null);
        return file == null ? this.sources.get(0).getAbsolutePath() : file.getAbsolutePath();
    }

    public static class DataHubManifest {
        public String terminal;
        public String qn;
        public List<String> publish;
        public List<String> subscribe;
        public Map<String, String> tankClasses;
        public Map<String, List<String>> messageContexts;
    }
}

