/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.resource;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.ActionRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Service;
import java.io.File;
import java.util.List;

public class PageRenderer
extends ActionRenderer {
    private final CompilationContext compilationContext;
    private final Service.UI.Resource resource;
    private final Service.UI service;

    public PageRenderer(CompilationContext compilationContext, Service.UI.Resource resource) {
        super(compilationContext, "ui");
        this.compilationContext = compilationContext;
        this.resource = resource;
        this.service = (Service.UI)resource.core$().ownerAs(Service.UI.class);
    }

    @Override
    public void render() {
        FrameBuilder builder = new FrameBuilder().add("action").add("ui");
        Service.UI uiService = (Service.UI)this.resource.core$().ownerAs(Service.UI.class);
        builder.add("name", (Object)this.resource.name$());
        if (this.resource.isPage()) {
            builder.add("templateName", (Object)this.resource.asPage().template().name$());
        }
        builder.add("uiService", (Object)uiService.name$());
        builder.add("package", (Object)this.packageName());
        builder.add("box", (Object)this.boxName());
        builder.add("importTemplates", (Object)this.packageName());
        builder.add("component", (Object)this.componentFrame());
        builder.add("parameter", (Object)this.parameters());
        builder.add("contextProperty", (Object)this.contextPropertyFrame());
        this.service.useList().forEach(use -> builder.add("usedUnit", (Object)this.usedUnitFrame((Service.UI.Use)((Object)use))));
        if (this.service.title() != null) {
            builder.add("title", (Object)this.titleFrame());
        }
        if (this.service.favicon() != null) {
            builder.add("favicon", (Object)this.service.favicon());
        }
        this.compilationContext.classes().put(((Object)((Object)this.resource)).getClass().getSimpleName() + "#" + this.firstUpperCase(this.resource.core$().name()), "actions." + this.firstUpperCase(StringHelper.snakeCaseToCamelCase((String)this.resource.name$())) + this.suffix());
        if (!this.alreadyRendered(this.src(), this.resource.name$())) {
            Commons.writeFrame(this.destinationPackage(this.src()), this.resource.name$() + this.suffix(), this.template().render((Object)builder.toFrame()));
            if (this.target.equals((Object)Target.Owner)) {
                this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.resource), Commons.javaFile(this.destinationPackage(this.src()), this.resource.name$() + this.suffix()).getAbsolutePath()));
            }
        }
        Commons.writeFrame(this.destinationPackage(this.gen()), "Abstract" + this.firstUpperCase(this.resource.name$()) + this.suffix(), this.template().render((Object)builder.add("gen").toFrame()));
        if (this.target.equals((Object)Target.Owner)) {
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.resource), Commons.javaFile(this.destinationPackage(this.gen()), "Abstract" + this.firstUpperCase(this.resource.name$()) + this.suffix()).getAbsolutePath()));
        }
    }

    private FrameBuilder titleFrame() {
        FrameBuilder result = new FrameBuilder(new String[]{"title"});
        String title = this.service.title();
        if (title.startsWith("{") && title.endsWith("}")) {
            title = title.substring(1, title.length() - 1);
            result.add("configuration");
        }
        result.add("title", (Object)title);
        return result;
    }

    @Override
    protected ActionRenderer.ContextType contextType() {
        return ActionRenderer.ContextType.Spark;
    }

    private Frame usedUnitFrame(Service.UI.Use use) {
        FrameBuilder result = new FrameBuilder(new String[]{"usedUnit"});
        result.add(this.isCustomParameter(use.url()) ? "custom" : "standard");
        result.add("name", (Object)use.name().toLowerCase());
        result.add("url", (Object)(this.isCustomParameter(use.url()) ? this.customParameterValue(use.url()) : use.url()));
        return result.toFrame();
    }

    private FrameBuilder componentFrame() {
        return new FrameBuilder(new String[]{"component"}).add("value", (Object)KonosGraph.templateFor(this.resource).name$());
    }

    private FrameBuilder[] parameters() {
        List<String> parameters = Commons.extractUrlPathParameters(this.resource.path());
        return (FrameBuilder[])parameters.stream().map(parameter -> new FrameBuilder().add("parameter").add("type", (Object)"String").add("name", parameter)).toArray(FrameBuilder[]::new);
    }

    @Override
    protected File destinationPackage(File destiny) {
        return new File(destiny, CodeGenerationHelper.format("%spages", Target.Owner));
    }

    @Override
    protected String suffix() {
        return "Page";
    }
}

