/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components.other;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.model.graph.VisualizationComponents;

public class BoardRenderer
extends ComponentRenderer<VisualizationComponents.Board> {
    public BoardRenderer(CompilationContext compilationContext, VisualizationComponents.Board component, TemplateProvider provider, Target target) {
        super(compilationContext, component, provider, target);
    }

    @Override
    public FrameBuilder properties() {
        FrameBuilder result = super.properties();
        result.add("icon", (Object)((VisualizationComponents.Board)this.element).materialIcon());
        this.addSource(result);
        return result;
    }

    private void addSource(FrameBuilder builder) {
        VisualizationComponents.Board.Source source = ((VisualizationComponents.Board)this.element).source();
        this.addFromFileAspect(builder, source);
        this.addFromResourceAspect(builder, source);
        this.addInlineAspect(builder, source);
    }

    private void addFromFileAspect(FrameBuilder builder, VisualizationComponents.Board.Source source) {
        if (!source.isFromFile()) {
            return;
        }
        builder.add("fromFile");
        VisualizationComponents.Board.Source.FromFile origin = source.asFromFile();
        if (origin.file() != null && !origin.file().isEmpty()) {
            builder.add("source", (Object)this.fileMethodFrame("source", origin.file()).add("extraParam", (Object)this.clean(origin.separator())));
        }
    }

    private String clean(String separator) {
        return separator.replace("\\\\", "\\");
    }

    private void addFromResourceAspect(FrameBuilder builder, VisualizationComponents.Board.Source source) {
        if (!source.isFromResource()) {
            return;
        }
        builder.add("fromResource");
        VisualizationComponents.Board.Source.FromResource origin = source.asFromResource();
        if (origin.path() != null && !origin.path().isEmpty()) {
            builder.add("source", (Object)this.resourceMethodFrame("source", origin.path()).add("extraParam", (Object)this.clean(origin.separator())));
        }
    }

    private void addInlineAspect(FrameBuilder builder, VisualizationComponents.Board.Source source) {
        if (!source.isInline()) {
            return;
        }
        builder.add("inline");
        VisualizationComponents.Board.Source.Inline origin = source.asInline();
        origin.applicationList().forEach(a -> builder.add("application", (Object)this.applicationFrame((VisualizationComponents.Board.Source.Inline.Application)((Object)a))));
    }

    private FrameBuilder applicationFrame(VisualizationComponents.Board.Source.Inline.Application application) {
        FrameBuilder result = new FrameBuilder(new String[]{"boardApplication"});
        result.add("name", (Object)application.name());
        result.add("url", (Object)application.url());
        application.translationList().forEach(t -> result.add("translation", this.translationFrame(application, (VisualizationComponents.Board.Source.Inline.Application.Translation)((Object)t))));
        return result;
    }

    private Object translationFrame(VisualizationComponents.Board.Source.Inline.Application application, VisualizationComponents.Board.Source.Inline.Application.Translation translation) {
        FrameBuilder result = new FrameBuilder(new String[]{"boardApplicationTranslation"});
        result.add("language", (Object)translation.language());
        result.add("name", (Object)translation.name());
        return result;
    }

    @Override
    protected String className(Class clazz) {
        return super.className(clazz).replace("board", "");
    }
}

