/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph.rules;

import io.intino.magritte.lang.model.Node;
import io.intino.magritte.lang.model.rules.NodeRule;
import java.util.List;

public class ViewRule
implements NodeRule {
    private ERROR_TYPE error = ERROR_TYPE.NAME;

    public boolean accept(Node node) {
        List components = node.components();
        if (components.size() != 1) {
            this.error(ERROR_TYPE.SIZE);
            return false;
        }
        return components.stream().noneMatch(component -> this.hasForbiddenTypes((Node)component) || node.isAnonymous() && (this.hasFilteredCatalog((Node)component) || this.isRenderDisplay((Node)component)));
    }

    private boolean hasForbiddenTypes(Node component) {
        return component.types().contains("RenderPanels") || component.types().contains("RenderObjects") && this.error(ERROR_TYPE.COMPONENT_NOT_ALLOWED);
    }

    private boolean hasFilteredCatalog(Node component) {
        return component.types().contains("RenderCatalogs") && component.parameters().stream().anyMatch(p -> p.name().equals("filtered") && p.values().get(0).toString().equals("true")) && this.error(ERROR_TYPE.NAME);
    }

    private boolean isRenderDisplay(Node component) {
        return component.types().contains("RenderDisplay") && this.error(ERROR_TYPE.NAME);
    }

    public String errorMessage() {
        switch (this.error) {
            case NAME: {
                return "This View must have name";
            }
            case SIZE: {
                return "This View must have just one Render";
            }
            case COMPONENT_NOT_ALLOWED: {
                return "RenderPanels and RenderObjects are not allowed here";
            }
        }
        return "";
    }

    private boolean error(ERROR_TYPE type) {
        this.error = type;
        return true;
    }

    static enum ERROR_TYPE {
        NAME,
        SIZE,
        COMPONENT_NOT_ALLOWED;

    }
}

