/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.bpm;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.bpm.ProcessTemplate;
import io.intino.konos.builder.codegeneration.bpm.WorkflowTemplate;
import io.intino.konos.builder.codegeneration.bpm.parser.BpmnParser;
import io.intino.konos.builder.codegeneration.bpm.parser.Link;
import io.intino.konos.builder.codegeneration.bpm.parser.State;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Workflow;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class BpmRenderer
extends Renderer {
    private final CompilationContext compilationContext;
    private final List<Workflow.Process> processes;
    private final File src;
    private final File gen;
    private final KonosGraph graph;
    private final Workflow workflow;
    private final List<String> stateServices = new ArrayList<String>();

    public BpmRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext, Target.Owner);
        this.compilationContext = compilationContext;
        this.workflow = graph.workflow();
        this.processes = this.workflow != null ? graph.workflow().processList() : Collections.emptyList();
        this.src = new File(compilationContext.src(Target.Owner), "bpm");
        this.gen = new File(compilationContext.gen(Target.Owner), "bpm");
        this.graph = graph;
    }

    @Override
    protected void render() throws KonosException {
        this.renderProcesses();
        this.renderWorkflow();
    }

    private void renderWorkflow() throws KonosException {
        if (this.processes.isEmpty()) {
            return;
        }
        if (this.compilationContext.dataHubManifest() == null) {
            throw new KonosException("Is required the Data hub declaration in artifact to instance subscribers");
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"workflow"}).add("box", (Object)this.compilationContext.boxName()).add("package", (Object)this.compilationContext.packageName()).add("directory", (Object)Commons.fileFrame(this.workflow.directory(), this.packageName())).add("terminal", (Object)this.compilationContext.dataHubManifest().qn).add(this.compilationContext.boxName()).add("process", this.processes.stream().filter(p -> this.file((Workflow.Process)((Object)p)) != null).map(p -> this.frameOf((Workflow.Process)((Object)p), this.file((Workflow.Process)((Object)p)))).toArray(FrameBuilder[]::new));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.graph.workflow()), Commons.javaFile(this.gen, "Workflow").getAbsolutePath()));
        Commons.writeFrame(this.gen, "Workflow", Formatters.customize(new WorkflowTemplate()).render((Object)builder.toFrame()));
    }

    private void renderProcesses() {
        for (Workflow.Process process : this.processes) {
            this.stateServices.clear();
            File file = this.file(process);
            if (file == null) continue;
            this.renderProcess(process, file);
        }
    }

    private File file(Workflow.Process process) {
        File file;
        File file2 = file = process.bpmn() == null ? null : new File(URLDecoder.decode(process.bpmn().getFile(), Charset.defaultCharset()));
        if (file == null || !file.exists()) {
            return null;
        }
        return file;
    }

    private void renderProcess(Workflow.Process process, File file) {
        FrameBuilder builder = this.frameOf(process, file);
        this.compilationContext.classes().put(((Object)((Object)process)).getClass().getSimpleName() + "#" + process.name$(), "bpm." + process.name$());
        Commons.writeFrame(this.gen, "Abstract" + Commons.firstUpperCase(process.name$()), Formatters.customize(new ProcessTemplate()).render((Object)builder.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(process), Commons.javaFile(this.gen, "Abstract" + Commons.firstUpperCase(process.name$())).getAbsolutePath()));
        if (!this.alreadyRendered(this.src, process.name$())) {
            Commons.writeFrame(this.src, process.name$(), Formatters.customize(new ProcessTemplate()).render((Object)builder.add("src").toFrame()));
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(process), Commons.javaFile(this.src(), process.name$()).getAbsolutePath()));
        }
    }

    private FrameBuilder frameOf(Workflow.Process process, File bpmn) {
        BpmnParser bpmnParser;
        try {
            bpmnParser = new BpmnParser(new FileInputStream(bpmn));
        }
        catch (FileNotFoundException e) {
            return null;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"process"}).add("box", (Object)this.compilationContext.boxName()).add("package", (Object)this.compilationContext.packageName()).add("name", (Object)process.name$());
        List<State> states = bpmnParser.states();
        for (State state : states) {
            builder.add("state", (Object)this.frameOf(state, states));
            state.links().sort((o1, o2) -> Boolean.compare(o1.isDefault(), o2.isDefault()));
            state.links().forEach(link -> builder.add("link", (Object)this.frameOf(state, (Link)link)));
            if (state.type() != State.Type.Initial || state.comment() == null) continue;
            Arrays.stream(state.comment().split("\n|\t| ")).filter(s -> !s.isEmpty() && !s.isBlank()).map(String::trim).filter(l -> l.startsWith("*")).forEach(p -> builder.add("parameter", (Object)p.trim().substring(1)));
        }
        return builder;
    }

    private FrameBuilder frameOf(State state, List<State> states) {
        List<State.Type> types = this.typesOf(state);
        FrameBuilder builder = new FrameBuilder(new String[]{"state", this.entryLink(state, states)}).add("method", (Object)this.format(state)).add("label", (Object)state.label());
        if (!types.contains((Object)State.Type.Intermediate)) {
            builder.add("type", types.stream().map(Enum::name).toArray(String[]::new));
        }
        if (state.taskType() == State.TaskType.Service) {
            this.stateServices.add(this.format(state));
        }
        builder.add("taskType", (Object)state.taskType());
        return builder;
    }

    private String entryLink(State state, List<State> states) {
        for (State s : states) {
            Link link = s.links().stream().filter(l -> l.to().equals(state)).findFirst().orElse(null);
            if (link == null || link.type() == Link.Type.Line) continue;
            return "conditional";
        }
        return Link.Type.Line.name();
    }

    private List<State.Type> typesOf(State state) {
        ArrayList<State.Type> types = new ArrayList<State.Type>();
        if (state.type() == State.Type.Initial) {
            types.add(State.Type.Initial);
        }
        if (state.links().isEmpty() || state.type() == State.Type.Terminal) {
            types.add(State.Type.Terminal);
        } else if (!types.contains((Object)State.Type.Initial)) {
            types.add(State.Type.Intermediate);
        }
        return types;
    }

    private FrameBuilder frameOf(State state, Link link) {
        return new FrameBuilder(new String[]{"link"}).add("from", (Object)state.label()).add("to", (Object)link.state().label()).add("type", (Object)(link.isDefault() ? "Default" : link.type().name()));
    }

    private String format(State state) {
        return Formatters.snakeCaseToCamelCase().format((Object)Normalizer.normalize(state.label().replaceAll(" |/", "_"), Normalizer.Form.NFKD)).toString();
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

