/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Addressable;
import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.CatalogComponents;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.DataComponents;
import io.intino.konos.model.graph.Dataframe;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.HelperComponents;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.OtherComponents;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.Template;
import io.intino.konos.model.graph.VisualizationComponents;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.InstantLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class InteractionComponents
extends Layer
implements Terminal {
    protected List<Toolbar> toolbarList = new ArrayList<Toolbar>();
    protected List<Actionable> actionableList = new ArrayList<Actionable>();
    protected List<Link> linkList = new ArrayList<Link>();
    protected List<AbstractButton> abstractButtonList = new ArrayList<AbstractButton>();
    protected List<Button> buttonList = new ArrayList<Button>();
    protected List<SplitButton> splitButtonList = new ArrayList<SplitButton>();
    protected List<IconButton> iconButtonList = new ArrayList<IconButton>();
    protected List<MaterialIconButton> materialIconButtonList = new ArrayList<MaterialIconButton>();
    protected List<AvatarIconButton> avatarIconButtonList = new ArrayList<AvatarIconButton>();
    protected List<Switch> switchList = new ArrayList<Switch>();
    protected List<AbstractToggle> abstractToggleList = new ArrayList<AbstractToggle>();
    protected List<Toggle> toggleList = new ArrayList<Toggle>();
    protected List<IconToggle> iconToggleList = new ArrayList<IconToggle>();
    protected List<MaterialIconToggle> materialIconToggleList = new ArrayList<MaterialIconToggle>();

    public InteractionComponents(Node node) {
        super(node);
    }

    public List<Toolbar> toolbarList() {
        return Collections.unmodifiableList(this.toolbarList);
    }

    public Toolbar toolbar(int index) {
        return this.toolbarList.get(index);
    }

    public List<Toolbar> toolbarList(Predicate<Toolbar> predicate) {
        return this.toolbarList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Actionable> actionableList() {
        return Collections.unmodifiableList(this.actionableList);
    }

    public Actionable actionable(int index) {
        return this.actionableList.get(index);
    }

    public List<Actionable> actionableList(Predicate<Actionable> predicate) {
        return this.actionableList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Link> linkList() {
        return Collections.unmodifiableList(this.linkList);
    }

    public Link link(int index) {
        return this.linkList.get(index);
    }

    public List<Link> linkList(Predicate<Link> predicate) {
        return this.linkList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<AbstractButton> abstractButtonList() {
        return Collections.unmodifiableList(this.abstractButtonList);
    }

    public AbstractButton abstractButton(int index) {
        return this.abstractButtonList.get(index);
    }

    public List<AbstractButton> abstractButtonList(Predicate<AbstractButton> predicate) {
        return this.abstractButtonList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Button> buttonList() {
        return Collections.unmodifiableList(this.buttonList);
    }

    public Button button(int index) {
        return this.buttonList.get(index);
    }

    public List<Button> buttonList(Predicate<Button> predicate) {
        return this.buttonList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<SplitButton> splitButtonList() {
        return Collections.unmodifiableList(this.splitButtonList);
    }

    public SplitButton splitButton(int index) {
        return this.splitButtonList.get(index);
    }

    public List<SplitButton> splitButtonList(Predicate<SplitButton> predicate) {
        return this.splitButtonList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<IconButton> iconButtonList() {
        return Collections.unmodifiableList(this.iconButtonList);
    }

    public IconButton iconButton(int index) {
        return this.iconButtonList.get(index);
    }

    public List<IconButton> iconButtonList(Predicate<IconButton> predicate) {
        return this.iconButtonList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<MaterialIconButton> materialIconButtonList() {
        return Collections.unmodifiableList(this.materialIconButtonList);
    }

    public MaterialIconButton materialIconButton(int index) {
        return this.materialIconButtonList.get(index);
    }

    public List<MaterialIconButton> materialIconButtonList(Predicate<MaterialIconButton> predicate) {
        return this.materialIconButtonList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<AvatarIconButton> avatarIconButtonList() {
        return Collections.unmodifiableList(this.avatarIconButtonList);
    }

    public AvatarIconButton avatarIconButton(int index) {
        return this.avatarIconButtonList.get(index);
    }

    public List<AvatarIconButton> avatarIconButtonList(Predicate<AvatarIconButton> predicate) {
        return this.avatarIconButtonList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Switch> switchList() {
        return Collections.unmodifiableList(this.switchList);
    }

    public Switch switch$(int index) {
        return this.switchList.get(index);
    }

    public List<Switch> switchList(Predicate<Switch> predicate) {
        return this.switchList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<AbstractToggle> abstractToggleList() {
        return Collections.unmodifiableList(this.abstractToggleList);
    }

    public AbstractToggle abstractToggle(int index) {
        return this.abstractToggleList.get(index);
    }

    public List<AbstractToggle> abstractToggleList(Predicate<AbstractToggle> predicate) {
        return this.abstractToggleList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Toggle> toggleList() {
        return Collections.unmodifiableList(this.toggleList);
    }

    public Toggle toggle(int index) {
        return this.toggleList.get(index);
    }

    public List<Toggle> toggleList(Predicate<Toggle> predicate) {
        return this.toggleList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<IconToggle> iconToggleList() {
        return Collections.unmodifiableList(this.iconToggleList);
    }

    public IconToggle iconToggle(int index) {
        return this.iconToggleList.get(index);
    }

    public List<IconToggle> iconToggleList(Predicate<IconToggle> predicate) {
        return this.iconToggleList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<MaterialIconToggle> materialIconToggleList() {
        return Collections.unmodifiableList(this.materialIconToggleList);
    }

    public MaterialIconToggle materialIconToggle(int index) {
        return this.materialIconToggleList.get(index);
    }

    public List<MaterialIconToggle> materialIconToggleList(Predicate<MaterialIconToggle> predicate) {
        return this.materialIconToggleList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Toolbar>(this.toolbarList).forEach(c -> components.add(c.core$()));
        new ArrayList<Actionable>(this.actionableList).forEach(c -> components.add(c.core$()));
        new ArrayList<Link>(this.linkList).forEach(c -> components.add(c.core$()));
        new ArrayList<AbstractButton>(this.abstractButtonList).forEach(c -> components.add(c.core$()));
        new ArrayList<Button>(this.buttonList).forEach(c -> components.add(c.core$()));
        new ArrayList<SplitButton>(this.splitButtonList).forEach(c -> components.add(c.core$()));
        new ArrayList<IconButton>(this.iconButtonList).forEach(c -> components.add(c.core$()));
        new ArrayList<MaterialIconButton>(this.materialIconButtonList).forEach(c -> components.add(c.core$()));
        new ArrayList<AvatarIconButton>(this.avatarIconButtonList).forEach(c -> components.add(c.core$()));
        new ArrayList<Switch>(this.switchList).forEach(c -> components.add(c.core$()));
        new ArrayList<AbstractToggle>(this.abstractToggleList).forEach(c -> components.add(c.core$()));
        new ArrayList<Toggle>(this.toggleList).forEach(c -> components.add(c.core$()));
        new ArrayList<IconToggle>(this.iconToggleList).forEach(c -> components.add(c.core$()));
        new ArrayList<MaterialIconToggle>(this.materialIconToggleList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("InteractionComponents$Toolbar")) {
            this.toolbarList.add((Toolbar)node.as(Toolbar.class));
        }
        if (node.is("InteractionComponents$Actionable")) {
            this.actionableList.add((Actionable)node.as(Actionable.class));
        }
        if (node.is("InteractionComponents$Link")) {
            this.linkList.add((Link)node.as(Link.class));
        }
        if (node.is("InteractionComponents$AbstractButton")) {
            this.abstractButtonList.add((AbstractButton)node.as(AbstractButton.class));
        }
        if (node.is("InteractionComponents$Button")) {
            this.buttonList.add((Button)node.as(Button.class));
        }
        if (node.is("InteractionComponents$SplitButton")) {
            this.splitButtonList.add((SplitButton)node.as(SplitButton.class));
        }
        if (node.is("InteractionComponents$IconButton")) {
            this.iconButtonList.add((IconButton)node.as(IconButton.class));
        }
        if (node.is("InteractionComponents$MaterialIconButton")) {
            this.materialIconButtonList.add((MaterialIconButton)node.as(MaterialIconButton.class));
        }
        if (node.is("InteractionComponents$AvatarIconButton")) {
            this.avatarIconButtonList.add((AvatarIconButton)node.as(AvatarIconButton.class));
        }
        if (node.is("InteractionComponents$Switch")) {
            this.switchList.add((Switch)node.as(Switch.class));
        }
        if (node.is("InteractionComponents$AbstractToggle")) {
            this.abstractToggleList.add((AbstractToggle)node.as(AbstractToggle.class));
        }
        if (node.is("InteractionComponents$Toggle")) {
            this.toggleList.add((Toggle)node.as(Toggle.class));
        }
        if (node.is("InteractionComponents$IconToggle")) {
            this.iconToggleList.add((IconToggle)node.as(IconToggle.class));
        }
        if (node.is("InteractionComponents$MaterialIconToggle")) {
            this.materialIconToggleList.add((MaterialIconToggle)node.as(MaterialIconToggle.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("InteractionComponents$Toolbar")) {
            this.toolbarList.remove(node.as(Toolbar.class));
        }
        if (node.is("InteractionComponents$Actionable")) {
            this.actionableList.remove(node.as(Actionable.class));
        }
        if (node.is("InteractionComponents$Link")) {
            this.linkList.remove(node.as(Link.class));
        }
        if (node.is("InteractionComponents$AbstractButton")) {
            this.abstractButtonList.remove(node.as(AbstractButton.class));
        }
        if (node.is("InteractionComponents$Button")) {
            this.buttonList.remove(node.as(Button.class));
        }
        if (node.is("InteractionComponents$SplitButton")) {
            this.splitButtonList.remove(node.as(SplitButton.class));
        }
        if (node.is("InteractionComponents$IconButton")) {
            this.iconButtonList.remove(node.as(IconButton.class));
        }
        if (node.is("InteractionComponents$MaterialIconButton")) {
            this.materialIconButtonList.remove(node.as(MaterialIconButton.class));
        }
        if (node.is("InteractionComponents$AvatarIconButton")) {
            this.avatarIconButtonList.remove(node.as(AvatarIconButton.class));
        }
        if (node.is("InteractionComponents$Switch")) {
            this.switchList.remove(node.as(Switch.class));
        }
        if (node.is("InteractionComponents$AbstractToggle")) {
            this.abstractToggleList.remove(node.as(AbstractToggle.class));
        }
        if (node.is("InteractionComponents$Toggle")) {
            this.toggleList.remove(node.as(Toggle.class));
        }
        if (node.is("InteractionComponents$IconToggle")) {
            this.iconToggleList.remove(node.as(IconToggle.class));
        }
        if (node.is("InteractionComponents$MaterialIconToggle")) {
            this.materialIconToggleList.remove(node.as(MaterialIconToggle.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class MaterialIconToggle
    extends AbstractToggle
    implements Terminal {
        protected String icon;

        public MaterialIconToggle(Node node) {
            super(node);
        }

        public String icon() {
            return this.icon;
        }

        public MaterialIconToggle icon(String value) {
            this.icon = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("icon", new ArrayList<String>(Collections.singletonList(this.icon)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class IconToggle
    extends AbstractToggle
    implements Terminal {
        protected String icon;

        public IconToggle(Node node) {
            super(node);
        }

        public String icon() {
            return this.icon;
        }

        public IconToggle icon(String value) {
            this.icon = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("icon", new ArrayList<String>(Collections.singletonList(this.icon)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Toggle
    extends AbstractToggle
    implements Terminal {
        public Toggle(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static abstract class AbstractToggle
    extends Actionable
    implements Terminal {
        protected State state;

        public AbstractToggle(Node node) {
            super(node);
        }

        public State state() {
            return this.state;
        }

        public AbstractToggle state(State value) {
            this.state = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("state", new ArrayList<State>(Collections.singletonList(this.state)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("state")) {
                this.state = (State)((Object)WordLoader.load(values, State.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("state")) {
                this.state = (State)((Object)values.get(0));
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum State {
            On,
            Off;

        }
    }

    public static class Switch
    extends Actionable
    implements Terminal {
        protected State state;

        public Switch(Node node) {
            super(node);
        }

        public State state() {
            return this.state;
        }

        public Switch state(State value) {
            this.state = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("state", new ArrayList<State>(Collections.singletonList(this.state)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("state")) {
                this.state = (State)((Object)WordLoader.load(values, State.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("state")) {
                this.state = (State)((Object)values.get(0));
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum State {
            On,
            Off;

        }
    }

    public static class AvatarIconButton
    extends AbstractButton
    implements Terminal {
        public AvatarIconButton(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class MaterialIconButton
    extends AbstractButton
    implements Terminal {
        protected String icon;

        public MaterialIconButton(Node node) {
            super(node);
        }

        public String icon() {
            return this.icon;
        }

        public MaterialIconButton icon(String value) {
            this.icon = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("icon", new ArrayList<String>(Collections.singletonList(this.icon)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class IconButton
    extends AbstractButton
    implements Terminal {
        protected String icon;

        public IconButton(Node node) {
            super(node);
        }

        public String icon() {
            return this.icon;
        }

        public IconButton icon(String value) {
            this.icon = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("icon", new ArrayList<String>(Collections.singletonList(this.icon)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class SplitButton
    extends AbstractButton
    implements Terminal {
        protected List<String> options = new ArrayList<String>();
        protected String defaultOption;

        public SplitButton(Node node) {
            super(node);
        }

        public List<String> options() {
            return this.options;
        }

        public String options(int index) {
            return this.options.get(index);
        }

        public List<String> options(Predicate<String> predicate) {
            return this.options().stream().filter(predicate).collect(Collectors.toList());
        }

        public String defaultOption() {
            return this.defaultOption;
        }

        public SplitButton defaultOption(String value) {
            this.defaultOption = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("options", this.options);
            map.put("defaultOption", new ArrayList<String>(Collections.singletonList(this.defaultOption)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = StringLoader.load(values, (Layer)this);
            } else if (name.equalsIgnoreCase("defaultOption")) {
                this.defaultOption = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("options")) {
                this.options = new ArrayList(values);
            } else if (name.equalsIgnoreCase("defaultOption")) {
                this.defaultOption = (String)values.get(0);
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static class Button
    extends AbstractButton
    implements Terminal {
        public Button(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static abstract class AbstractButton
    extends Actionable
    implements Terminal {
        protected Highlight highlight;

        public AbstractButton(Node node) {
            super(node);
        }

        public Highlight highlight() {
            return this.highlight;
        }

        public AbstractButton highlight(Highlight value) {
            this.highlight = value;
            return this;
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("highlight", new ArrayList<Highlight>(Collections.singletonList(this.highlight)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("highlight")) {
                this.highlight = (Highlight)((Object)WordLoader.load(values, Highlight.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("highlight")) {
                this.highlight = (Highlight)((Object)values.get(0));
            }
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static enum Highlight {
            None,
            Outline,
            Fill;

        }
    }

    public static class Link
    extends Actionable
    implements Terminal {
        public Link(Node node) {
            super(node);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }
    }

    public static abstract class Actionable
    extends Component
    implements Terminal {
        protected String title;
        protected Target target;
        protected Size size;
        protected Readonly _readonly;
        protected Addressable _addressable;
        protected Secured _secured;
        protected Affirmed _affirmed;
        protected Signed _signed;
        protected Behavior _behavior;
        protected Action _action;
        protected OpenDrawer _openDrawer;
        protected CloseDrawer _closeDrawer;
        protected OpenPage _openPage;
        protected OpenSite _openSite;
        protected OpenBlock _openBlock;
        protected OpenDialog _openDialog;
        protected CloseDialog _closeDialog;
        protected OpenPopover _openPopover;
        protected SelectPreviousItem _selectPreviousItem;
        protected SelectNextItem _selectNextItem;
        protected Export _export;
        protected Download _download;

        public Actionable(Node node) {
            super(node);
        }

        public String title() {
            return this.title;
        }

        public Target target() {
            return this.target;
        }

        public Size size() {
            return this.size;
        }

        public Actionable title(String value) {
            this.title = value;
            return this;
        }

        public Actionable target(Target value) {
            this.target = value;
            return this;
        }

        public Actionable size(Size value) {
            this.size = value;
            return this;
        }

        public Export asExport() {
            Layer as = this.a$(Export.class);
            return as != null ? (Export)as : null;
        }

        public boolean isExport() {
            return this.core$().is(Export.class);
        }

        public Signed asSigned() {
            return (Signed)this.a$(Signed.class);
        }

        public Signed asSigned(String signText) {
            Signed newElement = (Signed)this.core$().addAspect(Signed.class);
            newElement.core$().set((Layer)newElement, "signText", Collections.singletonList(signText));
            return newElement;
        }

        public boolean isSigned() {
            return this.core$().is(Signed.class);
        }

        public void removeSigned() {
            this.core$().removeAspect(Signed.class);
        }

        public Action asAction() {
            Layer as = this.a$(Action.class);
            return as != null ? (Action)as : null;
        }

        public boolean isAction() {
            return this.core$().is(Action.class);
        }

        public OpenDrawer asOpenDrawer() {
            return (OpenDrawer)this.a$(OpenDrawer.class);
        }

        public OpenDrawer asOpenDrawer(Block.Drawer drawer) {
            OpenDrawer newElement = (OpenDrawer)this.core$().addAspect(OpenDrawer.class);
            newElement.core$().set((Layer)newElement, "drawer", Collections.singletonList(drawer));
            return newElement;
        }

        public boolean isOpenDrawer() {
            return this.core$().is(OpenDrawer.class);
        }

        public void removeOpenDrawer() {
            this.core$().removeAspect(OpenDrawer.class);
        }

        public OpenSite asOpenSite() {
            return (OpenSite)this.a$(OpenSite.class);
        }

        public OpenSite asOpenSite(String site) {
            OpenSite newElement = (OpenSite)this.core$().addAspect(OpenSite.class);
            newElement.core$().set((Layer)newElement, "site", Collections.singletonList(site));
            return newElement;
        }

        public boolean isOpenSite() {
            return this.core$().is(OpenSite.class);
        }

        public void removeOpenSite() {
            this.core$().removeAspect(OpenSite.class);
        }

        public Download asDownload() {
            Layer as = this.a$(Download.class);
            return as != null ? (Download)as : null;
        }

        public boolean isDownload() {
            return this.core$().is(Download.class);
        }

        public CloseDrawer asCloseDrawer() {
            return (CloseDrawer)this.a$(CloseDrawer.class);
        }

        public CloseDrawer asCloseDrawer(Block.Drawer drawer) {
            CloseDrawer newElement = (CloseDrawer)this.core$().addAspect(CloseDrawer.class);
            newElement.core$().set((Layer)newElement, "drawer", Collections.singletonList(drawer));
            return newElement;
        }

        public boolean isCloseDrawer() {
            return this.core$().is(CloseDrawer.class);
        }

        public void removeCloseDrawer() {
            this.core$().removeAspect(CloseDrawer.class);
        }

        public Behavior asBehavior() {
            Layer as = this.a$(Behavior.class);
            return as != null ? (Behavior)as : null;
        }

        public boolean isBehavior() {
            return this.core$().is(Behavior.class);
        }

        public Affirmed asAffirmed() {
            return (Affirmed)this.a$(Affirmed.class);
        }

        public Affirmed asAffirmed(String affirmText) {
            Affirmed newElement = (Affirmed)this.core$().addAspect(Affirmed.class);
            newElement.core$().set((Layer)newElement, "affirmText", Collections.singletonList(affirmText));
            return newElement;
        }

        public boolean isAffirmed() {
            return this.core$().is(Affirmed.class);
        }

        public void removeAffirmed() {
            this.core$().removeAspect(Affirmed.class);
        }

        public CloseDialog asCloseDialog() {
            return (CloseDialog)this.a$(CloseDialog.class);
        }

        public CloseDialog asCloseDialog(OtherComponents.AbstractDialog dialog) {
            CloseDialog newElement = (CloseDialog)this.core$().addAspect(CloseDialog.class);
            newElement.core$().set((Layer)newElement, "dialog", Collections.singletonList(dialog));
            return newElement;
        }

        public boolean isCloseDialog() {
            return this.core$().is(CloseDialog.class);
        }

        public void removeCloseDialog() {
            this.core$().removeAspect(CloseDialog.class);
        }

        public OpenBlock asOpenBlock() {
            return (OpenBlock)this.a$(OpenBlock.class);
        }

        public OpenBlock asOpenBlock(Block.Conditional block) {
            OpenBlock newElement = (OpenBlock)this.core$().addAspect(OpenBlock.class);
            newElement.core$().set((Layer)newElement, "block", Collections.singletonList(block));
            return newElement;
        }

        public boolean isOpenBlock() {
            return this.core$().is(OpenBlock.class);
        }

        public void removeOpenBlock() {
            this.core$().removeAspect(OpenBlock.class);
        }

        public SelectNextItem asSelectNextItem() {
            return (SelectNextItem)this.a$(SelectNextItem.class);
        }

        public SelectNextItem asSelectNextItem(CatalogComponents.Collection collection) {
            SelectNextItem newElement = (SelectNextItem)this.core$().addAspect(SelectNextItem.class);
            newElement.core$().set((Layer)newElement, "collection", Collections.singletonList(collection));
            return newElement;
        }

        public boolean isSelectNextItem() {
            return this.core$().is(SelectNextItem.class);
        }

        public void removeSelectNextItem() {
            this.core$().removeAspect(SelectNextItem.class);
        }

        public Readonly asReadonly() {
            Layer as = this.a$(Readonly.class);
            return as != null ? (Readonly)as : null;
        }

        public boolean isReadonly() {
            return this.core$().is(Readonly.class);
        }

        public Addressable asAddressable() {
            return (Addressable)this.a$(Addressable.class);
        }

        public Addressable asAddressable(Service.UI.Resource addressableResource) {
            Addressable newElement = (Addressable)this.core$().addAspect(Addressable.class);
            newElement.core$().set((Layer)newElement, "addressableResource", Collections.singletonList(addressableResource));
            return newElement;
        }

        public boolean isAddressable() {
            return this.core$().is(Addressable.class);
        }

        public void removeAddressable() {
            this.core$().removeAspect(Addressable.class);
        }

        public Secured asSecured() {
            Layer as = this.a$(Secured.class);
            return as != null ? (Secured)as : null;
        }

        public boolean isSecured() {
            return this.core$().is(Secured.class);
        }

        public OpenPage asOpenPage() {
            return (OpenPage)this.a$(OpenPage.class);
        }

        public OpenPage asOpenPage(Service.UI.Resource.Page page) {
            OpenPage newElement = (OpenPage)this.core$().addAspect(OpenPage.class);
            newElement.core$().set((Layer)newElement, "page", Collections.singletonList(page));
            return newElement;
        }

        public boolean isOpenPage() {
            return this.core$().is(OpenPage.class);
        }

        public void removeOpenPage() {
            this.core$().removeAspect(OpenPage.class);
        }

        public SelectPreviousItem asSelectPreviousItem() {
            return (SelectPreviousItem)this.a$(SelectPreviousItem.class);
        }

        public SelectPreviousItem asSelectPreviousItem(CatalogComponents.Collection collection) {
            SelectPreviousItem newElement = (SelectPreviousItem)this.core$().addAspect(SelectPreviousItem.class);
            newElement.core$().set((Layer)newElement, "collection", Collections.singletonList(collection));
            return newElement;
        }

        public boolean isSelectPreviousItem() {
            return this.core$().is(SelectPreviousItem.class);
        }

        public void removeSelectPreviousItem() {
            this.core$().removeAspect(SelectPreviousItem.class);
        }

        public OpenDialog asOpenDialog() {
            return (OpenDialog)this.a$(OpenDialog.class);
        }

        public OpenDialog asOpenDialog(OtherComponents.AbstractDialog dialog) {
            OpenDialog newElement = (OpenDialog)this.core$().addAspect(OpenDialog.class);
            newElement.core$().set((Layer)newElement, "dialog", Collections.singletonList(dialog));
            return newElement;
        }

        public boolean isOpenDialog() {
            return this.core$().is(OpenDialog.class);
        }

        public void removeOpenDialog() {
            this.core$().removeAspect(OpenDialog.class);
        }

        public OpenPopover asOpenPopover() {
            return (OpenPopover)this.a$(OpenPopover.class);
        }

        public OpenPopover asOpenPopover(Block.Popover popover) {
            OpenPopover newElement = (OpenPopover)this.core$().addAspect(OpenPopover.class);
            newElement.core$().set((Layer)newElement, "popover", Collections.singletonList(popover));
            return newElement;
        }

        public boolean isOpenPopover() {
            return this.core$().is(OpenPopover.class);
        }

        public void removeOpenPopover() {
            this.core$().removeAspect(OpenPopover.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
            map.put("target", new ArrayList<Target>(Collections.singletonList(this.target)));
            map.put("size", new ArrayList<Size>(Collections.singletonList(this.size)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("title")) {
                this.title = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("target")) {
                this.target = (Target)((Object)WordLoader.load(values, Target.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("size")) {
                this.size = (Size)((Object)WordLoader.load(values, Size.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("title")) {
                this.title = (String)values.get(0);
            } else if (name.equalsIgnoreCase("target")) {
                this.target = (Target)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("size")) {
                this.size = (Size)((Object)values.get(0));
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Download
        extends Behavior
        implements Terminal {
            protected List<String> options = new ArrayList<String>();
            protected CatalogComponents.Collection collection;
            protected Context context;

            public Download(Node node) {
                super(node);
            }

            public List<String> options() {
                return this.options;
            }

            public String options(int index) {
                return this.options.get(index);
            }

            public List<String> options(Predicate<String> predicate) {
                return this.options().stream().filter(predicate).collect(Collectors.toList());
            }

            public CatalogComponents.Collection collection() {
                return this.collection;
            }

            public Context context() {
                return this.context;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public Download collection(CatalogComponents.Collection value) {
                this.collection = value;
                return this;
            }

            public Download context(Context value) {
                this.context = value;
                return this;
            }

            @Override
            public Download title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public Download target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public Download size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("options", this.options);
                map.put("collection", this.collection != null ? new ArrayList<CatalogComponents.Collection>(Collections.singletonList(this.collection)) : Collections.emptyList());
                map.put("context", new ArrayList<Context>(Collections.singletonList(this.context)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = StringLoader.load(values, (Layer)this);
                } else if (name.equalsIgnoreCase("collection")) {
                    this.collection = (CatalogComponents.Collection)((Object)NodeLoader.load(values, CatalogComponents.Collection.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("context")) {
                    this.context = (Context)((Object)WordLoader.load(values, Context.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = new ArrayList(values);
                } else if (name.equalsIgnoreCase("collection")) {
                    this.collection = values.get(0) != null ? (CatalogComponents.Collection)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(CatalogComponents.Collection.class) : null;
                } else if (name.equalsIgnoreCase("context")) {
                    this.context = (Context)((Object)values.get(0));
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Download.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Download.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Download.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)Download.this.core$().graph().concept(Block.class).createNode(this.name, Download.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Download.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Download.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Download.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Download.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }

            public static enum Context {
                CurrentObject,
                Selection;

            }
        }

        public static class Export
        extends Behavior
        implements Terminal {
            protected List<String> options = new ArrayList<String>();
            protected Instant from;
            protected Instant to;
            protected Instant min;
            protected Instant max;
            protected int rangeMin;
            protected int rangeMax;

            public Export(Node node) {
                super(node);
            }

            public List<String> options() {
                return this.options;
            }

            public String options(int index) {
                return this.options.get(index);
            }

            public List<String> options(Predicate<String> predicate) {
                return this.options().stream().filter(predicate).collect(Collectors.toList());
            }

            public Instant from() {
                return this.from;
            }

            public Instant to() {
                return this.to;
            }

            public Instant min() {
                return this.min;
            }

            public Instant max() {
                return this.max;
            }

            public int rangeMin() {
                return this.rangeMin;
            }

            public int rangeMax() {
                return this.rangeMax;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public Export from(Instant value) {
                this.from = value;
                return this;
            }

            public Export to(Instant value) {
                this.to = value;
                return this;
            }

            public Export min(Instant value) {
                this.min = value;
                return this;
            }

            public Export max(Instant value) {
                this.max = value;
                return this;
            }

            public Export rangeMin(int value) {
                this.rangeMin = value;
                return this;
            }

            public Export rangeMax(int value) {
                this.rangeMax = value;
                return this;
            }

            @Override
            public Export title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public Export target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public Export size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("options", this.options);
                map.put("from", new ArrayList<Instant>(Collections.singletonList(this.from)));
                map.put("to", new ArrayList<Instant>(Collections.singletonList(this.to)));
                map.put("min", new ArrayList<Instant>(Collections.singletonList(this.min)));
                map.put("max", new ArrayList<Instant>(Collections.singletonList(this.max)));
                map.put("rangeMin", new ArrayList<Integer>(Collections.singletonList(this.rangeMin)));
                map.put("rangeMax", new ArrayList<Integer>(Collections.singletonList(this.rangeMax)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = StringLoader.load(values, (Layer)this);
                } else if (name.equalsIgnoreCase("from")) {
                    this.from = (Instant)InstantLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("to")) {
                    this.to = (Instant)InstantLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("min")) {
                    this.min = (Instant)InstantLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Instant)InstantLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("rangeMin")) {
                    this.rangeMin = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("rangeMax")) {
                    this.rangeMax = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("options")) {
                    this.options = new ArrayList(values);
                } else if (name.equalsIgnoreCase("from")) {
                    this.from = (Instant)values.get(0);
                } else if (name.equalsIgnoreCase("to")) {
                    this.to = (Instant)values.get(0);
                } else if (name.equalsIgnoreCase("min")) {
                    this.min = (Instant)values.get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Instant)values.get(0);
                } else if (name.equalsIgnoreCase("rangeMin")) {
                    this.rangeMin = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("rangeMax")) {
                    this.rangeMax = (Integer)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Export.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Export.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Export.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)Export.this.core$().graph().concept(Block.class).createNode(this.name, Export.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Export.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Export.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Export.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Export.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class SelectNextItem
        extends Behavior
        implements Terminal {
            protected CatalogComponents.Collection collection;

            public SelectNextItem(Node node) {
                super(node);
            }

            public CatalogComponents.Collection collection() {
                return this.collection;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public SelectNextItem collection(CatalogComponents.Collection value) {
                this.collection = value;
                return this;
            }

            @Override
            public SelectNextItem title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public SelectNextItem target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public SelectNextItem size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("collection", this.collection != null ? new ArrayList<CatalogComponents.Collection>(Collections.singletonList(this.collection)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("collection")) {
                    this.collection = (CatalogComponents.Collection)((Object)NodeLoader.load(values, CatalogComponents.Collection.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("collection")) {
                    this.collection = values.get(0) != null ? (CatalogComponents.Collection)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(CatalogComponents.Collection.class) : null;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(SelectNextItem.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(SelectNextItem.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(SelectNextItem.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)SelectNextItem.this.core$().graph().concept(Block.class).createNode(this.name, SelectNextItem.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)SelectNextItem.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, SelectNextItem.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)SelectNextItem.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, SelectNextItem.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class SelectPreviousItem
        extends Behavior
        implements Terminal {
            protected CatalogComponents.Collection collection;

            public SelectPreviousItem(Node node) {
                super(node);
            }

            public CatalogComponents.Collection collection() {
                return this.collection;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public SelectPreviousItem collection(CatalogComponents.Collection value) {
                this.collection = value;
                return this;
            }

            @Override
            public SelectPreviousItem title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public SelectPreviousItem target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public SelectPreviousItem size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("collection", this.collection != null ? new ArrayList<CatalogComponents.Collection>(Collections.singletonList(this.collection)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("collection")) {
                    this.collection = (CatalogComponents.Collection)((Object)NodeLoader.load(values, CatalogComponents.Collection.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("collection")) {
                    this.collection = values.get(0) != null ? (CatalogComponents.Collection)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(CatalogComponents.Collection.class) : null;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(SelectPreviousItem.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(SelectPreviousItem.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(SelectPreviousItem.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)SelectPreviousItem.this.core$().graph().concept(Block.class).createNode(this.name, SelectPreviousItem.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)SelectPreviousItem.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, SelectPreviousItem.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)SelectPreviousItem.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, SelectPreviousItem.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class OpenPopover
        extends Behavior
        implements Terminal {
            protected Block.Popover popover;

            public OpenPopover(Node node) {
                super(node);
            }

            public Block.Popover popover() {
                return this.popover;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public OpenPopover popover(Block.Popover value) {
                this.popover = value;
                return this;
            }

            @Override
            public OpenPopover title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public OpenPopover target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public OpenPopover size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("popover", this.popover != null ? new ArrayList<Block.Popover>(Collections.singletonList(this.popover)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("popover")) {
                    this.popover = (Block.Popover)((Object)NodeLoader.load(values, Block.Popover.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("popover")) {
                    this.popover = values.get(0) != null ? (Block.Popover)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Block.Popover.class) : null;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(OpenPopover.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(OpenPopover.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(OpenPopover.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)OpenPopover.this.core$().graph().concept(Block.class).createNode(this.name, OpenPopover.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)OpenPopover.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, OpenPopover.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)OpenPopover.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, OpenPopover.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class CloseDialog
        extends Behavior
        implements Terminal {
            protected OtherComponents.AbstractDialog dialog;

            public CloseDialog(Node node) {
                super(node);
            }

            public OtherComponents.AbstractDialog dialog() {
                return this.dialog;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public CloseDialog dialog(OtherComponents.AbstractDialog value) {
                this.dialog = value;
                return this;
            }

            @Override
            public CloseDialog title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public CloseDialog target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public CloseDialog size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("dialog", this.dialog != null ? new ArrayList<OtherComponents.AbstractDialog>(Collections.singletonList(this.dialog)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("dialog")) {
                    this.dialog = (OtherComponents.AbstractDialog)((Object)NodeLoader.load(values, OtherComponents.AbstractDialog.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("dialog")) {
                    this.dialog = values.get(0) != null ? (OtherComponents.AbstractDialog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(OtherComponents.AbstractDialog.class) : null;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(CloseDialog.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(CloseDialog.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(CloseDialog.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)CloseDialog.this.core$().graph().concept(Block.class).createNode(this.name, CloseDialog.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)CloseDialog.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, CloseDialog.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)CloseDialog.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, CloseDialog.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class OpenDialog
        extends Behavior
        implements Terminal {
            protected OtherComponents.AbstractDialog dialog;

            public OpenDialog(Node node) {
                super(node);
            }

            public OtherComponents.AbstractDialog dialog() {
                return this.dialog;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public OpenDialog dialog(OtherComponents.AbstractDialog value) {
                this.dialog = value;
                return this;
            }

            @Override
            public OpenDialog title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public OpenDialog target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public OpenDialog size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("dialog", this.dialog != null ? new ArrayList<OtherComponents.AbstractDialog>(Collections.singletonList(this.dialog)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("dialog")) {
                    this.dialog = (OtherComponents.AbstractDialog)((Object)NodeLoader.load(values, OtherComponents.AbstractDialog.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("dialog")) {
                    this.dialog = values.get(0) != null ? (OtherComponents.AbstractDialog)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(OtherComponents.AbstractDialog.class) : null;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(OpenDialog.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(OpenDialog.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(OpenDialog.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)OpenDialog.this.core$().graph().concept(Block.class).createNode(this.name, OpenDialog.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)OpenDialog.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, OpenDialog.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)OpenDialog.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, OpenDialog.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class OpenBlock
        extends Behavior
        implements Terminal {
            protected Block.Conditional block;

            public OpenBlock(Node node) {
                super(node);
            }

            public Block.Conditional block() {
                return this.block;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public OpenBlock block(Block.Conditional value) {
                this.block = value;
                return this;
            }

            @Override
            public OpenBlock title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public OpenBlock target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public OpenBlock size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("block", this.block != null ? new ArrayList<Block.Conditional>(Collections.singletonList(this.block)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("block")) {
                    this.block = (Block.Conditional)((Object)NodeLoader.load(values, Block.Conditional.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("block")) {
                    this.block = values.get(0) != null ? (Block.Conditional)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Block.Conditional.class) : null;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(OpenBlock.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(OpenBlock.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(OpenBlock.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)OpenBlock.this.core$().graph().concept(Block.class).createNode(this.name, OpenBlock.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)OpenBlock.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, OpenBlock.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)OpenBlock.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, OpenBlock.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class OpenSite
        extends Behavior
        implements Terminal {
            protected String site;

            public OpenSite(Node node) {
                super(node);
            }

            public String site() {
                return this.site;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public OpenSite site(String value) {
                this.site = value;
                return this;
            }

            @Override
            public OpenSite title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public OpenSite target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public OpenSite size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("site", new ArrayList<String>(Collections.singletonList(this.site)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("site")) {
                    this.site = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("site")) {
                    this.site = (String)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(OpenSite.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(OpenSite.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(OpenSite.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)OpenSite.this.core$().graph().concept(Block.class).createNode(this.name, OpenSite.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)OpenSite.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, OpenSite.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)OpenSite.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, OpenSite.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class OpenPage
        extends Behavior
        implements Terminal {
            protected Service.UI.Resource.Page page;

            public OpenPage(Node node) {
                super(node);
            }

            public Service.UI.Resource.Page page() {
                return this.page;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public OpenPage page(Service.UI.Resource.Page value) {
                this.page = value;
                return this;
            }

            @Override
            public OpenPage title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public OpenPage target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public OpenPage size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("page", this.page != null ? new ArrayList<Service.UI.Resource.Page>(Collections.singletonList(this.page)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("page")) {
                    this.page = (Service.UI.Resource.Page)((Object)NodeLoader.load(values, Service.UI.Resource.Page.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("page")) {
                    this.page = values.get(0) != null ? (Service.UI.Resource.Page)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Service.UI.Resource.Page.class) : null;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(OpenPage.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(OpenPage.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(OpenPage.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)OpenPage.this.core$().graph().concept(Block.class).createNode(this.name, OpenPage.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)OpenPage.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, OpenPage.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)OpenPage.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, OpenPage.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class CloseDrawer
        extends Behavior
        implements Terminal {
            protected Block.Drawer drawer;

            public CloseDrawer(Node node) {
                super(node);
            }

            public Block.Drawer drawer() {
                return this.drawer;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public CloseDrawer drawer(Block.Drawer value) {
                this.drawer = value;
                return this;
            }

            @Override
            public CloseDrawer title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public CloseDrawer target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public CloseDrawer size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("drawer", this.drawer != null ? new ArrayList<Block.Drawer>(Collections.singletonList(this.drawer)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("drawer")) {
                    this.drawer = (Block.Drawer)((Object)NodeLoader.load(values, Block.Drawer.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("drawer")) {
                    this.drawer = values.get(0) != null ? (Block.Drawer)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Block.Drawer.class) : null;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(CloseDrawer.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(CloseDrawer.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(CloseDrawer.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)CloseDrawer.this.core$().graph().concept(Block.class).createNode(this.name, CloseDrawer.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)CloseDrawer.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, CloseDrawer.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)CloseDrawer.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, CloseDrawer.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class OpenDrawer
        extends Behavior
        implements Terminal {
            protected Block.Drawer drawer;

            public OpenDrawer(Node node) {
                super(node);
            }

            public Block.Drawer drawer() {
                return this.drawer;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public OpenDrawer drawer(Block.Drawer value) {
                this.drawer = value;
                return this;
            }

            @Override
            public OpenDrawer title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public OpenDrawer target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public OpenDrawer size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("drawer", this.drawer != null ? new ArrayList<Block.Drawer>(Collections.singletonList(this.drawer)) : Collections.emptyList());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("drawer")) {
                    this.drawer = (Block.Drawer)((Object)NodeLoader.load(values, Block.Drawer.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("drawer")) {
                    this.drawer = values.get(0) != null ? (Block.Drawer)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Block.Drawer.class) : null;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(OpenDrawer.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(OpenDrawer.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(OpenDrawer.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)OpenDrawer.this.core$().graph().concept(Block.class).createNode(this.name, OpenDrawer.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)OpenDrawer.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, OpenDrawer.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)OpenDrawer.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, OpenDrawer.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Action
        extends Behavior
        implements Terminal {
            protected Context context;

            public Action(Node node) {
                super(node);
            }

            public Context context() {
                return this.context;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public Action context(Context value) {
                this.context = value;
                return this;
            }

            @Override
            public Action title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public Action target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public Action size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("context", new ArrayList<Context>(Collections.singletonList(this.context)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("context")) {
                    this.context = (Context)((Object)WordLoader.load(values, Context.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("context")) {
                    this.context = (Context)((Object)values.get(0));
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Behavior.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Action.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Action.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Action.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Behavior.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)Action.this.core$().graph().concept(Block.class).createNode(this.name, Action.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Action.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Action.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Action.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Action.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }

            public static enum Context {
                CurrentObject,
                Selection;

            }
        }

        public static abstract class Behavior
        extends Layer
        implements Terminal {
            protected Actionable _actionable;

            public Behavior(Node node) {
                super(node);
            }

            public String title() {
                return this._actionable.title();
            }

            public Target target() {
                return this._actionable.target();
            }

            public Size size() {
                return this._actionable.size();
            }

            public Behavior title(String value) {
                this._actionable.title(value);
                return this;
            }

            public Behavior target(Target value) {
                this._actionable.target(value);
                return this;
            }

            public Behavior size(Size value) {
                this._actionable.size(value);
                return this;
            }

            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Actionable) {
                    this._actionable = (Actionable)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Behavior.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Behavior.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Behavior.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Behavior.this.core$().graph().concept(Block.class).createNode(this.name, Behavior.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Behavior.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Behavior.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Behavior.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Behavior.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Signed
        extends Secured
        implements Terminal {
            protected String signText;
            protected String reasonText;

            public Signed(Node node) {
                super(node);
            }

            public String signText() {
                return this.signText;
            }

            public String reasonText() {
                return this.reasonText;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public Signed signText(String value) {
                this.signText = value;
                return this;
            }

            public Signed reasonText(String value) {
                this.reasonText = value;
                return this;
            }

            @Override
            public Signed title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public Signed target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public Signed size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("signText", new ArrayList<String>(Collections.singletonList(this.signText)));
                map.put("reasonText", new ArrayList<String>(Collections.singletonList(this.reasonText)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("signText")) {
                    this.signText = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("reasonText")) {
                    this.reasonText = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("signText")) {
                    this.signText = (String)values.get(0);
                } else if (name.equalsIgnoreCase("reasonText")) {
                    this.reasonText = (String)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Secured.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Signed.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Signed.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Signed.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Secured.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)Signed.this.core$().graph().concept(Block.class).createNode(this.name, Signed.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Signed.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Signed.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Signed.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Signed.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Affirmed
        extends Secured
        implements Terminal {
            protected String affirmText;

            public Affirmed(Node node) {
                super(node);
            }

            public String affirmText() {
                return this.affirmText;
            }

            @Override
            public String title() {
                return this._actionable.title();
            }

            @Override
            public Target target() {
                return this._actionable.target();
            }

            @Override
            public Size size() {
                return this._actionable.size();
            }

            public Affirmed affirmText(String value) {
                this.affirmText = value;
                return this;
            }

            @Override
            public Affirmed title(String value) {
                this._actionable.title(value);
                return this;
            }

            @Override
            public Affirmed target(Target value) {
                this._actionable.target(value);
                return this;
            }

            @Override
            public Affirmed size(Size value) {
                this._actionable.size(value);
                return this;
            }

            @Override
            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            @Override
            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            @Override
            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            @Override
            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            @Override
            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            @Override
            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            @Override
            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("affirmText", new ArrayList<String>(Collections.singletonList(this.affirmText)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._actionable.core$().load((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("affirmText")) {
                    this.affirmText = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._actionable.core$().set((Layer)this._actionable, name, values);
                if (name.equalsIgnoreCase("affirmText")) {
                    this.affirmText = (String)values.get(0);
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            @Override
            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear
            extends Secured.Clear {
                @Override
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Affirmed.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Affirmed.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                @Override
                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Affirmed.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends Secured.Create {
                public Create(String name) {
                    super(name);
                }

                @Override
                public Block block() {
                    Block newElement = (Block)Affirmed.this.core$().graph().concept(Block.class).createNode(this.name, Affirmed.this.core$()).as(Block.class);
                    return newElement;
                }

                @Override
                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Affirmed.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Affirmed.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                @Override
                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Affirmed.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Affirmed.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static abstract class Secured
        extends Layer
        implements Terminal {
            protected Actionable _actionable;

            public Secured(Node node) {
                super(node);
            }

            public String title() {
                return this._actionable.title();
            }

            public Target target() {
                return this._actionable.target();
            }

            public Size size() {
                return this._actionable.size();
            }

            public Secured title(String value) {
                this._actionable.title(value);
                return this;
            }

            public Secured target(Target value) {
                this._actionable.target(value);
                return this;
            }

            public Secured size(Size value) {
                this._actionable.size(value);
                return this;
            }

            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Actionable) {
                    this._actionable = (Actionable)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Secured.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Secured.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Secured.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Secured.this.core$().graph().concept(Block.class).createNode(this.name, Secured.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Secured.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Secured.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Secured.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Secured.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Addressable
        extends io.intino.konos.model.graph.Addressable
        implements Terminal {
            protected Actionable _actionable;

            public Addressable(Node node) {
                super(node);
            }

            public String title() {
                return this._actionable.title();
            }

            public Target target() {
                return this._actionable.target();
            }

            public Size size() {
                return this._actionable.size();
            }

            public Addressable title(String value) {
                this._actionable.title(value);
                return this;
            }

            public Addressable target(Target value) {
                this._actionable.target(value);
                return this;
            }

            public Addressable size(Size value) {
                this._actionable.size(value);
                return this;
            }

            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Actionable) {
                    this._actionable = (Actionable)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Addressable.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Addressable.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Addressable.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Addressable$Create {
                public Create(String name) {
                    super(Addressable.this, name);
                }

                public Block block() {
                    Block newElement = (Block)Addressable.this.core$().graph().concept(Block.class).createNode(this.name, Addressable.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Addressable.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Addressable.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Addressable.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Addressable.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Readonly
        extends Layer
        implements Terminal {
            protected Actionable _actionable;

            public Readonly(Node node) {
                super(node);
            }

            public String title() {
                return this._actionable.title();
            }

            public Target target() {
                return this._actionable.target();
            }

            public Size size() {
                return this._actionable.size();
            }

            public Readonly title(String value) {
                this._actionable.title(value);
                return this;
            }

            public Readonly target(Target value) {
                this._actionable.target(value);
                return this;
            }

            public Readonly size(Size value) {
                this._actionable.size(value);
                return this;
            }

            public List<Block> blockList() {
                return this._actionable.blockList();
            }

            public Block blockList(int index) {
                return this._actionable.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._actionable.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._actionable.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._actionable.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._actionable.notificationList().get(index);
            }

            public Actionable asActionable() {
                return (Actionable)this.a$(Actionable.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Actionable) {
                    this._actionable = (Actionable)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Readonly.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Readonly.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Readonly.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Readonly.this.core$().graph().concept(Block.class).createNode(this.name, Readonly.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Readonly.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Readonly.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public class Clear
        extends Component.Clear {
            public Clear() {
                super(Actionable.this);
            }
        }

        public class Create
        extends Component.Create {
            public Create(String name) {
                super(Actionable.this, name);
            }
        }

        public static enum Size {
            Small,
            Medium,
            Large;

        }

        public static enum Target {
            Blank,
            Self,
            Parent,
            Top;

        }
    }

    public static class Toolbar
    extends Component
    implements Terminal {
        protected List<Component> componentList = new ArrayList<Component>();
        protected Linked _linked;

        public Toolbar(Node node) {
            super(node);
        }

        public List<Component> componentList() {
            return Collections.unmodifiableList(this.componentList);
        }

        public Component component(int index) {
            return this.componentList.get(index);
        }

        public List<Component> componentList(Predicate<Component> predicate) {
            return this.componentList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Linked asLinked() {
            return (Linked)this.a$(Linked.class);
        }

        public Linked asLinked(CatalogComponents.Collection to) {
            Linked newElement = (Linked)this.core$().addAspect(Linked.class);
            newElement.core$().set((Layer)newElement, "to", Collections.singletonList(to));
            return newElement;
        }

        public boolean isLinked() {
            return this.core$().is(Linked.class);
        }

        public void removeLinked() {
            this.core$().removeAspect(Linked.class);
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<Component>(this.componentList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Component")) {
                this.componentList.add((Component)node.as(Component.class));
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Component")) {
                this.componentList.remove(node.as(Component.class));
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Linked
        extends Layer
        implements Terminal {
            protected CatalogComponents.Collection to;
            protected List<Actionable> actionableList = new ArrayList<Actionable>();
            protected Toolbar _toolbar;

            public Linked(Node node) {
                super(node);
            }

            public CatalogComponents.Collection to() {
                return this.to;
            }

            public Linked to(CatalogComponents.Collection value) {
                this.to = value;
                return this;
            }

            public List<Actionable> actionableList() {
                return Collections.unmodifiableList(this.actionableList);
            }

            public Actionable actionable(int index) {
                return this.actionableList.get(index);
            }

            public List<Actionable> actionableList(Predicate<Actionable> predicate) {
                return this.actionableList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Component> componentList() {
                return this._toolbar.componentList();
            }

            public Component componentList(int index) {
                return this._toolbar.componentList().get(index);
            }

            public List<Block> blockList() {
                return this._toolbar.blockList();
            }

            public Block blockList(int index) {
                return this._toolbar.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._toolbar.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._toolbar.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._toolbar.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._toolbar.notificationList().get(index);
            }

            public Toolbar asToolbar() {
                return (Toolbar)this.a$(Toolbar.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                new ArrayList<Actionable>(this.actionableList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("to", this.to != null ? new ArrayList<CatalogComponents.Collection>(Collections.singletonList(this.to)) : Collections.emptyList());
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("InteractionComponents$Actionable")) {
                    this.actionableList.add((Actionable)node.as(Actionable.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("InteractionComponents$Actionable")) {
                    this.actionableList.remove(node.as(Actionable.class));
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("to")) {
                    this.to = (CatalogComponents.Collection)((Object)NodeLoader.load(values, CatalogComponents.Collection.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("to")) {
                    this.to = values.get(0) != null ? (CatalogComponents.Collection)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(CatalogComponents.Collection.class) : null;
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Toolbar) {
                    this._toolbar = (Toolbar)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void component(Predicate<Component> filter) {
                    new ArrayList<Component>(Linked.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Linked.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Linked.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Linked.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Component component() {
                    Component newElement = (Component)Linked.this.core$().graph().concept(Component.class).createNode(this.name, Linked.this.core$()).as(Component.class);
                    return newElement;
                }

                public Block block() {
                    Block newElement = (Block)Linked.this.core$().graph().concept(Block.class).createNode(this.name, Linked.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Linked.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Linked.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Linked.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Linked.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }

                public IconButton iconButton(String title, String icon) {
                    IconButton newElement = (IconButton)Linked.this.core$().graph().concept(IconButton.class).createNode(this.name, Linked.this.core$()).as(IconButton.class);
                    newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                    newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                    return newElement;
                }

                public Link link(String title) {
                    Link newElement = (Link)Linked.this.core$().graph().concept(Link.class).createNode(this.name, Linked.this.core$()).as(Link.class);
                    newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                    return newElement;
                }

                public Button button(String title) {
                    Button newElement = (Button)Linked.this.core$().graph().concept(Button.class).createNode(this.name, Linked.this.core$()).as(Button.class);
                    newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                    return newElement;
                }

                public Toggle toggle(String title) {
                    Toggle newElement = (Toggle)Linked.this.core$().graph().concept(Toggle.class).createNode(this.name, Linked.this.core$()).as(Toggle.class);
                    newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                    return newElement;
                }

                public SplitButton splitButton(String title, List<String> options, String defaultOption) {
                    SplitButton newElement = (SplitButton)Linked.this.core$().graph().concept(SplitButton.class).createNode(this.name, Linked.this.core$()).as(SplitButton.class);
                    newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                    newElement.core$().set((Layer)newElement, "options", options);
                    newElement.core$().set((Layer)newElement, "defaultOption", Collections.singletonList(defaultOption));
                    return newElement;
                }

                public Switch switch$(String title) {
                    Switch newElement = (Switch)Linked.this.core$().graph().concept(Switch.class).createNode(this.name, Linked.this.core$()).as(Switch.class);
                    newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                    return newElement;
                }

                public AvatarIconButton avatarIconButton(String title) {
                    AvatarIconButton newElement = (AvatarIconButton)Linked.this.core$().graph().concept(AvatarIconButton.class).createNode(this.name, Linked.this.core$()).as(AvatarIconButton.class);
                    newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                    return newElement;
                }

                public IconToggle iconToggle(String title, String icon) {
                    IconToggle newElement = (IconToggle)Linked.this.core$().graph().concept(IconToggle.class).createNode(this.name, Linked.this.core$()).as(IconToggle.class);
                    newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                    newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                    return newElement;
                }

                public MaterialIconToggle materialIconToggle(String title, String icon) {
                    MaterialIconToggle newElement = (MaterialIconToggle)Linked.this.core$().graph().concept(MaterialIconToggle.class).createNode(this.name, Linked.this.core$()).as(MaterialIconToggle.class);
                    newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                    newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                    return newElement;
                }

                public MaterialIconButton materialIconButton(String title, String icon) {
                    MaterialIconButton newElement = (MaterialIconButton)Linked.this.core$().graph().concept(MaterialIconButton.class).createNode(this.name, Linked.this.core$()).as(MaterialIconButton.class);
                    newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                    newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                    return newElement;
                }
            }
        }

        public class Clear
        extends Component.Clear {
            public Clear() {
                super(Toolbar.this);
            }

            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Toolbar.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Component.Create {
            public Create(String name) {
                super(Toolbar.this, name);
            }

            public Component component() {
                Component newElement = (Component)Toolbar.this.core$().graph().concept(Component.class).createNode(this.name, Toolbar.this.core$()).as(Component.class);
                return newElement;
            }

            public HelperComponents.Row row(List<CatalogComponents.Collection.Mold.Item> items) {
                HelperComponents.Row newElement = (HelperComponents.Row)Toolbar.this.core$().graph().concept(HelperComponents.Row.class).createNode(this.name, Toolbar.this.core$()).as(HelperComponents.Row.class);
                newElement.core$().set((Layer)newElement, "items", items);
                return newElement;
            }

            public CatalogComponents.Collection.Mold.Heading heading() {
                CatalogComponents.Collection.Mold.Heading newElement = (CatalogComponents.Collection.Mold.Heading)Toolbar.this.core$().graph().concept(CatalogComponents.Collection.Mold.Heading.class).createNode(this.name, Toolbar.this.core$()).as(CatalogComponents.Collection.Mold.Heading.class);
                return newElement;
            }

            public OtherComponents.User user() {
                OtherComponents.User newElement = (OtherComponents.User)Toolbar.this.core$().graph().concept(OtherComponents.User.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.User.class);
                return newElement;
            }

            public OtherComponents.Divider divider() {
                OtherComponents.Divider newElement = (OtherComponents.Divider)Toolbar.this.core$().graph().concept(OtherComponents.Divider.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.Divider.class);
                return newElement;
            }

            public CatalogComponents.SearchBox searchBox(List<CatalogComponents.Collection> collections) {
                CatalogComponents.SearchBox newElement = (CatalogComponents.SearchBox)Toolbar.this.core$().graph().concept(CatalogComponents.SearchBox.class).createNode(this.name, Toolbar.this.core$()).as(CatalogComponents.SearchBox.class);
                newElement.core$().set((Layer)newElement, "collections", collections);
                return newElement;
            }

            public DataComponents.Date date() {
                DataComponents.Date newElement = (DataComponents.Date)Toolbar.this.core$().graph().concept(DataComponents.Date.class).createNode(this.name, Toolbar.this.core$()).as(DataComponents.Date.class);
                return newElement;
            }

            public OtherComponents.Chip chip() {
                OtherComponents.Chip newElement = (OtherComponents.Chip)Toolbar.this.core$().graph().concept(OtherComponents.Chip.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.Chip.class);
                return newElement;
            }

            public OtherComponents.Selector selector() {
                OtherComponents.Selector newElement = (OtherComponents.Selector)Toolbar.this.core$().graph().concept(OtherComponents.Selector.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.Selector.class);
                return newElement;
            }

            public OtherComponents.DecisionDialog decisionDialog(String title) {
                OtherComponents.DecisionDialog newElement = (OtherComponents.DecisionDialog)Toolbar.this.core$().graph().concept(OtherComponents.DecisionDialog.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.DecisionDialog.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }

            public VisualizationComponents.Dashboard dashboard() {
                VisualizationComponents.Dashboard newElement = (VisualizationComponents.Dashboard)Toolbar.this.core$().graph().concept(VisualizationComponents.Dashboard.class).createNode(this.name, Toolbar.this.core$()).as(VisualizationComponents.Dashboard.class);
                return newElement;
            }

            public CatalogComponents.Grouping grouping(List<CatalogComponents.Collection> collections) {
                CatalogComponents.Grouping newElement = (CatalogComponents.Grouping)Toolbar.this.core$().graph().concept(CatalogComponents.Grouping.class).createNode(this.name, Toolbar.this.core$()).as(CatalogComponents.Grouping.class);
                newElement.core$().set((Layer)newElement, "collections", collections);
                return newElement;
            }

            public OtherComponents.Icon icon(String icon) {
                OtherComponents.Icon newElement = (OtherComponents.Icon)Toolbar.this.core$().graph().concept(OtherComponents.Icon.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.Icon.class);
                newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                return newElement;
            }

            public Toggle toggle(String title) {
                Toggle newElement = (Toggle)Toolbar.this.core$().graph().concept(Toggle.class).createNode(this.name, Toolbar.this.core$()).as(Toggle.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }

            public OtherComponents.Dialog dialog(String title) {
                OtherComponents.Dialog newElement = (OtherComponents.Dialog)Toolbar.this.core$().graph().concept(OtherComponents.Dialog.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.Dialog.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }

            public DataComponents.Location location() {
                DataComponents.Location newElement = (DataComponents.Location)Toolbar.this.core$().graph().concept(DataComponents.Location.class).createNode(this.name, Toolbar.this.core$()).as(DataComponents.Location.class);
                return newElement;
            }

            public Toolbar toolbar() {
                Toolbar newElement = (Toolbar)Toolbar.this.core$().graph().concept(Toolbar.class).createNode(this.name, Toolbar.this.core$()).as(Toolbar.class);
                return newElement;
            }

            public DataComponents.Text text() {
                DataComponents.Text newElement = (DataComponents.Text)Toolbar.this.core$().graph().concept(DataComponents.Text.class).createNode(this.name, Toolbar.this.core$()).as(DataComponents.Text.class);
                return newElement;
            }

            public OtherComponents.Progress progress() {
                OtherComponents.Progress newElement = (OtherComponents.Progress)Toolbar.this.core$().graph().concept(OtherComponents.Progress.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.Progress.class);
                return newElement;
            }

            public DataComponents.Image image() {
                DataComponents.Image newElement = (DataComponents.Image)Toolbar.this.core$().graph().concept(DataComponents.Image.class).createNode(this.name, Toolbar.this.core$()).as(DataComponents.Image.class);
                return newElement;
            }

            public OtherComponents.Snackbar snackbar() {
                OtherComponents.Snackbar newElement = (OtherComponents.Snackbar)Toolbar.this.core$().graph().concept(OtherComponents.Snackbar.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.Snackbar.class);
                return newElement;
            }

            public Button button(String title) {
                Button newElement = (Button)Toolbar.this.core$().graph().concept(Button.class).createNode(this.name, Toolbar.this.core$()).as(Button.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }

            public CatalogComponents.Table table() {
                CatalogComponents.Table newElement = (CatalogComponents.Table)Toolbar.this.core$().graph().concept(CatalogComponents.Table.class).createNode(this.name, Toolbar.this.core$()).as(CatalogComponents.Table.class);
                return newElement;
            }

            @Override
            public Block block() {
                Block newElement = (Block)Toolbar.this.core$().graph().concept(Block.class).createNode(this.name, Toolbar.this.core$()).as(Block.class);
                return newElement;
            }

            public VisualizationComponents.Chart chart(Dataframe input, String query) {
                VisualizationComponents.Chart newElement = (VisualizationComponents.Chart)Toolbar.this.core$().graph().concept(VisualizationComponents.Chart.class).createNode(this.name, Toolbar.this.core$()).as(VisualizationComponents.Chart.class);
                newElement.core$().set((Layer)newElement, "input", Collections.singletonList(input));
                newElement.core$().set((Layer)newElement, "query", Collections.singletonList(query));
                return newElement;
            }

            public CatalogComponents.Map map() {
                CatalogComponents.Map newElement = (CatalogComponents.Map)Toolbar.this.core$().graph().concept(CatalogComponents.Map.class).createNode(this.name, Toolbar.this.core$()).as(CatalogComponents.Map.class);
                return newElement;
            }

            public DataComponents.Number number() {
                DataComponents.Number newElement = (DataComponents.Number)Toolbar.this.core$().graph().concept(DataComponents.Number.class).createNode(this.name, Toolbar.this.core$()).as(DataComponents.Number.class);
                return newElement;
            }

            public OtherComponents.Card card() {
                OtherComponents.Card newElement = (OtherComponents.Card)Toolbar.this.core$().graph().concept(OtherComponents.Card.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.Card.class);
                return newElement;
            }

            public OtherComponents.Tooltip tooltip() {
                OtherComponents.Tooltip newElement = (OtherComponents.Tooltip)Toolbar.this.core$().graph().concept(OtherComponents.Tooltip.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.Tooltip.class);
                return newElement;
            }

            public OtherComponents.ProxyStamp proxyStamp(String proxy, Service.UI.Use from) {
                OtherComponents.ProxyStamp newElement = (OtherComponents.ProxyStamp)Toolbar.this.core$().graph().concept(OtherComponents.ProxyStamp.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.ProxyStamp.class);
                newElement.core$().set((Layer)newElement, "proxy", Collections.singletonList(proxy));
                newElement.core$().set((Layer)newElement, "from", Collections.singletonList(from));
                return newElement;
            }

            public OtherComponents.MaterialIcon materialIcon(String icon) {
                OtherComponents.MaterialIcon newElement = (OtherComponents.MaterialIcon)Toolbar.this.core$().graph().concept(OtherComponents.MaterialIcon.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.MaterialIcon.class);
                newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                return newElement;
            }

            public OtherComponents.DisplayStamp displayStamp(Display display) {
                OtherComponents.DisplayStamp newElement = (OtherComponents.DisplayStamp)Toolbar.this.core$().graph().concept(OtherComponents.DisplayStamp.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.DisplayStamp.class);
                newElement.core$().set((Layer)newElement, "display", Collections.singletonList(display));
                return newElement;
            }

            public SplitButton splitButton(String title, List<String> options, String defaultOption) {
                SplitButton newElement = (SplitButton)Toolbar.this.core$().graph().concept(SplitButton.class).createNode(this.name, Toolbar.this.core$()).as(SplitButton.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                newElement.core$().set((Layer)newElement, "options", options);
                newElement.core$().set((Layer)newElement, "defaultOption", Collections.singletonList(defaultOption));
                return newElement;
            }

            public OtherComponents.Frame frame(String url) {
                OtherComponents.Frame newElement = (OtherComponents.Frame)Toolbar.this.core$().graph().concept(OtherComponents.Frame.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.Frame.class);
                newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
                return newElement;
            }

            public VisualizationComponents.Stepper stepper() {
                VisualizationComponents.Stepper newElement = (VisualizationComponents.Stepper)Toolbar.this.core$().graph().concept(VisualizationComponents.Stepper.class).createNode(this.name, Toolbar.this.core$()).as(VisualizationComponents.Stepper.class);
                return newElement;
            }

            public AvatarIconButton avatarIconButton(String title) {
                AvatarIconButton newElement = (AvatarIconButton)Toolbar.this.core$().graph().concept(AvatarIconButton.class).createNode(this.name, Toolbar.this.core$()).as(AvatarIconButton.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }

            public CatalogComponents.Collection.Mold.Item item(int height) {
                CatalogComponents.Collection.Mold.Item newElement = (CatalogComponents.Collection.Mold.Item)Toolbar.this.core$().graph().concept(CatalogComponents.Collection.Mold.Item.class).createNode(this.name, Toolbar.this.core$()).as(CatalogComponents.Collection.Mold.Item.class);
                newElement.core$().set((Layer)newElement, "height", Collections.singletonList(height));
                return newElement;
            }

            public DataComponents.File file() {
                DataComponents.File newElement = (DataComponents.File)Toolbar.this.core$().graph().concept(DataComponents.File.class).createNode(this.name, Toolbar.this.core$()).as(DataComponents.File.class);
                return newElement;
            }

            public IconToggle iconToggle(String title, String icon) {
                IconToggle newElement = (IconToggle)Toolbar.this.core$().graph().concept(IconToggle.class).createNode(this.name, Toolbar.this.core$()).as(IconToggle.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                return newElement;
            }

            public VisualizationComponents.Stepper.Step step() {
                VisualizationComponents.Stepper.Step newElement = (VisualizationComponents.Stepper.Step)Toolbar.this.core$().graph().concept(VisualizationComponents.Stepper.Step.class).createNode(this.name, Toolbar.this.core$()).as(VisualizationComponents.Stepper.Step.class);
                return newElement;
            }

            public VisualizationComponents.Slider slider() {
                VisualizationComponents.Slider newElement = (VisualizationComponents.Slider)Toolbar.this.core$().graph().concept(VisualizationComponents.Slider.class).createNode(this.name, Toolbar.this.core$()).as(VisualizationComponents.Slider.class);
                return newElement;
            }

            public CatalogComponents.List list() {
                CatalogComponents.List newElement = (CatalogComponents.List)Toolbar.this.core$().graph().concept(CatalogComponents.List.class).createNode(this.name, Toolbar.this.core$()).as(CatalogComponents.List.class);
                return newElement;
            }

            public IconButton iconButton(String title, String icon) {
                IconButton newElement = (IconButton)Toolbar.this.core$().graph().concept(IconButton.class).createNode(this.name, Toolbar.this.core$()).as(IconButton.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                return newElement;
            }

            public OtherComponents.AlertDialog alertDialog(String title, String message) {
                OtherComponents.AlertDialog newElement = (OtherComponents.AlertDialog)Toolbar.this.core$().graph().concept(OtherComponents.AlertDialog.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.AlertDialog.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                newElement.core$().set((Layer)newElement, "message", Collections.singletonList(message));
                return newElement;
            }

            public CatalogComponents.Sorting sorting(List<CatalogComponents.Collection> collections) {
                CatalogComponents.Sorting newElement = (CatalogComponents.Sorting)Toolbar.this.core$().graph().concept(CatalogComponents.Sorting.class).createNode(this.name, Toolbar.this.core$()).as(CatalogComponents.Sorting.class);
                newElement.core$().set((Layer)newElement, "collections", collections);
                return newElement;
            }

            public OtherComponents.OwnerTemplateStamp ownerTemplateStamp(Service.UI.Use owner, String template) {
                OtherComponents.OwnerTemplateStamp newElement = (OtherComponents.OwnerTemplateStamp)Toolbar.this.core$().graph().concept(OtherComponents.OwnerTemplateStamp.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.OwnerTemplateStamp.class);
                newElement.core$().set((Layer)newElement, "owner", Collections.singletonList(owner));
                newElement.core$().set((Layer)newElement, "template", Collections.singletonList(template));
                return newElement;
            }

            public Template template() {
                Template newElement = (Template)Toolbar.this.core$().graph().concept(Template.class).createNode(this.name, Toolbar.this.core$()).as(Template.class);
                return newElement;
            }

            public MaterialIconButton materialIconButton(String title, String icon) {
                MaterialIconButton newElement = (MaterialIconButton)Toolbar.this.core$().graph().concept(MaterialIconButton.class).createNode(this.name, Toolbar.this.core$()).as(MaterialIconButton.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                return newElement;
            }

            public Link link(String title) {
                Link newElement = (Link)Toolbar.this.core$().graph().concept(Link.class).createNode(this.name, Toolbar.this.core$()).as(Link.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }

            public HelperComponents.HelperComponent helperComponent() {
                HelperComponents.HelperComponent newElement = (HelperComponents.HelperComponent)Toolbar.this.core$().graph().concept(HelperComponents.HelperComponent.class).createNode(this.name, Toolbar.this.core$()).as(HelperComponents.HelperComponent.class);
                return newElement;
            }

            public Switch switch$(String title) {
                Switch newElement = (Switch)Toolbar.this.core$().graph().concept(Switch.class).createNode(this.name, Toolbar.this.core$()).as(Switch.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }

            public CatalogComponents.Magazine magazine() {
                CatalogComponents.Magazine newElement = (CatalogComponents.Magazine)Toolbar.this.core$().graph().concept(CatalogComponents.Magazine.class).createNode(this.name, Toolbar.this.core$()).as(CatalogComponents.Magazine.class);
                return newElement;
            }

            public MaterialIconToggle materialIconToggle(String title, String icon) {
                MaterialIconToggle newElement = (MaterialIconToggle)Toolbar.this.core$().graph().concept(MaterialIconToggle.class).createNode(this.name, Toolbar.this.core$()).as(MaterialIconToggle.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
                return newElement;
            }

            public VisualizationComponents.Spinner spinner() {
                VisualizationComponents.Spinner newElement = (VisualizationComponents.Spinner)Toolbar.this.core$().graph().concept(VisualizationComponents.Spinner.class).createNode(this.name, Toolbar.this.core$()).as(VisualizationComponents.Spinner.class);
                return newElement;
            }

            public OtherComponents.CollectionDialog collectionDialog(String title) {
                OtherComponents.CollectionDialog newElement = (OtherComponents.CollectionDialog)Toolbar.this.core$().graph().concept(OtherComponents.CollectionDialog.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.CollectionDialog.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                return newElement;
            }

            public OtherComponents.TemplateStamp templateStamp(Template template) {
                OtherComponents.TemplateStamp newElement = (OtherComponents.TemplateStamp)Toolbar.this.core$().graph().concept(OtherComponents.TemplateStamp.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.TemplateStamp.class);
                newElement.core$().set((Layer)newElement, "template", Collections.singletonList(template));
                return newElement;
            }

            public CatalogComponents.DynamicTable dynamicTable() {
                CatalogComponents.DynamicTable newElement = (CatalogComponents.DynamicTable)Toolbar.this.core$().graph().concept(CatalogComponents.DynamicTable.class).createNode(this.name, Toolbar.this.core$()).as(CatalogComponents.DynamicTable.class);
                return newElement;
            }

            public OtherComponents.Header header() {
                OtherComponents.Header newElement = (OtherComponents.Header)Toolbar.this.core$().graph().concept(OtherComponents.Header.class).createNode(this.name, Toolbar.this.core$()).as(OtherComponents.Header.class);
                return newElement;
            }

            public VisualizationComponents.TemporalSlider temporalSlider(List<CatalogComponents.Collection> collections, List<VisualizationComponents.TemporalSlider.Scales> scales) {
                VisualizationComponents.TemporalSlider newElement = (VisualizationComponents.TemporalSlider)Toolbar.this.core$().graph().concept(VisualizationComponents.TemporalSlider.class).createNode(this.name, Toolbar.this.core$()).as(VisualizationComponents.TemporalSlider.class);
                newElement.core$().set((Layer)newElement, "collections", collections);
                newElement.core$().set((Layer)newElement, "scales", scales);
                return newElement;
            }

            public VisualizationComponents.KPI kPI() {
                VisualizationComponents.KPI newElement = (VisualizationComponents.KPI)Toolbar.this.core$().graph().concept(VisualizationComponents.KPI.class).createNode(this.name, Toolbar.this.core$()).as(VisualizationComponents.KPI.class);
                return newElement;
            }
        }
    }

    public class Clear {
        public void toolbar(Predicate<Toolbar> filter) {
            new ArrayList<Toolbar>(InteractionComponents.this.toolbarList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void link(Predicate<Link> filter) {
            new ArrayList<Link>(InteractionComponents.this.linkList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void button(Predicate<Button> filter) {
            new ArrayList<Button>(InteractionComponents.this.buttonList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void splitButton(Predicate<SplitButton> filter) {
            new ArrayList<SplitButton>(InteractionComponents.this.splitButtonList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void iconButton(Predicate<IconButton> filter) {
            new ArrayList<IconButton>(InteractionComponents.this.iconButtonList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void materialIconButton(Predicate<MaterialIconButton> filter) {
            new ArrayList<MaterialIconButton>(InteractionComponents.this.materialIconButtonList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void avatarIconButton(Predicate<AvatarIconButton> filter) {
            new ArrayList<AvatarIconButton>(InteractionComponents.this.avatarIconButtonList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void switch$(Predicate<Switch> filter) {
            new ArrayList<Switch>(InteractionComponents.this.switchList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void toggle(Predicate<Toggle> filter) {
            new ArrayList<Toggle>(InteractionComponents.this.toggleList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void iconToggle(Predicate<IconToggle> filter) {
            new ArrayList<IconToggle>(InteractionComponents.this.iconToggleList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void materialIconToggle(Predicate<MaterialIconToggle> filter) {
            new ArrayList<MaterialIconToggle>(InteractionComponents.this.materialIconToggleList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Toolbar toolbar() {
            Toolbar newElement = (Toolbar)InteractionComponents.this.core$().graph().concept(Toolbar.class).createNode(this.name, InteractionComponents.this.core$()).as(Toolbar.class);
            return newElement;
        }

        public Link link(String title) {
            Link newElement = (Link)InteractionComponents.this.core$().graph().concept(Link.class).createNode(this.name, InteractionComponents.this.core$()).as(Link.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public Button button(String title) {
            Button newElement = (Button)InteractionComponents.this.core$().graph().concept(Button.class).createNode(this.name, InteractionComponents.this.core$()).as(Button.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public SplitButton splitButton(String title, List<String> options, String defaultOption) {
            SplitButton newElement = (SplitButton)InteractionComponents.this.core$().graph().concept(SplitButton.class).createNode(this.name, InteractionComponents.this.core$()).as(SplitButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "options", options);
            newElement.core$().set((Layer)newElement, "defaultOption", Collections.singletonList(defaultOption));
            return newElement;
        }

        public IconButton iconButton(String title, String icon) {
            IconButton newElement = (IconButton)InteractionComponents.this.core$().graph().concept(IconButton.class).createNode(this.name, InteractionComponents.this.core$()).as(IconButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public MaterialIconButton materialIconButton(String title, String icon) {
            MaterialIconButton newElement = (MaterialIconButton)InteractionComponents.this.core$().graph().concept(MaterialIconButton.class).createNode(this.name, InteractionComponents.this.core$()).as(MaterialIconButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public AvatarIconButton avatarIconButton(String title) {
            AvatarIconButton newElement = (AvatarIconButton)InteractionComponents.this.core$().graph().concept(AvatarIconButton.class).createNode(this.name, InteractionComponents.this.core$()).as(AvatarIconButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public Switch switch$(String title) {
            Switch newElement = (Switch)InteractionComponents.this.core$().graph().concept(Switch.class).createNode(this.name, InteractionComponents.this.core$()).as(Switch.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public Toggle toggle(String title) {
            Toggle newElement = (Toggle)InteractionComponents.this.core$().graph().concept(Toggle.class).createNode(this.name, InteractionComponents.this.core$()).as(Toggle.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public IconToggle iconToggle(String title, String icon) {
            IconToggle newElement = (IconToggle)InteractionComponents.this.core$().graph().concept(IconToggle.class).createNode(this.name, InteractionComponents.this.core$()).as(IconToggle.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public MaterialIconToggle materialIconToggle(String title, String icon) {
            MaterialIconToggle newElement = (MaterialIconToggle)InteractionComponents.this.core$().graph().concept(MaterialIconToggle.class).createNode(this.name, InteractionComponents.this.core$()).as(MaterialIconToggle.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }
    }
}

