/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.cache;

import io.intino.alexandria.logger.Logger;
import io.intino.konos.builder.codegeneration.cache.LayerCache;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.magritte.framework.Store;
import io.intino.magritte.framework.stores.FileSystemStore;
import io.intino.magritte.framework.utils.StoreAuditor;
import io.intino.magritte.io.Stash;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class CacheReader
extends HashMap<String, Integer> {
    private final File folder;

    public CacheReader(File folder) {
        this.folder = folder;
    }

    public LayerCache load(KonosGraph graph) {
        return this.load(graph, null);
    }

    public LayerCache load(KonosGraph graph, Stash[] stashes) {
        StoreAuditor auditor = this.loadAuditor(graph, stashes);
        return this.loadCacheFile(auditor);
    }

    private StoreAuditor loadAuditor(KonosGraph graph, Stash[] stashes) {
        StoreAuditor auditor = new StoreAuditor((Store)this.store(stashes));
        Arrays.stream(graph.core$().openedStashes()).forEach(arg_0 -> ((StoreAuditor)auditor).trace(arg_0));
        return auditor;
    }

    private FileSystemStore store(final Stash[] stashes) {
        return new FileSystemStore(this.folder){

            public Stash stashFrom(String path) {
                Stash stash = Arrays.stream(stashes).filter(s -> s.path.equals(path)).findFirst().orElse(null);
                if (stash != null) {
                    return stash;
                }
                return super.stashFrom(path);
            }
        };
    }

    private LayerCache loadCacheFile(StoreAuditor auditor) {
        try {
            File cacheFile = new File(this.folder + "/.cache");
            if (!cacheFile.exists()) {
                return new LayerCache(auditor);
            }
            Properties properties = new Properties();
            properties.load(new FileInputStream(cacheFile));
            Map<String, String> marks = properties.entrySet().stream().collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue()));
            return new LayerCache(auditor, marks);
        }
        catch (IOException e2) {
            Logger.error((Throwable)e2);
            return null;
        }
    }
}

