/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.subscriber;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datahub.subscriber.SubscriberTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.context.WarningMessage;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Subscriber;
import java.io.File;
import java.util.List;

public class SubscriberRenderer {
    private final CompilationContext context;
    private final List<Subscriber> subscribers;
    private final File srcSubscribers;

    public SubscriberRenderer(CompilationContext context, KonosGraph graph) {
        this.context = context;
        this.subscribers = graph.subscriberList();
        this.srcSubscribers = new File(context.src(Target.Owner), "subscribers");
    }

    public void execute() throws KonosException {
        CompilationContext.DataHubManifest manifest = this.context.dataHubManifest();
        if (!this.subscribers.isEmpty() && manifest == null) {
            throw new KonosException("Is required the Data hub declaration in artifact to instance subscribers");
        }
        if (manifest == null) {
            return;
        }
        for (Subscriber subscriber : this.subscribers) {
            FrameBuilder builder = this.baseFrame(subscriber);
            String type = manifest.tankClasses.get(subscriber.event());
            if (type == null) {
                this.context.addWarning(new WarningMessage(1, "Tank not found", null, 1, 1));
                continue;
            }
            builder.add("type", (Object)type);
            builder.add("typeName", (Object)type.substring(type.lastIndexOf(".") + 1));
            this.context.classes().put(((Object)((Object)subscriber)).getClass().getSimpleName() + "#" + subscriber.name$(), "subscribers." + subscriber.name$());
            if (this.alreadyRendered(this.srcSubscribers, subscriber.name$())) continue;
            Commons.writeFrame(this.srcSubscribers, subscriber.name$(), Formatters.customize(new SubscriberTemplate()).render((Object)builder.toFrame()));
        }
    }

    private FrameBuilder baseFrame(Subscriber subscriber) {
        return new FrameBuilder(new String[]{"subscriber"}).add("box", (Object)this.context.boxName()).add("package", (Object)this.context.packageName()).add("name", (Object)subscriber.name$());
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

