/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.mounter;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datahub.mounter.MounterTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Datamart;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MounterRenderer {
    private final CompilationContext context;
    private final KonosGraph graph;
    private File genMounters;

    public MounterRenderer(CompilationContext context, KonosGraph graph) {
        this.context = context;
        this.graph = graph;
        this.genMounters = new File(context.gen(Target.Owner), "mounters");
    }

    public void execute() {
        CompilationContext.DataHubManifest manifest = this.context.dataHubManifest();
        for (Datamart datamart : this.graph.datamartList()) {
            for (Datamart.Mounter mounter : datamart.mounterList()) {
                String mounterName = mounter.name$();
                FrameBuilder builder = this.baseFrame(mounter);
                if (mounter.isPopulation()) {
                    this.populationMounter(mounter, mounterName, builder);
                    continue;
                }
                if (manifest == null || this.alreadyRendered(this.context.src(Target.Owner), mounterName)) continue;
                this.eventMounter(mounter, mounterName, manifest, builder);
            }
        }
    }

    private FrameBuilder baseFrame(Datamart.Mounter mounter) {
        return new FrameBuilder(new String[]{"mounter"}).add("box", (Object)this.context.boxName()).add("package", (Object)this.context.packageName()).add("name", (Object)mounter.name$());
    }

    private void eventMounter(Datamart.Mounter mounter, String mounterName, CompilationContext.DataHubManifest manifest, FrameBuilder builder) {
        String datamart = ((Datamart)mounter.core$().ownerAs(Datamart.class)).name$();
        builder.add("event").add("datamart", (Object)datamart).add("type", (Object)this.types(mounter, manifest));
        this.context.classes().put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "mounters." + datamart + "." + mounterName);
        File datamartFolder = new File(this.context.src(Target.Owner), datamart);
        File mounters = new File(datamartFolder, "mounters");
        if (!this.alreadyRendered(mounters, mounterName)) {
            Commons.writeFrame(mounters, mounterName, Formatters.customize(new MounterTemplate()).render((Object)builder.toFrame()));
        }
    }

    private String[] types(Datamart.Mounter mounter, CompilationContext.DataHubManifest manifest) {
        return (String[])mounter.asEvent().requireList().stream().map(r -> manifest.tankClasses.get(r.tank())).filter(Objects::nonNull).toArray(String[]::new);
    }

    private void populationMounter(Datamart.Mounter mounter, String mounterName, FrameBuilder builder) {
        this.populationMounter(builder, mounter.asPopulation());
        this.context.classes().put(((Object)((Object)mounter)).getClass().getSimpleName() + "#" + mounter.name$(), "mounters." + mounterName);
        Commons.writeFrame(this.genMounters, mounter.name$(), Formatters.customize(new MounterTemplate()).render((Object)builder.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(mounter), Commons.javaFile(this.genMounters, mounter.name$()).getAbsolutePath()));
        this.mounterFunctions(mounter);
    }

    private void mounterFunctions(Datamart.Mounter mounter) {
        String datamart = ((Datamart)mounter.core$().ownerAs(Datamart.class)).name$();
        mounter.asPopulation().clear().split(t -> true);
        FrameBuilder baseFrame = this.baseFrame(mounter).add("src");
        this.populationMounter(baseFrame, mounter.asPopulation());
        File datamartFolder = new File(this.context.src(Target.Owner), datamart);
        File mounters = new File(datamartFolder, "mounters");
        if (!this.alreadyRendered(mounters, mounter.name$() + "MounterFunctions")) {
            Commons.writeFrame(mounters, mounter.name$() + "MounterFunctions", Formatters.customize(new MounterTemplate()).render((Object)baseFrame.toFrame()));
        }
    }

    private void populationMounter(FrameBuilder builder, Datamart.Mounter.Population mounter) {
        ArrayList frames = new ArrayList();
        mounter.sourceList().stream().map(this::buildersOf).forEach(frames::addAll);
        builder.add("population").add("column", (Object)frames.toArray(new FrameBuilder[0])).add("datamart", (Object)((Datamart)mounter.core$().ownerAs(Datamart.class)).name$()).add("format", (Object)mounter.format().name());
    }

    private List<FrameBuilder> buildersOf(Datamart.Mounter.Population.Source source) {
        ArrayList<FrameBuilder> builders = new ArrayList<FrameBuilder>();
        for (String tank : this.tanksOf((Datamart.Mounter.Population)source.core$().ownerAs(Datamart.Mounter.Population.class), source.tank())) {
            FrameBuilder builder = new FrameBuilder(new String[]{"column"}).add("fullName", (Object)tank).add("name", (Object)source.tank()).add("type", (Object)source.type().name()).add("mounter", (Object)((Datamart.Mounter)source.core$().ownerAs(Datamart.Mounter.class)).name$());
            if (source.isId()) {
                builder.add("facet", (Object)"id");
            }
            builders.add(builder);
        }
        return builders;
    }

    private List<String> tanksOf(Datamart.Mounter.Population mounter, String tank) {
        ArrayList<String> tanks = new ArrayList<String>();
        if (!mounter.splitList().isEmpty()) {
            for (Datamart.Mounter.Population.Split split : mounter.splitList()) {
                split.splits().stream().map(s -> s + "." + tank).forEach(tanks::add);
            }
        } else {
            return Collections.singletonList(tank);
        }
        return tanks;
    }

    private boolean alreadyRendered(File destination, String action) {
        return Commons.javaFile(destination, action).exists();
    }
}

