/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.zip.Zip;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.ui.ServiceRenderer;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.compiler.shared.PostCompileActionMessage;
import io.intino.konos.compiler.shared.PostCompileDependantWebModuleActionMessage;
import io.intino.konos.model.graph.Service;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class ServiceCreator
extends UIRenderer {
    private final Service.UI service;

    public ServiceCreator(CompilationContext compilationContext, Service.UI service) {
        super(compilationContext, Target.Accessor);
        this.service = service;
    }

    @Override
    public void render() {
        try {
            this.context.postCompileActionMessages().add((PostCompileActionMessage)new PostCompileDependantWebModuleActionMessage(this.context.configuration().module(), this.service.name$()));
            if (this.context.webModuleDirectory() == null) {
                this.context.webModuleDirectory(new File(this.context.configuration().moduleDirectory().getParentFile(), Formatters.camelCaseToSnakeCase().format((Object)this.service.name$()).toString()));
            }
            if (!this.context.webModuleDirectory().exists()) {
                this.createSkeleton();
            }
            new ServiceRenderer(this.context, this.service).execute();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void createSkeleton() throws IOException {
        File destiny = this.root();
        File file = new File(destiny, "ui.zip");
        this.copyResourcesRecursively(this.getClass().getResource("/ui/ui.zip"), file);
        new Zip(file).unzip(destiny.getAbsolutePath());
        file.delete();
        new File(destiny, "images").mkdirs();
    }

    private void copyResourcesRecursively(URL originUrl, File destination) {
        try {
            URLConnection urlConnection = originUrl.openConnection();
            if (urlConnection instanceof JarURLConnection) {
                this.copyJarResourcesRecursively(destination, (JarURLConnection)urlConnection);
            } else {
                FileUtils.copyFile((File)new File(originUrl.getPath()), (File)destination);
            }
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    private void copyJarResourcesRecursively(File destination, JarURLConnection jarConnection) throws IOException {
        JarFile jarFile = jarConnection.getJarFile();
        Enumeration<JarEntry> list = jarFile.entries();
        while (list.hasMoreElements()) {
            JarEntry entry = list.nextElement();
            if (!entry.getName().startsWith(jarConnection.getEntryName())) continue;
            String fileName = StringUtils.removeStart((String)entry.getName(), (String)jarConnection.getEntryName());
            if (!entry.isDirectory()) {
                InputStream entryInputStream = jarFile.getInputStream(entry);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)entryInputStream, (File)new File(destination, fileName));
                    continue;
                }
                finally {
                    if (entryInputStream != null) {
                        entryInputStream.close();
                    }
                    continue;
                }
            }
            new File(destination, fileName).exists();
        }
    }
}

