/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.helpers;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.model.graph.Data;
import io.intino.konos.model.graph.Redirect;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Service;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Commons {
    private static final Logger LOG = Logger.getGlobal();

    public static void writeFrame(File packageFolder, String name, String text) {
        try {
            packageFolder.mkdirs();
            File file = Commons.javaFile(packageFolder, name);
            Files.write(file.toPath(), text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
    }

    public static Frame fileFrame(String directory, String packageName) {
        if (directory.startsWith(".archetype")) {
            String boxPackage = packageName;
            boxPackage = boxPackage.substring(0, boxPackage.lastIndexOf("."));
            String archetypePath = Commons.archetypePath(directory);
            return new FrameBuilder(new String[]{"archetype"}).add("package", (Object)boxPackage).add("path", (Object)archetypePath).toFrame();
        }
        return new FrameBuilder(new String[]{"file"}).add("path", (Object)directory).toFrame();
    }

    public static void write(File file, String text) {
        Commons.write(file.toPath(), text);
    }

    public static void write(Path file, String text) {
        try {
            Files.write(file, text.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            LOG.severe(e.getMessage());
        }
    }

    public static File javaFile(File packageFolder, String name) {
        return Commons.preparedFile(packageFolder, name, "java");
    }

    public static String javaFilename(String name) {
        return Commons.prepareName(name) + ".java";
    }

    public static File javascriptFile(File packageFolder, String name) {
        return Commons.preparedFile(packageFolder, name, "js");
    }

    public static long queryParameters(Service.REST.Resource.Operation operation) {
        return operation.parameterList().stream().filter(p -> p.in() == Service.REST.Resource.Parameter.In.query).count();
    }

    public static long bodyParameters(Service.REST.Resource.Operation operation) {
        return operation.parameterList().stream().filter(p -> p.in() == Service.REST.Resource.Parameter.In.body).count();
    }

    public static long queryParameters(Service.REST.Notification operation) {
        return operation.parameterList().stream().filter(p -> p.in() == Service.REST.Notification.Parameter.In.query).count();
    }

    public static long bodyParameters(Service.REST.Notification operation) {
        return operation.parameterList().stream().filter(p -> p.in() == Service.REST.Notification.Parameter.In.body).count();
    }

    public static String format(String path) {
        return path.isEmpty() ? "" : path + "/";
    }

    public static String path(Service.REST.Resource resource) {
        Service.REST service = (Service.REST)resource.core$().ownerAs(Service.REST.class);
        Object basePath = Commons.basePath(service.basePath());
        if (service.info() != null && service.info().version() != null) {
            basePath = (String)basePath + service.info().version() + "/";
        }
        String resourcePath = resource.path();
        return ((String)basePath + resourcePath).replace("//", "/");
    }

    public static String path(Service.Soap.Operation operation) {
        Service.Soap service = (Service.Soap)operation.core$().ownerAs(Service.Soap.class);
        return (Commons.basePath(service.basePath()) + operation.path()).replace("//", "/");
    }

    private static String basePath(String path) {
        path = !path.isEmpty() && !path.endsWith("/") ? path + "/" : path;
        return path.startsWith("/") ? path.substring(1) : path;
    }

    public static Set<String> extractParameters(String text) {
        LinkedHashSet<String> list = new LinkedHashSet<String>();
        Pattern pattern = Pattern.compile("\\{([^\\}]*)\\}");
        Matcher matcher = pattern.matcher(text);
        while (matcher.find()) {
            list.add(matcher.group(1));
        }
        return list;
    }

    public static List<String> extractUrlPathParameters(String url) {
        return Arrays.stream(url.split("/")).filter(s -> s.contains(":")).map(s -> s.replace(":", "")).collect(Collectors.toList());
    }

    public static String returnType(Response response) {
        if (response == null || response.asType() == null) {
            return "void";
        }
        return response.isList() ? "List<" + response.asType().type() + ">" : response.asType().type();
    }

    public static String returnType(Response response, String packageName) {
        if (response == null) {
            return "void";
        }
        if (response.i$(Redirect.class)) {
            return String.class.getName();
        }
        if (response.asType() == null) {
            return "void";
        }
        String innerPackage = response.isObject() && response.asObject().isComponent() != false ? String.join((CharSequence)".", packageName, "schemas.") : "";
        String type = innerPackage + response.asType().type();
        return response.isList() ? "List<" + type + ">" : type;
    }

    public static String fullReturnType(Response response, String packageName) {
        if (response == null) {
            return "void";
        }
        if (response.i$(Redirect.class)) {
            return String.class.getName();
        }
        if (response.asType() == null) {
            return "void";
        }
        String innerPackage = response.isObject() ? String.join((CharSequence)".", packageName, "schemas.") : "";
        String type = innerPackage + response.asType().type();
        return response.isList() ? "java.util.List<" + type + ">" : type;
    }

    public static int fileParameters(Service.REST.Resource.Operation operation) {
        return (int)operation.parameterList().stream().filter(p -> p.i$(Data.File.class)).count();
    }

    public static String firstUpperCase(String value) {
        return value.isEmpty() ? "" : value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    private static File preparedFile(File packageFolder, String name, String extension) {
        return new File(packageFolder, Commons.prepareName(name) + "." + extension);
    }

    private static String prepareName(String name) {
        return name.isEmpty() ? name : Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    public static String archetypePath(String path) {
        return path.replace(".archetype", "").substring(1).replace("+", "().").replace("-", "().") + "()";
    }
}

