/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.bpm.parser;

import io.intino.alexandria.logger.Logger;
import io.intino.konos.builder.codegeneration.bpm.parser.Link;
import io.intino.konos.builder.codegeneration.bpm.parser.State;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BpmnParser {
    private InputStream source;
    private Document document;
    private Map<String, String> annotations;
    private List<Node> tasks;

    public BpmnParser(String xmlText) {
        this(new ByteArrayInputStream(xmlText.getBytes()));
    }

    public BpmnParser(InputStream xmlStream) {
        this.source = xmlStream;
        this.document = this.getDOM();
        this.tasks = this.tasks();
        this.annotations = this.annotations();
    }

    public List<State> states() {
        List<State> states = this.tasks.stream().map(this::stateFrom).collect(Collectors.toList());
        this.calculateLinks(states);
        states.forEach(this::addComments);
        return states;
    }

    private void calculateLinks(List<State> states) {
        Map<String, State> map = this.toMap(states);
        this.tasks.forEach(task -> this.calculateLinks(map, (Node)task));
    }

    private void calculateLinks(Map<String, State> map, Node task) {
        this.calculateStartEvent(map.get(this.id(task)), task);
        List<Node> outgoings = this.children(task, "outgoing");
        for (Node outgoing : outgoings) {
            List<String> destinationStates = this.findDestinationStates(outgoing.getTextContent(), false);
            if (destinationStates.isEmpty()) {
                this.calculateEndEvent(map.get(this.id(task)), outgoing);
            }
            for (String destinationState : destinationStates) {
                String[] split = destinationState.split("#");
                map.get(this.id(task)).link(map.get(split[0]), Link.Type.valueOf(split[1]), split.length > 2);
            }
        }
    }

    private void calculateEndEvent(State state, Node outgoing) {
        this.streamOf(this.document.getElementsByTagName("bpmn:endEvent")).forEach(n -> {
            Node incoming = this.child((Node)n, "incoming");
            if (incoming != null && incoming.getTextContent().equals(outgoing.getTextContent())) {
                state.type(State.Type.Terminal);
            }
        });
    }

    private void calculateStartEvent(State state, Node task) {
        Node outgoing = this.child(this.document.getElementsByTagName("bpmn:startEvent").item(0), "outgoing");
        Node incoming = this.child(task, "incoming");
        if (outgoing != null && incoming != null && outgoing.getTextContent().equals(incoming.getTextContent())) {
            state.type(State.Type.Initial);
        }
    }

    private List<String> findDestinationStates(String outgoingId, boolean isDefault) {
        List<String> states = this.directIncoming(outgoingId, isDefault);
        if (!states.isEmpty()) {
            return states;
        }
        return this.throughGateway(outgoingId);
    }

    private List<String> directIncoming(String outgoingId, boolean isDefault) {
        for (Node item : this.tasks) {
            List<Node> incomings = this.children(item, "incoming");
            for (Node incoming : incomings) {
                if (incoming == null || !outgoingId.equalsIgnoreCase(incoming.getTextContent())) continue;
                return List.of(this.id(item) + "#" + Link.Type.Line + (isDefault ? "#Default" : ""));
            }
        }
        return Collections.emptyList();
    }

    private List<Node> tasks() {
        NodeList items = this.document.getDocumentElement().getElementsByTagName("bpmn:process").item(0).getChildNodes();
        return IntStream.range(0, items.getLength()).mapToObj(items::item).filter(item -> item.getNodeName().endsWith("Task") || item.getNodeName().equals("bpmn:task")).collect(Collectors.toList());
    }

    private List<String> throughGateway(String outgoingId) {
        Node processNode = this.document.getElementsByTagName("bpmn:process").item(0);
        NodeList childNodes = processNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node gateway = childNodes.item(i);
            if (!gateway.getNodeName().endsWith("Gateway")) continue;
            Node incoming = this.child(gateway, "incoming");
            String defaultBranch = this.attribute(gateway, "default");
            if (incoming == null || !incoming.getTextContent().equals(outgoingId)) continue;
            return this.children(gateway, "outgoing").stream().map(n -> this.findDestinationStates(n.getTextContent(), n.getTextContent().equals(defaultBranch))).flatMap(Collection::stream).map(s -> s.replace("#" + Link.Type.Line, "#" + Link.Type.valueOf(BpmnParser.firstUpperCase(this.cleanGatewayType(gateway))))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private String cleanGatewayType(Node child) {
        return child.getNodeName().replace("bpmn:", "").replace("Gateway", "");
    }

    private State stateFrom(Node item) {
        State state = new State(this.id(item), this.name(item));
        if (!item.getNodeName().equals("bpmn:task")) {
            state.taskType(State.TaskType.valueOf(BpmnParser.firstUpperCase(this.cleanTaskType(item))));
        }
        return state;
    }

    private void addComments(State state) {
        if (this.annotations.containsKey(state.id())) {
            state.comment(this.annotations.get(state.id()));
        }
        if (state.type().equals((Object)State.Type.Initial) && state.comment() == null) {
            state.comment(this.annotations.get(this.id(this.document.getElementsByTagName("bpmn:startEvent").item(0))));
        }
    }

    private Map<String, String> annotations() {
        return this.streamOf(this.document.getElementsByTagName("bpmn:textAnnotation")).collect(Collectors.toMap(n -> this.findState(this.id((Node)n)), n -> this.child((Node)n, "text").getTextContent(), (a, b) -> b));
    }

    private String findState(String textAnnotationId) {
        return this.streamOf(this.document.getElementsByTagName("bpmn:association")).filter(node -> this.attribute((Node)node, "targetRef").equals(textAnnotationId)).findFirst().map(n -> this.attribute((Node)n, "sourceRef")).get();
    }

    private Stream<Node> streamOf(NodeList nodeList) {
        return IntStream.range(0, nodeList.getLength()).mapToObj(nodeList::item);
    }

    private Node child(Node item, String type) {
        NodeList childNodes = item.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!child.getNodeName().equalsIgnoreCase("bpmn:" + type)) continue;
            return child;
        }
        return null;
    }

    private List<Node> children(Node item, String type) {
        NodeList childNodes = item.getChildNodes();
        return IntStream.range(0, childNodes.getLength()).mapToObj(childNodes::item).filter(child -> child.getNodeName().equalsIgnoreCase("bpmn:" + type)).collect(Collectors.toList());
    }

    private Map<String, State> toMap(List<State> states) {
        return states.stream().collect(Collectors.toMap(State::id, s -> s));
    }

    private String id(Node item) {
        return this.attribute(item, "id");
    }

    private String name(Node item) {
        return this.attribute(item, "name");
    }

    private String attribute(Node item, String name) {
        Node namedItem = item.getAttributes().getNamedItem(name);
        return namedItem == null ? null : namedItem.getNodeValue();
    }

    private Document getDOM() {
        Document document = null;
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            document = dBuilder.parse(this.source);
            document.getDocumentElement().normalize();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        return document;
    }

    public static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    private String cleanTaskType(Node child) {
        return child.getNodeName().replace("bpmn:", "").replace("Task", "");
    }
}

