/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.KonosGraph;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Datamart
extends Layer
implements Terminal {
    protected Type type;
    protected List<Mounter> mounterList = new ArrayList<Mounter>();

    public Datamart(Node node) {
        super(node);
    }

    public Type type() {
        return this.type;
    }

    public Datamart type(Type value) {
        this.type = value;
        return this;
    }

    public List<Mounter> mounterList() {
        return Collections.unmodifiableList(this.mounterList);
    }

    public Mounter mounter(int index) {
        return this.mounterList.get(index);
    }

    public List<Mounter> mounterList(Predicate<Mounter> predicate) {
        return this.mounterList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Mounter>(this.mounterList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Datamart$Mounter")) {
            this.mounterList.add((Mounter)node.as(Mounter.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Datamart$Mounter")) {
            this.mounterList.remove(node.as(Mounter.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("type")) {
            this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
        }
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("type")) {
            this.type = (Type)((Object)values.get(0));
        }
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Mounter
    extends Layer
    implements Terminal {
        protected MounterType _mounterType;
        protected Population _population;
        protected Event _event;

        public Mounter(Node node) {
            super(node);
        }

        public Population asPopulation() {
            return (Population)this.a$(Population.class);
        }

        public Population asPopulation(Population.Format format) {
            Population newElement = (Population)this.core$().addAspect(Population.class);
            newElement.core$().set((Layer)newElement, "format", Collections.singletonList(format));
            return newElement;
        }

        public boolean isPopulation() {
            return this.core$().is(Population.class);
        }

        public void removePopulation() {
            this.core$().removeAspect(Population.class);
        }

        public Event asEvent() {
            Layer as = this.a$(Event.class);
            return as != null ? (Event)as : (Event)this.core$().addAspect(Event.class);
        }

        public boolean isEvent() {
            return this.core$().is(Event.class);
        }

        public MounterType asMounterType() {
            Layer as = this.a$(MounterType.class);
            return as != null ? (MounterType)as : (MounterType)this.core$().addAspect(MounterType.class);
        }

        public boolean isMounterType() {
            return this.core$().is(MounterType.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Event
        extends MounterType
        implements Terminal {
            protected List<Require> requireList = new ArrayList<Require>();

            public Event(Node node) {
                super(node);
            }

            public List<Require> requireList() {
                return Collections.unmodifiableList(this.requireList);
            }

            public Require require(int index) {
                return this.requireList.get(index);
            }

            public List<Require> requireList(Predicate<Require> predicate) {
                return this.requireList().stream().filter(predicate).collect(Collectors.toList());
            }

            @Override
            public Mounter asMounter() {
                return (Mounter)this.a$(Mounter.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                new ArrayList<Require>(this.requireList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Datamart$Mounter$Event$Require")) {
                    this.requireList.add((Require)node.as(Require.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Datamart$Mounter$Event$Require")) {
                    this.requireList.remove(node.as(Require.class));
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._mounter.core$().load((Layer)this._mounter, name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._mounter.core$().set((Layer)this._mounter, name, values);
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Require
            extends Layer
            implements Terminal {
                protected String tank;

                public Require(Node node) {
                    super(node);
                }

                public String tank() {
                    return this.tank;
                }

                public Require tank(String value) {
                    this.tank = value;
                    return this;
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("tank", new ArrayList<String>(Collections.singletonList(this.tank)));
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("tank")) {
                        this.tank = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("tank")) {
                        this.tank = (String)values.get(0);
                    }
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public class Clear {
                public void require(Predicate<Require> filter) {
                    new ArrayList<Require>(Event.this.requireList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends MounterType.Create {
                public Create(String name) {
                    super(name);
                }

                public Require require(String tank) {
                    Require newElement = (Require)Event.this.core$().graph().concept(Require.class).createNode(this.name, Event.this.core$()).as(Require.class);
                    newElement.core$().set((Layer)newElement, "tank", Collections.singletonList(tank));
                    return newElement;
                }
            }
        }

        public static class Population
        extends MounterType
        implements Terminal {
            protected Format format;
            protected List<Split> splitList = new ArrayList<Split>();
            protected List<Source> sourceList = new ArrayList<Source>();
            protected Filter filter;
            protected Aggregation aggregation;

            public Population(Node node) {
                super(node);
            }

            public Format format() {
                return this.format;
            }

            public Population format(Format value) {
                this.format = value;
                return this;
            }

            public List<Split> splitList() {
                return Collections.unmodifiableList(this.splitList);
            }

            public Split split(int index) {
                return this.splitList.get(index);
            }

            public List<Split> splitList(Predicate<Split> predicate) {
                return this.splitList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Source> sourceList() {
                return Collections.unmodifiableList(this.sourceList);
            }

            public Source source(int index) {
                return this.sourceList.get(index);
            }

            public List<Source> sourceList(Predicate<Source> predicate) {
                return this.sourceList().stream().filter(predicate).collect(Collectors.toList());
            }

            public Filter filter() {
                return this.filter;
            }

            public Aggregation aggregation() {
                return this.aggregation;
            }

            @Override
            public Mounter asMounter() {
                return (Mounter)this.a$(Mounter.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                new ArrayList<Split>(this.splitList).forEach(c -> components.add(c.core$()));
                new ArrayList<Source>(this.sourceList).forEach(c -> components.add(c.core$()));
                if (this.filter != null) {
                    components.add(this.filter.core$());
                }
                if (this.aggregation != null) {
                    components.add(this.aggregation.core$());
                }
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("format", new ArrayList<Format>(Collections.singletonList(this.format)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Datamart$Mounter$Population$Split")) {
                    this.splitList.add((Split)node.as(Split.class));
                }
                if (node.is("Datamart$Mounter$Population$Source")) {
                    this.sourceList.add((Source)node.as(Source.class));
                }
                if (node.is("Datamart$Mounter$Population$Filter")) {
                    this.filter = (Filter)node.as(Filter.class);
                }
                if (node.is("Datamart$Mounter$Population$Aggregation")) {
                    this.aggregation = (Aggregation)node.as(Aggregation.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Datamart$Mounter$Population$Split")) {
                    this.splitList.remove(node.as(Split.class));
                }
                if (node.is("Datamart$Mounter$Population$Source")) {
                    this.sourceList.remove(node.as(Source.class));
                }
                if (node.is("Datamart$Mounter$Population$Filter")) {
                    this.filter = null;
                }
                if (node.is("Datamart$Mounter$Population$Aggregation")) {
                    this.aggregation = null;
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                this._mounter.core$().load((Layer)this._mounter, name, values);
                if (name.equalsIgnoreCase("format")) {
                    this.format = (Format)((Object)WordLoader.load(values, Format.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                this._mounter.core$().set((Layer)this._mounter, name, values);
                if (name.equalsIgnoreCase("format")) {
                    this.format = (Format)((Object)values.get(0));
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Aggregation
            extends Layer
            implements Terminal {
                protected List<Column> columnList = new ArrayList<Column>();

                public Aggregation(Node node) {
                    super(node);
                }

                public List<Column> columnList() {
                    return Collections.unmodifiableList(this.columnList);
                }

                public Column column(int index) {
                    return this.columnList.get(index);
                }

                public List<Column> columnList(Predicate<Column> predicate) {
                    return this.columnList().stream().filter(predicate).collect(Collectors.toList());
                }

                protected List<Node> componentList$() {
                    LinkedHashSet components = new LinkedHashSet(super.componentList$());
                    new ArrayList<Column>(this.columnList).forEach(c -> components.add(c.core$()));
                    return new ArrayList<Node>(components);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    return map;
                }

                protected void addNode$(Node node) {
                    super.addNode$(node);
                    if (node.is("Datamart$Mounter$Population$Aggregation$Column")) {
                        this.columnList.add((Column)node.as(Column.class));
                    }
                }

                protected void removeNode$(Node node) {
                    super.removeNode$(node);
                    if (node.is("Datamart$Mounter$Population$Aggregation$Column")) {
                        this.columnList.remove(node.as(Column.class));
                    }
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Clear clear() {
                    return new Clear();
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public static class Column
                extends Layer
                implements Terminal {
                    protected String name;
                    protected String tank;
                    protected Type type;

                    public Column(Node node) {
                        super(node);
                    }

                    public String name() {
                        return this.name;
                    }

                    public String tank() {
                        return this.tank;
                    }

                    public Type type() {
                        return this.type;
                    }

                    public Column name(String value) {
                        this.name = value;
                        return this;
                    }

                    public Column tank(String value) {
                        this.tank = value;
                        return this;
                    }

                    public Column type(Type value) {
                        this.type = value;
                        return this;
                    }

                    protected Map<String, List<?>> variables$() {
                        LinkedHashMap map = new LinkedHashMap();
                        map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
                        map.put("tank", new ArrayList<String>(Collections.singletonList(this.tank)));
                        map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
                        return map;
                    }

                    protected void load$(String name, List<?> values) {
                        super.load$(name, values);
                        if (name.equalsIgnoreCase("name")) {
                            this.name = (String)StringLoader.load(values, (Layer)this).get(0);
                        } else if (name.equalsIgnoreCase("tank")) {
                            this.tank = (String)StringLoader.load(values, (Layer)this).get(0);
                        } else if (name.equalsIgnoreCase("type")) {
                            this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
                        }
                    }

                    protected void set$(String name, List<?> values) {
                        super.set$(name, values);
                        if (name.equalsIgnoreCase("name")) {
                            this.name = (String)values.get(0);
                        } else if (name.equalsIgnoreCase("tank")) {
                            this.tank = (String)values.get(0);
                        } else if (name.equalsIgnoreCase("type")) {
                            this.type = (Type)((Object)values.get(0));
                        }
                    }

                    public KonosGraph graph() {
                        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                    }

                    public static enum Type {
                        Boolean,
                        String,
                        Integer,
                        Double,
                        Nominal,
                        Datetime,
                        Instant,
                        Long,
                        Timetag;

                    }
                }

                public class Clear {
                    public void column(Predicate<Column> filter) {
                        new ArrayList<Column>(Aggregation.this.columnList()).stream().filter(filter).forEach(Layer::delete$);
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Column column(String name, String tank, Column.Type type) {
                        Column newElement = (Column)Aggregation.this.core$().graph().concept(Column.class).createNode(this.name, Aggregation.this.core$()).as(Column.class);
                        newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
                        newElement.core$().set((Layer)newElement, "tank", Collections.singletonList(tank));
                        newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
                        return newElement;
                    }
                }
            }

            public static class Filter
            extends Layer
            implements Terminal {
                public Filter(Node node) {
                    super(node);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public static class Source
            extends Layer
            implements Terminal {
                protected String tank;
                protected Type type;
                protected Id _id;
                protected Constant _constant;

                public Source(Node node) {
                    super(node);
                }

                public String tank() {
                    return this.tank;
                }

                public Type type() {
                    return this.type;
                }

                public Source tank(String value) {
                    this.tank = value;
                    return this;
                }

                public Source type(Type value) {
                    this.type = value;
                    return this;
                }

                public Constant asConstant() {
                    return (Constant)this.a$(Constant.class);
                }

                public Constant asConstant(String value) {
                    Constant newElement = (Constant)this.core$().addAspect(Constant.class);
                    newElement.core$().set((Layer)newElement, "value", Collections.singletonList(value));
                    return newElement;
                }

                public boolean isConstant() {
                    return this.core$().is(Constant.class);
                }

                public void removeConstant() {
                    this.core$().removeAspect(Constant.class);
                }

                public Id asId() {
                    Layer as = this.a$(Id.class);
                    return as != null ? (Id)as : (Id)this.core$().addAspect(Id.class);
                }

                public boolean isId() {
                    return this.core$().is(Id.class);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("tank", new ArrayList<String>(Collections.singletonList(this.tank)));
                    map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("tank")) {
                        this.tank = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("type")) {
                        this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("tank")) {
                        this.tank = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("type")) {
                        this.type = (Type)((Object)values.get(0));
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public static class Constant
                extends Layer
                implements Terminal {
                    protected Type type;
                    protected String value;
                    protected Source _source;

                    public Constant(Node node) {
                        super(node);
                    }

                    public Type type() {
                        return this.type;
                    }

                    public String value() {
                        return this.value;
                    }

                    public String tank() {
                        return this._source.tank();
                    }

                    public Constant type(Type value) {
                        this.type = value;
                        return this;
                    }

                    public Constant value(String value) {
                        this.value = value;
                        return this;
                    }

                    public Constant tank(String value) {
                        this._source.tank(value);
                        return this;
                    }

                    public Source asSource() {
                        return (Source)this.a$(Source.class);
                    }

                    protected Map<String, List<?>> variables$() {
                        LinkedHashMap map = new LinkedHashMap();
                        map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
                        map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
                        return map;
                    }

                    protected void load$(String name, List<?> values) {
                        super.load$(name, values);
                        if (name.equalsIgnoreCase("type")) {
                            this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
                        } else if (name.equalsIgnoreCase("value")) {
                            this.value = (String)StringLoader.load(values, (Layer)this).get(0);
                        }
                    }

                    protected void set$(String name, List<?> values) {
                        super.set$(name, values);
                        if (name.equalsIgnoreCase("type")) {
                            this.type = (Type)((Object)values.get(0));
                        } else if (name.equalsIgnoreCase("value")) {
                            this.value = (String)values.get(0);
                        }
                    }

                    protected void sync$(Layer layer) {
                        super.sync$(layer);
                        if (layer instanceof Source) {
                            this._source = (Source)layer;
                        }
                    }

                    public KonosGraph graph() {
                        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                    }

                    public static enum Type {
                        Boolean,
                        String,
                        Integer,
                        Double,
                        Nominal,
                        Datetime,
                        Instant,
                        Long,
                        Timetag;

                    }
                }

                public static class Id
                extends Layer
                implements Terminal {
                    protected Type type;
                    protected Source _source;

                    public Id(Node node) {
                        super(node);
                    }

                    public Type type() {
                        return this.type;
                    }

                    public String tank() {
                        return this._source.tank();
                    }

                    public Id type(Type value) {
                        this.type = value;
                        return this;
                    }

                    public Id tank(String value) {
                        this._source.tank(value);
                        return this;
                    }

                    public Source asSource() {
                        return (Source)this.a$(Source.class);
                    }

                    protected Map<String, List<?>> variables$() {
                        LinkedHashMap map = new LinkedHashMap();
                        map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
                        return map;
                    }

                    protected void load$(String name, List<?> values) {
                        super.load$(name, values);
                        if (name.equalsIgnoreCase("type")) {
                            this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
                        }
                    }

                    protected void set$(String name, List<?> values) {
                        super.set$(name, values);
                        if (name.equalsIgnoreCase("type")) {
                            this.type = (Type)((Object)values.get(0));
                        }
                    }

                    protected void sync$(Layer layer) {
                        super.sync$(layer);
                        if (layer instanceof Source) {
                            this._source = (Source)layer;
                        }
                    }

                    public KonosGraph graph() {
                        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                    }

                    public static enum Type {
                        Boolean,
                        String,
                        Integer,
                        Double,
                        Nominal,
                        Datetime,
                        Instant,
                        Long,
                        Timetag;

                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }
                }

                public static enum Type {
                    Boolean,
                    String,
                    Integer,
                    Double,
                    Nominal,
                    Datetime,
                    Instant,
                    Long,
                    Timetag;

                }
            }

            public static class Split
            extends Layer
            implements Terminal {
                protected List<String> splits = new ArrayList<String>();

                public Split(Node node) {
                    super(node);
                }

                public List<String> splits() {
                    return this.splits;
                }

                public String splits(int index) {
                    return this.splits.get(index);
                }

                public List<String> splits(Predicate<String> predicate) {
                    return this.splits().stream().filter(predicate).collect(Collectors.toList());
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("splits", this.splits);
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("splits")) {
                        this.splits = StringLoader.load(values, (Layer)this);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("splits")) {
                        this.splits = new ArrayList(values);
                    }
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public class Clear {
                public void split(Predicate<Split> filter) {
                    new ArrayList<Split>(Population.this.splitList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void source(Predicate<Source> filter) {
                    new ArrayList<Source>(Population.this.sourceList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends MounterType.Create {
                public Create(String name) {
                    super(name);
                }

                public Split split(List<String> splits) {
                    Split newElement = (Split)Population.this.core$().graph().concept(Split.class).createNode(this.name, Population.this.core$()).as(Split.class);
                    newElement.core$().set((Layer)newElement, "splits", splits);
                    return newElement;
                }

                public Source source(String tank, Source.Type type) {
                    Source newElement = (Source)Population.this.core$().graph().concept(Source.class).createNode(this.name, Population.this.core$()).as(Source.class);
                    newElement.core$().set((Layer)newElement, "tank", Collections.singletonList(tank));
                    newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
                    return newElement;
                }

                public Filter filter() {
                    Filter newElement = (Filter)Population.this.core$().graph().concept(Filter.class).createNode(this.name, Population.this.core$()).as(Filter.class);
                    return newElement;
                }

                public Aggregation aggregation() {
                    Aggregation newElement = (Aggregation)Population.this.core$().graph().concept(Aggregation.class).createNode(this.name, Population.this.core$()).as(Aggregation.class);
                    return newElement;
                }
            }

            public static enum Format {
                Arff,
                Tabb,
                Csv;

            }
        }

        public static abstract class MounterType
        extends Layer
        implements Terminal {
            protected Mounter _mounter;

            public MounterType(Node node) {
                super(node);
            }

            public Mounter asMounter() {
                return (Mounter)this.a$(Mounter.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Mounter) {
                    this._mounter = (Mounter)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }
        }
    }

    public class Clear {
        public void mounter(Predicate<Mounter> filter) {
            new ArrayList<Mounter>(Datamart.this.mounterList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Mounter mounter() {
            Mounter newElement = (Mounter)Datamart.this.core$().graph().concept(Mounter.class).createNode(this.name, Datamart.this.core$()).as(Mounter.class);
            return newElement;
        }
    }

    public static enum Type {
        Table,
        Graph;

    }
}

