/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Absolute;
import io.intino.konos.model.graph.Animated;
import io.intino.konos.model.graph.CatalogComponents;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.DataComponents;
import io.intino.konos.model.graph.Dataframe;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.HelperComponents;
import io.intino.konos.model.graph.InteractionComponents;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Multiple;
import io.intino.konos.model.graph.OtherComponents;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.Relative;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.Template;
import io.intino.konos.model.graph.VisualizationComponents;
import io.intino.konos.model.graph.rules.Layout;
import io.intino.konos.model.graph.rules.Spacing;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Block
extends Component
implements Terminal {
    protected List<Layout> layout = new ArrayList<Layout>();
    protected Spacing spacing;
    protected Hidden hidden;
    protected List<Component> componentList = new ArrayList<Component>();
    protected Drawer _drawer;
    protected Splitter _splitter;
    protected Absolute _absolute;
    protected Relative _relative;
    protected Paper _paper;
    protected Badge _badge;
    protected Parallax _parallax;
    protected Collapsible _collapsible;
    protected Conditional _conditional;
    protected Animated _animated;
    protected Multiple _multiple;
    protected Popover _popover;

    public Block(Node node) {
        super(node);
    }

    public List<Layout> layout() {
        return this.layout;
    }

    public Spacing spacing() {
        return this.spacing;
    }

    public Hidden hidden() {
        return this.hidden;
    }

    public Block layout(List<Layout> values) {
        this.layout = values;
        return this;
    }

    public Block spacing(Spacing value) {
        this.spacing = value;
        return this;
    }

    public Block hidden(Hidden value) {
        this.hidden = value;
        return this;
    }

    public List<Component> componentList() {
        return Collections.unmodifiableList(this.componentList);
    }

    public Component component(int index) {
        return this.componentList.get(index);
    }

    public List<Component> componentList(Predicate<Component> predicate) {
        return this.componentList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Relative asRelative() {
        Layer as = this.a$(Relative.class);
        return as != null ? (Relative)as : (Relative)this.core$().addAspect(Relative.class);
    }

    public boolean isRelative() {
        return this.core$().is(Relative.class);
    }

    public Animated asAnimated() {
        Layer as = this.a$(Animated.class);
        return as != null ? (Animated)as : (Animated)this.core$().addAspect(Animated.class);
    }

    public boolean isAnimated() {
        return this.core$().is(Animated.class);
    }

    public Paper asPaper() {
        Layer as = this.a$(Paper.class);
        return as != null ? (Paper)as : (Paper)this.core$().addAspect(Paper.class);
    }

    public boolean isPaper() {
        return this.core$().is(Paper.class);
    }

    public Popover asPopover() {
        Layer as = this.a$(Popover.class);
        return as != null ? (Popover)as : (Popover)this.core$().addAspect(Popover.class);
    }

    public boolean isPopover() {
        return this.core$().is(Popover.class);
    }

    public Drawer asDrawer() {
        Layer as = this.a$(Drawer.class);
        return as != null ? (Drawer)as : (Drawer)this.core$().addAspect(Drawer.class);
    }

    public boolean isDrawer() {
        return this.core$().is(Drawer.class);
    }

    public Conditional asConditional() {
        Layer as = this.a$(Conditional.class);
        return as != null ? (Conditional)as : (Conditional)this.core$().addAspect(Conditional.class);
    }

    public boolean isConditional() {
        return this.core$().is(Conditional.class);
    }

    public Badge asBadge() {
        Layer as = this.a$(Badge.class);
        return as != null ? (Badge)as : (Badge)this.core$().addAspect(Badge.class);
    }

    public boolean isBadge() {
        return this.core$().is(Badge.class);
    }

    public Collapsible asCollapsible() {
        Layer as = this.a$(Collapsible.class);
        return as != null ? (Collapsible)as : (Collapsible)this.core$().addAspect(Collapsible.class);
    }

    public boolean isCollapsible() {
        return this.core$().is(Collapsible.class);
    }

    public Splitter asSplitter() {
        Layer as = this.a$(Splitter.class);
        return as != null ? (Splitter)as : (Splitter)this.core$().addAspect(Splitter.class);
    }

    public boolean isSplitter() {
        return this.core$().is(Splitter.class);
    }

    public Absolute asAbsolute() {
        Layer as = this.a$(Absolute.class);
        return as != null ? (Absolute)as : (Absolute)this.core$().addAspect(Absolute.class);
    }

    public boolean isAbsolute() {
        return this.core$().is(Absolute.class);
    }

    public Parallax asParallax() {
        return (Parallax)this.a$(Parallax.class);
    }

    public Parallax asParallax(String background) {
        Parallax newElement = (Parallax)this.core$().addAspect(Parallax.class);
        newElement.core$().set((Layer)newElement, "background", Collections.singletonList(background));
        return newElement;
    }

    public boolean isParallax() {
        return this.core$().is(Parallax.class);
    }

    public void removeParallax() {
        this.core$().removeAspect(Parallax.class);
    }

    public Multiple asMultiple() {
        Layer as = this.a$(Multiple.class);
        return as != null ? (Multiple)as : (Multiple)this.core$().addAspect(Multiple.class);
    }

    public boolean isMultiple() {
        return this.core$().is(Multiple.class);
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Component>(this.componentList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("layout", this.layout);
        map.put("spacing", new ArrayList<Spacing>(Collections.singletonList(this.spacing)));
        map.put("hidden", new ArrayList<Hidden>(Collections.singletonList(this.hidden)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Component")) {
            this.componentList.add((Component)node.as(Component.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Component")) {
            this.componentList.remove(node.as(Component.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("layout")) {
            this.layout = WordLoader.load(values, Layout.class, (Layer)this);
        } else if (name.equalsIgnoreCase("spacing")) {
            this.spacing = (Spacing)((Object)WordLoader.load(values, Spacing.class, (Layer)this).get(0));
        } else if (name.equalsIgnoreCase("hidden")) {
            this.hidden = (Hidden)((Object)WordLoader.load(values, Hidden.class, (Layer)this).get(0));
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("layout")) {
            this.layout = new ArrayList(values);
        } else if (name.equalsIgnoreCase("spacing")) {
            this.spacing = (Spacing)((Object)values.get(0));
        } else if (name.equalsIgnoreCase("hidden")) {
            this.hidden = (Hidden)((Object)values.get(0));
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Popover
    extends Layer
    implements Terminal {
        protected Position position;
        protected Block _block;

        public Popover(Node node) {
            super(node);
        }

        public Position position() {
            return this.position;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Popover position(Position value) {
            this.position = value;
            return this;
        }

        public Popover layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Popover spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Popover hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("position", new ArrayList<Position>(Collections.singletonList(this.position)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)WordLoader.load(values, Position.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)values.get(0));
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Popover.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Popover.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Popover.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Popover.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Popover.this.core$().graph().concept(Component.class).createNode(this.name, Popover.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Popover.this.core$().graph().concept(Block.class).createNode(this.name, Popover.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Popover.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Popover.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Popover.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Popover.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public static enum Position {
            TopLeft,
            TopCenter,
            TopRight,
            LeftTop,
            LeftCenter,
            LeftBottom,
            RightTop,
            RightCenter,
            RightBottom,
            BottomLeft,
            BottomCenter,
            BottomRight;

        }
    }

    public static class Multiple
    extends io.intino.konos.model.graph.Multiple
    implements Terminal {
        protected Block _block;

        public Multiple(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Multiple layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Multiple hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Multiple.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Multiple.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Multiple.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Multiple.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Multiple.Create {
            public Create(String name) {
                super(name);
            }

            public Component component() {
                Component newElement = (Component)Multiple.this.core$().graph().concept(Component.class).createNode(this.name, Multiple.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Multiple.this.core$().graph().concept(Block.class).createNode(this.name, Multiple.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Multiple.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Multiple.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Animated
    extends io.intino.konos.model.graph.Animated
    implements Terminal {
        protected Block _block;

        public Animated(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Animated layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Animated spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Animated hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Animated.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Animated.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Animated.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Animated.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Animated.Create {
            public Create(String name) {
                super(Animated.this, name);
            }

            public Component component() {
                Component newElement = (Component)Animated.this.core$().graph().concept(Component.class).createNode(this.name, Animated.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Animated.this.core$().graph().concept(Block.class).createNode(this.name, Animated.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Animated.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Animated.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Animated.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Animated.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Conditional
    extends Layer
    implements Terminal {
        protected Component.Option selected;
        protected Block _block;

        public Conditional(Node node) {
            super(node);
        }

        public Component.Option selected() {
            return this.selected;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Conditional selected(Component.Option value) {
            this.selected = value;
            return this;
        }

        public Conditional layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Conditional spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Conditional hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("selected", this.selected != null ? new ArrayList<Component.Option>(Collections.singletonList(this.selected)) : Collections.emptyList());
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("selected")) {
                this.selected = (Component.Option)((Object)NodeLoader.load(values, Component.Option.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("selected")) {
                this.selected = values.get(0) != null ? (Component.Option)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Component.Option.class) : null;
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Conditional.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Conditional.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Conditional.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Conditional.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Conditional.this.core$().graph().concept(Component.class).createNode(this.name, Conditional.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Conditional.this.core$().graph().concept(Block.class).createNode(this.name, Conditional.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Conditional.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Conditional.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Conditional.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Conditional.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Collapsible
    extends Layer
    implements Terminal {
        protected Block _block;

        public Collapsible(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Collapsible layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Collapsible spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Collapsible hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Collapsible.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Collapsible.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Collapsible.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Collapsible.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Collapsible.this.core$().graph().concept(Component.class).createNode(this.name, Collapsible.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Collapsible.this.core$().graph().concept(Block.class).createNode(this.name, Collapsible.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Collapsible.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Collapsible.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Collapsible.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Collapsible.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Parallax
    extends Layer
    implements Terminal {
        protected String background;
        protected Block _block;

        public Parallax(Node node) {
            super(node);
        }

        public String background() {
            return this.background;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Parallax background(String value) {
            this.background = value;
            return this;
        }

        public Parallax layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Parallax spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Parallax hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("background", new ArrayList<String>(Collections.singletonList(this.background)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("background")) {
                this.background = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("background")) {
                this.background = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Parallax.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Parallax.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Parallax.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Parallax.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Parallax.this.core$().graph().concept(Component.class).createNode(this.name, Parallax.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Parallax.this.core$().graph().concept(Block.class).createNode(this.name, Parallax.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Parallax.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Parallax.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Parallax.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Parallax.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Badge
    extends Layer
    implements Terminal {
        protected int value;
        protected int max;
        protected boolean showZero;
        protected Mode mode;
        protected Block _block;

        public Badge(Node node) {
            super(node);
        }

        public int value() {
            return this.value;
        }

        public int max() {
            return this.max;
        }

        public boolean showZero() {
            return this.showZero;
        }

        public Mode mode() {
            return this.mode;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Badge value(int value) {
            this.value = value;
            return this;
        }

        public Badge max(int value) {
            this.max = value;
            return this;
        }

        public Badge showZero(boolean value) {
            this.showZero = value;
            return this;
        }

        public Badge mode(Mode value) {
            this.mode = value;
            return this;
        }

        public Badge layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Badge spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Badge hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("value", new ArrayList<Integer>(Collections.singletonList(this.value)));
            map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
            map.put("showZero", new ArrayList<Boolean>(Collections.singletonList(this.showZero)));
            map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("showZero")) {
                this.showZero = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("max")) {
                this.max = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("showZero")) {
                this.showZero = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)values.get(0));
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Badge.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Badge.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Badge.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Badge.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Badge.this.core$().graph().concept(Component.class).createNode(this.name, Badge.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Badge.this.core$().graph().concept(Block.class).createNode(this.name, Badge.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Badge.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Badge.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Badge.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Badge.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public static enum Mode {
            Normal,
            Dot;

        }
    }

    public static class Paper
    extends Layer
    implements Terminal {
        protected Block _block;

        public Paper(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Paper layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Paper spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Paper hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Paper.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Paper.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Paper.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Paper.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Paper.this.core$().graph().concept(Component.class).createNode(this.name, Paper.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Paper.this.core$().graph().concept(Block.class).createNode(this.name, Paper.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Paper.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Paper.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Paper.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Paper.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Relative
    extends io.intino.konos.model.graph.Relative
    implements Terminal {
        protected Block _block;

        public Relative(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Relative layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Relative spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Relative hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Relative.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Relative.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Relative.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Relative.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Relative.Create {
            public Create(String name) {
                super(name);
            }

            public Component component() {
                Component newElement = (Component)Relative.this.core$().graph().concept(Component.class).createNode(this.name, Relative.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Relative.this.core$().graph().concept(Block.class).createNode(this.name, Relative.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Relative.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Relative.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Relative.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Relative.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Absolute
    extends io.intino.konos.model.graph.Absolute
    implements Terminal {
        protected Block _block;

        public Absolute(Node node) {
            super(node);
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Absolute layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Absolute spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Absolute hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Absolute.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Absolute.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Absolute.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Absolute.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Absolute.Create {
            public Create(String name) {
                super(Absolute.this, name);
            }

            public Component component() {
                Component newElement = (Component)Absolute.this.core$().graph().concept(Component.class).createNode(this.name, Absolute.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Absolute.this.core$().graph().concept(Block.class).createNode(this.name, Absolute.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Absolute.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Absolute.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Absolute.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Absolute.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Splitter
    extends Layer
    implements Terminal {
        protected String splitMobileLabel;
        protected Block _block;

        public Splitter(Node node) {
            super(node);
        }

        public String splitMobileLabel() {
            return this.splitMobileLabel;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Splitter splitMobileLabel(String value) {
            this.splitMobileLabel = value;
            return this;
        }

        public Splitter layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Splitter spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Splitter hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("splitMobileLabel", new ArrayList<String>(Collections.singletonList(this.splitMobileLabel)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("splitMobileLabel")) {
                this.splitMobileLabel = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("splitMobileLabel")) {
                this.splitMobileLabel = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Splitter.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Splitter.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Splitter.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Splitter.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Splitter.this.core$().graph().concept(Component.class).createNode(this.name, Splitter.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Splitter.this.core$().graph().concept(Block.class).createNode(this.name, Splitter.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Splitter.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Splitter.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Splitter.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Splitter.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Drawer
    extends Layer
    implements Terminal {
        protected Position position;
        protected Variant variant;
        protected Block _block;

        public Drawer(Node node) {
            super(node);
        }

        public Position position() {
            return this.position;
        }

        public Variant variant() {
            return this.variant;
        }

        public List<Layout> layout() {
            return this._block.layout();
        }

        public Spacing spacing() {
            return this._block.spacing();
        }

        public Hidden hidden() {
            return this._block.hidden();
        }

        public Drawer position(Position value) {
            this.position = value;
            return this;
        }

        public Drawer variant(Variant value) {
            this.variant = value;
            return this;
        }

        public Drawer layout(List<Layout> values) {
            this._block.layout(values);
            return this;
        }

        public Drawer spacing(Spacing value) {
            this._block.spacing(value);
            return this;
        }

        public Drawer hidden(Hidden value) {
            this._block.hidden(value);
            return this;
        }

        public List<Component> componentList() {
            return this._block.componentList();
        }

        public Component componentList(int index) {
            return this._block.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._block.blockList();
        }

        public Block blockList(int index) {
            return this._block.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._block.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._block.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._block.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._block.notificationList().get(index);
        }

        public Block asBlock() {
            return (Block)this.a$(Block.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("position", new ArrayList<Position>(Collections.singletonList(this.position)));
            map.put("variant", new ArrayList<Variant>(Collections.singletonList(this.variant)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)WordLoader.load(values, Position.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("variant")) {
                this.variant = (Variant)((Object)WordLoader.load(values, Variant.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("position")) {
                this.position = (Position)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("variant")) {
                this.variant = (Variant)((Object)values.get(0));
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Block) {
                this._block = (Block)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Drawer.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Drawer.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Drawer.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Drawer.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Drawer.this.core$().graph().concept(Component.class).createNode(this.name, Drawer.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Drawer.this.core$().graph().concept(Block.class).createNode(this.name, Drawer.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Drawer.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Drawer.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Drawer.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Drawer.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public static enum Variant {
            Permanent,
            Persistent,
            PersistentAndMini,
            Temporary;

        }

        public static enum Position {
            Left,
            Top,
            Bottom,
            Right;

        }
    }

    public class Clear
    extends Component.Clear {
        public Clear() {
            super(Block.this);
        }

        public void component(Predicate<Component> filter) {
            new ArrayList<Component>(Block.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Component.Create {
        public Create(String name) {
            super(Block.this, name);
        }

        public Component component() {
            Component newElement = (Component)Block.this.core$().graph().concept(Component.class).createNode(this.name, Block.this.core$()).as(Component.class);
            return newElement;
        }

        public OtherComponents.CollectionDialog collectionDialog(String title) {
            OtherComponents.CollectionDialog newElement = (OtherComponents.CollectionDialog)Block.this.core$().graph().concept(OtherComponents.CollectionDialog.class).createNode(this.name, Block.this.core$()).as(OtherComponents.CollectionDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public InteractionComponents.Button button(String title) {
            InteractionComponents.Button newElement = (InteractionComponents.Button)Block.this.core$().graph().concept(InteractionComponents.Button.class).createNode(this.name, Block.this.core$()).as(InteractionComponents.Button.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OtherComponents.Portal portal(String to, Service.UI.Use in) {
            OtherComponents.Portal newElement = (OtherComponents.Portal)Block.this.core$().graph().concept(OtherComponents.Portal.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Portal.class);
            newElement.core$().set((Layer)newElement, "to", Collections.singletonList(to));
            newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
            return newElement;
        }

        public OtherComponents.Divider divider() {
            OtherComponents.Divider newElement = (OtherComponents.Divider)Block.this.core$().graph().concept(OtherComponents.Divider.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Divider.class);
            return newElement;
        }

        public DataComponents.Text text() {
            DataComponents.Text newElement = (DataComponents.Text)Block.this.core$().graph().concept(DataComponents.Text.class).createNode(this.name, Block.this.core$()).as(DataComponents.Text.class);
            return newElement;
        }

        public VisualizationComponents.Dashboard dashboard(String serverScript, String uiScript) {
            VisualizationComponents.Dashboard newElement = (VisualizationComponents.Dashboard)Block.this.core$().graph().concept(VisualizationComponents.Dashboard.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Dashboard.class);
            newElement.core$().set((Layer)newElement, "serverScript", Collections.singletonList(serverScript));
            newElement.core$().set((Layer)newElement, "uiScript", Collections.singletonList(uiScript));
            return newElement;
        }

        public DataComponents.Date date() {
            DataComponents.Date newElement = (DataComponents.Date)Block.this.core$().graph().concept(DataComponents.Date.class).createNode(this.name, Block.this.core$()).as(DataComponents.Date.class);
            return newElement;
        }

        public OtherComponents.User user() {
            OtherComponents.User newElement = (OtherComponents.User)Block.this.core$().graph().concept(OtherComponents.User.class).createNode(this.name, Block.this.core$()).as(OtherComponents.User.class);
            return newElement;
        }

        public OtherComponents.Frame frame(Display display) {
            OtherComponents.Frame newElement = (OtherComponents.Frame)Block.this.core$().graph().concept(OtherComponents.Frame.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Frame.class);
            newElement.core$().set((Layer)newElement, "display", Collections.singletonList(display));
            return newElement;
        }

        public OtherComponents.Stamp stamp(Template template) {
            OtherComponents.Stamp newElement = (OtherComponents.Stamp)Block.this.core$().graph().concept(OtherComponents.Stamp.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Stamp.class);
            newElement.core$().set((Layer)newElement, "template", Collections.singletonList(template));
            return newElement;
        }

        public OtherComponents.Chip chip() {
            OtherComponents.Chip newElement = (OtherComponents.Chip)Block.this.core$().graph().concept(OtherComponents.Chip.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Chip.class);
            return newElement;
        }

        public InteractionComponents.Toggle toggle(String title) {
            InteractionComponents.Toggle newElement = (InteractionComponents.Toggle)Block.this.core$().graph().concept(InteractionComponents.Toggle.class).createNode(this.name, Block.this.core$()).as(InteractionComponents.Toggle.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OtherComponents.Icon icon(String icon) {
            OtherComponents.Icon newElement = (OtherComponents.Icon)Block.this.core$().graph().concept(OtherComponents.Icon.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Icon.class);
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public CatalogComponents.Collection.Mold.Heading heading() {
            CatalogComponents.Collection.Mold.Heading newElement = (CatalogComponents.Collection.Mold.Heading)Block.this.core$().graph().concept(CatalogComponents.Collection.Mold.Heading.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Collection.Mold.Heading.class);
            return newElement;
        }

        public OtherComponents.Card card() {
            OtherComponents.Card newElement = (OtherComponents.Card)Block.this.core$().graph().concept(OtherComponents.Card.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Card.class);
            return newElement;
        }

        public InteractionComponents.Switch switch$(String title) {
            InteractionComponents.Switch newElement = (InteractionComponents.Switch)Block.this.core$().graph().concept(InteractionComponents.Switch.class).createNode(this.name, Block.this.core$()).as(InteractionComponents.Switch.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public CatalogComponents.Collection.Mold.Item item(int height) {
            CatalogComponents.Collection.Mold.Item newElement = (CatalogComponents.Collection.Mold.Item)Block.this.core$().graph().concept(CatalogComponents.Collection.Mold.Item.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Collection.Mold.Item.class);
            newElement.core$().set((Layer)newElement, "height", Collections.singletonList(height));
            return newElement;
        }

        public VisualizationComponents.Spinner spinner() {
            VisualizationComponents.Spinner newElement = (VisualizationComponents.Spinner)Block.this.core$().graph().concept(VisualizationComponents.Spinner.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Spinner.class);
            return newElement;
        }

        public HelperComponents.HelperComponent helperComponent() {
            HelperComponents.HelperComponent newElement = (HelperComponents.HelperComponent)Block.this.core$().graph().concept(HelperComponents.HelperComponent.class).createNode(this.name, Block.this.core$()).as(HelperComponents.HelperComponent.class);
            return newElement;
        }

        public InteractionComponents.Toolbar toolbar() {
            InteractionComponents.Toolbar newElement = (InteractionComponents.Toolbar)Block.this.core$().graph().concept(InteractionComponents.Toolbar.class).createNode(this.name, Block.this.core$()).as(InteractionComponents.Toolbar.class);
            return newElement;
        }

        public OtherComponents.AlertDialog alertDialog(String title, String message) {
            OtherComponents.AlertDialog newElement = (OtherComponents.AlertDialog)Block.this.core$().graph().concept(OtherComponents.AlertDialog.class).createNode(this.name, Block.this.core$()).as(OtherComponents.AlertDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "message", Collections.singletonList(message));
            return newElement;
        }

        public CatalogComponents.List list() {
            CatalogComponents.List newElement = (CatalogComponents.List)Block.this.core$().graph().concept(CatalogComponents.List.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.List.class);
            return newElement;
        }

        public CatalogComponents.Magazine magazine() {
            CatalogComponents.Magazine newElement = (CatalogComponents.Magazine)Block.this.core$().graph().concept(CatalogComponents.Magazine.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Magazine.class);
            return newElement;
        }

        public OtherComponents.Dialog dialog(String title) {
            OtherComponents.Dialog newElement = (OtherComponents.Dialog)Block.this.core$().graph().concept(OtherComponents.Dialog.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Dialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public InteractionComponents.IconButton iconButton(String title, String icon) {
            InteractionComponents.IconButton newElement = (InteractionComponents.IconButton)Block.this.core$().graph().concept(InteractionComponents.IconButton.class).createNode(this.name, Block.this.core$()).as(InteractionComponents.IconButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public InteractionComponents.MaterialIconButton materialIconButton(String title, String icon) {
            InteractionComponents.MaterialIconButton newElement = (InteractionComponents.MaterialIconButton)Block.this.core$().graph().concept(InteractionComponents.MaterialIconButton.class).createNode(this.name, Block.this.core$()).as(InteractionComponents.MaterialIconButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public VisualizationComponents.Slider slider() {
            VisualizationComponents.Slider newElement = (VisualizationComponents.Slider)Block.this.core$().graph().concept(VisualizationComponents.Slider.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Slider.class);
            return newElement;
        }

        public OtherComponents.Snackbar snackbar() {
            OtherComponents.Snackbar newElement = (OtherComponents.Snackbar)Block.this.core$().graph().concept(OtherComponents.Snackbar.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Snackbar.class);
            return newElement;
        }

        public OtherComponents.DecisionDialog decisionDialog(String title) {
            OtherComponents.DecisionDialog newElement = (OtherComponents.DecisionDialog)Block.this.core$().graph().concept(OtherComponents.DecisionDialog.class).createNode(this.name, Block.this.core$()).as(OtherComponents.DecisionDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public VisualizationComponents.Stepper.Step step() {
            VisualizationComponents.Stepper.Step newElement = (VisualizationComponents.Stepper.Step)Block.this.core$().graph().concept(VisualizationComponents.Stepper.Step.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Stepper.Step.class);
            return newElement;
        }

        @Override
        public Block block() {
            Block newElement = (Block)Block.this.core$().graph().concept(Block.class).createNode(this.name, Block.this.core$()).as(Block.class);
            return newElement;
        }

        public VisualizationComponents.Chart chart(Dataframe input, String query) {
            VisualizationComponents.Chart newElement = (VisualizationComponents.Chart)Block.this.core$().graph().concept(VisualizationComponents.Chart.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Chart.class);
            newElement.core$().set((Layer)newElement, "input", Collections.singletonList(input));
            newElement.core$().set((Layer)newElement, "query", Collections.singletonList(query));
            return newElement;
        }

        public HelperComponents.Row row(List<CatalogComponents.Collection.Mold.Item> items) {
            HelperComponents.Row newElement = (HelperComponents.Row)Block.this.core$().graph().concept(HelperComponents.Row.class).createNode(this.name, Block.this.core$()).as(HelperComponents.Row.class);
            newElement.core$().set((Layer)newElement, "items", items);
            return newElement;
        }

        public CatalogComponents.SearchBox searchBox(List<CatalogComponents.Collection> collections) {
            CatalogComponents.SearchBox newElement = (CatalogComponents.SearchBox)Block.this.core$().graph().concept(CatalogComponents.SearchBox.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.SearchBox.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            return newElement;
        }

        public VisualizationComponents.KPI kPI() {
            VisualizationComponents.KPI newElement = (VisualizationComponents.KPI)Block.this.core$().graph().concept(VisualizationComponents.KPI.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.KPI.class);
            return newElement;
        }

        public CatalogComponents.Sorting sorting(List<CatalogComponents.Collection> collections) {
            CatalogComponents.Sorting newElement = (CatalogComponents.Sorting)Block.this.core$().graph().concept(CatalogComponents.Sorting.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Sorting.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            return newElement;
        }

        public VisualizationComponents.TemporalSlider temporalSlider(List<CatalogComponents.Collection> collections, List<VisualizationComponents.TemporalSlider.Scales> scales) {
            VisualizationComponents.TemporalSlider newElement = (VisualizationComponents.TemporalSlider)Block.this.core$().graph().concept(VisualizationComponents.TemporalSlider.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.TemporalSlider.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            newElement.core$().set((Layer)newElement, "scales", scales);
            return newElement;
        }

        public VisualizationComponents.Stepper stepper() {
            VisualizationComponents.Stepper newElement = (VisualizationComponents.Stepper)Block.this.core$().graph().concept(VisualizationComponents.Stepper.class).createNode(this.name, Block.this.core$()).as(VisualizationComponents.Stepper.class);
            return newElement;
        }

        public DataComponents.Number number() {
            DataComponents.Number newElement = (DataComponents.Number)Block.this.core$().graph().concept(DataComponents.Number.class).createNode(this.name, Block.this.core$()).as(DataComponents.Number.class);
            return newElement;
        }

        public OtherComponents.Tooltip tooltip() {
            OtherComponents.Tooltip newElement = (OtherComponents.Tooltip)Block.this.core$().graph().concept(OtherComponents.Tooltip.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Tooltip.class);
            return newElement;
        }

        public OtherComponents.Selector selector() {
            OtherComponents.Selector newElement = (OtherComponents.Selector)Block.this.core$().graph().concept(OtherComponents.Selector.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Selector.class);
            return newElement;
        }

        public OtherComponents.ProxyStamp proxyStamp(String proxy, Service.UI.Use from) {
            OtherComponents.ProxyStamp newElement = (OtherComponents.ProxyStamp)Block.this.core$().graph().concept(OtherComponents.ProxyStamp.class).createNode(this.name, Block.this.core$()).as(OtherComponents.ProxyStamp.class);
            newElement.core$().set((Layer)newElement, "proxy", Collections.singletonList(proxy));
            newElement.core$().set((Layer)newElement, "from", Collections.singletonList(from));
            return newElement;
        }

        public InteractionComponents.Link link(String title) {
            InteractionComponents.Link newElement = (InteractionComponents.Link)Block.this.core$().graph().concept(InteractionComponents.Link.class).createNode(this.name, Block.this.core$()).as(InteractionComponents.Link.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public CatalogComponents.Grouping grouping(List<CatalogComponents.Collection> collections) {
            CatalogComponents.Grouping newElement = (CatalogComponents.Grouping)Block.this.core$().graph().concept(CatalogComponents.Grouping.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Grouping.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            return newElement;
        }

        public OtherComponents.MaterialIcon materialIcon(String icon) {
            OtherComponents.MaterialIcon newElement = (OtherComponents.MaterialIcon)Block.this.core$().graph().concept(OtherComponents.MaterialIcon.class).createNode(this.name, Block.this.core$()).as(OtherComponents.MaterialIcon.class);
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public DataComponents.File file() {
            DataComponents.File newElement = (DataComponents.File)Block.this.core$().graph().concept(DataComponents.File.class).createNode(this.name, Block.this.core$()).as(DataComponents.File.class);
            return newElement;
        }

        public CatalogComponents.Table table() {
            CatalogComponents.Table newElement = (CatalogComponents.Table)Block.this.core$().graph().concept(CatalogComponents.Table.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Table.class);
            return newElement;
        }

        public OtherComponents.Header header() {
            OtherComponents.Header newElement = (OtherComponents.Header)Block.this.core$().graph().concept(OtherComponents.Header.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Header.class);
            return newElement;
        }

        public DataComponents.Location location() {
            DataComponents.Location newElement = (DataComponents.Location)Block.this.core$().graph().concept(DataComponents.Location.class).createNode(this.name, Block.this.core$()).as(DataComponents.Location.class);
            return newElement;
        }

        public OtherComponents.Progress progress() {
            OtherComponents.Progress newElement = (OtherComponents.Progress)Block.this.core$().graph().concept(OtherComponents.Progress.class).createNode(this.name, Block.this.core$()).as(OtherComponents.Progress.class);
            return newElement;
        }

        public DataComponents.Image image() {
            DataComponents.Image newElement = (DataComponents.Image)Block.this.core$().graph().concept(DataComponents.Image.class).createNode(this.name, Block.this.core$()).as(DataComponents.Image.class);
            return newElement;
        }

        public CatalogComponents.Map map() {
            CatalogComponents.Map newElement = (CatalogComponents.Map)Block.this.core$().graph().concept(CatalogComponents.Map.class).createNode(this.name, Block.this.core$()).as(CatalogComponents.Map.class);
            return newElement;
        }

        public Template template() {
            Template newElement = (Template)Block.this.core$().graph().concept(Template.class).createNode(this.name, Block.this.core$()).as(Template.class);
            return newElement;
        }
    }

    public static enum Hidden {
        Never,
        Always,
        IfMobile,
        IfNotMobile;

    }
}

