/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.rest;

import cottons.utils.MimeTypes;
import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.RESTNotificationActionRenderer;
import io.intino.konos.builder.codegeneration.action.RESTResourceActionRenderer;
import io.intino.konos.builder.codegeneration.services.rest.RestResourceTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Data;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Redirect;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Service;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;

public class RESTResourceRenderer
extends Renderer {
    private static final String RESOURCES_PACKAGE = "rest/resources";
    private static final String NOTIFICATIONS_PACKAGE = "rest/notifications";
    private final List<Service.REST> services;

    public RESTResourceRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext, Target.Owner);
        this.services = graph.serviceList(Service::isREST).map(Service::asREST).collect(Collectors.toList());
    }

    @Override
    public void render() {
        this.services.forEach(this::processService);
    }

    private void processService(Service.REST service) {
        service.core$().findNode(Service.REST.Resource.class).forEach(this::processResource);
        service.core$().findNode(Service.REST.Notification.class).forEach(this::processNotification);
    }

    private void processResource(Service.REST.Resource resource) {
        for (Service.REST.Resource.Operation operation : resource.operationList()) {
            Frame frame = this.frameOf(resource, operation);
            String className = StringHelper.snakeCaseToCamelCase((String)(((Object)((Object)operation)).getClass().getSimpleName() + "_" + resource.name$())) + "Resource";
            File resourcesPackage = new File(this.gen(), RESOURCES_PACKAGE);
            Commons.writeFrame(resourcesPackage, className, this.template().render((Object)frame));
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(resource), Commons.javaFile(resourcesPackage, className).getAbsolutePath()));
            this.createCorrespondingAction(operation);
        }
    }

    private void processNotification(Service.REST.Notification notification) {
        String className = StringHelper.snakeCaseToCamelCase((String)notification.name$()) + "Notification";
        Service.REST service = (Service.REST)notification.core$().ownerAs(Service.REST.class);
        FrameBuilder builder = new FrameBuilder(new String[]{"notification"}).add("path", (Object)notification.path());
        this.addCommons(notification.name$(), builder);
        builder.add("parameter", (Object)this.notificationParameters(notification.parameterList()));
        builder.add("returnType", (Object)this.notificationResponse());
        this.authenticated(service, builder);
        if (service.authenticatedWithToken() != null) {
            builder.add("throws", (Object)"Unauthorized");
        }
        Commons.writeFrame(new File(this.gen(), NOTIFICATIONS_PACKAGE), className, this.template().render((Object)builder.toFrame()));
        this.createCorrespondingAction(notification);
    }

    private void createCorrespondingAction(Service.REST.Resource.Operation operation) {
        new RESTResourceActionRenderer(this.context, operation).execute();
    }

    private void createCorrespondingAction(Service.REST.Notification notification) {
        new RESTNotificationActionRenderer(this.context, notification).execute();
    }

    private Frame frameOf(Service.REST.Resource resource, Service.REST.Resource.Operation operation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"resource"});
        this.addCommons(resource.name$(), builder);
        builder.add("operation", (Object)((Object)((Object)operation)).getClass().getSimpleName());
        builder.add("throws", (Object)this.throwCodes(operation));
        builder.add("parameter", (Object)this.parameters(operation.parameterList()));
        if (this.hasResponse(operation)) {
            builder.add("returnType", (Object)this.frameOf(operation.response()));
        }
        if (!resource.graph().schemaList().isEmpty()) {
            builder.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()).toFrame());
        }
        this.authenticated((Service.REST)resource.core$().ownerAs(Service.REST.class), builder);
        return builder.toFrame();
    }

    private void authenticated(Service.REST service, FrameBuilder builder) {
        Service.REST.AuthenticatedWithToken authenticated = service.authenticatedWithToken();
        if (authenticated != null) {
            builder.add("authenticationValidator", (Object)new FrameBuilder(new String[]{"authenticationValidator"}).add("type", (Object)"Basic").toFrame());
        }
    }

    private void addCommons(String name, FrameBuilder builder) {
        builder.add("package", (Object)this.packageName());
        builder.add("name", (Object)name);
        builder.add("box", (Object)this.boxName());
    }

    private boolean hasResponse(Service.REST.Resource.Operation operation) {
        return operation.response() != null && (operation.response().isType() || operation.response().i$(Redirect.class));
    }

    private Frame frameOf(Response response) {
        FrameBuilder builder = new FrameBuilder(new String[]{((Object)((Object)response)).getClass().getSimpleName()}).add("value", (Object)Commons.returnType(response, this.packageName()));
        if (response.isText() && response.dataFormat() != Response.DataFormat.html) {
            builder.add("format", (Object)MimeTypes.get((String)response.dataFormat().toString()));
        }
        return builder.toFrame();
    }

    private Frame notificationResponse() {
        return new FrameBuilder(new String[]{"Response"}).add("value", (Object)String.class.getSimpleName()).add("format", (Object)MimeTypes.get((String)"text")).toFrame();
    }

    private String[] throwCodes(Service.REST.Resource.Operation resource) {
        String[] stringArray;
        Service.REST.AuthenticatedWithToken authenticated = ((Service.REST)resource.core$().ownerAs(Service.REST.class)).authenticatedWithToken();
        List<String> throwCodes = resource.exceptionList().stream().map(r -> r.code().toString()).collect(Collectors.toList());
        if (authenticated != null) {
            throwCodes.add("Unauthorized");
        }
        if (throwCodes.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "Unknown";
        } else {
            stringArray = throwCodes.toArray(new String[0]);
        }
        return stringArray;
    }

    private Frame[] parameters(List<? extends Service.REST.Resource.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame[] notificationParameters(List<Service.REST.Notification.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Service.REST.Resource.Parameter parameter) {
        FrameBuilder builder = new FrameBuilder(new String[]{"parameter", parameter.in().toString(), ((Object)((Object)parameter.asType())).getClass().getSimpleName(), parameter.isRequired() ? "required" : "optional"});
        if (parameter.isList()) {
            builder.add("List");
        }
        builder.add("name", (Object)parameter.name$()).add("parameterType", (Object)this.parameterType(parameter)).add("in", (Object)parameter.in().name());
        if (parameter.isRequired()) {
            return builder.toFrame();
        }
        if (parameter.isBool()) {
            builder.add("defaultValue").add("defaultValue", (Object)parameter.asBool().defaultValue());
        } else if (parameter.isText() && parameter.asText().defaultValue() != null) {
            builder.add("defaultValue").add("defaultValue", (Object)parameter.asText().defaultValue());
        } else if (parameter.isReal()) {
            builder.add("defaultValue").add("defaultValue", (Object)parameter.asReal().defaultValue());
        } else if (parameter.isInteger()) {
            builder.add("defaultValue").add("defaultValue", (Object)parameter.asInteger().defaultValue());
        } else if (parameter.isLongInteger()) {
            builder.add("defaultValue").add("defaultValue", (Object)parameter.asLongInteger().defaultValue());
        }
        return builder.toFrame();
    }

    private Frame parameter(Service.REST.Notification.Parameter parameter) {
        FrameBuilder builder = new FrameBuilder(new String[]{"parameter", parameter.in().toString(), ((Object)((Object)parameter.asType())).getClass().getSimpleName(), parameter.isRequired() ? "required" : "optional"});
        if (parameter.isList()) {
            builder.add("List");
        }
        return builder.add("name", (Object)parameter.name$()).add("parameterType", (Object)this.parameterType(parameter)).add("in", (Object)parameter.in().name()).toFrame();
    }

    private Frame parameterType(Parameter parameter) {
        String innerPackage = parameter.isObject() && parameter.asObject().isComponent() != false ? String.join((CharSequence)".", this.packageName(), "schemas.") : "";
        FrameBuilder builder = new FrameBuilder().add("value", (Object)(innerPackage + parameter.asType().type()));
        if (parameter.i$(Data.List.class)) {
            builder.add("list");
        }
        return builder.toFrame();
    }

    private Template template() {
        return Formatters.customize(new RestResourceTemplate());
    }
}

