/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Absolute;
import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Editable;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Multiple;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.Relative;
import io.intino.konos.model.graph.rules.CodeLanguage;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.DoubleLoader;
import io.intino.magritte.framework.loaders.InstantLoader;
import io.intino.magritte.framework.loaders.IntegerLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class DataComponents
extends Layer
implements Terminal {
    protected List<Text> textList = new ArrayList<Text>();
    protected List<File> fileList = new ArrayList<File>();
    protected List<Image> imageList = new ArrayList<Image>();
    protected List<Number> numberList = new ArrayList<Number>();
    protected List<Date> dateList = new ArrayList<Date>();
    protected List<Location> locationList = new ArrayList<Location>();

    public DataComponents(Node node) {
        super(node);
    }

    public List<Text> textList() {
        return Collections.unmodifiableList(this.textList);
    }

    public Text text(int index) {
        return this.textList.get(index);
    }

    public List<Text> textList(Predicate<Text> predicate) {
        return this.textList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<File> fileList() {
        return Collections.unmodifiableList(this.fileList);
    }

    public File file(int index) {
        return this.fileList.get(index);
    }

    public List<File> fileList(Predicate<File> predicate) {
        return this.fileList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Image> imageList() {
        return Collections.unmodifiableList(this.imageList);
    }

    public Image image(int index) {
        return this.imageList.get(index);
    }

    public List<Image> imageList(Predicate<Image> predicate) {
        return this.imageList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Number> numberList() {
        return Collections.unmodifiableList(this.numberList);
    }

    public Number number(int index) {
        return this.numberList.get(index);
    }

    public List<Number> numberList(Predicate<Number> predicate) {
        return this.numberList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Date> dateList() {
        return Collections.unmodifiableList(this.dateList);
    }

    public Date date(int index) {
        return this.dateList.get(index);
    }

    public List<Date> dateList(Predicate<Date> predicate) {
        return this.dateList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Location> locationList() {
        return Collections.unmodifiableList(this.locationList);
    }

    public Location location(int index) {
        return this.locationList.get(index);
    }

    public List<Location> locationList(Predicate<Location> predicate) {
        return this.locationList().stream().filter(predicate).collect(Collectors.toList());
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Text>(this.textList).forEach(c -> components.add(c.core$()));
        new ArrayList<File>(this.fileList).forEach(c -> components.add(c.core$()));
        new ArrayList<Image>(this.imageList).forEach(c -> components.add(c.core$()));
        new ArrayList<Number>(this.numberList).forEach(c -> components.add(c.core$()));
        new ArrayList<Date>(this.dateList).forEach(c -> components.add(c.core$()));
        new ArrayList<Location>(this.locationList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("DataComponents$Text")) {
            this.textList.add((Text)node.as(Text.class));
        }
        if (node.is("DataComponents$File")) {
            this.fileList.add((File)node.as(File.class));
        }
        if (node.is("DataComponents$Image")) {
            this.imageList.add((Image)node.as(Image.class));
        }
        if (node.is("DataComponents$Number")) {
            this.numberList.add((Number)node.as(Number.class));
        }
        if (node.is("DataComponents$Date")) {
            this.dateList.add((Date)node.as(Date.class));
        }
        if (node.is("DataComponents$Location")) {
            this.locationList.add((Location)node.as(Location.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("DataComponents$Text")) {
            this.textList.remove(node.as(Text.class));
        }
        if (node.is("DataComponents$File")) {
            this.fileList.remove(node.as(File.class));
        }
        if (node.is("DataComponents$Image")) {
            this.imageList.remove(node.as(Image.class));
        }
        if (node.is("DataComponents$Number")) {
            this.numberList.remove(node.as(Number.class));
        }
        if (node.is("DataComponents$Date")) {
            this.dateList.remove(node.as(Date.class));
        }
        if (node.is("DataComponents$Location")) {
            this.locationList.remove(node.as(Location.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Location
    extends Component
    implements Terminal {
        protected String icon;
        protected String value;
        protected Center center;
        protected Zoom zoom;
        protected Editable _editable;
        protected Readonly _readonly;
        protected Required _required;
        protected Focused _focused;

        public Location(Node node) {
            super(node);
        }

        public String icon() {
            return this.icon;
        }

        public String value() {
            return this.value;
        }

        public Location icon(String value) {
            this.icon = value;
            return this;
        }

        public Location value(String value) {
            this.value = value;
            return this;
        }

        public Center center() {
            return this.center;
        }

        public Zoom zoom() {
            return this.zoom;
        }

        public Focused asFocused() {
            Layer as = this.a$(Focused.class);
            return as != null ? (Focused)as : (Focused)this.core$().addAspect(Focused.class);
        }

        public boolean isFocused() {
            return this.core$().is(Focused.class);
        }

        public Editable asEditable() {
            Layer as = this.a$(Editable.class);
            return as != null ? (Editable)as : (Editable)this.core$().addAspect(Editable.class);
        }

        public boolean isEditable() {
            return this.core$().is(Editable.class);
        }

        public Readonly asReadonly() {
            Layer as = this.a$(Readonly.class);
            return as != null ? (Readonly)as : (Readonly)this.core$().addAspect(Readonly.class);
        }

        public boolean isReadonly() {
            return this.core$().is(Readonly.class);
        }

        public Required asRequired() {
            Layer as = this.a$(Required.class);
            return as != null ? (Required)as : (Required)this.core$().addAspect(Required.class);
        }

        public boolean isRequired() {
            return this.core$().is(Required.class);
        }

        @Override
        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.center != null) {
                components.add(this.center.core$());
            }
            if (this.zoom != null) {
                components.add(this.zoom.core$());
            }
            return new ArrayList<Node>(components);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("icon", new ArrayList<String>(Collections.singletonList(this.icon)));
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            return map;
        }

        @Override
        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("DataComponents$Location$Center")) {
                this.center = (Center)node.as(Center.class);
            }
            if (node.is("DataComponents$Location$Zoom")) {
                this.zoom = (Zoom)node.as(Zoom.class);
            }
        }

        @Override
        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("DataComponents$Location$Center")) {
                this.center = null;
            }
            if (node.is("DataComponents$Location$Zoom")) {
                this.zoom = null;
            }
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("icon")) {
                this.icon = (String)values.get(0);
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Focused
        extends Layer
        implements Terminal {
            protected Location _location;

            public Focused(Node node) {
                super(node);
            }

            public String icon() {
                return this._location.icon();
            }

            public String value() {
                return this._location.value();
            }

            public Focused icon(String value) {
                this._location.icon(value);
                return this;
            }

            public Focused value(String value) {
                this._location.value(value);
                return this;
            }

            public Center center() {
                return this._location.center();
            }

            public Zoom zoom() {
                return this._location.zoom();
            }

            public List<Block> blockList() {
                return this._location.blockList();
            }

            public Block blockList(int index) {
                return this._location.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._location.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._location.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._location.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._location.notificationList().get(index);
            }

            public Location asLocation() {
                return (Location)this.a$(Location.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Location) {
                    this._location = (Location)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Focused.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Focused.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Focused.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Center center(double latitude, double longitude) {
                    Center newElement = (Center)Focused.this.core$().graph().concept(Center.class).createNode(this.name, Focused.this.core$()).as(Center.class);
                    newElement.core$().set((Layer)newElement, "latitude", Collections.singletonList(latitude));
                    newElement.core$().set((Layer)newElement, "longitude", Collections.singletonList(longitude));
                    return newElement;
                }

                public Zoom zoom(int defaultZoom, int min, int max) {
                    Zoom newElement = (Zoom)Focused.this.core$().graph().concept(Zoom.class).createNode(this.name, Focused.this.core$()).as(Zoom.class);
                    newElement.core$().set((Layer)newElement, "defaultZoom", Collections.singletonList(defaultZoom));
                    newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
                    newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
                    return newElement;
                }

                public Block block() {
                    Block newElement = (Block)Focused.this.core$().graph().concept(Block.class).createNode(this.name, Focused.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Focused.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Focused.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Required
        extends Layer
        implements Terminal {
            protected Location _location;

            public Required(Node node) {
                super(node);
            }

            public String icon() {
                return this._location.icon();
            }

            public String value() {
                return this._location.value();
            }

            public Required icon(String value) {
                this._location.icon(value);
                return this;
            }

            public Required value(String value) {
                this._location.value(value);
                return this;
            }

            public Center center() {
                return this._location.center();
            }

            public Zoom zoom() {
                return this._location.zoom();
            }

            public List<Block> blockList() {
                return this._location.blockList();
            }

            public Block blockList(int index) {
                return this._location.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._location.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._location.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._location.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._location.notificationList().get(index);
            }

            public Location asLocation() {
                return (Location)this.a$(Location.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Location) {
                    this._location = (Location)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Required.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Required.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Required.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Center center(double latitude, double longitude) {
                    Center newElement = (Center)Required.this.core$().graph().concept(Center.class).createNode(this.name, Required.this.core$()).as(Center.class);
                    newElement.core$().set((Layer)newElement, "latitude", Collections.singletonList(latitude));
                    newElement.core$().set((Layer)newElement, "longitude", Collections.singletonList(longitude));
                    return newElement;
                }

                public Zoom zoom(int defaultZoom, int min, int max) {
                    Zoom newElement = (Zoom)Required.this.core$().graph().concept(Zoom.class).createNode(this.name, Required.this.core$()).as(Zoom.class);
                    newElement.core$().set((Layer)newElement, "defaultZoom", Collections.singletonList(defaultZoom));
                    newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
                    newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
                    return newElement;
                }

                public Block block() {
                    Block newElement = (Block)Required.this.core$().graph().concept(Block.class).createNode(this.name, Required.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Required.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Required.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Required.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Required.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Readonly
        extends Layer
        implements Terminal {
            protected Location _location;

            public Readonly(Node node) {
                super(node);
            }

            public String icon() {
                return this._location.icon();
            }

            public String value() {
                return this._location.value();
            }

            public Readonly icon(String value) {
                this._location.icon(value);
                return this;
            }

            public Readonly value(String value) {
                this._location.value(value);
                return this;
            }

            public Center center() {
                return this._location.center();
            }

            public Zoom zoom() {
                return this._location.zoom();
            }

            public List<Block> blockList() {
                return this._location.blockList();
            }

            public Block blockList(int index) {
                return this._location.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._location.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._location.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._location.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._location.notificationList().get(index);
            }

            public Location asLocation() {
                return (Location)this.a$(Location.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Location) {
                    this._location = (Location)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Readonly.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Readonly.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Readonly.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Center center(double latitude, double longitude) {
                    Center newElement = (Center)Readonly.this.core$().graph().concept(Center.class).createNode(this.name, Readonly.this.core$()).as(Center.class);
                    newElement.core$().set((Layer)newElement, "latitude", Collections.singletonList(latitude));
                    newElement.core$().set((Layer)newElement, "longitude", Collections.singletonList(longitude));
                    return newElement;
                }

                public Zoom zoom(int defaultZoom, int min, int max) {
                    Zoom newElement = (Zoom)Readonly.this.core$().graph().concept(Zoom.class).createNode(this.name, Readonly.this.core$()).as(Zoom.class);
                    newElement.core$().set((Layer)newElement, "defaultZoom", Collections.singletonList(defaultZoom));
                    newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
                    newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
                    return newElement;
                }

                public Block block() {
                    Block newElement = (Block)Readonly.this.core$().graph().concept(Block.class).createNode(this.name, Readonly.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Readonly.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Readonly.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Editable
        extends io.intino.konos.model.graph.Editable
        implements Terminal {
            protected List<Modes> modes = new ArrayList<Modes>();
            protected Location _location;

            public Editable(Node node) {
                super(node);
            }

            public List<Modes> modes() {
                return this.modes;
            }

            public String icon() {
                return this._location.icon();
            }

            public String value() {
                return this._location.value();
            }

            public Editable icon(String value) {
                this._location.icon(value);
                return this;
            }

            public Editable value(String value) {
                this._location.value(value);
                return this;
            }

            public Center center() {
                return this._location.center();
            }

            public Zoom zoom() {
                return this._location.zoom();
            }

            public List<Block> blockList() {
                return this._location.blockList();
            }

            public Block blockList(int index) {
                return this._location.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._location.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._location.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._location.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._location.notificationList().get(index);
            }

            public Location asLocation() {
                return (Location)this.a$(Location.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("modes", this.modes);
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("modes")) {
                    this.modes = WordLoader.load(values, Modes.class, (Layer)this);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("modes")) {
                    this.modes = new ArrayList(values);
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Location) {
                    this._location = (Location)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Editable.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Editable.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Editable.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Editable$Create {
                public Create(String name) {
                    super(name);
                }

                public Center center(double latitude, double longitude) {
                    Center newElement = (Center)Editable.this.core$().graph().concept(Center.class).createNode(this.name, Editable.this.core$()).as(Center.class);
                    newElement.core$().set((Layer)newElement, "latitude", Collections.singletonList(latitude));
                    newElement.core$().set((Layer)newElement, "longitude", Collections.singletonList(longitude));
                    return newElement;
                }

                public Zoom zoom(int defaultZoom, int min, int max) {
                    Zoom newElement = (Zoom)Editable.this.core$().graph().concept(Zoom.class).createNode(this.name, Editable.this.core$()).as(Zoom.class);
                    newElement.core$().set((Layer)newElement, "defaultZoom", Collections.singletonList(defaultZoom));
                    newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
                    newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
                    return newElement;
                }

                public Block block() {
                    Block newElement = (Block)Editable.this.core$().graph().concept(Block.class).createNode(this.name, Editable.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Editable.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Editable.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }

            public static enum Modes {
                Point,
                Polygon,
                Polyline,
                Rectangle;

            }
        }

        public static class Zoom
        extends Layer
        implements Terminal {
            protected int defaultZoom;
            protected int min;
            protected int max;

            public Zoom(Node node) {
                super(node);
            }

            public int defaultZoom() {
                return this.defaultZoom;
            }

            public int min() {
                return this.min;
            }

            public int max() {
                return this.max;
            }

            public Zoom defaultZoom(int value) {
                this.defaultZoom = value;
                return this;
            }

            public Zoom min(int value) {
                this.min = value;
                return this;
            }

            public Zoom max(int value) {
                this.max = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("defaultZoom", new ArrayList<Integer>(Collections.singletonList(this.defaultZoom)));
                map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
                map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("defaultZoom")) {
                    this.defaultZoom = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("min")) {
                    this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("defaultZoom")) {
                    this.defaultZoom = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("min")) {
                    this.min = (Integer)values.get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Integer)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Center
        extends Layer
        implements Terminal {
            protected double latitude;
            protected double longitude;

            public Center(Node node) {
                super(node);
            }

            public double latitude() {
                return this.latitude;
            }

            public double longitude() {
                return this.longitude;
            }

            public Center latitude(double value) {
                this.latitude = value;
                return this;
            }

            public Center longitude(double value) {
                this.longitude = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("latitude", new ArrayList<Double>(Collections.singletonList(this.latitude)));
                map.put("longitude", new ArrayList<Double>(Collections.singletonList(this.longitude)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("latitude")) {
                    this.latitude = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("longitude")) {
                    this.longitude = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("latitude")) {
                    this.latitude = (Double)values.get(0);
                } else if (name.equalsIgnoreCase("longitude")) {
                    this.longitude = (Double)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public class Clear
        extends Component.Clear {
        }

        public class Create
        extends Component.Create {
            public Create(String name) {
                super(name);
            }

            public Center center(double latitude, double longitude) {
                Center newElement = (Center)Location.this.core$().graph().concept(Center.class).createNode(this.name, Location.this.core$()).as(Center.class);
                newElement.core$().set((Layer)newElement, "latitude", Collections.singletonList(latitude));
                newElement.core$().set((Layer)newElement, "longitude", Collections.singletonList(longitude));
                return newElement;
            }

            public Zoom zoom(int defaultZoom, int min, int max) {
                Zoom newElement = (Zoom)Location.this.core$().graph().concept(Zoom.class).createNode(this.name, Location.this.core$()).as(Zoom.class);
                newElement.core$().set((Layer)newElement, "defaultZoom", Collections.singletonList(defaultZoom));
                newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
                newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
                return newElement;
            }
        }
    }

    public static class Date
    extends Component
    implements Terminal {
        protected String pattern;
        protected Mode mode;
        protected Instant value;
        protected Multiple _multiple;
        protected Editable _editable;
        protected Readonly _readonly;
        protected Required _required;
        protected Focused _focused;

        public Date(Node node) {
            super(node);
        }

        public String pattern() {
            return this.pattern;
        }

        public Mode mode() {
            return this.mode;
        }

        public Instant value() {
            return this.value;
        }

        public Date pattern(String value) {
            this.pattern = value;
            return this;
        }

        public Date mode(Mode value) {
            this.mode = value;
            return this;
        }

        public Date value(Instant value) {
            this.value = value;
            return this;
        }

        public Readonly asReadonly() {
            Layer as = this.a$(Readonly.class);
            return as != null ? (Readonly)as : (Readonly)this.core$().addAspect(Readonly.class);
        }

        public boolean isReadonly() {
            return this.core$().is(Readonly.class);
        }

        public Multiple asMultiple() {
            Layer as = this.a$(Multiple.class);
            return as != null ? (Multiple)as : (Multiple)this.core$().addAspect(Multiple.class);
        }

        public boolean isMultiple() {
            return this.core$().is(Multiple.class);
        }

        public Editable asEditable() {
            Layer as = this.a$(Editable.class);
            return as != null ? (Editable)as : (Editable)this.core$().addAspect(Editable.class);
        }

        public boolean isEditable() {
            return this.core$().is(Editable.class);
        }

        public Required asRequired() {
            Layer as = this.a$(Required.class);
            return as != null ? (Required)as : (Required)this.core$().addAspect(Required.class);
        }

        public boolean isRequired() {
            return this.core$().is(Required.class);
        }

        public Focused asFocused() {
            Layer as = this.a$(Focused.class);
            return as != null ? (Focused)as : (Focused)this.core$().addAspect(Focused.class);
        }

        public boolean isFocused() {
            return this.core$().is(Focused.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("pattern", new ArrayList<String>(Collections.singletonList(this.pattern)));
            map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
            map.put("value", new ArrayList<Instant>(Collections.singletonList(this.value)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("pattern")) {
                this.pattern = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (Instant)InstantLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("pattern")) {
                this.pattern = (String)values.get(0);
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (Instant)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Focused
        extends Layer
        implements Terminal {
            protected Date _date;

            public Focused(Node node) {
                super(node);
            }

            public String pattern() {
                return this._date.pattern();
            }

            public Mode mode() {
                return this._date.mode();
            }

            public Instant value() {
                return this._date.value();
            }

            public Focused pattern(String value) {
                this._date.pattern(value);
                return this;
            }

            public Focused mode(Mode value) {
                this._date.mode(value);
                return this;
            }

            public Focused value(Instant value) {
                this._date.value(value);
                return this;
            }

            public List<Block> blockList() {
                return this._date.blockList();
            }

            public Block blockList(int index) {
                return this._date.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._date.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._date.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._date.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._date.notificationList().get(index);
            }

            public Date asDate() {
                return (Date)this.a$(Date.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Date) {
                    this._date = (Date)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Focused.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Focused.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Focused.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Focused.this.core$().graph().concept(Block.class).createNode(this.name, Focused.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Focused.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Focused.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Required
        extends Layer
        implements Terminal {
            protected Date _date;

            public Required(Node node) {
                super(node);
            }

            public String pattern() {
                return this._date.pattern();
            }

            public Mode mode() {
                return this._date.mode();
            }

            public Instant value() {
                return this._date.value();
            }

            public Required pattern(String value) {
                this._date.pattern(value);
                return this;
            }

            public Required mode(Mode value) {
                this._date.mode(value);
                return this;
            }

            public Required value(Instant value) {
                this._date.value(value);
                return this;
            }

            public List<Block> blockList() {
                return this._date.blockList();
            }

            public Block blockList(int index) {
                return this._date.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._date.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._date.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._date.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._date.notificationList().get(index);
            }

            public Date asDate() {
                return (Date)this.a$(Date.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Date) {
                    this._date = (Date)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Required.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Required.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Required.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Required.this.core$().graph().concept(Block.class).createNode(this.name, Required.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Required.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Required.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Required.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Required.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Readonly
        extends Layer
        implements Terminal {
            protected Date _date;

            public Readonly(Node node) {
                super(node);
            }

            public String pattern() {
                return this._date.pattern();
            }

            public Mode mode() {
                return this._date.mode();
            }

            public Instant value() {
                return this._date.value();
            }

            public Readonly pattern(String value) {
                this._date.pattern(value);
                return this;
            }

            public Readonly mode(Mode value) {
                this._date.mode(value);
                return this;
            }

            public Readonly value(Instant value) {
                this._date.value(value);
                return this;
            }

            public List<Block> blockList() {
                return this._date.blockList();
            }

            public Block blockList(int index) {
                return this._date.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._date.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._date.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._date.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._date.notificationList().get(index);
            }

            public Date asDate() {
                return (Date)this.a$(Date.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Date) {
                    this._date = (Date)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Readonly.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Readonly.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Readonly.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Readonly.this.core$().graph().concept(Block.class).createNode(this.name, Readonly.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Readonly.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Readonly.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Editable
        extends io.intino.konos.model.graph.Editable
        implements Terminal {
            protected Instant min;
            protected Instant max;
            protected boolean timePicker;
            protected String mask;
            protected boolean allowEmpty;
            protected Date _date;

            public Editable(Node node) {
                super(node);
            }

            public Instant min() {
                return this.min;
            }

            public Instant max() {
                return this.max;
            }

            public boolean timePicker() {
                return this.timePicker;
            }

            public String mask() {
                return this.mask;
            }

            public boolean allowEmpty() {
                return this.allowEmpty;
            }

            public String pattern() {
                return this._date.pattern();
            }

            public Mode mode() {
                return this._date.mode();
            }

            public Instant value() {
                return this._date.value();
            }

            public Editable min(Instant value) {
                this.min = value;
                return this;
            }

            public Editable max(Instant value) {
                this.max = value;
                return this;
            }

            public Editable timePicker(boolean value) {
                this.timePicker = value;
                return this;
            }

            public Editable mask(String value) {
                this.mask = value;
                return this;
            }

            public Editable allowEmpty(boolean value) {
                this.allowEmpty = value;
                return this;
            }

            public Editable pattern(String value) {
                this._date.pattern(value);
                return this;
            }

            public Editable mode(Mode value) {
                this._date.mode(value);
                return this;
            }

            public Editable value(Instant value) {
                this._date.value(value);
                return this;
            }

            public List<Block> blockList() {
                return this._date.blockList();
            }

            public Block blockList(int index) {
                return this._date.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._date.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._date.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._date.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._date.notificationList().get(index);
            }

            public Date asDate() {
                return (Date)this.a$(Date.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("min", new ArrayList<Instant>(Collections.singletonList(this.min)));
                map.put("max", new ArrayList<Instant>(Collections.singletonList(this.max)));
                map.put("timePicker", new ArrayList<Boolean>(Collections.singletonList(this.timePicker)));
                map.put("mask", new ArrayList<String>(Collections.singletonList(this.mask)));
                map.put("allowEmpty", new ArrayList<Boolean>(Collections.singletonList(this.allowEmpty)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("min")) {
                    this.min = (Instant)InstantLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Instant)InstantLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("timePicker")) {
                    this.timePicker = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("mask")) {
                    this.mask = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("allowEmpty")) {
                    this.allowEmpty = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("min")) {
                    this.min = (Instant)values.get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Instant)values.get(0);
                } else if (name.equalsIgnoreCase("timePicker")) {
                    this.timePicker = (Boolean)values.get(0);
                } else if (name.equalsIgnoreCase("mask")) {
                    this.mask = (String)values.get(0);
                } else if (name.equalsIgnoreCase("allowEmpty")) {
                    this.allowEmpty = (Boolean)values.get(0);
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Date) {
                    this._date = (Date)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Editable.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Editable.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Editable.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Editable$Create {
                public Create(String name) {
                    super(name);
                }

                public Block block() {
                    Block newElement = (Block)Editable.this.core$().graph().concept(Block.class).createNode(this.name, Editable.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Editable.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Editable.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Multiple
        extends io.intino.konos.model.graph.Multiple
        implements Terminal {
            protected Date _date;

            public Multiple(Node node) {
                super(node);
            }

            public String pattern() {
                return this._date.pattern();
            }

            public Mode mode() {
                return this._date.mode();
            }

            public Instant value() {
                return this._date.value();
            }

            public Multiple pattern(String value) {
                this._date.pattern(value);
                return this;
            }

            public Multiple mode(Mode value) {
                this._date.mode(value);
                return this;
            }

            public Multiple value(Instant value) {
                this._date.value(value);
                return this;
            }

            public List<Block> blockList() {
                return this._date.blockList();
            }

            public Block blockList(int index) {
                return this._date.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._date.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._date.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._date.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._date.notificationList().get(index);
            }

            public Date asDate() {
                return (Date)this.a$(Date.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Date) {
                    this._date = (Date)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Multiple.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Multiple.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Multiple.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Multiple$Create {
                public Create(String name) {
                    super(name);
                }

                public Block block() {
                    Block newElement = (Block)Multiple.this.core$().graph().concept(Block.class).createNode(this.name, Multiple.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Multiple.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Multiple.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public class Clear
        extends Component.Clear {
        }

        public class Create
        extends Component.Create {
            public Create(String name) {
                super(name);
            }
        }

        public static enum Mode {
            FromNow,
            ToNow,
            None;

        }
    }

    public static class Number
    extends Component
    implements Terminal {
        protected double value;
        protected String prefix;
        protected String suffix;
        protected int countDecimals;
        protected boolean expanded;
        protected Style style;
        protected Multiple _multiple;
        protected Editable _editable;
        protected Readonly _readonly;
        protected Required _required;
        protected Focused _focused;

        public Number(Node node) {
            super(node);
        }

        public double value() {
            return this.value;
        }

        public String prefix() {
            return this.prefix;
        }

        public String suffix() {
            return this.suffix;
        }

        public int countDecimals() {
            return this.countDecimals;
        }

        public boolean expanded() {
            return this.expanded;
        }

        public Style style() {
            return this.style;
        }

        public Number value(double value) {
            this.value = value;
            return this;
        }

        public Number prefix(String value) {
            this.prefix = value;
            return this;
        }

        public Number suffix(String value) {
            this.suffix = value;
            return this;
        }

        public Number countDecimals(int value) {
            this.countDecimals = value;
            return this;
        }

        public Number expanded(boolean value) {
            this.expanded = value;
            return this;
        }

        public Number style(Style value) {
            this.style = value;
            return this;
        }

        public Readonly asReadonly() {
            Layer as = this.a$(Readonly.class);
            return as != null ? (Readonly)as : (Readonly)this.core$().addAspect(Readonly.class);
        }

        public boolean isReadonly() {
            return this.core$().is(Readonly.class);
        }

        public Editable asEditable() {
            Layer as = this.a$(Editable.class);
            return as != null ? (Editable)as : (Editable)this.core$().addAspect(Editable.class);
        }

        public boolean isEditable() {
            return this.core$().is(Editable.class);
        }

        public Focused asFocused() {
            Layer as = this.a$(Focused.class);
            return as != null ? (Focused)as : (Focused)this.core$().addAspect(Focused.class);
        }

        public boolean isFocused() {
            return this.core$().is(Focused.class);
        }

        public Multiple asMultiple() {
            Layer as = this.a$(Multiple.class);
            return as != null ? (Multiple)as : (Multiple)this.core$().addAspect(Multiple.class);
        }

        public boolean isMultiple() {
            return this.core$().is(Multiple.class);
        }

        public Required asRequired() {
            Layer as = this.a$(Required.class);
            return as != null ? (Required)as : (Required)this.core$().addAspect(Required.class);
        }

        public boolean isRequired() {
            return this.core$().is(Required.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("value", new ArrayList<Double>(Collections.singletonList(this.value)));
            map.put("prefix", new ArrayList<String>(Collections.singletonList(this.prefix)));
            map.put("suffix", new ArrayList<String>(Collections.singletonList(this.suffix)));
            map.put("countDecimals", new ArrayList<Integer>(Collections.singletonList(this.countDecimals)));
            map.put("expanded", new ArrayList<Boolean>(Collections.singletonList(this.expanded)));
            map.put("style", new ArrayList<Style>(Collections.singletonList(this.style)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Double)DoubleLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("prefix")) {
                this.prefix = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("suffix")) {
                this.suffix = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("countDecimals")) {
                this.countDecimals = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("expanded")) {
                this.expanded = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("style")) {
                this.style = (Style)((Object)WordLoader.load(values, Style.class, (Layer)this).get(0));
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (Double)values.get(0);
            } else if (name.equalsIgnoreCase("prefix")) {
                this.prefix = (String)values.get(0);
            } else if (name.equalsIgnoreCase("suffix")) {
                this.suffix = (String)values.get(0);
            } else if (name.equalsIgnoreCase("countDecimals")) {
                this.countDecimals = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("expanded")) {
                this.expanded = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("style")) {
                this.style = (Style)((Object)values.get(0));
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Focused
        extends Layer
        implements Terminal {
            protected Number _number;

            public Focused(Node node) {
                super(node);
            }

            public double value() {
                return this._number.value();
            }

            public String prefix() {
                return this._number.prefix();
            }

            public String suffix() {
                return this._number.suffix();
            }

            public int countDecimals() {
                return this._number.countDecimals();
            }

            public boolean expanded() {
                return this._number.expanded();
            }

            public Style style() {
                return this._number.style();
            }

            public Focused value(double value) {
                this._number.value(value);
                return this;
            }

            public Focused prefix(String value) {
                this._number.prefix(value);
                return this;
            }

            public Focused suffix(String value) {
                this._number.suffix(value);
                return this;
            }

            public Focused countDecimals(int value) {
                this._number.countDecimals(value);
                return this;
            }

            public Focused expanded(boolean value) {
                this._number.expanded(value);
                return this;
            }

            public Focused style(Style value) {
                this._number.style(value);
                return this;
            }

            public List<Block> blockList() {
                return this._number.blockList();
            }

            public Block blockList(int index) {
                return this._number.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._number.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._number.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._number.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._number.notificationList().get(index);
            }

            public Number asNumber() {
                return (Number)this.a$(Number.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Number) {
                    this._number = (Number)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Focused.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Focused.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Focused.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Focused.this.core$().graph().concept(Block.class).createNode(this.name, Focused.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Focused.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Focused.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Required
        extends Layer
        implements Terminal {
            protected Number _number;

            public Required(Node node) {
                super(node);
            }

            public double value() {
                return this._number.value();
            }

            public String prefix() {
                return this._number.prefix();
            }

            public String suffix() {
                return this._number.suffix();
            }

            public int countDecimals() {
                return this._number.countDecimals();
            }

            public boolean expanded() {
                return this._number.expanded();
            }

            public Style style() {
                return this._number.style();
            }

            public Required value(double value) {
                this._number.value(value);
                return this;
            }

            public Required prefix(String value) {
                this._number.prefix(value);
                return this;
            }

            public Required suffix(String value) {
                this._number.suffix(value);
                return this;
            }

            public Required countDecimals(int value) {
                this._number.countDecimals(value);
                return this;
            }

            public Required expanded(boolean value) {
                this._number.expanded(value);
                return this;
            }

            public Required style(Style value) {
                this._number.style(value);
                return this;
            }

            public List<Block> blockList() {
                return this._number.blockList();
            }

            public Block blockList(int index) {
                return this._number.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._number.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._number.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._number.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._number.notificationList().get(index);
            }

            public Number asNumber() {
                return (Number)this.a$(Number.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Number) {
                    this._number = (Number)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Required.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Required.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Required.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Required.this.core$().graph().concept(Block.class).createNode(this.name, Required.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Required.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Required.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Required.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Required.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Readonly
        extends Layer
        implements Terminal {
            protected Number _number;

            public Readonly(Node node) {
                super(node);
            }

            public double value() {
                return this._number.value();
            }

            public String prefix() {
                return this._number.prefix();
            }

            public String suffix() {
                return this._number.suffix();
            }

            public int countDecimals() {
                return this._number.countDecimals();
            }

            public boolean expanded() {
                return this._number.expanded();
            }

            public Style style() {
                return this._number.style();
            }

            public Readonly value(double value) {
                this._number.value(value);
                return this;
            }

            public Readonly prefix(String value) {
                this._number.prefix(value);
                return this;
            }

            public Readonly suffix(String value) {
                this._number.suffix(value);
                return this;
            }

            public Readonly countDecimals(int value) {
                this._number.countDecimals(value);
                return this;
            }

            public Readonly expanded(boolean value) {
                this._number.expanded(value);
                return this;
            }

            public Readonly style(Style value) {
                this._number.style(value);
                return this;
            }

            public List<Block> blockList() {
                return this._number.blockList();
            }

            public Block blockList(int index) {
                return this._number.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._number.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._number.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._number.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._number.notificationList().get(index);
            }

            public Number asNumber() {
                return (Number)this.a$(Number.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Number) {
                    this._number = (Number)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Readonly.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Readonly.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Readonly.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Readonly.this.core$().graph().concept(Block.class).createNode(this.name, Readonly.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Readonly.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Readonly.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Editable
        extends io.intino.konos.model.graph.Editable
        implements Terminal {
            protected double min;
            protected double max;
            protected double step;
            protected Number _number;

            public Editable(Node node) {
                super(node);
            }

            public double min() {
                return this.min;
            }

            public double max() {
                return this.max;
            }

            public double step() {
                return this.step;
            }

            public double value() {
                return this._number.value();
            }

            public String prefix() {
                return this._number.prefix();
            }

            public String suffix() {
                return this._number.suffix();
            }

            public int countDecimals() {
                return this._number.countDecimals();
            }

            public boolean expanded() {
                return this._number.expanded();
            }

            public Style style() {
                return this._number.style();
            }

            public Editable min(double value) {
                this.min = value;
                return this;
            }

            public Editable max(double value) {
                this.max = value;
                return this;
            }

            public Editable step(double value) {
                this.step = value;
                return this;
            }

            public Editable value(double value) {
                this._number.value(value);
                return this;
            }

            public Editable prefix(String value) {
                this._number.prefix(value);
                return this;
            }

            public Editable suffix(String value) {
                this._number.suffix(value);
                return this;
            }

            public Editable countDecimals(int value) {
                this._number.countDecimals(value);
                return this;
            }

            public Editable expanded(boolean value) {
                this._number.expanded(value);
                return this;
            }

            public Editable style(Style value) {
                this._number.style(value);
                return this;
            }

            public List<Block> blockList() {
                return this._number.blockList();
            }

            public Block blockList(int index) {
                return this._number.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._number.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._number.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._number.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._number.notificationList().get(index);
            }

            public Number asNumber() {
                return (Number)this.a$(Number.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("min", new ArrayList<Double>(Collections.singletonList(this.min)));
                map.put("max", new ArrayList<Double>(Collections.singletonList(this.max)));
                map.put("step", new ArrayList<Double>(Collections.singletonList(this.step)));
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("min")) {
                    this.min = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("step")) {
                    this.step = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("min")) {
                    this.min = (Double)values.get(0);
                } else if (name.equalsIgnoreCase("max")) {
                    this.max = (Double)values.get(0);
                } else if (name.equalsIgnoreCase("step")) {
                    this.step = (Double)values.get(0);
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Number) {
                    this._number = (Number)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Editable.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Editable.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Editable.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Editable$Create {
                public Create(String name) {
                    super(name);
                }

                public Block block() {
                    Block newElement = (Block)Editable.this.core$().graph().concept(Block.class).createNode(this.name, Editable.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Editable.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Editable.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Multiple
        extends io.intino.konos.model.graph.Multiple
        implements Terminal {
            protected Number _number;

            public Multiple(Node node) {
                super(node);
            }

            public double value() {
                return this._number.value();
            }

            public String prefix() {
                return this._number.prefix();
            }

            public String suffix() {
                return this._number.suffix();
            }

            public int countDecimals() {
                return this._number.countDecimals();
            }

            public boolean expanded() {
                return this._number.expanded();
            }

            public Style style() {
                return this._number.style();
            }

            public Multiple value(double value) {
                this._number.value(value);
                return this;
            }

            public Multiple prefix(String value) {
                this._number.prefix(value);
                return this;
            }

            public Multiple suffix(String value) {
                this._number.suffix(value);
                return this;
            }

            public Multiple countDecimals(int value) {
                this._number.countDecimals(value);
                return this;
            }

            public Multiple expanded(boolean value) {
                this._number.expanded(value);
                return this;
            }

            public Multiple style(Style value) {
                this._number.style(value);
                return this;
            }

            public List<Block> blockList() {
                return this._number.blockList();
            }

            public Block blockList(int index) {
                return this._number.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._number.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._number.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._number.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._number.notificationList().get(index);
            }

            public Number asNumber() {
                return (Number)this.a$(Number.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Number) {
                    this._number = (Number)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Multiple.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Multiple.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Multiple.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Multiple$Create {
                public Create(String name) {
                    super(name);
                }

                public Block block() {
                    Block newElement = (Block)Multiple.this.core$().graph().concept(Block.class).createNode(this.name, Multiple.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Multiple.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Multiple.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public class Clear
        extends Component.Clear {
        }

        public class Create
        extends Component.Create {
            public Create(String name) {
                super(name);
            }
        }

        public static enum Style {
            Number,
            Currency,
            Bytes,
            Percentage,
            Exponential;

        }
    }

    public static class Image
    extends Component
    implements Terminal {
        protected String value;
        protected String defaultValue;
        protected int mobileReduceFactor;
        protected Avatar _avatar;
        protected Absolute _absolute;
        protected Relative _relative;
        protected Multiple _multiple;
        protected Editable _editable;
        protected Readonly _readonly;
        protected Required _required;
        protected Focused _focused;

        public Image(Node node) {
            super(node);
        }

        public String value() {
            return this.value;
        }

        public String defaultValue() {
            return this.defaultValue;
        }

        public int mobileReduceFactor() {
            return this.mobileReduceFactor;
        }

        public Image value(String value) {
            this.value = value;
            return this;
        }

        public Image defaultValue(String value) {
            this.defaultValue = value;
            return this;
        }

        public Image mobileReduceFactor(int value) {
            this.mobileReduceFactor = value;
            return this;
        }

        public Readonly asReadonly() {
            Layer as = this.a$(Readonly.class);
            return as != null ? (Readonly)as : (Readonly)this.core$().addAspect(Readonly.class);
        }

        public boolean isReadonly() {
            return this.core$().is(Readonly.class);
        }

        public Relative asRelative() {
            Layer as = this.a$(Relative.class);
            return as != null ? (Relative)as : (Relative)this.core$().addAspect(Relative.class);
        }

        public boolean isRelative() {
            return this.core$().is(Relative.class);
        }

        public Avatar asAvatar() {
            return (Avatar)this.a$(Avatar.class);
        }

        public Avatar asAvatar(String text) {
            Avatar newElement = (Avatar)this.core$().addAspect(Avatar.class);
            newElement.core$().set((Layer)newElement, "text", Collections.singletonList(text));
            return newElement;
        }

        public boolean isAvatar() {
            return this.core$().is(Avatar.class);
        }

        public void removeAvatar() {
            this.core$().removeAspect(Avatar.class);
        }

        public Editable asEditable() {
            Layer as = this.a$(Editable.class);
            return as != null ? (Editable)as : (Editable)this.core$().addAspect(Editable.class);
        }

        public boolean isEditable() {
            return this.core$().is(Editable.class);
        }

        public Absolute asAbsolute() {
            Layer as = this.a$(Absolute.class);
            return as != null ? (Absolute)as : (Absolute)this.core$().addAspect(Absolute.class);
        }

        public boolean isAbsolute() {
            return this.core$().is(Absolute.class);
        }

        public Multiple asMultiple() {
            Layer as = this.a$(Multiple.class);
            return as != null ? (Multiple)as : (Multiple)this.core$().addAspect(Multiple.class);
        }

        public boolean isMultiple() {
            return this.core$().is(Multiple.class);
        }

        public Required asRequired() {
            Layer as = this.a$(Required.class);
            return as != null ? (Required)as : (Required)this.core$().addAspect(Required.class);
        }

        public boolean isRequired() {
            return this.core$().is(Required.class);
        }

        public Focused asFocused() {
            Layer as = this.a$(Focused.class);
            return as != null ? (Focused)as : (Focused)this.core$().addAspect(Focused.class);
        }

        public boolean isFocused() {
            return this.core$().is(Focused.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            map.put("defaultValue", new ArrayList<String>(Collections.singletonList(this.defaultValue)));
            map.put("mobileReduceFactor", new ArrayList<Integer>(Collections.singletonList(this.mobileReduceFactor)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("defaultValue")) {
                this.defaultValue = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("mobileReduceFactor")) {
                this.mobileReduceFactor = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            } else if (name.equalsIgnoreCase("defaultValue")) {
                this.defaultValue = (String)values.get(0);
            } else if (name.equalsIgnoreCase("mobileReduceFactor")) {
                this.mobileReduceFactor = (Integer)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Focused
        extends Layer
        implements Terminal {
            protected Image _image;

            public Focused(Node node) {
                super(node);
            }

            public String value() {
                return this._image.value();
            }

            public String defaultValue() {
                return this._image.defaultValue();
            }

            public int mobileReduceFactor() {
                return this._image.mobileReduceFactor();
            }

            public Focused value(String value) {
                this._image.value(value);
                return this;
            }

            public Focused defaultValue(String value) {
                this._image.defaultValue(value);
                return this;
            }

            public Focused mobileReduceFactor(int value) {
                this._image.mobileReduceFactor(value);
                return this;
            }

            public List<Block> blockList() {
                return this._image.blockList();
            }

            public Block blockList(int index) {
                return this._image.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._image.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._image.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._image.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._image.notificationList().get(index);
            }

            public Image asImage() {
                return (Image)this.a$(Image.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Image) {
                    this._image = (Image)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Focused.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Focused.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Focused.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Focused.this.core$().graph().concept(Block.class).createNode(this.name, Focused.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Focused.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Focused.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Required
        extends Layer
        implements Terminal {
            protected Image _image;

            public Required(Node node) {
                super(node);
            }

            public String value() {
                return this._image.value();
            }

            public String defaultValue() {
                return this._image.defaultValue();
            }

            public int mobileReduceFactor() {
                return this._image.mobileReduceFactor();
            }

            public Required value(String value) {
                this._image.value(value);
                return this;
            }

            public Required defaultValue(String value) {
                this._image.defaultValue(value);
                return this;
            }

            public Required mobileReduceFactor(int value) {
                this._image.mobileReduceFactor(value);
                return this;
            }

            public List<Block> blockList() {
                return this._image.blockList();
            }

            public Block blockList(int index) {
                return this._image.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._image.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._image.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._image.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._image.notificationList().get(index);
            }

            public Image asImage() {
                return (Image)this.a$(Image.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Image) {
                    this._image = (Image)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Required.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Required.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Required.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Required.this.core$().graph().concept(Block.class).createNode(this.name, Required.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Required.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Required.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Required.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Required.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Readonly
        extends Layer
        implements Terminal {
            protected Image _image;

            public Readonly(Node node) {
                super(node);
            }

            public String value() {
                return this._image.value();
            }

            public String defaultValue() {
                return this._image.defaultValue();
            }

            public int mobileReduceFactor() {
                return this._image.mobileReduceFactor();
            }

            public Readonly value(String value) {
                this._image.value(value);
                return this;
            }

            public Readonly defaultValue(String value) {
                this._image.defaultValue(value);
                return this;
            }

            public Readonly mobileReduceFactor(int value) {
                this._image.mobileReduceFactor(value);
                return this;
            }

            public List<Block> blockList() {
                return this._image.blockList();
            }

            public Block blockList(int index) {
                return this._image.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._image.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._image.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._image.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._image.notificationList().get(index);
            }

            public Image asImage() {
                return (Image)this.a$(Image.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Image) {
                    this._image = (Image)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Readonly.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Readonly.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Readonly.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Readonly.this.core$().graph().concept(Block.class).createNode(this.name, Readonly.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Readonly.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Readonly.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Editable
        extends io.intino.konos.model.graph.Editable
        implements Terminal {
            protected boolean showPreview;
            protected Validation validation;
            protected Image _image;

            public Editable(Node node) {
                super(node);
            }

            public boolean showPreview() {
                return this.showPreview;
            }

            public String value() {
                return this._image.value();
            }

            public int mobileReduceFactor() {
                return this._image.mobileReduceFactor();
            }

            public Editable showPreview(boolean value) {
                this.showPreview = value;
                return this;
            }

            public Editable value(String value) {
                this._image.value(value);
                return this;
            }

            public Editable mobileReduceFactor(int value) {
                this._image.mobileReduceFactor(value);
                return this;
            }

            public Validation validation() {
                return this.validation;
            }

            public List<Block> blockList() {
                return this._image.blockList();
            }

            public Block blockList(int index) {
                return this._image.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._image.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._image.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._image.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._image.notificationList().get(index);
            }

            public Image asImage() {
                return (Image)this.a$(Image.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.validation != null) {
                    components.add(this.validation.core$());
                }
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("showPreview", new ArrayList<Boolean>(Collections.singletonList(this.showPreview)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("DataComponents$Image$Editable$Validation")) {
                    this.validation = (Validation)node.as(Validation.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("DataComponents$Image$Editable$Validation")) {
                    this.validation = null;
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("showPreview")) {
                    this.showPreview = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("showPreview")) {
                    this.showPreview = (Boolean)values.get(0);
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Image) {
                    this._image = (Image)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Validation
            extends Layer
            implements Terminal {
                protected double maxSize;
                protected List<String> allowedExtensions = new ArrayList<String>();

                public Validation(Node node) {
                    super(node);
                }

                public double maxSize() {
                    return this.maxSize;
                }

                public List<String> allowedExtensions() {
                    return this.allowedExtensions;
                }

                public String allowedExtensions(int index) {
                    return this.allowedExtensions.get(index);
                }

                public List<String> allowedExtensions(Predicate<String> predicate) {
                    return this.allowedExtensions().stream().filter(predicate).collect(Collectors.toList());
                }

                public Validation maxSize(double value) {
                    this.maxSize = value;
                    return this;
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("maxSize", new ArrayList<Double>(Collections.singletonList(this.maxSize)));
                    map.put("allowedExtensions", this.allowedExtensions);
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("maxSize")) {
                        this.maxSize = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("allowedExtensions")) {
                        this.allowedExtensions = StringLoader.load(values, (Layer)this);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("maxSize")) {
                        this.maxSize = (Double)values.get(0);
                    } else if (name.equalsIgnoreCase("allowedExtensions")) {
                        this.allowedExtensions = new ArrayList(values);
                    }
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Editable.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Editable.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Editable.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Editable$Create {
                public Create(String name) {
                    super(name);
                }

                public Validation validation(double maxSize) {
                    Validation newElement = (Validation)Editable.this.core$().graph().concept(Validation.class).createNode(this.name, Editable.this.core$()).as(Validation.class);
                    newElement.core$().set((Layer)newElement, "maxSize", Collections.singletonList(maxSize));
                    return newElement;
                }

                public Block block() {
                    Block newElement = (Block)Editable.this.core$().graph().concept(Block.class).createNode(this.name, Editable.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Editable.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Editable.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Multiple
        extends io.intino.konos.model.graph.Multiple
        implements Terminal {
            protected Image _image;

            public Multiple(Node node) {
                super(node);
            }

            public String value() {
                return this._image.value();
            }

            public String defaultValue() {
                return this._image.defaultValue();
            }

            public int mobileReduceFactor() {
                return this._image.mobileReduceFactor();
            }

            public Multiple value(String value) {
                this._image.value(value);
                return this;
            }

            public Multiple defaultValue(String value) {
                this._image.defaultValue(value);
                return this;
            }

            public Multiple mobileReduceFactor(int value) {
                this._image.mobileReduceFactor(value);
                return this;
            }

            public List<Block> blockList() {
                return this._image.blockList();
            }

            public Block blockList(int index) {
                return this._image.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._image.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._image.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._image.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._image.notificationList().get(index);
            }

            public Image asImage() {
                return (Image)this.a$(Image.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Image) {
                    this._image = (Image)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Multiple.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Multiple.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Multiple.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Multiple$Create {
                public Create(String name) {
                    super(name);
                }

                public Block block() {
                    Block newElement = (Block)Multiple.this.core$().graph().concept(Block.class).createNode(this.name, Multiple.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Multiple.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Multiple.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Relative
        extends io.intino.konos.model.graph.Relative
        implements Terminal {
            protected Image _image;

            public Relative(Node node) {
                super(node);
            }

            public String value() {
                return this._image.value();
            }

            public String defaultValue() {
                return this._image.defaultValue();
            }

            public int mobileReduceFactor() {
                return this._image.mobileReduceFactor();
            }

            public Relative value(String value) {
                this._image.value(value);
                return this;
            }

            public Relative defaultValue(String value) {
                this._image.defaultValue(value);
                return this;
            }

            public Relative mobileReduceFactor(int value) {
                this._image.mobileReduceFactor(value);
                return this;
            }

            public List<Block> blockList() {
                return this._image.blockList();
            }

            public Block blockList(int index) {
                return this._image.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._image.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._image.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._image.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._image.notificationList().get(index);
            }

            public Image asImage() {
                return (Image)this.a$(Image.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Image) {
                    this._image = (Image)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Relative.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Relative.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Relative.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Relative$Create {
                public Create(String name) {
                    super(name);
                }

                public Block block() {
                    Block newElement = (Block)Relative.this.core$().graph().concept(Block.class).createNode(this.name, Relative.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Relative.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Relative.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Relative.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Relative.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Absolute
        extends io.intino.konos.model.graph.Absolute
        implements Terminal {
            protected Image _image;

            public Absolute(Node node) {
                super(node);
            }

            public String value() {
                return this._image.value();
            }

            public String defaultValue() {
                return this._image.defaultValue();
            }

            public int mobileReduceFactor() {
                return this._image.mobileReduceFactor();
            }

            public Absolute value(String value) {
                this._image.value(value);
                return this;
            }

            public Absolute defaultValue(String value) {
                this._image.defaultValue(value);
                return this;
            }

            public Absolute mobileReduceFactor(int value) {
                this._image.mobileReduceFactor(value);
                return this;
            }

            public List<Block> blockList() {
                return this._image.blockList();
            }

            public Block blockList(int index) {
                return this._image.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._image.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._image.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._image.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._image.notificationList().get(index);
            }

            public Image asImage() {
                return (Image)this.a$(Image.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Image) {
                    this._image = (Image)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Absolute.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Absolute.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Absolute.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Absolute$Create {
                public Create(String name) {
                    super(name);
                }

                public Block block() {
                    Block newElement = (Block)Absolute.this.core$().graph().concept(Block.class).createNode(this.name, Absolute.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Absolute.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Absolute.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Absolute.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Absolute.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Avatar
        extends Layer
        implements Terminal {
            protected String text;
            protected Image _image;

            public Avatar(Node node) {
                super(node);
            }

            public String text() {
                return this.text;
            }

            public String value() {
                return this._image.value();
            }

            public String defaultValue() {
                return this._image.defaultValue();
            }

            public int mobileReduceFactor() {
                return this._image.mobileReduceFactor();
            }

            public Avatar text(String value) {
                this.text = value;
                return this;
            }

            public Avatar value(String value) {
                this._image.value(value);
                return this;
            }

            public Avatar defaultValue(String value) {
                this._image.defaultValue(value);
                return this;
            }

            public Avatar mobileReduceFactor(int value) {
                this._image.mobileReduceFactor(value);
                return this;
            }

            public List<Block> blockList() {
                return this._image.blockList();
            }

            public Block blockList(int index) {
                return this._image.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._image.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._image.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._image.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._image.notificationList().get(index);
            }

            public Image asImage() {
                return (Image)this.a$(Image.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("text", new ArrayList<String>(Collections.singletonList(this.text)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("text")) {
                    this.text = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("text")) {
                    this.text = (String)values.get(0);
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Image) {
                    this._image = (Image)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Avatar.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Avatar.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Avatar.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Avatar.this.core$().graph().concept(Block.class).createNode(this.name, Avatar.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Avatar.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Avatar.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Avatar.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Avatar.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public class Clear
        extends Component.Clear {
        }

        public class Create
        extends Component.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static class File
    extends Component
    implements Terminal {
        protected String value;
        protected Absolute _absolute;
        protected Relative _relative;
        protected Multiple _multiple;
        protected Editable _editable;
        protected Readonly _readonly;
        protected Required _required;
        protected Focused _focused;

        public File(Node node) {
            super(node);
        }

        public String value() {
            return this.value;
        }

        public File value(String value) {
            this.value = value;
            return this;
        }

        public Relative asRelative() {
            Layer as = this.a$(Relative.class);
            return as != null ? (Relative)as : (Relative)this.core$().addAspect(Relative.class);
        }

        public boolean isRelative() {
            return this.core$().is(Relative.class);
        }

        public Focused asFocused() {
            Layer as = this.a$(Focused.class);
            return as != null ? (Focused)as : (Focused)this.core$().addAspect(Focused.class);
        }

        public boolean isFocused() {
            return this.core$().is(Focused.class);
        }

        public Readonly asReadonly() {
            Layer as = this.a$(Readonly.class);
            return as != null ? (Readonly)as : (Readonly)this.core$().addAspect(Readonly.class);
        }

        public boolean isReadonly() {
            return this.core$().is(Readonly.class);
        }

        public Multiple asMultiple() {
            Layer as = this.a$(Multiple.class);
            return as != null ? (Multiple)as : (Multiple)this.core$().addAspect(Multiple.class);
        }

        public boolean isMultiple() {
            return this.core$().is(Multiple.class);
        }

        public Required asRequired() {
            Layer as = this.a$(Required.class);
            return as != null ? (Required)as : (Required)this.core$().addAspect(Required.class);
        }

        public boolean isRequired() {
            return this.core$().is(Required.class);
        }

        public Absolute asAbsolute() {
            Layer as = this.a$(Absolute.class);
            return as != null ? (Absolute)as : (Absolute)this.core$().addAspect(Absolute.class);
        }

        public boolean isAbsolute() {
            return this.core$().is(Absolute.class);
        }

        public Editable asEditable() {
            Layer as = this.a$(Editable.class);
            return as != null ? (Editable)as : (Editable)this.core$().addAspect(Editable.class);
        }

        public boolean isEditable() {
            return this.core$().is(Editable.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Focused
        extends Layer
        implements Terminal {
            protected File _file;

            public Focused(Node node) {
                super(node);
            }

            public String value() {
                return this._file.value();
            }

            public Focused value(String value) {
                this._file.value(value);
                return this;
            }

            public List<Block> blockList() {
                return this._file.blockList();
            }

            public Block blockList(int index) {
                return this._file.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._file.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._file.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._file.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._file.notificationList().get(index);
            }

            public File asFile() {
                return (File)this.a$(File.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof File) {
                    this._file = (File)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Focused.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Focused.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Focused.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Focused.this.core$().graph().concept(Block.class).createNode(this.name, Focused.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Focused.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Focused.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Required
        extends Layer
        implements Terminal {
            protected File _file;

            public Required(Node node) {
                super(node);
            }

            public String value() {
                return this._file.value();
            }

            public Required value(String value) {
                this._file.value(value);
                return this;
            }

            public List<Block> blockList() {
                return this._file.blockList();
            }

            public Block blockList(int index) {
                return this._file.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._file.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._file.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._file.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._file.notificationList().get(index);
            }

            public File asFile() {
                return (File)this.a$(File.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof File) {
                    this._file = (File)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Required.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Required.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Required.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Required.this.core$().graph().concept(Block.class).createNode(this.name, Required.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Required.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Required.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Required.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Required.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Readonly
        extends Layer
        implements Terminal {
            protected File _file;

            public Readonly(Node node) {
                super(node);
            }

            public String value() {
                return this._file.value();
            }

            public Readonly value(String value) {
                this._file.value(value);
                return this;
            }

            public List<Block> blockList() {
                return this._file.blockList();
            }

            public Block blockList(int index) {
                return this._file.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._file.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._file.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._file.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._file.notificationList().get(index);
            }

            public File asFile() {
                return (File)this.a$(File.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof File) {
                    this._file = (File)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Readonly.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Readonly.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Readonly.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Readonly.this.core$().graph().concept(Block.class).createNode(this.name, Readonly.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Readonly.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Readonly.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Editable
        extends io.intino.konos.model.graph.Editable
        implements Terminal {
            protected boolean showPreview;
            protected Validation validation;
            protected File _file;

            public Editable(Node node) {
                super(node);
            }

            public boolean showPreview() {
                return this.showPreview;
            }

            public String value() {
                return this._file.value();
            }

            public Editable showPreview(boolean value) {
                this.showPreview = value;
                return this;
            }

            public Editable value(String value) {
                this._file.value(value);
                return this;
            }

            public Validation validation() {
                return this.validation;
            }

            public List<Block> blockList() {
                return this._file.blockList();
            }

            public Block blockList(int index) {
                return this._file.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._file.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._file.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._file.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._file.notificationList().get(index);
            }

            public File asFile() {
                return (File)this.a$(File.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.validation != null) {
                    components.add(this.validation.core$());
                }
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("showPreview", new ArrayList<Boolean>(Collections.singletonList(this.showPreview)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("DataComponents$File$Editable$Validation")) {
                    this.validation = (Validation)node.as(Validation.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("DataComponents$File$Editable$Validation")) {
                    this.validation = null;
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("showPreview")) {
                    this.showPreview = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("showPreview")) {
                    this.showPreview = (Boolean)values.get(0);
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof File) {
                    this._file = (File)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Validation
            extends Layer
            implements Terminal {
                protected double maxSize;
                protected List<String> allowedExtensions = new ArrayList<String>();

                public Validation(Node node) {
                    super(node);
                }

                public double maxSize() {
                    return this.maxSize;
                }

                public List<String> allowedExtensions() {
                    return this.allowedExtensions;
                }

                public String allowedExtensions(int index) {
                    return this.allowedExtensions.get(index);
                }

                public List<String> allowedExtensions(Predicate<String> predicate) {
                    return this.allowedExtensions().stream().filter(predicate).collect(Collectors.toList());
                }

                public Validation maxSize(double value) {
                    this.maxSize = value;
                    return this;
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("maxSize", new ArrayList<Double>(Collections.singletonList(this.maxSize)));
                    map.put("allowedExtensions", this.allowedExtensions);
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("maxSize")) {
                        this.maxSize = (Double)DoubleLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("allowedExtensions")) {
                        this.allowedExtensions = StringLoader.load(values, (Layer)this);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("maxSize")) {
                        this.maxSize = (Double)values.get(0);
                    } else if (name.equalsIgnoreCase("allowedExtensions")) {
                        this.allowedExtensions = new ArrayList(values);
                    }
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Editable.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Editable.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Editable.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Editable$Create {
                public Create(String name) {
                    super(name);
                }

                public Validation validation(double maxSize) {
                    Validation newElement = (Validation)Editable.this.core$().graph().concept(Validation.class).createNode(this.name, Editable.this.core$()).as(Validation.class);
                    newElement.core$().set((Layer)newElement, "maxSize", Collections.singletonList(maxSize));
                    return newElement;
                }

                public Block block() {
                    Block newElement = (Block)Editable.this.core$().graph().concept(Block.class).createNode(this.name, Editable.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Editable.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Editable.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Multiple
        extends io.intino.konos.model.graph.Multiple
        implements Terminal {
            protected File _file;

            public Multiple(Node node) {
                super(node);
            }

            public String value() {
                return this._file.value();
            }

            public Multiple value(String value) {
                this._file.value(value);
                return this;
            }

            public List<Block> blockList() {
                return this._file.blockList();
            }

            public Block blockList(int index) {
                return this._file.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._file.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._file.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._file.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._file.notificationList().get(index);
            }

            public File asFile() {
                return (File)this.a$(File.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof File) {
                    this._file = (File)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Multiple.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Multiple.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Multiple.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Multiple$Create {
                public Create(String name) {
                    super(name);
                }

                public Block block() {
                    Block newElement = (Block)Multiple.this.core$().graph().concept(Block.class).createNode(this.name, Multiple.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Multiple.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Multiple.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Relative
        extends io.intino.konos.model.graph.Relative
        implements Terminal {
            protected File _file;

            public Relative(Node node) {
                super(node);
            }

            public String value() {
                return this._file.value();
            }

            public Relative value(String value) {
                this._file.value(value);
                return this;
            }

            public List<Block> blockList() {
                return this._file.blockList();
            }

            public Block blockList(int index) {
                return this._file.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._file.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._file.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._file.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._file.notificationList().get(index);
            }

            public File asFile() {
                return (File)this.a$(File.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof File) {
                    this._file = (File)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Relative.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Relative.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Relative.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Relative$Create {
                public Create(String name) {
                    super(name);
                }

                public Block block() {
                    Block newElement = (Block)Relative.this.core$().graph().concept(Block.class).createNode(this.name, Relative.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Relative.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Relative.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Relative.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Relative.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Absolute
        extends io.intino.konos.model.graph.Absolute
        implements Terminal {
            protected File _file;

            public Absolute(Node node) {
                super(node);
            }

            public String value() {
                return this._file.value();
            }

            public Absolute value(String value) {
                this._file.value(value);
                return this;
            }

            public List<Block> blockList() {
                return this._file.blockList();
            }

            public Block blockList(int index) {
                return this._file.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._file.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._file.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._file.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._file.notificationList().get(index);
            }

            public File asFile() {
                return (File)this.a$(File.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof File) {
                    this._file = (File)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Absolute.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Absolute.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Absolute.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Absolute$Create {
                public Create(String name) {
                    super(name);
                }

                public Block block() {
                    Block newElement = (Block)Absolute.this.core$().graph().concept(Block.class).createNode(this.name, Absolute.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Absolute.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Absolute.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Absolute.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Absolute.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public class Clear
        extends Component.Clear {
        }

        public class Create
        extends Component.Create {
            public Create(String name) {
                super(name);
            }
        }
    }

    public static class Text
    extends Component
    implements Terminal {
        protected Mode mode;
        protected String value;
        protected String prefix;
        protected String suffix;
        protected int cropWithEllipsis;
        protected boolean translate;
        protected Multiple _multiple;
        protected Highlighted _highlighted;
        protected Code _code;
        protected Editable _editable;
        protected Memo _memo;
        protected Password _password;
        protected Readonly _readonly;
        protected Required _required;
        protected Focused _focused;

        public Text(Node node) {
            super(node);
        }

        public Mode mode() {
            return this.mode;
        }

        public String value() {
            return this.value;
        }

        public String prefix() {
            return this.prefix;
        }

        public String suffix() {
            return this.suffix;
        }

        public int cropWithEllipsis() {
            return this.cropWithEllipsis;
        }

        public boolean translate() {
            return this.translate;
        }

        public Text mode(Mode value) {
            this.mode = value;
            return this;
        }

        public Text value(String value) {
            this.value = value;
            return this;
        }

        public Text prefix(String value) {
            this.prefix = value;
            return this;
        }

        public Text suffix(String value) {
            this.suffix = value;
            return this;
        }

        public Text cropWithEllipsis(int value) {
            this.cropWithEllipsis = value;
            return this;
        }

        public Text translate(boolean value) {
            this.translate = value;
            return this;
        }

        public Code asCode() {
            return (Code)this.a$(Code.class);
        }

        public Code asCode(CodeLanguage language) {
            Code newElement = (Code)this.core$().addAspect(Code.class);
            newElement.core$().set((Layer)newElement, "language", Collections.singletonList(language));
            return newElement;
        }

        public boolean isCode() {
            return this.core$().is(Code.class);
        }

        public void removeCode() {
            this.core$().removeAspect(Code.class);
        }

        public Password asPassword() {
            Layer as = this.a$(Password.class);
            return as != null ? (Password)as : (Password)this.core$().addAspect(Password.class);
        }

        public boolean isPassword() {
            return this.core$().is(Password.class);
        }

        public Highlighted asHighlighted() {
            return (Highlighted)this.a$(Highlighted.class);
        }

        public Highlighted asHighlighted(String textColor, String backgroundColor) {
            Highlighted newElement = (Highlighted)this.core$().addAspect(Highlighted.class);
            newElement.core$().set((Layer)newElement, "textColor", Collections.singletonList(textColor));
            newElement.core$().set((Layer)newElement, "backgroundColor", Collections.singletonList(backgroundColor));
            return newElement;
        }

        public boolean isHighlighted() {
            return this.core$().is(Highlighted.class);
        }

        public void removeHighlighted() {
            this.core$().removeAspect(Highlighted.class);
        }

        public Memo asMemo() {
            Layer as = this.a$(Memo.class);
            return as != null ? (Memo)as : (Memo)this.core$().addAspect(Memo.class);
        }

        public boolean isMemo() {
            return this.core$().is(Memo.class);
        }

        public Multiple asMultiple() {
            Layer as = this.a$(Multiple.class);
            return as != null ? (Multiple)as : (Multiple)this.core$().addAspect(Multiple.class);
        }

        public boolean isMultiple() {
            return this.core$().is(Multiple.class);
        }

        public Editable asEditable() {
            Layer as = this.a$(Editable.class);
            return as != null ? (Editable)as : (Editable)this.core$().addAspect(Editable.class);
        }

        public boolean isEditable() {
            return this.core$().is(Editable.class);
        }

        public Focused asFocused() {
            Layer as = this.a$(Focused.class);
            return as != null ? (Focused)as : (Focused)this.core$().addAspect(Focused.class);
        }

        public boolean isFocused() {
            return this.core$().is(Focused.class);
        }

        public Readonly asReadonly() {
            Layer as = this.a$(Readonly.class);
            return as != null ? (Readonly)as : (Readonly)this.core$().addAspect(Readonly.class);
        }

        public boolean isReadonly() {
            return this.core$().is(Readonly.class);
        }

        public Required asRequired() {
            Layer as = this.a$(Required.class);
            return as != null ? (Required)as : (Required)this.core$().addAspect(Required.class);
        }

        public boolean isRequired() {
            return this.core$().is(Required.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
            map.put("value", new ArrayList<String>(Collections.singletonList(this.value)));
            map.put("prefix", new ArrayList<String>(Collections.singletonList(this.prefix)));
            map.put("suffix", new ArrayList<String>(Collections.singletonList(this.suffix)));
            map.put("cropWithEllipsis", new ArrayList<Integer>(Collections.singletonList(this.cropWithEllipsis)));
            map.put("translate", new ArrayList<Boolean>(Collections.singletonList(this.translate)));
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("prefix")) {
                this.prefix = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("suffix")) {
                this.suffix = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("cropWithEllipsis")) {
                this.cropWithEllipsis = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("translate")) {
                this.translate = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            }
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("value")) {
                this.value = (String)values.get(0);
            } else if (name.equalsIgnoreCase("prefix")) {
                this.prefix = (String)values.get(0);
            } else if (name.equalsIgnoreCase("suffix")) {
                this.suffix = (String)values.get(0);
            } else if (name.equalsIgnoreCase("cropWithEllipsis")) {
                this.cropWithEllipsis = (Integer)values.get(0);
            } else if (name.equalsIgnoreCase("translate")) {
                this.translate = (Boolean)values.get(0);
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Focused
        extends Layer
        implements Terminal {
            protected Text _text;

            public Focused(Node node) {
                super(node);
            }

            public Mode mode() {
                return this._text.mode();
            }

            public String value() {
                return this._text.value();
            }

            public String prefix() {
                return this._text.prefix();
            }

            public String suffix() {
                return this._text.suffix();
            }

            public int cropWithEllipsis() {
                return this._text.cropWithEllipsis();
            }

            public boolean translate() {
                return this._text.translate();
            }

            public Focused mode(Mode value) {
                this._text.mode(value);
                return this;
            }

            public Focused value(String value) {
                this._text.value(value);
                return this;
            }

            public Focused prefix(String value) {
                this._text.prefix(value);
                return this;
            }

            public Focused suffix(String value) {
                this._text.suffix(value);
                return this;
            }

            public Focused cropWithEllipsis(int value) {
                this._text.cropWithEllipsis(value);
                return this;
            }

            public Focused translate(boolean value) {
                this._text.translate(value);
                return this;
            }

            public List<Block> blockList() {
                return this._text.blockList();
            }

            public Block blockList(int index) {
                return this._text.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._text.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._text.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._text.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._text.notificationList().get(index);
            }

            public Text asText() {
                return (Text)this.a$(Text.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Text) {
                    this._text = (Text)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Focused.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Focused.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Focused.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Focused.this.core$().graph().concept(Block.class).createNode(this.name, Focused.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Focused.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Focused.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Focused.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Required
        extends Layer
        implements Terminal {
            protected Text _text;

            public Required(Node node) {
                super(node);
            }

            public Mode mode() {
                return this._text.mode();
            }

            public String value() {
                return this._text.value();
            }

            public String prefix() {
                return this._text.prefix();
            }

            public String suffix() {
                return this._text.suffix();
            }

            public int cropWithEllipsis() {
                return this._text.cropWithEllipsis();
            }

            public boolean translate() {
                return this._text.translate();
            }

            public Required mode(Mode value) {
                this._text.mode(value);
                return this;
            }

            public Required value(String value) {
                this._text.value(value);
                return this;
            }

            public Required prefix(String value) {
                this._text.prefix(value);
                return this;
            }

            public Required suffix(String value) {
                this._text.suffix(value);
                return this;
            }

            public Required cropWithEllipsis(int value) {
                this._text.cropWithEllipsis(value);
                return this;
            }

            public Required translate(boolean value) {
                this._text.translate(value);
                return this;
            }

            public List<Block> blockList() {
                return this._text.blockList();
            }

            public Block blockList(int index) {
                return this._text.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._text.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._text.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._text.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._text.notificationList().get(index);
            }

            public Text asText() {
                return (Text)this.a$(Text.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Text) {
                    this._text = (Text)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Required.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Required.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Required.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Required.this.core$().graph().concept(Block.class).createNode(this.name, Required.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Required.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Required.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Required.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Required.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Readonly
        extends Layer
        implements Terminal {
            protected Text _text;

            public Readonly(Node node) {
                super(node);
            }

            public Mode mode() {
                return this._text.mode();
            }

            public String value() {
                return this._text.value();
            }

            public String prefix() {
                return this._text.prefix();
            }

            public String suffix() {
                return this._text.suffix();
            }

            public int cropWithEllipsis() {
                return this._text.cropWithEllipsis();
            }

            public boolean translate() {
                return this._text.translate();
            }

            public Readonly mode(Mode value) {
                this._text.mode(value);
                return this;
            }

            public Readonly value(String value) {
                this._text.value(value);
                return this;
            }

            public Readonly prefix(String value) {
                this._text.prefix(value);
                return this;
            }

            public Readonly suffix(String value) {
                this._text.suffix(value);
                return this;
            }

            public Readonly cropWithEllipsis(int value) {
                this._text.cropWithEllipsis(value);
                return this;
            }

            public Readonly translate(boolean value) {
                this._text.translate(value);
                return this;
            }

            public List<Block> blockList() {
                return this._text.blockList();
            }

            public Block blockList(int index) {
                return this._text.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._text.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._text.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._text.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._text.notificationList().get(index);
            }

            public Text asText() {
                return (Text)this.a$(Text.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Text) {
                    this._text = (Text)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Readonly.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Readonly.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Readonly.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Readonly.this.core$().graph().concept(Block.class).createNode(this.name, Readonly.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Readonly.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Readonly.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Readonly.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Password
        extends Layer
        implements Terminal {
            protected Validation validation;
            protected Text _text;

            public Password(Node node) {
                super(node);
            }

            public Mode mode() {
                return this._text.mode();
            }

            public String value() {
                return this._text.value();
            }

            public String prefix() {
                return this._text.prefix();
            }

            public String suffix() {
                return this._text.suffix();
            }

            public int cropWithEllipsis() {
                return this._text.cropWithEllipsis();
            }

            public boolean translate() {
                return this._text.translate();
            }

            public Password mode(Mode value) {
                this._text.mode(value);
                return this;
            }

            public Password value(String value) {
                this._text.value(value);
                return this;
            }

            public Password prefix(String value) {
                this._text.prefix(value);
                return this;
            }

            public Password suffix(String value) {
                this._text.suffix(value);
                return this;
            }

            public Password cropWithEllipsis(int value) {
                this._text.cropWithEllipsis(value);
                return this;
            }

            public Password translate(boolean value) {
                this._text.translate(value);
                return this;
            }

            public Validation validation() {
                return this.validation;
            }

            public List<Block> blockList() {
                return this._text.blockList();
            }

            public Block blockList(int index) {
                return this._text.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._text.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._text.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._text.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._text.notificationList().get(index);
            }

            public Text asText() {
                return (Text)this.a$(Text.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.validation != null) {
                    components.add(this.validation.core$());
                }
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("DataComponents$Text$Password$Validation")) {
                    this.validation = (Validation)node.as(Validation.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("DataComponents$Text$Password$Validation")) {
                    this.validation = null;
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Text) {
                    this._text = (Text)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Validation
            extends Layer
            implements Terminal {
                protected List<IsRequired> isRequired = new ArrayList<IsRequired>();
                protected Length length;

                public Validation(Node node) {
                    super(node);
                }

                public List<IsRequired> isRequired() {
                    return this.isRequired;
                }

                public Length length() {
                    return this.length;
                }

                protected List<Node> componentList$() {
                    LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                    if (this.length != null) {
                        components.add(this.length.core$());
                    }
                    return new ArrayList<Node>(components);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("isRequired", this.isRequired);
                    return map;
                }

                protected void addNode$(Node node) {
                    super.addNode$(node);
                    if (node.is("DataComponents$Text$Password$Validation$Length")) {
                        this.length = (Length)node.as(Length.class);
                    }
                }

                protected void removeNode$(Node node) {
                    super.removeNode$(node);
                    if (node.is("DataComponents$Text$Password$Validation$Length")) {
                        this.length = null;
                    }
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("isRequired")) {
                        this.isRequired = WordLoader.load(values, IsRequired.class, (Layer)this);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("isRequired")) {
                        this.isRequired = new ArrayList(values);
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public static class Length
                extends Layer
                implements Terminal {
                    protected int min;
                    protected int max;

                    public Length(Node node) {
                        super(node);
                    }

                    public int min() {
                        return this.min;
                    }

                    public int max() {
                        return this.max;
                    }

                    public Length min(int value) {
                        this.min = value;
                        return this;
                    }

                    public Length max(int value) {
                        this.max = value;
                        return this;
                    }

                    protected Map<String, List<?>> variables$() {
                        LinkedHashMap map = new LinkedHashMap();
                        map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
                        map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
                        return map;
                    }

                    protected void load$(String name, List<?> values) {
                        super.load$(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        }
                    }

                    protected void set$(String name, List<?> values) {
                        super.set$(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)values.get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)values.get(0);
                        }
                    }

                    public KonosGraph graph() {
                        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Length length(int min, int max) {
                        Length newElement = (Length)Validation.this.core$().graph().concept(Length.class).createNode(this.name, Validation.this.core$()).as(Length.class);
                        newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
                        newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
                        return newElement;
                    }
                }

                public static enum IsRequired {
                    Letter,
                    Number,
                    Symbol;

                }
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Password.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Password.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Password.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Validation validation() {
                    Validation newElement = (Validation)Password.this.core$().graph().concept(Validation.class).createNode(this.name, Password.this.core$()).as(Validation.class);
                    return newElement;
                }

                public Block block() {
                    Block newElement = (Block)Password.this.core$().graph().concept(Block.class).createNode(this.name, Password.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Password.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Password.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Password.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Password.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Memo
        extends Layer
        implements Terminal {
            protected EditionMode editionMode;
            protected int height;
            protected Text _text;

            public Memo(Node node) {
                super(node);
            }

            public EditionMode editionMode() {
                return this.editionMode;
            }

            public int height() {
                return this.height;
            }

            public Mode mode() {
                return this._text.mode();
            }

            public String value() {
                return this._text.value();
            }

            public String prefix() {
                return this._text.prefix();
            }

            public String suffix() {
                return this._text.suffix();
            }

            public int cropWithEllipsis() {
                return this._text.cropWithEllipsis();
            }

            public boolean translate() {
                return this._text.translate();
            }

            public Memo editionMode(EditionMode value) {
                this.editionMode = value;
                return this;
            }

            public Memo height(int value) {
                this.height = value;
                return this;
            }

            public Memo mode(Mode value) {
                this._text.mode(value);
                return this;
            }

            public Memo value(String value) {
                this._text.value(value);
                return this;
            }

            public Memo prefix(String value) {
                this._text.prefix(value);
                return this;
            }

            public Memo suffix(String value) {
                this._text.suffix(value);
                return this;
            }

            public Memo cropWithEllipsis(int value) {
                this._text.cropWithEllipsis(value);
                return this;
            }

            public Memo translate(boolean value) {
                this._text.translate(value);
                return this;
            }

            public List<Block> blockList() {
                return this._text.blockList();
            }

            public Block blockList(int index) {
                return this._text.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._text.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._text.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._text.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._text.notificationList().get(index);
            }

            public Text asText() {
                return (Text)this.a$(Text.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("editionMode", new ArrayList<EditionMode>(Collections.singletonList(this.editionMode)));
                map.put("height", new ArrayList<Integer>(Collections.singletonList(this.height)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("editionMode")) {
                    this.editionMode = (EditionMode)((Object)WordLoader.load(values, EditionMode.class, (Layer)this).get(0));
                } else if (name.equalsIgnoreCase("height")) {
                    this.height = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("editionMode")) {
                    this.editionMode = (EditionMode)((Object)values.get(0));
                } else if (name.equalsIgnoreCase("height")) {
                    this.height = (Integer)values.get(0);
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Text) {
                    this._text = (Text)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Memo.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Memo.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Memo.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Memo.this.core$().graph().concept(Block.class).createNode(this.name, Memo.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Memo.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Memo.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Memo.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Memo.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }

            public static enum EditionMode {
                Raw,
                Rich;

            }
        }

        public static class Editable
        extends io.intino.konos.model.graph.Editable
        implements Terminal {
            protected Edition edition;
            protected Validation validation;
            protected Text _text;

            public Editable(Node node) {
                super(node);
            }

            public Edition edition() {
                return this.edition;
            }

            public Mode mode() {
                return this._text.mode();
            }

            public String value() {
                return this._text.value();
            }

            public String prefix() {
                return this._text.prefix();
            }

            public String suffix() {
                return this._text.suffix();
            }

            public int cropWithEllipsis() {
                return this._text.cropWithEllipsis();
            }

            public boolean translate() {
                return this._text.translate();
            }

            public Editable edition(Edition value) {
                this.edition = value;
                return this;
            }

            public Editable mode(Mode value) {
                this._text.mode(value);
                return this;
            }

            public Editable value(String value) {
                this._text.value(value);
                return this;
            }

            public Editable prefix(String value) {
                this._text.prefix(value);
                return this;
            }

            public Editable suffix(String value) {
                this._text.suffix(value);
                return this;
            }

            public Editable cropWithEllipsis(int value) {
                this._text.cropWithEllipsis(value);
                return this;
            }

            public Editable translate(boolean value) {
                this._text.translate(value);
                return this;
            }

            public Validation validation() {
                return this.validation;
            }

            public List<Block> blockList() {
                return this._text.blockList();
            }

            public Block blockList(int index) {
                return this._text.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._text.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._text.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._text.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._text.notificationList().get(index);
            }

            public Text asText() {
                return (Text)this.a$(Text.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.validation != null) {
                    components.add(this.validation.core$());
                }
                return new ArrayList<Node>(components);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                map.put("edition", new ArrayList<Edition>(Collections.singletonList(this.edition)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("DataComponents$Text$Editable$Validation")) {
                    this.validation = (Validation)node.as(Validation.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("DataComponents$Text$Editable$Validation")) {
                    this.validation = null;
                }
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("edition")) {
                    this.edition = (Edition)((Object)WordLoader.load(values, Edition.class, (Layer)this).get(0));
                }
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("edition")) {
                    this.edition = (Edition)((Object)values.get(0));
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Text) {
                    this._text = (Text)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Validation
            extends Layer
            implements Terminal {
                protected List<String> allowedValues = new ArrayList<String>();
                protected List<String> disallowedValues = new ArrayList<String>();
                protected boolean disallowEmptySpaces;
                protected Length length;

                public Validation(Node node) {
                    super(node);
                }

                public List<String> allowedValues() {
                    return this.allowedValues;
                }

                public String allowedValues(int index) {
                    return this.allowedValues.get(index);
                }

                public List<String> allowedValues(Predicate<String> predicate) {
                    return this.allowedValues().stream().filter(predicate).collect(Collectors.toList());
                }

                public List<String> disallowedValues() {
                    return this.disallowedValues;
                }

                public String disallowedValues(int index) {
                    return this.disallowedValues.get(index);
                }

                public List<String> disallowedValues(Predicate<String> predicate) {
                    return this.disallowedValues().stream().filter(predicate).collect(Collectors.toList());
                }

                public boolean disallowEmptySpaces() {
                    return this.disallowEmptySpaces;
                }

                public Validation disallowEmptySpaces(boolean value) {
                    this.disallowEmptySpaces = value;
                    return this;
                }

                public Length length() {
                    return this.length;
                }

                protected List<Node> componentList$() {
                    LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                    if (this.length != null) {
                        components.add(this.length.core$());
                    }
                    return new ArrayList<Node>(components);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("allowedValues", this.allowedValues);
                    map.put("disallowedValues", this.disallowedValues);
                    map.put("disallowEmptySpaces", new ArrayList<Boolean>(Collections.singletonList(this.disallowEmptySpaces)));
                    return map;
                }

                protected void addNode$(Node node) {
                    super.addNode$(node);
                    if (node.is("DataComponents$Text$Editable$Validation$Length")) {
                        this.length = (Length)node.as(Length.class);
                    }
                }

                protected void removeNode$(Node node) {
                    super.removeNode$(node);
                    if (node.is("DataComponents$Text$Editable$Validation$Length")) {
                        this.length = null;
                    }
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("allowedValues")) {
                        this.allowedValues = StringLoader.load(values, (Layer)this);
                    } else if (name.equalsIgnoreCase("disallowedValues")) {
                        this.disallowedValues = StringLoader.load(values, (Layer)this);
                    } else if (name.equalsIgnoreCase("disallowEmptySpaces")) {
                        this.disallowEmptySpaces = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("allowedValues")) {
                        this.allowedValues = new ArrayList(values);
                    } else if (name.equalsIgnoreCase("disallowedValues")) {
                        this.disallowedValues = new ArrayList(values);
                    } else if (name.equalsIgnoreCase("disallowEmptySpaces")) {
                        this.disallowEmptySpaces = (Boolean)values.get(0);
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public static class Length
                extends Layer
                implements Terminal {
                    protected int min;
                    protected int max;

                    public Length(Node node) {
                        super(node);
                    }

                    public int min() {
                        return this.min;
                    }

                    public int max() {
                        return this.max;
                    }

                    public Length min(int value) {
                        this.min = value;
                        return this;
                    }

                    public Length max(int value) {
                        this.max = value;
                        return this;
                    }

                    protected Map<String, List<?>> variables$() {
                        LinkedHashMap map = new LinkedHashMap();
                        map.put("min", new ArrayList<Integer>(Collections.singletonList(this.min)));
                        map.put("max", new ArrayList<Integer>(Collections.singletonList(this.max)));
                        return map;
                    }

                    protected void load$(String name, List<?> values) {
                        super.load$(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)IntegerLoader.load(values, (Layer)this).get(0);
                        }
                    }

                    protected void set$(String name, List<?> values) {
                        super.set$(name, values);
                        if (name.equalsIgnoreCase("min")) {
                            this.min = (Integer)values.get(0);
                        } else if (name.equalsIgnoreCase("max")) {
                            this.max = (Integer)values.get(0);
                        }
                    }

                    public KonosGraph graph() {
                        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Length length(int min, int max) {
                        Length newElement = (Length)Validation.this.core$().graph().concept(Length.class).createNode(this.name, Validation.this.core$()).as(Length.class);
                        newElement.core$().set((Layer)newElement, "min", Collections.singletonList(min));
                        newElement.core$().set((Layer)newElement, "max", Collections.singletonList(max));
                        return newElement;
                    }
                }
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Editable.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Editable.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Editable.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Editable$Create {
                public Create(String name) {
                    super(name);
                }

                public Validation validation() {
                    Validation newElement = (Validation)Editable.this.core$().graph().concept(Validation.class).createNode(this.name, Editable.this.core$()).as(Validation.class);
                    return newElement;
                }

                public Block block() {
                    Block newElement = (Block)Editable.this.core$().graph().concept(Block.class).createNode(this.name, Editable.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Editable.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Editable.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Editable.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }

            public static enum Edition {
                Normal,
                Email,
                Url;

            }
        }

        public static class Code
        extends Layer
        implements Terminal {
            protected CodeLanguage language;
            protected Text _text;

            public Code(Node node) {
                super(node);
            }

            public CodeLanguage language() {
                return this.language;
            }

            public Mode mode() {
                return this._text.mode();
            }

            public String value() {
                return this._text.value();
            }

            public String prefix() {
                return this._text.prefix();
            }

            public String suffix() {
                return this._text.suffix();
            }

            public int cropWithEllipsis() {
                return this._text.cropWithEllipsis();
            }

            public boolean translate() {
                return this._text.translate();
            }

            public Code language(CodeLanguage value) {
                this.language = value;
                return this;
            }

            public Code mode(Mode value) {
                this._text.mode(value);
                return this;
            }

            public Code value(String value) {
                this._text.value(value);
                return this;
            }

            public Code prefix(String value) {
                this._text.prefix(value);
                return this;
            }

            public Code suffix(String value) {
                this._text.suffix(value);
                return this;
            }

            public Code cropWithEllipsis(int value) {
                this._text.cropWithEllipsis(value);
                return this;
            }

            public Code translate(boolean value) {
                this._text.translate(value);
                return this;
            }

            public List<Block> blockList() {
                return this._text.blockList();
            }

            public Block blockList(int index) {
                return this._text.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._text.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._text.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._text.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._text.notificationList().get(index);
            }

            public Text asText() {
                return (Text)this.a$(Text.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("language", new ArrayList<CodeLanguage>(Collections.singletonList(this.language)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("language")) {
                    this.language = (CodeLanguage)((Object)WordLoader.load(values, CodeLanguage.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("language")) {
                    this.language = (CodeLanguage)((Object)values.get(0));
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Text) {
                    this._text = (Text)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Code.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Code.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Code.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Code.this.core$().graph().concept(Block.class).createNode(this.name, Code.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Code.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Code.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Code.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Code.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Highlighted
        extends Layer
        implements Terminal {
            protected String textColor;
            protected String backgroundColor;
            protected Text _text;

            public Highlighted(Node node) {
                super(node);
            }

            public String textColor() {
                return this.textColor;
            }

            public String backgroundColor() {
                return this.backgroundColor;
            }

            public Mode mode() {
                return this._text.mode();
            }

            public String value() {
                return this._text.value();
            }

            public String prefix() {
                return this._text.prefix();
            }

            public String suffix() {
                return this._text.suffix();
            }

            public int cropWithEllipsis() {
                return this._text.cropWithEllipsis();
            }

            public boolean translate() {
                return this._text.translate();
            }

            public Highlighted textColor(String value) {
                this.textColor = value;
                return this;
            }

            public Highlighted backgroundColor(String value) {
                this.backgroundColor = value;
                return this;
            }

            public Highlighted mode(Mode value) {
                this._text.mode(value);
                return this;
            }

            public Highlighted value(String value) {
                this._text.value(value);
                return this;
            }

            public Highlighted prefix(String value) {
                this._text.prefix(value);
                return this;
            }

            public Highlighted suffix(String value) {
                this._text.suffix(value);
                return this;
            }

            public Highlighted cropWithEllipsis(int value) {
                this._text.cropWithEllipsis(value);
                return this;
            }

            public Highlighted translate(boolean value) {
                this._text.translate(value);
                return this;
            }

            public List<Block> blockList() {
                return this._text.blockList();
            }

            public Block blockList(int index) {
                return this._text.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._text.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._text.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._text.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._text.notificationList().get(index);
            }

            public Text asText() {
                return (Text)this.a$(Text.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("textColor", new ArrayList<String>(Collections.singletonList(this.textColor)));
                map.put("backgroundColor", new ArrayList<String>(Collections.singletonList(this.backgroundColor)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("textColor")) {
                    this.textColor = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("backgroundColor")) {
                    this.backgroundColor = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("textColor")) {
                    this.textColor = (String)values.get(0);
                } else if (name.equalsIgnoreCase("backgroundColor")) {
                    this.backgroundColor = (String)values.get(0);
                }
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Text) {
                    this._text = (Text)layer;
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Highlighted.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Highlighted.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Highlighted.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Block block() {
                    Block newElement = (Block)Highlighted.this.core$().graph().concept(Block.class).createNode(this.name, Highlighted.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Highlighted.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Highlighted.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Highlighted.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Highlighted.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public static class Multiple
        extends io.intino.konos.model.graph.Multiple
        implements Terminal {
            protected Text _text;

            public Multiple(Node node) {
                super(node);
            }

            public Mode mode() {
                return this._text.mode();
            }

            public String value() {
                return this._text.value();
            }

            public String prefix() {
                return this._text.prefix();
            }

            public String suffix() {
                return this._text.suffix();
            }

            public int cropWithEllipsis() {
                return this._text.cropWithEllipsis();
            }

            public boolean translate() {
                return this._text.translate();
            }

            public Multiple mode(Mode value) {
                this._text.mode(value);
                return this;
            }

            public Multiple value(String value) {
                this._text.value(value);
                return this;
            }

            public Multiple prefix(String value) {
                this._text.prefix(value);
                return this;
            }

            public Multiple suffix(String value) {
                this._text.suffix(value);
                return this;
            }

            public Multiple cropWithEllipsis(int value) {
                this._text.cropWithEllipsis(value);
                return this;
            }

            public Multiple translate(boolean value) {
                this._text.translate(value);
                return this;
            }

            public List<Block> blockList() {
                return this._text.blockList();
            }

            public Block blockList(int index) {
                return this._text.blockList().get(index);
            }

            public List<PassiveView.Request> requestList() {
                return this._text.requestList();
            }

            public PassiveView.Request requestList(int index) {
                return this._text.requestList().get(index);
            }

            public List<PassiveView.Notification> notificationList() {
                return this._text.notificationList();
            }

            public PassiveView.Notification notificationList(int index) {
                return this._text.notificationList().get(index);
            }

            public Text asText() {
                return (Text)this.a$(Text.class);
            }

            @Override
            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap(super.variables$());
                return map;
            }

            @Override
            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            @Override
            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            protected void sync$(Layer layer) {
                super.sync$(layer);
                if (layer instanceof Text) {
                    this._text = (Text)layer;
                }
            }

            @Override
            public Create create() {
                return new Create(null);
            }

            @Override
            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            @Override
            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void block(Predicate<Block> filter) {
                    new ArrayList<Block>(Multiple.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<PassiveView.Request> filter) {
                    new ArrayList<PassiveView.Request>(Multiple.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void notification(Predicate<PassiveView.Notification> filter) {
                    new ArrayList<PassiveView.Notification>(Multiple.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create
            extends io.intino.konos.model.graph.Multiple$Create {
                public Create(String name) {
                    super(name);
                }

                public Block block() {
                    Block newElement = (Block)Multiple.this.core$().graph().concept(Block.class).createNode(this.name, Multiple.this.core$()).as(Block.class);
                    return newElement;
                }

                public PassiveView.Request request() {
                    PassiveView.Request newElement = (PassiveView.Request)Multiple.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Request.class);
                    return newElement;
                }

                public PassiveView.Notification notification() {
                    PassiveView.Notification newElement = (PassiveView.Notification)Multiple.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Multiple.this.core$()).as(PassiveView.Notification.class);
                    return newElement;
                }
            }
        }

        public class Clear
        extends Component.Clear {
        }

        public class Create
        extends Component.Create {
            public Create(String name) {
                super(name);
            }
        }

        public static enum Mode {
            Uppercase,
            Lowercase,
            Capitalize,
            Normal;

        }
    }

    public class Clear {
        public void text(Predicate<Text> filter) {
            new ArrayList<Text>(DataComponents.this.textList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void file(Predicate<File> filter) {
            new ArrayList<File>(DataComponents.this.fileList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void image(Predicate<Image> filter) {
            new ArrayList<Image>(DataComponents.this.imageList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void number(Predicate<Number> filter) {
            new ArrayList<Number>(DataComponents.this.numberList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void date(Predicate<Date> filter) {
            new ArrayList<Date>(DataComponents.this.dateList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void location(Predicate<Location> filter) {
            new ArrayList<Location>(DataComponents.this.locationList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Text text() {
            Text newElement = (Text)DataComponents.this.core$().graph().concept(Text.class).createNode(this.name, DataComponents.this.core$()).as(Text.class);
            return newElement;
        }

        public File file() {
            File newElement = (File)DataComponents.this.core$().graph().concept(File.class).createNode(this.name, DataComponents.this.core$()).as(File.class);
            return newElement;
        }

        public Image image() {
            Image newElement = (Image)DataComponents.this.core$().graph().concept(Image.class).createNode(this.name, DataComponents.this.core$()).as(Image.class);
            return newElement;
        }

        public Number number() {
            Number newElement = (Number)DataComponents.this.core$().graph().concept(Number.class).createNode(this.name, DataComponents.this.core$()).as(Number.class);
            return newElement;
        }

        public Date date() {
            Date newElement = (Date)DataComponents.this.core$().graph().concept(Date.class).createNode(this.name, DataComponents.this.core$()).as(Date.class);
            return newElement;
        }

        public Location location() {
            Location newElement = (Location)DataComponents.this.core$().graph().concept(Location.class).createNode(this.name, DataComponents.this.core$()).as(Location.class);
            return newElement;
        }
    }
}

