/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.services.messaging;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class MessagingServiceTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("jms"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(";\n\nimport io.intino.alexandria.message.MessageHub;\nimport io.intino.alexandria.logger.Logger;\n\nimport java.io.ByteArrayOutputStream;\nimport java.io.IOException;\nimport java.io.InputStream;\n")}).output(new Rule.Output[]{this.mark("schemaImport", new String[0])}).output(new Rule.Output[]{this.literal("\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Service {\n\tprivate final ")}).output(new Rule.Output[]{this.mark("box", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box;\n\tprivate final ")}).output(new Rule.Output[]{this.mark("box", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Configuration configuration;\n\tprivate final MessageHub messageHub;\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Service(MessageHub messageHub, ")}).output(new Rule.Output[]{this.mark("box", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box) {\n\t\tthis.box = box;\n\t\tthis.configuration = box.configuration();\n\t\tthis.messageHub = messageHub;\n\t\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("registerProcessListener()")}).output(new Rule.Output[]{this.mark("hasProcess", new String[0])})}).output(new Rule.Output[]{this.literal("\n\t\t")}).output(new Rule.Output[]{this.mark("request", new String[0]).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tprivate void registerProcessListener() {\n\t\tmessageHub.attachListener(\"Task\", \"")}).output(new Rule.Output[]{this.mark("box", new String[]{"lowercase-task"})}).output(new Rule.Output[]{this.literal("\", message -> {\n\t\t\tString name = message.get(\"name\").data();\n\t\t\t")}).output(new Rule.Output[]{this.mark("request", new String[]{"processlistener"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t});\n\t\tmessageHub.attachListener(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("businessUnit", new String[0])}).output(new Rule.Output[]{this.literal(".\" +")})}).output(new Rule.Output[]{this.literal(" io.intino.alexandria.bpm.Workflow.EventType, message -> {\n\t\t\tio.intino.alexandria.bpm.ProcessStatus status = new io.intino.alexandria.bpm.ProcessStatus(message);\n\t\t\tif (!status.hasCallback()) return;\n\t\t\tString callback = message.get(\"callback\").data();\n\t\t\tObject data = dispatcher(status.processName()).onResponse();\n\t\t\tio.intino.alexandria.message.Message result = new io.intino.alexandria.message.Message(callback.substring(callback.lastIndexOf(\".\") + 1))\n\t\t\t\t.set(\"callbackProcess\", status.callbackProcess())\n\t\t\t\t.set(\"callbackState\", status.callbackState())\n\t\t\t\t.set(\"data\", io.intino.alexandria.Json.toString(data));\n\t\t\tmessageHub.sendMessage(callback, result);\n\t\t});\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("notification", new String[0]).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\tprivate InboxDispatcher dispatcher(String name) {\n\t\t")}).output(new Rule.Output[]{this.mark("request", new String[]{"processSelect"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\treturn null;\n\t}\n\n\tpublic interface InboxDispatcher<Response> {\n\t\tResponse onResponse();\n\t}\n}")}), this.rule().condition(this.type("process"), new Rule.Condition[]{this.trigger("processlistener")}).output(new Rule.Output[]{this.literal("if (name.equalsIgnoreCase(\"")}).output(new Rule.Output[]{this.mark("process", new String[0])}).output(new Rule.Output[]{this.literal("\")) {\n\tString callbackData = message.get(\"callback\").data();\n\tio.intino.alexandria.bpm.Callback callback = io.intino.alexandria.bpm.Callback.from(callbackData);\n\tnew ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".actions.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Action(box).onRequest(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal("io.intino.alexandria.Json.fromString(message.get(\"data\").data(), ")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"type"})}).output(new Rule.Output[]{this.literal(".class)")})}).output(new Rule.Output[]{this.literal(");\n\tmessageHub.sendMessage(\"")}).output(new Rule.Output[]{this.mark("businessUnit", new String[0])}).output(new Rule.Output[]{this.literal(".\" + io.intino.alexandria.bpm.Workflow.EventType, new io.intino.alexandria.bpm.ProcessStatus(java.util.UUID.randomUUID().toString(), \"")}).output(new Rule.Output[]{this.mark("process", new String[0])}).output(new Rule.Output[]{this.literal("\", io.intino.alexandria.bpm.Process.Status.Enter, message.get(\"owner\").data(), callback.requesterId(), callback.requesterState()).message().set(\"callback\", callback.value()));\n}")}), this.rule().condition(this.not(this.type("process")), new Rule.Condition[]{this.trigger("processlistener")}), this.rule().condition(this.type("process"), new Rule.Condition[]{this.trigger("processselect")}).output(new Rule.Output[]{this.literal("if (name.equalsIgnoreCase(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\")) return new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".actions.")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("Action(box);")}), this.rule().condition(this.not(this.type("process")), new Rule.Condition[]{this.trigger("processselect")}), this.rule().condition(this.not(this.type("process")), new Rule.Condition[]{this.type("request")}).output(new Rule.Output[]{this.literal("messageHub.attachRequestListener(")}).output(new Rule.Output[]{this.mark("queue", new String[]{"format"})}).output(new Rule.Output[]{this.literal(", m -> new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".requests.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Request(box).execute());")}), this.rule().condition(this.type("notification"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public void notify")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("parameter", new String[]{"signature"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(") throws JMSException {//TODO\n\tfinal ")}).output(new Rule.Output[]{this.mark("returnMessageType", new String[0])}).output(new Rule.Output[]{this.literal("Message message = session.create")}).output(new Rule.Output[]{this.mark("returnMessageType", new String[0])}).output(new Rule.Output[]{this.literal("Message();\n\tfill")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Message(message")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"name"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(");\n\tnew ")}).output(new Rule.Output[]{this.mark("model", new String[0])}).output(new Rule.Output[]{this.literal("Producer(session, ")}).output(new Rule.Output[]{this.mark("queue", new String[]{"format"})}).output(new Rule.Output[]{this.literal(").produce(message);\n}\n\nprivate void fill")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Message(")}).output(new Rule.Output[]{this.mark("returnMessageType", new String[0])}).output(new Rule.Output[]{this.literal("Message message")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(", ")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"signature"}).multiple(", ")})}).output(new Rule.Output[]{this.literal(") throws JMSException {\n\t")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"assign"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n}")}), this.rule().condition(this.type("queue"), new Rule.Condition[]{this.trigger("format")}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\"")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("custom", new String[0]).multiple("")})}), this.rule().condition(this.trigger("custom"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal(".replace(\"{")}).output(new Rule.Output[]{this.mark("value", new String[0])}).output(new Rule.Output[]{this.literal("}\", configuration.get(\"")}).output(new Rule.Output[]{this.mark("value", new String[0])}).output(new Rule.Output[]{this.literal("\"))")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("type")}).output(new Rule.Output[]{this.mark("type", new String[]{"formatted"})}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("name")}).output(new Rule.Output[]{this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("signature")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"SnakeCaseToCamelCase", "firstLowerCase"})}), this.rule().condition(this.allTypes(new String[]{"parameter", "fileData"}), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("message.writeBytes(toByteArray(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("));")}), this.rule().condition(this.allTypes(new String[]{"parameter", "objectData"}), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("message.setText(new Gson().toJson(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("));")}), this.rule().condition(this.type("parameter"), new Rule.Condition[]{this.trigger("assign")}).output(new Rule.Output[]{this.literal("message.set")}).output(new Rule.Output[]{this.mark("type", new String[]{"formatted"})}).output(new Rule.Output[]{this.literal("Property(\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\", ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(");")}), this.rule().condition(this.attribute("integer"), new Rule.Condition[]{this.trigger("formatted")}).output(new Rule.Output[]{this.literal("Int")}), this.rule().condition(this.type("schemaImport"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("import ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".schemas.*;")})});
    }
}

