/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.helpers;

import io.intino.konos.builder.codegeneration.ElementReference;
import io.intino.konos.model.graph.InteractionComponents;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ElementHelper {
    private static Map<Layer, String> typeMap = new HashMap<Layer, String>();

    public String shortId(Layer element) {
        return this.shortId(element, "");
    }

    public String shortId(Layer element, String suffix) {
        String name = this.nameOf(element);
        if (this.isNamed(name)) {
            if (!ElementHelper.isRoot(element.core$())) {
                name = this.generatedName(element, name);
            }
        } else {
            name = this.generatedName(element, name);
        }
        return name + suffix;
    }

    private String generatedName(Layer element, String name) {
        return ("a" + (this.anonymousOwner(element) + "_" + name).hashCode()).replace("-", "_");
    }

    public String nameOf(Layer element) {
        return element.name$();
    }

    private String anonymousOwner(Layer element) {
        Node owner;
        StringBuilder name = new StringBuilder();
        for (owner = element.core$().owner(); owner != null && this.isNamed(owner.name()); owner = owner.owner()) {
            name.insert(0, owner.name() + "_");
        }
        if (owner != null) {
            name.insert(0, this.withOutHashCode(owner.name()) + "_");
        }
        String id = name.toString();
        return id.substring(0, id.length() - 1);
    }

    private String withOutHashCode(String name) {
        return name.substring(0, name.lastIndexOf("_"));
    }

    private boolean isNamed(String name) {
        if (!name.contains("_")) {
            return true;
        }
        String[] s = name.split("_");
        return s.length != 4;
    }

    public String nameOf(String id) {
        return Predicate.nameOf((String)id);
    }

    public String typeOf(Layer element) {
        if (!typeMap.containsKey(element)) {
            String type = element.i$(InteractionComponents.Actionable.class) ? this.typeOfActionable((InteractionComponents.Actionable)element.a$(InteractionComponents.Actionable.class)) : element.getClass().getSimpleName();
            typeMap.put(element, type);
        }
        return typeMap.get(element);
    }

    private String typeOfActionable(InteractionComponents.Actionable actionable) {
        String context;
        Object result = InteractionComponents.Actionable.Action.class.getSimpleName();
        if (actionable.isAction()) {
            context = actionable.asAction().context() == InteractionComponents.Actionable.Action.Context.Selection ? "Selection" : "";
            result = context + InteractionComponents.Actionable.Action.class.getSimpleName();
        }
        if (actionable.isOpenDrawer()) {
            result = InteractionComponents.Actionable.OpenDrawer.class.getSimpleName();
        }
        if (actionable.isCloseDrawer()) {
            result = InteractionComponents.Actionable.CloseDrawer.class.getSimpleName();
        }
        if (actionable.isOpenPage()) {
            result = InteractionComponents.Actionable.OpenPage.class.getSimpleName();
        }
        if (actionable.isOpenSite()) {
            result = InteractionComponents.Actionable.OpenSite.class.getSimpleName();
        }
        if (actionable.isOpenBlock()) {
            result = InteractionComponents.Actionable.OpenBlock.class.getSimpleName();
        }
        if (actionable.isOpenDialog()) {
            result = InteractionComponents.Actionable.OpenDialog.class.getSimpleName();
        }
        if (actionable.isCloseDialog()) {
            result = InteractionComponents.Actionable.CloseDialog.class.getSimpleName();
        }
        if (actionable.isExport()) {
            result = InteractionComponents.Actionable.Export.class.getSimpleName();
        }
        if (actionable.isDownload()) {
            context = actionable.asDownload().context() == InteractionComponents.Actionable.Download.Context.Selection ? "Selection" : "";
            result = InteractionComponents.Actionable.Download.class.getSimpleName() + context;
        }
        return result;
    }

    public String ownerId(Layer element) {
        ArrayList<String> result = new ArrayList<String>();
        for (Node owner = element.core$().owner(); owner != null; owner = owner.owner()) {
            result.add(this.shortId(owner.as(Layer.class)));
        }
        Collections.reverse(result);
        return String.join((CharSequence)".", result);
    }

    public ElementReference referenceOf(Layer element) {
        return ElementReference.of(this.nameOf(element), this.typeOf(element), ElementReference.Context.from(element));
    }

    private String generateName(Layer element) {
        return this.generateName(element.core$(), "");
    }

    private String generateName(Node element, String name) {
        Node owner = element.owner();
        if (ElementHelper.isRoot(owner)) {
            return owner.name() + this.position(element, owner);
        }
        return this.generateName(owner, name) + this.position(element, owner);
    }

    private String rootNameOf(Layer element) {
        return element.core$().rootNodeId();
    }

    private int position(Node element, Node owner) {
        List children = owner.componentList();
        for (int pos = 0; pos < children.size(); ++pos) {
            if (!((Node)children.get(pos)).id().equals(element.id())) continue;
            return pos;
        }
        return -1;
    }

    public static boolean isRoot(Layer element) {
        return ElementHelper.isRoot(element.core$());
    }

    private static boolean isRoot(Node node) {
        return node.owner() == null || node.owner() == node.model();
    }
}

