/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.components.ComponentRendererFactory;
import io.intino.konos.builder.codegeneration.ui.passiveview.PassiveViewRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.CatalogComponents;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.HelperComponents;
import io.intino.konos.model.graph.InteractionComponents;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.OtherComponents;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.Template;

public abstract class BaseDisplayRenderer<D extends Display>
extends PassiveViewRenderer<D> {
    private static final ComponentRendererFactory factory = new ComponentRendererFactory();

    protected BaseDisplayRenderer(CompilationContext context, D display, TemplateProvider templateProvider, Target target) {
        super(context, display, templateProvider, target);
    }

    @Override
    public void render() {
        if (this.element == null) {
            return;
        }
        String path = this.path((Display)this.element);
        String newDisplay = StringHelper.snakeCaseToCamelCase((String)((Display)this.element).name$());
        this.classes().put("Display#" + ((Display)this.element).name$(), path + "." + newDisplay);
        FrameBuilder result = this.buildFrame();
        this.createPassiveViewFiles(result);
        this.write(result);
        if (((Display)this.element).isAccessible()) {
            this.writeDisplaysFor(((Display)this.element).asAccessible(), this.buildFrame(true));
        }
    }

    @Override
    public FrameBuilder buildFrame() {
        return this.buildFrame(false);
    }

    @Override
    public FrameBuilder buildFrame(boolean accessible) {
        FrameBuilder result = super.buildFrame(accessible);
        result.add("display");
        result.add(this.typeOf(this.element));
        if (accessible) {
            result.add("accessible");
        }
        this.addParametrized(result);
        this.addExtends(result);
        this.addImports(result, accessible);
        this.addImplements(result);
        this.addMethods(result);
        this.addRenderTagFrames(result);
        this.addDecoratedFrames(result);
        result.add("componentType", ((Display)this.element).components().stream().map(this::typeOf).distinct().map(type -> new FrameBuilder().add("componentType", type).toFrame()).toArray(Frame[]::new));
        if (((Display)this.element).parentDisplay() != null) {
            this.addParent((Display)this.element, result);
        }
        if (!((Display)this.element).graph().schemaList().isEmpty()) {
            result.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()));
        }
        if (((Display)this.element).isAccessible()) {
            result.add("parameter", ((Display)this.element).asAccessible().parameters().stream().map(p -> new FrameBuilder(new String[]{"parameter", "accessible"}).add("value", p).toFrame()).toArray(Frame[]::new));
        }
        return result;
    }

    private void addParametrized(FrameBuilder frame) {
        FrameBuilder result = new FrameBuilder(new String[]{"parametrized"});
        result.add("name", (Object)((Display)this.element).name$());
        this.addGeneric((PassiveView)this.element, result);
        this.addDecoratedFrames(result);
        frame.add("parametrized", (Object)result.toFrame());
    }

    private void addExtends(FrameBuilder frame) {
        String itemClass;
        FrameBuilder result = new FrameBuilder(new String[]{"displayExtends"});
        if (((Display)this.element).i$(OtherComponents.Dialog.class)) {
            result.add(OtherComponents.Dialog.class.getSimpleName());
        }
        if (((Display)this.element).i$(Template.class)) {
            result.add(Template.class.getSimpleName());
        }
        if (((Display)this.element).i$(CatalogComponents.Collection.Mold.Item.class)) {
            result.add(CatalogComponents.Collection.Mold.Item.class.getSimpleName());
        }
        if (((Display)this.element).i$(HelperComponents.Row.class)) {
            result.add(HelperComponents.Row.class.getSimpleName());
        }
        this.addGeneric((PassiveView)this.element, result);
        result.add("type", (Object)this.typeOf(this.element));
        this.addDecoratedFrames(result);
        if (((Display)this.element).i$(Template.class)) {
            String modelClass = ((Template)((Display)this.element).a$(Template.class)).modelClass();
            result.add("modelClass", (Object)(modelClass != null ? modelClass : "java.lang.Void"));
        }
        if (((Display)this.element).i$(CatalogComponents.Collection.Mold.Item.class)) {
            itemClass = ((CatalogComponents.Collection)((CatalogComponents.Collection.Mold.Item)((Display)this.element).a$(CatalogComponents.Collection.Mold.Item.class)).core$().ownerAs(CatalogComponents.Collection.class)).itemClass();
            result.add("itemClass", (Object)(itemClass != null ? itemClass : "java.lang.Void"));
        }
        if (((Display)this.element).i$(HelperComponents.Row.class)) {
            itemClass = ((CatalogComponents.Collection)((HelperComponents.Row)((Display)this.element).a$(HelperComponents.Row.class)).items(0).core$().ownerAs(CatalogComponents.Collection.class)).itemClass();
            result.add("itemClass", (Object)(itemClass != null ? itemClass : "java.lang.Void"));
        }
        result.add("name", (Object)this.nameOf(this.element));
        frame.add("displayExtends", (Object)result);
    }

    private void addImports(FrameBuilder frame, boolean accessible) {
        KonosGraph graph = ((Display)this.element).graph();
        if (graph.templateList().size() > 0) {
            frame.add("templatesImport", (Object)this.buildBaseFrame().add("templatesImport"));
        }
        if (graph.blockList().size() > 0) {
            frame.add("blocksImport", (Object)this.buildBaseFrame().add("blocksImport"));
        }
        if (graph.itemsDisplays(this.context.graphName()).size() > 0) {
            frame.add("itemsImport", (Object)this.buildBaseFrame().add("itemsImport"));
        }
        if (graph.rowsDisplays(this.context.graphName()).size() > 0) {
            frame.add("rowsImport", (Object)this.buildBaseFrame().add("rowsImport"));
        }
        if (!ElementHelper.isRoot(this.componentOf((PassiveView)this.element)) || ((Display)this.element).isAccessible() && accessible) {
            frame.add("displayRegistration", (Object)this.displayRegistrationFrame(accessible));
        }
        frame.add("requesterDirectory", (Object)(this.typeOf(this.element).equalsIgnoreCase("Display") || this.typeOf(this.element).equalsIgnoreCase("Display") ? "." : ".."));
        frame.add("notifierDirectory", (Object)(this.typeOf(this.element).equalsIgnoreCase("Display") ? "." : ".."));
    }

    private FrameBuilder displayRegistrationFrame(boolean accessible) {
        FrameBuilder result = this.buildBaseFrame().add("displayRegistration");
        if (((Display)this.element).isAccessible() && accessible) {
            result.add("accessible");
        }
        return result.add("name", (Object)this.nameOf(this.element));
    }

    protected void addImplements(FrameBuilder frame) {
        if (((Display)this.element).i$(Component.DynamicLoaded.class)) {
            frame.add("implements", (Object)new FrameBuilder(new String[]{"implements", Component.DynamicLoaded.class.getSimpleName()}));
        }
        if (((Display)this.element).i$(CatalogComponents.Collection.Selectable.class)) {
            frame.add("implements", (Object)new FrameBuilder(new String[]{"implements", CatalogComponents.Collection.Selectable.class.getSimpleName()}));
        }
        if (((Display)this.element).i$(InteractionComponents.Actionable.Action.class) && ((Display)this.element).i$(InteractionComponents.Actionable.Addressable.class)) {
            frame.add("implements", (Object)new FrameBuilder(new String[]{"implements", InteractionComponents.Actionable.Action.class.getSimpleName(), InteractionComponents.Actionable.Addressable.class.getSimpleName()}).add("name", (Object)this.nameOf(this.element)));
        }
        if (((Display)this.element).i$(OtherComponents.Selector.Addressable.class)) {
            frame.add("implements", (Object)new FrameBuilder(new String[]{"implements", OtherComponents.Selector.class.getSimpleName(), OtherComponents.Selector.Addressable.class.getSimpleName()}).add("name", (Object)this.nameOf(this.element)));
        }
    }

    protected void addMethods(FrameBuilder frame) {
        if (((Display)this.element).i$(Component.DynamicLoaded.class)) {
            frame.add("baseMethod", (Object)"renderDynamicLoaded");
            frame.add("methods", (Object)new FrameBuilder(new String[]{"methods", Component.DynamicLoaded.class.getSimpleName()}).add("loadTime", (Object)((Component.DynamicLoaded)((Display)this.element).a$(Component.DynamicLoaded.class)).loadTime().name()));
        } else if (((Display)this.element).i$(OtherComponents.Dialog.class)) {
            frame.add("baseMethod", (Object)"renderDialog");
        } else if (((Display)this.element).i$(HelperComponents.Row.class)) {
            frame.add("baseMethod", (Object)"renderRow");
        }
    }

    protected void addRenderTagFrames(FrameBuilder frame) {
        FrameBuilder renderTag = new FrameBuilder(new String[]{"renderTag"});
        if (((Display)this.element).i$(Block.class)) {
            ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.context, (Component)((Display)this.element).a$(Block.class), this.templateProvider, this.target);
            renderTag.add(Block.class.getSimpleName());
            renderTag.add("properties", (Object)renderer.properties());
        } else if (((Display)this.element).i$(Template.class)) {
            ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.context, (Component)((Display)this.element).a$(Template.class), this.templateProvider, this.target);
            renderTag.add(Template.class.getSimpleName());
            renderTag.add("properties", (Object)renderer.properties());
        } else if (((Display)this.element).i$(HelperComponents.Row.class)) {
            ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.context, (Component)((Display)this.element).a$(HelperComponents.Row.class), this.templateProvider, this.target);
            renderTag.add(HelperComponents.Row.class.getSimpleName());
            renderTag.add("properties", (Object)renderer.properties());
        } else if (((Display)this.element).i$(CatalogComponents.Collection.Mold.Item.class)) {
            renderTag.add(CatalogComponents.Collection.Mold.Item.class.getSimpleName());
        }
        frame.add("renderTag", (Object)renderTag);
    }

    protected void addDecoratedFrames(FrameBuilder frame) {
        this.addDecoratedFrames(frame, ElementHelper.isRoot(this.element));
    }

    protected void addDecoratedFrames(FrameBuilder frame, boolean decorated) {
        boolean isAbstract;
        boolean bl = isAbstract = decorated && !((Display)this.element).i$(OtherComponents.Stamp.class);
        if (isAbstract) {
            frame.add("abstract", (Object)"Abstract");
        } else {
            frame.add("notDecorated", (Object)((Display)this.element).name$());
        }
        FrameBuilder abstractBoxFrame = new FrameBuilder().add("box");
        if (isAbstract) {
            abstractBoxFrame.add("decorated");
        }
        abstractBoxFrame.add("box", (Object)this.boxName());
        if (this.belongsToAccessible((Display)this.element)) {
            abstractBoxFrame.add("accessible");
        }
        frame.add("abstractBox", (Object)abstractBoxFrame);
    }

    protected FrameBuilder componentFrame(Component component) {
        ComponentRenderer renderer = (ComponentRenderer)factory.renderer(this.context, component, this.templateProvider, this.target);
        renderer.buildChildren(true);
        renderer.decorated(ElementHelper.isRoot(this.element));
        renderer.owner((Display)this.element);
        return renderer.buildFrame();
    }

    protected void addComponent(Component component, FrameBuilder builder) {
        builder.add("component", (Object)this.componentFrame(component));
    }

    protected boolean belongsToAccessible(Display element) {
        if (element.isAccessible()) {
            return true;
        }
        Display owner = (Display)element.core$().ownerAs(Display.class);
        while (owner != null) {
            if (owner.isAccessible()) {
                return true;
            }
            owner = (Display)owner.core$().ownerAs(Display.class);
        }
        return false;
    }

    private void writeDisplaysFor(Display.Accessible display, FrameBuilder builder) {
        this.write(builder);
        this.writeNotifier((PassiveView)display.a$(PassiveView.class), builder);
        this.writeRequester((PassiveView)display.a$(PassiveView.class), builder);
    }

    private void addParent(Display display, FrameBuilder builder) {
        String parent = this.parent();
        FrameBuilder parentFrame = new FrameBuilder().add("value", (Object)display.parentDisplay()).add("dsl", (Object)parent).add("package", (Object)parent.substring(0, parent.lastIndexOf(".")));
        builder.add("parent", (Object)parentFrame.toFrame());
    }
}

