/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.sentinel;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.ActionTemplate;
import io.intino.konos.builder.codegeneration.action.ActionUpdater;
import io.intino.konos.builder.codegeneration.sentinel.ListenerTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Sentinel;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ListenerRenderer
extends Renderer {
    private final List<Sentinel.SystemListener> systemSentinels;
    private final List<Sentinel> sentinels;

    public ListenerRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext, Target.Owner);
        this.systemSentinels = graph.sentinelList(Sentinel::isSystemListener).map(Sentinel::asSystemListener).collect(Collectors.toList());
        this.sentinels = graph.sentinelList().stream().filter(t -> !t.isSystemListener()).collect(Collectors.toList());
    }

    @Override
    public void render() {
        this.systemSentinels.forEach(this::processSystemSentinel);
        this.sentinels.stream().filter(Sentinel::isFileListener).map(Sentinel::asFileListener).forEach(this::processFileListener);
    }

    private void processSystemSentinel(Sentinel.SystemListener sentinel) {
        FrameBuilder builder = this.baseFrame("listener").add("name", (Object)sentinel.name$());
        ArrayList<Frame> targets = new ArrayList<Frame>();
        targets.add(this.baseFrame(sentinel.name$()).add("name", (Object)sentinel.name$()).toFrame());
        builder.add("target", (Object)targets.toArray(new Frame[0]));
        Commons.writeFrame(this.destinyPackage(), sentinel.name$() + "Listener", this.template().render((Object)builder.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(sentinel), Commons.javaFile(this.destinyPackage(), sentinel.name$() + "Listener").getAbsolutePath()));
        this.createCorrespondingAction((Sentinel)sentinel.a$(Sentinel.class));
    }

    private void processFileListener(Sentinel.FileListener sentinel) {
        FrameBuilder frame = new FrameBuilder(new String[]{"action", "listener"}).add("name", (Object)sentinel.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).add("parameter", (Object)this.parameters(sentinel));
        if (!this.alreadyRendered(this.src(), (Sentinel)sentinel.a$(Sentinel.class))) {
            Commons.writeFrame(this.actionsPackage(this.src()), sentinel.name$() + "Action", this.actionTemplate().render((Object)frame));
        }
    }

    private Frame[] parameters(Sentinel.FileListener sentinel) {
        ArrayList<Frame> list = new ArrayList<Frame>();
        list.add(new FrameBuilder(new String[]{"parameter"}).add("type", (Object)File.class.getCanonicalName()).add("name", (Object)"directory").toFrame());
        list.add(new FrameBuilder(new String[]{"parameter"}).add("type", (Object)"io.intino.alexandria.scheduler.directory.DirectorySentinel.Event").add("name", (Object)"event").toFrame());
        return list.toArray(new Frame[0]);
    }

    private void createCorrespondingAction(Sentinel sentinel) {
        if (!this.alreadyRendered(this.src(), sentinel)) {
            Commons.writeFrame(this.actionsPackage(this.src()), sentinel.name$() + "Action", this.actionTemplate().render((Object)new FrameBuilder(new String[]{"action"}).add("name", (Object)sentinel.name$()).add("box", (Object)this.boxName()).add("package", (Object)this.packageName()).toFrame()));
        } else {
            new ActionUpdater(this.context, Commons.javaFile(this.actionsPackage(this.src()), sentinel.name$() + "Action"), "actions", Collections.emptyMap(), Collections.emptyList(), null).update();
        }
    }

    private Template actionTemplate() {
        return Formatters.customize(new ActionTemplate());
    }

    private Template template() {
        return Formatters.customize(new ListenerTemplate());
    }

    private boolean alreadyRendered(File destiny, Sentinel sentinel) {
        return Commons.javaFile(this.actionsPackage(destiny), sentinel.name$() + "Action").exists();
    }

    private File actionsPackage(File destiny) {
        return new File(destiny, "actions");
    }

    private File destinyPackage() {
        return new File(this.gen(), "scheduling");
    }

    private FrameBuilder baseFrame(String ... types) {
        return new FrameBuilder(types).add("box", (Object)this.context.boxName()).add("package", (Object)this.context.packageName());
    }
}

