/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays.components.other;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.displays.components.SizedRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.model.graph.Animated;
import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.OtherComponents;
import io.intino.konos.model.graph.rules.Spacing;

public class BlockRenderer
extends SizedRenderer<Block> {
    public BlockRenderer(CompilationContext compilationContext, Block component, TemplateProvider provider, Target target) {
        super(compilationContext, component, provider, target);
    }

    @Override
    public void fill(FrameBuilder builder) {
        if (((Block)this.element).isConditional()) {
            builder.add("conditional");
        }
        this.addBinding(builder);
    }

    @Override
    public FrameBuilder properties() {
        FrameBuilder result = super.properties();
        this.addSpacing(result);
        this.addLayout(result);
        this.addPaper(result);
        this.addBadge(result);
        this.addParallax(result);
        this.addDrawer(result);
        this.addTransition(result);
        this.addSplitter(result);
        if (((Block)this.element).hidden() != null && ((Block)this.element).hidden() != Block.Hidden.Never) {
            result.add("hidden", (Object)((Block)this.element).hidden().name());
        }
        if (((Block)this.element).isCollapsible()) {
            result.add("collapsible", (Object)"true");
        }
        return result;
    }

    private void addSpacing(FrameBuilder builder) {
        if (((Block)this.element).spacing() != Spacing.None) {
            builder.add("spacing", (Object)((Block)this.element).spacing().value());
        }
    }

    private void addLayout(FrameBuilder builder) {
        String[] layout = (String[])((Block)this.element).layout().stream().map(l -> l.name().toLowerCase()).toArray(String[]::new);
        builder.add("layout", (Object)layout);
    }

    private void addPaper(FrameBuilder builder) {
        if (!((Block)this.element).isPaper()) {
            return;
        }
        builder.add("paper", (Object)"paper");
    }

    private void addBadge(FrameBuilder builder) {
        if (!((Block)this.element).isBadge()) {
            return;
        }
        Block.Badge badgeBlock = ((Block)this.element).asBadge();
        FrameBuilder badgeFrame = new FrameBuilder(new String[]{"badge"});
        if (badgeBlock.value() != -1) {
            badgeFrame.add("value", (Object)badgeBlock.value());
        }
        if (badgeBlock.max() != -1) {
            badgeFrame.add("max", (Object)badgeBlock.max());
        }
        if (badgeBlock.showZero()) {
            badgeFrame.add("showZero", (Object)true);
        }
        badgeFrame.add("mode", (Object)badgeBlock.mode().name());
        builder.add("badge", (Object)badgeFrame);
    }

    private void addParallax(FrameBuilder builder) {
        if (!((Block)this.element).isParallax()) {
            return;
        }
        String background = ((Block)this.element).asParallax().background();
        if (background == null || background.isEmpty()) {
            return;
        }
        builder.add("background", (Object)this.resourceMethodFrame("background", background));
    }

    private void addDrawer(FrameBuilder builder) {
        if (!((Block)this.element).isDrawer()) {
            return;
        }
        Block.Drawer drawerBlock = ((Block)this.element).asDrawer();
        FrameBuilder drawerFrame = new FrameBuilder(new String[]{"drawer"});
        drawerFrame.add("position", (Object)drawerBlock.position().name());
        drawerFrame.add("variant", (Object)drawerBlock.variant().name());
        builder.add("drawer", (Object)drawerFrame);
    }

    private void addTransition(FrameBuilder builder) {
        if (!((Block)this.element).isAnimated()) {
            return;
        }
        Block.Animated block = ((Block)this.element).asAnimated();
        Animated.Transition transition = block.transition();
        builder.add("mode", (Object)block.mode().name());
        builder.add("transitionDirection", (Object)(transition != null ? transition.direction().name() : "Right"));
        builder.add("transitionDuration", (Object)(transition != null ? transition.duration() : 500));
    }

    private void addSplitter(FrameBuilder builder) {
        if (!((Block)this.element).isSplitter()) {
            return;
        }
        Block.Splitter block = ((Block)this.element).asSplitter();
        builder.add("splitMobileLabel", (Object)block.splitMobileLabel());
    }

    private void addBinding(FrameBuilder builder) {
        if (!((Block)this.element).isConditional()) {
            return;
        }
        Component.Option option = ((Block)this.element).asConditional().selected();
        if (option == null) {
            return;
        }
        OtherComponents.Selector selector = (OtherComponents.Selector)option.core$().ownerAs(OtherComponents.Selector.class);
        builder.add("binding", (Object)new FrameBuilder(new String[]{"binding"}).add("name", (Object)this.nameOf(this.element)).add("selector", (Object)selector.name$()).add("option", (Object)option.name$()));
    }

    @Override
    protected String className(Class clazz) {
        return super.className(clazz).replace("block", "");
    }
}

