/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.rest;

import cottons.utils.StringHelper;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.rest.RESTAccessorTemplate;
import io.intino.konos.builder.codegeneration.schema.SchemaListRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Data;
import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Service;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class RESTAccessorRenderer
extends Renderer {
    private final Service.REST service;
    private File destination;

    public RESTAccessorRenderer(CompilationContext compilationContext, Service.REST restService, File destination) {
        super(compilationContext, Target.Owner);
        this.service = restService;
        this.destination = destination;
        this.destination.mkdirs();
    }

    @Override
    public void render() {
        new SchemaListRenderer(this.context, this.service.graph(), this.destination).execute();
        this.processService(this.service);
    }

    private void processService(Service.REST service) {
        FrameBuilder frame = new FrameBuilder(new String[]{"accessor"});
        frame.add("name", (Object)service.name$());
        frame.add("package", (Object)this.packageName());
        this.setupAuthentication(service, frame);
        if (!service.graph().schemaList().isEmpty()) {
            frame.add("schemaImport", (Object)new FrameBuilder(new String[]{"schemaImport"}).add("package", (Object)this.packageName()));
        }
        ArrayList resourceFrames = new ArrayList();
        service.core$().findNode(Service.REST.Resource.class).stream().map(resource -> this.framesOf(service, (Service.REST.Resource)((Object)resource))).forEach(resourceFrames::addAll);
        frame.add("resource", (Object)resourceFrames.toArray(new Frame[0]));
        frame.add("notification", service.notificationList().stream().map(notification -> this.frameOf(service, (Service.REST.Notification)((Object)notification))).toArray(Frame[]::new));
        Commons.writeFrame(this.destination, StringHelper.snakeCaseToCamelCase((String)service.name$()) + "Accessor", this.template().render((Object)frame));
    }

    private void setupAuthentication(Service.REST restService, FrameBuilder builder) {
        if (restService.authenticated() != null) {
            builder.add("auth", (Object)"");
        }
        if (restService.authenticatedWithCertificate() != null) {
            builder.add("certificate", (Object)"");
        } else if (restService.authenticatedWithToken() != null) {
            builder.add("token", (Object)"");
        }
    }

    private List<Frame> framesOf(Service.REST restService, Service.REST.Resource resource) {
        return resource.operationList().stream().map(operation -> this.processOperation((Service.REST.Resource.Operation)((Object)operation), restService.authenticated() != null, restService.authenticatedWithCertificate() != null)).collect(Collectors.toList());
    }

    private Frame frameOf(Service.REST restService, Service.REST.Notification notification) {
        FrameBuilder notificationBuilder = new FrameBuilder(new String[]{"notification"}).add("path", (Object)notification.path()).add("name", (Object)notification.name$());
        if (restService.authenticatedWithToken() != null) {
            notificationBuilder.add("secure", (Object)"");
        }
        if (Commons.queryParameters(notification) > 0L || Commons.bodyParameters(notification) > 0L) {
            notificationBuilder.add("parameters", (Object)"parameters");
        }
        notificationBuilder.add("parameter", (Object)this.notificationParameters(notification.parameterList()));
        return notificationBuilder.toFrame();
    }

    private Frame processOperation(Service.REST.Resource.Operation operation, boolean authenticated, boolean cert) {
        return new FrameBuilder(new String[]{"resource"}).add("returnType", (Object)Commons.returnType(operation.response(), this.packageName())).add("operation", (Object)((Object)((Object)operation)).getClass().getSimpleName()).add("name", (Object)operation.core$().owner().name()).add("parameter", (Object)this.parameters(operation.parameterList())).add("invokeSentence", (Object)this.invokeSentence(operation, authenticated, cert)).add("exceptionResponses", (Object)this.exceptionResponses(operation)).toFrame();
    }

    private Frame[] parameters(List<Service.REST.Resource.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame[] notificationParameters(List<Service.REST.Notification.Parameter> parameters) {
        return (Frame[])parameters.stream().map(this::parameter).toArray(Frame[]::new);
    }

    private Frame parameter(Service.REST.Resource.Parameter parameter) {
        return new FrameBuilder(new String[]{"parameter", parameter.isList() ? "list" : "single", parameter.in().toString(), parameter.isRequired() ? "required" : "optional", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).add("name", (Object)parameter.name$()).add("parameterType", (Object)this.parameterType(parameter)).toFrame();
    }

    private Frame parameter(Service.REST.Notification.Parameter parameter) {
        return new FrameBuilder(new String[]{"parameter", parameter.isList() ? "list" : "single", parameter.in().toString(), parameter.isRequired() ? "required" : "optional", ((Object)((Object)parameter.asType())).getClass().getSimpleName()}).add("name", (Object)parameter.name$()).add("parameterType", (Object)this.parameterType(parameter)).toFrame();
    }

    private String parameterType(Service.REST.Resource.Parameter parameter) {
        if (parameter.isFile()) {
            return "java.io.InputStream";
        }
        String value = (parameter.isObject() && parameter.asObject().isComponent() != false ? String.join((CharSequence)".", this.packageName(), "schemas.") : "") + parameter.asType().type();
        return parameter.i$(Data.List.class) ? "List<" + value + ">" : value;
    }

    private String parameterType(Service.REST.Notification.Parameter parameter) {
        String value = (parameter.isObject() && parameter.asObject().isComponent() != false ? String.join((CharSequence)".", this.packageName(), "schemas.") : "") + parameter.asType().type();
        return parameter.i$(Data.List.class) ? "List<" + value + ">" : value;
    }

    private Frame invokeSentence(Service.REST.Resource.Operation operation, boolean authenticated, boolean cert) {
        Response response = operation.response();
        FrameBuilder result = response == null || response.asType() == null ? this.voidInvokeSentence() : (response.isObject() ? this.objectInvokeSentence(response) : (response.isFile() ? this.fileInvokeSentence(response.asFile()) : (response.isDate() ? this.dateInvokeSentence(response.asDate()) : (response.isDateTime() ? this.dateTimeInvokeSentence(response.asDateTime()) : this.primitiveInvokeSentence(response.asType())))));
        if (response.isList()) {
            result.add("list");
        }
        return result.add("doInvoke", (Object)this.doInvoke(operation, authenticated, cert)).toFrame();
    }

    private Frame doInvoke(Service.REST.Resource.Operation operation, boolean authenticated, boolean cert) {
        FrameBuilder builder = new FrameBuilder(new String[]{"doInvoke"}).add("relativePath", (Object)this.processPath(Commons.path((Service.REST.Resource)operation.core$().ownerAs(Service.REST.Resource.class)))).add("type", (Object)(operation.response().isFile() ? "getResource" : ((Object)((Object)operation)).getClass().getSimpleName().toLowerCase()));
        if (authenticated) {
            builder.add("auth");
        }
        if (cert) {
            builder.add("cert");
        }
        if (Commons.queryParameters(operation) > 0L || Commons.bodyParameters(operation) > 0L) {
            builder.add("parameters", (Object)"parameters");
        }
        if (Commons.fileParameters(operation) > 0) {
            builder.add("inputStream", operation.parameterList().stream().filter(p -> p.i$(Data.File.class)).map(Layer::name$).toArray(String[]::new));
        }
        return builder.toFrame();
    }

    private String processPath(String path) {
        StringBuilder builder = new StringBuilder();
        for (String pathPortion : path.split("/")) {
            if (pathPortion.startsWith(":")) {
                builder.append(" + \"/\" + ").append(this.asMethodParameter(pathPortion.substring(1)));
                continue;
            }
            builder.append(" + \"/").append(pathPortion).append("\"");
        }
        return builder.toString().substring(3);
    }

    private String asMethodParameter(String parameter) {
        String toCamelCase = StringHelper.snakeCaseToCamelCase((String)parameter);
        return Character.toLowerCase(toCamelCase.charAt(0)) + toCamelCase.substring(1);
    }

    private FrameBuilder exceptionResponses(Service.REST.Resource.Operation operation) {
        List<Exception> exceptions = operation.exceptionList();
        if (exceptions.isEmpty()) {
            return new FrameBuilder(new String[]{"exceptionResponses", "none"});
        }
        return new FrameBuilder(new String[]{"exceptionResponses"}).add("exceptionResponse", (Object)this.exceptionResponses(exceptions));
    }

    private Frame[] exceptionResponses(List<Exception> responses) {
        return (Frame[])responses.stream().map(this::exceptionResponse).toArray(Frame[]::new);
    }

    private FrameBuilder finallyException(Service.REST.Resource.Operation operation) {
        FrameBuilder builder = new FrameBuilder(new String[]{"io"});
        if (operation.response() == null || operation.response().asType() == null) {
            return builder;
        }
        return builder.add("return", (Object)"");
    }

    private Frame exceptionResponse(Exception response) {
        return new FrameBuilder(new String[]{"exceptionResponse"}).add("code", (Object)response.code().value()).add("exceptionName", (Object)response.code().toString()).toFrame();
    }

    private FrameBuilder voidInvokeSentence() {
        return new FrameBuilder(new String[]{"invokeSentence", "void"});
    }

    private FrameBuilder objectInvokeSentence(Response response) {
        return new FrameBuilder(new String[]{"invokeSentence", "object"}).add("returnType", (Object)Commons.returnType(response, this.packageName()));
    }

    private FrameBuilder fileInvokeSentence(Data.File fileData) {
        return new FrameBuilder(new String[]{"invokeSentence", "file"});
    }

    private FrameBuilder dateInvokeSentence(Data.Date dateData) {
        return new FrameBuilder(new String[]{"invokeSentence", "date"});
    }

    private FrameBuilder dateTimeInvokeSentence(Data.DateTime dateTimeData) {
        return new FrameBuilder(new String[]{"invokeSentence", "datetime"});
    }

    private FrameBuilder primitiveInvokeSentence(Data.Type typeData) {
        return new FrameBuilder(new String[]{"invokeSentence", "primitive", typeData.type()}).add("returnType", (Object)typeData.type());
    }

    private Template template() {
        return Formatters.customize(new RESTAccessorTemplate());
    }

    public static String firstLowerCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }
}

