/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.CompilationContext;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.ui.templates.DisplaysManifestTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.Service;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class DisplaysManifestRenderer
extends UIRenderer {
    private final Service.UI service;
    private final Set<String> renderedDisplays = new HashSet<String>();

    protected DisplaysManifestRenderer(CompilationContext compilationContext, Service.UI service) {
        super(compilationContext, Target.Accessor);
        this.service = service;
    }

    @Override
    public void render() {
        Set<Display> displays = this.service.graph().rootDisplays(this.context.graphName()).stream().filter(this::isBaseType).collect(Collectors.toSet());
        Set<PassiveView> baseDisplays = this.baseDisplays(displays);
        this.renderDisplays(displays, baseDisplays);
        this.renderedDisplays.clear();
        this.renderAccessibleDisplays(displays, baseDisplays);
    }

    private void renderDisplays(Set<Display> displays, Set<PassiveView> baseDisplays) {
        FrameBuilder result = new FrameBuilder(new String[]{"manifest"});
        baseDisplays.forEach(d -> this.renderDisplay(d, result));
        displays.stream().filter(d -> !this.renderedDisplays.contains(d.core$().id())).forEach(d -> this.renderDisplay(d, result));
        Commons.write(new File(this.gen() + File.separator + "Displays.js").toPath(), this.setup(new DisplaysManifestTemplate()).render((Object)result.toFrame()));
    }

    private void renderAccessibleDisplays(Set<Display> displays, Set<PassiveView> baseDisplays) {
        FrameBuilder result = new FrameBuilder(new String[]{"manifest"});
        baseDisplays.stream().filter(d -> d.i$(Display.Accessible.class)).forEach(d -> this.renderDisplay(d, result, true));
        displays.stream().filter(d -> !this.renderedDisplays.contains(d.core$().id()) && d.isAccessible()).forEach(d -> this.renderDisplay(d, result, true));
        Commons.write(new File(this.gen() + File.separator + "AccessibleDisplays.js").toPath(), this.setup(new DisplaysManifestTemplate()).render((Object)result.toFrame()));
    }

    private Set<PassiveView> baseDisplays(Set<Display> displays) {
        return displays.stream().filter(PassiveView::isExtensionOf).map(this::baseDisplays).flatMap(Collection::stream).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Set<PassiveView> baseDisplays(PassiveView view) {
        LinkedHashSet<PassiveView> result = new LinkedHashSet<PassiveView>();
        if (view.isExtensionOf()) {
            PassiveView passiveView = view.asExtensionOf().parentView();
            result.addAll(this.baseDisplays(passiveView));
        }
        result.add(view);
        return result;
    }

    private <D extends PassiveView> void renderDisplay(D display, FrameBuilder builder) {
        this.renderDisplay(display, builder, false);
    }

    private <D extends PassiveView> void renderDisplay(D display, FrameBuilder builder, boolean accessible) {
        builder.add("display", (Object)this.display(display, accessible));
        this.renderedDisplays.add(display.core$().id());
    }

    private <D extends PassiveView> Frame display(D display, boolean accessible) {
        FrameBuilder result = new FrameBuilder(new String[]{"display", this.typeOf(display)});
        result.add("name", (Object)this.nameOf(display));
        result.add("directory", (Object)(ElementHelper.isRoot(display) ? "src" : "gen"));
        if (accessible) {
            result.add("accessible");
            result.add("accessible", (Object)new FrameBuilder(new String[]{"accessible"}));
        }
        return result.toFrame();
    }
}

