/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder;

import cottons.utils.Files;
import io.intino.alexandria.logger.Logger;
import io.intino.konos.CompilerMessage;
import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.builder.KonosException;
import io.intino.konos.builder.Manifest;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.CompilationContext;
import io.intino.konos.builder.codegeneration.FullRenderer;
import io.intino.konos.builder.utils.GraphLoader;
import io.intino.konos.compiler.shared.PostCompileActionMessage;
import io.intino.konos.compiler.shared.PostCompileConfigurationDependencyActionMessage;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Sentinel;
import io.intino.magritte.io.Stash;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KonosCompiler {
    private static Map<String, Boolean> firstTimeMap = new HashMap<String, Boolean>();
    private final CompilerConfiguration configuration;
    private final List<CompilerMessage> collector;
    private final List<PostCompileActionMessage> postCompileActionMessages;

    public KonosCompiler(CompilerConfiguration configuration, List<CompilerMessage> collector, List<PostCompileActionMessage> postCompileActionMessages) {
        this.configuration = configuration;
        this.collector = collector;
        this.postCompileActionMessages = postCompileActionMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<OutputItem> compile(List<File> sources) {
        GraphLoader graphLoader;
        KonosGraph graph;
        ArrayList<OutputItem> compiledFiles;
        block7: {
            compiledFiles = new ArrayList<OutputItem>();
            if (this.configuration.isVerbose()) {
                this.configuration.out().println("@#$%@# Presentable:Konosc: Compiling model...");
            }
            if ((graph = (graphLoader = new GraphLoader()).loadGraph(this.configuration, sources)) != null) break block7;
            ArrayList<OutputItem> arrayList = compiledFiles;
            return arrayList;
        }
        try {
            if (this.configuration.isVerbose()) {
                this.configuration.out().println("@#$%@# Presentable:Konosc: Rendering classes...");
            }
            this.render(graph, graphLoader.stashes(), sources, compiledFiles);
            this.updateDependencies(this.requiredDependencies(graph));
            ArrayList<OutputItem> arrayList = compiledFiles;
            return arrayList;
        }
        catch (Exception e) {
            this.processCompilationException(e);
        }
        return compiledFiles;
    }

    private void updateDependencies(Map<String, String> requiredDependencies) {
        if (this.configuration.groupId().equals("io.intino.alexandria")) {
            return;
        }
        for (Map.Entry<String, String> entry : requiredDependencies.entrySet()) {
            this.postCompileActionMessages.add((PostCompileActionMessage)new PostCompileConfigurationDependencyActionMessage(this.configuration.module(), entry.getKey() + ":" + entry.getValue()));
        }
    }

    private Map<String, String> requiredDependencies(KonosGraph graph) {
        Map<String, String> dependencies = Manifest.load().dependencies;
        if (graph.jmxServiceList().isEmpty()) {
            this.remove(dependencies, "jmx");
        }
        if (graph.messagingServiceList().isEmpty()) {
            this.remove(dependencies, ":jms");
        }
        if (graph.sentinelList().isEmpty()) {
            this.remove(dependencies, "scheduler");
        }
        if (graph.datalake() == null) {
            this.remove(dependencies, "datalake");
            this.remove(dependencies, "sshj");
        } else if (!graph.datalake().isSshMirrored()) {
            this.remove(dependencies, "sshj");
        }
        if (graph.messageHub() == null) {
            this.remove(dependencies, "message");
            this.remove(dependencies, "terminal-jms");
        }
        if (graph.messageHub() != null && !graph.messageHub().isJmsBus()) {
            this.remove(dependencies, "terminal-jms");
        }
        if (graph.uiServiceList().isEmpty()) {
            this.remove(dependencies, "ui");
        }
        if (graph.restServiceList().isEmpty()) {
            this.remove(dependencies, "rest");
        }
        if (graph.soapServiceList().isEmpty()) {
            this.remove(dependencies, "soap");
        }
        if (graph.workflow() == null) {
            this.remove(dependencies, "bpm");
        }
        if (graph.slackBotServiceList().isEmpty()) {
            this.remove(dependencies, "slack");
        }
        if (graph.visualizationComponents() == null || graph.visualizationComponents().chartList(c -> c.isAbsolute() || c.isRelative()).isEmpty()) {
            this.remove(dependencies, "driver-r");
        }
        if (graph.visualizationComponents() == null || graph.visualizationComponents().dashboardList(d -> d.isAbsolute() || d.isRelative()).isEmpty()) {
            this.remove(dependencies, "driver-shiny");
        }
        if (graph.sentinelList().stream().noneMatch(Sentinel::isWebHook) || !graph.restServiceList().isEmpty() || !graph.soapServiceList().isEmpty() || !graph.uiServiceList().isEmpty()) {
            this.remove(dependencies, "http");
        }
        return dependencies;
    }

    private void remove(Map<String, String> dependencies, String type) {
        String toRemove = null;
        for (String dep : dependencies.keySet()) {
            if (!dep.contains(type)) continue;
            toRemove = dep;
        }
        if (toRemove != null) {
            dependencies.remove(toRemove);
        }
    }

    private void render(KonosGraph graph, Stash[] stashes, List<File> sources, List<OutputItem> compiledFiles) throws KonosException {
        try {
            CompilationContext context = new CompilationContext(this.configuration, this.postCompileActionMessages, sources, compiledFiles);
            context.loadCache(graph, stashes);
            new FullRenderer(graph, context).execute();
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                String exceptionAsString = sw.toString();
                throw new KonosException(exceptionAsString, e);
            }
            throw new KonosException(e.getMessage(), e);
        }
    }

    private void processCompilationException(Exception e) {
        if (e instanceof KonosException) {
            this.addErrorMessage((KonosException)e);
            return;
        }
        Logger.error((String)e.getMessage());
        this.addMessageWithoutLocation(e.getMessage(), true);
    }

    private void addMessageWithoutLocation(String message, boolean error) {
        this.collector.add(new CompilerMessage(error ? "error" : "warning", message, null, -1, -1));
    }

    private void addErrorMessage(KonosException exception) {
        this.collector.add(new CompilerMessage("error", exception.getMessage(), "null", -1, -1));
    }

    private File prepareIntinoFolder() {
        String intinoFolder = this.configuration.intinoProjectDirectory() + File.separator + "box" + File.separator + this.configuration.module();
        File folder = new File(intinoFolder);
        if (folder.exists() && !firstTimeMap.containsKey(intinoFolder)) {
            Files.removeDir((File)folder);
        }
        if (!folder.exists()) {
            folder.mkdirs();
        }
        firstTimeMap.put(intinoFolder, true);
        return folder;
    }
}

