/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.CompilationContext;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datahub.DatalakeTemplate;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Datalake;
import io.intino.konos.model.graph.Datamart;
import io.intino.konos.model.graph.KonosGraph;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DatalakeRenderer {
    private final CompilationContext context;
    private final KonosGraph graph;
    private final File genDirectory;

    public DatalakeRenderer(CompilationContext context, KonosGraph graph) {
        this.graph = graph;
        this.context = context;
        this.genDirectory = context.gen(Target.Owner);
    }

    public void execute() {
        Datalake datalake = this.graph.datalake();
        if (datalake == null || !datalake.isNfsMirrored() && !datalake.isSshMirrored()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"datalake", datalake.isNfsMirrored() ? "nfs" : "ssh"}).add("package", (Object)this.context.packageName());
        ArrayList eventTanks = new ArrayList();
        this.context.classes().put("Datalake", "Datalake");
        File destination = this.genDirectory;
        if (!Commons.javaFile(destination, "Datalake").exists()) {
            Commons.writeFrame(destination, "Datalake", Formatters.customize(new DatalakeTemplate()).render((Object)builder.toFrame()));
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(datalake), Commons.javaFile(destination, "Datalake").getAbsolutePath()));
        }
    }

    private List<String> tanksOf(Datamart.Mounter.Population mounter) {
        ArrayList<String> tanks = new ArrayList<String>();
        if (!mounter.splitList().isEmpty()) {
            for (Datamart.Mounter.Population.Split split : mounter.splitList()) {
                split.splits().forEach(s -> mounter.sourceList().stream().map(source -> s + "." + source.tank()).forEach(tanks::add));
            }
        } else {
            return mounter.sourceList().stream().map(Datamart.Mounter.Population.Source::tank).collect(Collectors.toList());
        }
        return tanks;
    }
}

