/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.main;

import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.main.MainTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import java.io.File;

public class MainRenderer
extends Renderer {
    private final CompilationContext context;
    private final File destination;
    private final boolean hasModel;
    private final CompilerConfiguration configuration;

    public MainRenderer(CompilationContext context, boolean hasModel) {
        super(context, Target.Owner);
        this.context = context;
        this.destination = context.src(Target.Owner);
        this.hasModel = hasModel;
        this.configuration = context.configuration();
    }

    @Override
    public void execute() {
        if (this.configuration == null) {
            return;
        }
        String name = this.context.boxName();
        FrameBuilder builder = new FrameBuilder(new String[]{"main"}).add("package", (Object)this.context.packageName()).add("name", (Object)name);
        if (this.hasModel) {
            builder.add("model", (Object)new FrameBuilder(new String[]{"model"}).add("name", (Object)name).toFrame());
        }
        if (!Commons.javaFile(this.destination, "Main").exists()) {
            Commons.writeFrame(this.destination, "Main", this.template().render((Object)builder.toFrame()));
        }
    }

    @Override
    protected void render() {
        this.execute();
    }

    private Template template() {
        return Formatters.customize(new MainTemplate());
    }
}

