/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.futures;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class AgendaServiceTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("service"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"ValidPackage"})}).output(new Rule.Output[]{this.literal(";\n\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("box", new String[]{"snakecaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("Box;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".agenda.*;\nimport io.intino.alexandria.http.AlexandriaSpark;\nimport io.intino.alexandria.logger.Logger;\nimport io.intino.alexandria.scheduler.AlexandriaScheduler;\nimport org.apache.commons.io.FileUtils;\nimport io.intino.alexandria.Json;\n\n")}).output(new Rule.Output[]{this.mark("schemaImport", new String[0])}).output(new Rule.Output[]{this.literal("\nimport org.quartz.*;\n\nimport java.io.File;\nimport java.io.IOException;\nimport java.nio.file.Files;\nimport java.time.Instant;\nimport java.time.temporal.ChronoUnit;\nimport java.util.*;\nimport java.util.function.Predicate;\nimport java.util.stream.Collectors;\n\nimport static io.intino.alexandria.Json.fromString;\nimport static org.quartz.CronScheduleBuilder.cronSchedule;\nimport static org.quartz.JobBuilder.newJob;\nimport static org.quartz.TriggerBuilder.newTrigger;\n\n@SuppressWarnings(\"unchecked\")\npublic class AgendaService {\n\tpublic static final String BaseUri = \"")}).output(new Rule.Output[]{this.mark("baseUri", new String[0])}).output(new Rule.Output[]{this.literal("/\";\n\tprivate static final Map<String, File> sources = new HashMap<>();\n\tprivate static final Map<String, Instant> timeouts = new HashMap<>();\n\tprivate final ")}).output(new Rule.Output[]{this.mark("box", new String[]{"snakecaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box;\n\tprivate final File root;\n\n\tpublic AgendaService(")}).output(new Rule.Output[]{this.mark("box", new String[]{"snakecaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box) {\n\t\tthis.box = box;\n\t\tthis.root = ")}).output(new Rule.Output[]{this.mark("rootPath", new String[]{"customizeDirectory"})}).output(new Rule.Output[]{this.literal(";\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("future", new String[]{"getter"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.mark("future", new String[]{"execute"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\tpublic AlexandriaSpark<?> setup(AlexandriaSpark<?> server, AlexandriaScheduler scheduler) {\n\t\tloadFutures();\n\t\tstartTimers(scheduler);\n\t\tstartService(server);\n\t\treturn server;\n\t}\n\n\tpublic Create create() {\n\t\treturn new Create();\n\t}\n\n\tpublic Remove remove() {\n\t\treturn new Remove();\n\t}\n\n\tprivate void startTimers(AlexandriaScheduler scheduler) {\n\t\ttry {\n\t\t\tJobDetail job = newJob(AgendaServiceTrigger.class).withIdentity(\"AgendaServiceTrigger\").build();\n\t\t\tjob.getJobDataMap().put(\"box\", box);\n\t\t\tscheduler.scheduleJob(job, Set.of(newTrigger().withIdentity(\"AgendaServiceTrigger\").withSchedule(cronSchedule(\"* * * 1/1 * ? *\")).build()), true);\n\t\t} catch (SchedulerException e) {\n\t\t\tLogger.error(e);\n\t\t}\n\t}\n\n\tprivate void startService(AlexandriaSpark<?> server) {\n\t\t")}).output(new Rule.Output[]{this.mark("future", new String[]{"route"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("future", new String[]{"register"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\n\tprivate void loadFutures() {\n\t\t")}).output(new Rule.Output[]{this.mark("future", new String[]{"load"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("future", new String[]{"private"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\n\tprivate static String read(File file) {\n\t\ttry {\n\t\t\treturn Files.readString(file.toPath());\n\t\t} catch (IOException e) {\n\t\t\tLogger.error(e);\n\t\t\treturn \"\";\n\t\t}\n\t}\n\n\tprivate void write(Object schema, File file) {\n\t\ttry {\n\t\t\tFiles.writeString(file.toPath(), Json.toString(schema));\n\t\t} catch (IOException e) {\n\t\t\tLogger.error(e);\n\t\t}\n\t}\n\n\tpublic class Create {\n\t\t")}).output(new Rule.Output[]{this.mark("future", new String[]{"createMethod"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\n\t\t")}).output(new Rule.Output[]{this.mark("future", new String[]{"createClass"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tpublic class Remove {\n\t\t")}).output(new Rule.Output[]{this.mark("future", new String[]{"removeMethod"}).multiple("\n\n")}).output(new Rule.Output[]{this.literal("\n\t}\n\n\tpublic static class Option {\n\t\tpublic String id = UUID.randomUUID().toString();\n\t}\n\n\tpublic static class AgendaServiceTrigger implements Job {\n\t\tpublic void execute(JobExecutionContext context) throws JobExecutionException {\n\t\t\t")}).output(new Rule.Output[]{this.mark("box", new String[]{"snakecaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("Box box = (")}).output(new Rule.Output[]{this.mark("box", new String[]{"snakecaseToCamelCase", "firstUpperCase"})}).output(new Rule.Output[]{this.literal("Box) context.getMergedJobDataMap().get(\"box\");\n\t\t\tfinal Instant instant = Instant.now().truncatedTo(ChronoUnit.SECONDS);\n\t\t\ttimeouts.forEach((k, v) -> {\n\t\t\t\tif (instant.equals(v)) {\n\t\t\t\t\t")}).output(new Rule.Output[]{this.mark("future", new String[]{"timeout"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\t\t\t\t}\n\t\t\t});\n\t\t}\n\t}\n}")}), this.rule().condition(this.trigger("register"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("private void register")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Schema schema) {\n\tFile file = ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("File(")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"schemaParameter"}).multiple(", ")}).output(new Rule.Output[]{this.literal(");\n\tregister(schema, file);\n\twrite(schema, file);\n}\n\nprivate static void register(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Schema schema, File file) {\n\t")}).output(new Rule.Output[]{this.mark("option", new String[]{"putOption"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\ttimeouts.put(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("#\" + schema.timeout().id, schema.timeout().on());\n}")}), this.rule().condition(this.trigger("load"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Files().forEach(file -> register(fromString(read(file), ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Schema.class), file));")}), this.rule().condition(this.trigger("route"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("server.route(BaseUri + Abstract")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(".URI.Path + \":id\").post(manager -> execute")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(manager.fromPath(\"id\")));")}), this.rule().condition(this.trigger("ifoption"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("if (\"")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("\".equals(option)) schema.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("();")}), this.rule().condition(this.trigger("putoption"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("sources.put(schema.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("().id, file);")}), this.rule().condition(this.trigger("private"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("private Collection<File> ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Files() {\n\tFile directory = new File(root, \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"camelCaseToSnakeCase"})}).output(new Rule.Output[]{this.literal("/\");\n\tdirectory.mkdirs();\n\treturn FileUtils.listFiles(directory, new String[]{\"json\"}, true);\n}\n\nprivate File ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("File(")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"signature"}).multiple(", ")}).output(new Rule.Output[]{this.literal(") {\n\treturn new File(root, \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"camelCaseToSnakeCase"})}).output(new Rule.Output[]{this.literal("/\" + ")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"names"}).multiple(" + \".\" + ")}).output(new Rule.Output[]{this.literal(" + \".json\");\n}\n\nprivate ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(File file) {\n\tfinal ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" future = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(box);\n\tfuture.schema(fromString(read(file), ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Schema.class));\n\treturn future;\n}")}), this.rule().condition(this.trigger("execute"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public void execute")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(String id) {\n\tfinal File file = sources.get(id);\n\tif (file == null) return;\n\tfinal ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" schema = ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(file);\n\tfinal String option = schema.uri().option(id);\n\tif (option == null) return;\n\t")}).output(new Rule.Output[]{this.mark("option", new String[]{"ifOption"}).multiple("\nelse ")}).output(new Rule.Output[]{this.literal("\n\tschema.uri().ids().forEach(sources::remove);\n\tfile.delete();\n}")}), this.rule().condition(this.trigger("getter"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public List<")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("> all")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"predicateSignature"}).multiple(", ")}).output(new Rule.Output[]{this.literal(") {\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("Files().stream()\n\t\t\t.filter(f -> ")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"test"}).multiple(" && ")}).output(new Rule.Output[]{this.literal(")\n\t\t\t.map(this::")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(").collect(Collectors.toList());\n}\n\npublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"signature"}).multiple(", ")}).output(new Rule.Output[]{this.literal(") {\n\treturn ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("File(")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"names"}).multiple(", ")}).output(new Rule.Output[]{this.literal("));\n}")}), this.rule().condition(this.trigger("removemethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public boolean ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"signature"}).multiple(", ")}).output(new Rule.Output[]{this.literal(") {\n\tfinal File file = ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("File(")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"names"}).multiple(", ")}).output(new Rule.Output[]{this.literal(");\n\tfinal ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(" = AgendaService.this.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(file);\n\ttimeouts.remove(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("#\" + ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(".schema().timeout().id);\n\tfor (String key : new ArrayList<>(sources.keySet()))\n\t\tif (sources.get(key).equals(file)) sources.remove(key);\n\tif (file.exists()) return file.delete();\n\treturn false;\n}")}), this.rule().condition(this.trigger("createmethod"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"signature"}).multiple(", ")}).output(new Rule.Output[]{this.literal(") {\n\treturn new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"names"}).multiple(", ")}).output(new Rule.Output[]{this.literal(");\n}")}), this.rule().condition(this.trigger("timeout"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("if (k.startsWith(\"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("#\")) box.agenda().execute")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("(k.split(\"#\")[1]);")}), this.rule().condition(this.trigger("predicatesignature"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("Predicate<")}).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal("> ")}).output(new Rule.Output[]{this.mark("name", new String[0])}), this.rule().condition(this.trigger("signature"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("type", new String[0])}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[0])}), this.rule().condition(this.trigger("names"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("name", new String[0])}), this.rule().condition(this.trigger("test"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".test(f.getName().split(\"\\\\.\")[")}).output(new Rule.Output[]{this.mark("index", new String[0])}).output(new Rule.Output[]{this.literal("])")}), this.rule().condition(this.trigger("schemaparameter"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("schema.")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("()")}), this.rule().condition(this.trigger("fluid"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal(")")}), this.rule().condition(this.trigger("optioncreate"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public ")}).output(new Rule.Output[]{this.mark("future", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("optionParameter", new String[]{"signature"}).multiple(", ")}).output(new Rule.Output[]{this.literal(") {\n\tschema.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstLowerCase"})}).output(new Rule.Output[]{this.literal("(new ")}).output(new Rule.Output[]{this.mark("future", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Schema.")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("optionParameter", new String[]{"names"}).multiple(", ")}).output(new Rule.Output[]{this.literal("));\n\treturn this;\n}")}), this.rule().condition(this.trigger("createclass"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public class ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" {\n\tprivate final ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Schema schema;\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"signature"}).multiple(", ")}).output(new Rule.Output[]{this.literal(") {\n\t\tschema = new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Schema()")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.literal(".")}).output(new Rule.Output[]{this.mark("parameter", new String[]{"fluid"}).multiple(".")})}).output(new Rule.Output[]{this.literal(";\n\t}\n\n\t")}).output(new Rule.Output[]{this.mark("option", new String[]{"optionCreate"}).multiple("\n")}).output(new Rule.Output[]{this.literal("\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal(" timeout(Instant timeout) {\n\t\tschema.timeout(new ")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("Schema.Timeout(timeout.truncatedTo(ChronoUnit.SECONDS)));\n\t\treturn this;\n\t}\n\n\tpublic void save() {\n\t\tregister")}).output(new Rule.Output[]{this.mark("name", new String[]{"firstUpperCase"})}).output(new Rule.Output[]{this.literal("(schema);\n\t}\n}")}), this.rule().condition(this.type("schemaImport"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("import ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".schemas.*;")}), this.rule().condition(this.type("archetype"), new Rule.Condition[]{this.trigger("customizedirectory")}).output(new Rule.Output[]{this.literal("new ")}).output(new Rule.Output[]{this.mark("package", new String[0])}).output(new Rule.Output[]{this.literal(".Archetype(box.configuration().home()).")}).output(new Rule.Output[]{this.mark("path", new String[0])}).output(new Rule.Output[]{this.literal(".root()")}), this.rule().condition(this.trigger("customizedirectory"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("new java.io.File(\"")}).output(new Rule.Output[]{this.mark("path", new String[0])}).output(new Rule.Output[]{this.literal("\")")})});
    }
}

