/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.datahub.messagehub;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.datahub.messagehub.MessageHubTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.MessageHub;
import java.io.File;

public class MessageHubRenderer {
    private final CompilationContext context;
    private final KonosGraph graph;
    private final File sourceDirectory;
    private final File genDirectory;

    public MessageHubRenderer(CompilationContext context, KonosGraph graph) {
        this.graph = graph;
        this.context = context;
        this.sourceDirectory = context.src(Target.Owner);
        this.genDirectory = context.gen(Target.Owner);
    }

    public void execute() {
        File destination;
        MessageHub terminal = this.graph.messageHub();
        if (terminal == null) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"messageHub"}).add("box", (Object)this.context.boxName()).add("package", (Object)this.context.packageName());
        if (terminal.isJmsBus()) {
            builder.add("jms");
        }
        this.context.classes().put("MessageHub", "MessageHub");
        File file = destination = terminal.isJmsBus() ? this.genDirectory : this.sourceDirectory;
        if (!Commons.javaFile(destination, "MessageHub").exists()) {
            Commons.writeFrame(destination, "MessageHub", Formatters.customize(new MessageHubTemplate()).render((Object)builder.toFrame()));
            this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(terminal), Commons.javaFile(destination, "MessageHub").getAbsolutePath()));
        }
    }
}

