/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos;

import io.intino.konos.KonosCompilerRunner;
import io.intino.konos.builder.context.KonosException;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KonoscRunner {
    private static final Logger LOG = Logger.getGlobal();

    private KonoscRunner() {
    }

    public static void main(String[] args) {
        boolean verbose;
        boolean bl = verbose = args.length != 2 || Boolean.parseBoolean(args[1]);
        if (verbose) {
            System.out.println("@#$%@# Presentable:Starting compiling");
        }
        try {
            File argsFile;
            if (KonoscRunner.checkArgumentsNumber(args) || (argsFile = KonoscRunner.checkConfigurationFile(args[0])) == null) {
                throw new KonosException("Error finding args file");
            }
            new KonosCompilerRunner(verbose).run(argsFile);
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, e.getMessage() == null ? e.getStackTrace()[0].toString() : e.getMessage());
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static File checkConfigurationFile(String arg) {
        File argsFile = new File(arg);
        if (!argsFile.exists()) {
            LOG.severe("%%mArguments file for Tara compiler not found/%m");
            return null;
        }
        return argsFile;
    }

    private static boolean checkArgumentsNumber(String[] args) {
        if (args.length < 1) {
            LOG.severe("%%mThere is no arguments for tara compiler/%m");
            return true;
        }
        return false;
    }
}

