/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.ui.displays;

import io.intino.alexandria.logger.Logger;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.ui.TemplateProvider;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.codegeneration.ui.displays.DisplayRendererFactory;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.Service;
import java.util.List;

public class DisplayListRenderer
extends UIRenderer {
    private final List<Display> displays;
    private final TemplateProvider templateProvider;

    public DisplayListRenderer(CompilationContext compilationContext, Service.UI service, TemplateProvider templateProvider, Target target) {
        super(compilationContext, target);
        this.displays = service.graph().rootDisplays(compilationContext.graphName());
        this.templateProvider = templateProvider;
    }

    @Override
    public void render() throws KonosException {
        DisplayRendererFactory factory = new DisplayRendererFactory();
        this.displays.forEach(d -> this.render((Display)((Object)d), factory));
    }

    private void delay() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            Logger.error((Throwable)e);
        }
    }

    private void render(Display display, DisplayRendererFactory factory) {
        try {
            ((Renderer)factory.renderer(this.context, display, this.templateProvider, this.target)).execute();
        }
        catch (KonosException e) {
            Logger.error((Throwable)e);
        }
    }
}

