/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Absolute;
import io.intino.konos.model.graph.Block;
import io.intino.konos.model.graph.CatalogComponents;
import io.intino.konos.model.graph.Component;
import io.intino.konos.model.graph.DataComponents;
import io.intino.konos.model.graph.Dataframe;
import io.intino.konos.model.graph.Display;
import io.intino.konos.model.graph.HelperComponents;
import io.intino.konos.model.graph.InteractionComponents;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.OtherComponents;
import io.intino.konos.model.graph.PassiveView;
import io.intino.konos.model.graph.Relative;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.VisualizationComponents;
import io.intino.konos.model.graph.rules.Layout;
import io.intino.konos.model.graph.rules.Spacing;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Template
extends Component
implements Terminal {
    protected String modelClass;
    protected List<Layout> layout = new ArrayList<Layout>();
    protected Spacing spacing;
    protected List<Component> componentList = new ArrayList<Component>();
    protected Desktop _desktop;
    protected DrawerNavigable _drawerNavigable;
    protected Responsible _responsible;
    protected Persistent _persistent;
    protected Absolute _absolute;
    protected Relative _relative;

    public Template(Node node) {
        super(node);
    }

    public String modelClass() {
        return this.modelClass;
    }

    public List<Layout> layout() {
        return this.layout;
    }

    public Spacing spacing() {
        return this.spacing;
    }

    public Template modelClass(String value) {
        this.modelClass = value;
        return this;
    }

    public Template layout(List<Layout> values) {
        this.layout = values;
        return this;
    }

    public Template spacing(Spacing value) {
        this.spacing = value;
        return this;
    }

    public List<Component> componentList() {
        return Collections.unmodifiableList(this.componentList);
    }

    public Component component(int index) {
        return this.componentList.get(index);
    }

    public List<Component> componentList(Predicate<Component> predicate) {
        return this.componentList().stream().filter(predicate).collect(Collectors.toList());
    }

    public Relative asRelative() {
        Layer as = this.a$(Relative.class);
        return as != null ? (Relative)as : (Relative)this.core$().addAspect(Relative.class);
    }

    public boolean isRelative() {
        return this.core$().is(Relative.class);
    }

    public DrawerNavigable asDrawerNavigable() {
        Layer as = this.a$(DrawerNavigable.class);
        return as != null ? (DrawerNavigable)as : (DrawerNavigable)this.core$().addAspect(DrawerNavigable.class);
    }

    public boolean isDrawerNavigable() {
        return this.core$().is(DrawerNavigable.class);
    }

    public Absolute asAbsolute() {
        Layer as = this.a$(Absolute.class);
        return as != null ? (Absolute)as : (Absolute)this.core$().addAspect(Absolute.class);
    }

    public boolean isAbsolute() {
        return this.core$().is(Absolute.class);
    }

    public Responsible asResponsible() {
        Layer as = this.a$(Responsible.class);
        return as != null ? (Responsible)as : (Responsible)this.core$().addAspect(Responsible.class);
    }

    public boolean isResponsible() {
        return this.core$().is(Responsible.class);
    }

    public Persistent asPersistent() {
        Layer as = this.a$(Persistent.class);
        return as != null ? (Persistent)as : (Persistent)this.core$().addAspect(Persistent.class);
    }

    public boolean isPersistent() {
        return this.core$().is(Persistent.class);
    }

    public Desktop asDesktop() {
        Layer as = this.a$(Desktop.class);
        return as != null ? (Desktop)as : (Desktop)this.core$().addAspect(Desktop.class);
    }

    public boolean isDesktop() {
        return this.core$().is(Desktop.class);
    }

    @Override
    protected List<Node> componentList$() {
        LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
        new ArrayList<Component>(this.componentList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    @Override
    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap(super.variables$());
        map.put("modelClass", new ArrayList<String>(Collections.singletonList(this.modelClass)));
        map.put("layout", this.layout);
        map.put("spacing", new ArrayList<Spacing>(Collections.singletonList(this.spacing)));
        return map;
    }

    @Override
    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Component")) {
            this.componentList.add((Component)node.as(Component.class));
        }
    }

    @Override
    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Component")) {
            this.componentList.remove(node.as(Component.class));
        }
    }

    @Override
    protected void load$(String name, List<?> values) {
        super.load$(name, values);
        if (name.equalsIgnoreCase("modelClass")) {
            this.modelClass = (String)StringLoader.load(values, (Layer)this).get(0);
        } else if (name.equalsIgnoreCase("layout")) {
            this.layout = WordLoader.load(values, Layout.class, (Layer)this);
        } else if (name.equalsIgnoreCase("spacing")) {
            this.spacing = (Spacing)((Object)WordLoader.load(values, Spacing.class, (Layer)this).get(0));
        }
    }

    @Override
    protected void set$(String name, List<?> values) {
        super.set$(name, values);
        if (name.equalsIgnoreCase("modelClass")) {
            this.modelClass = (String)values.get(0);
        } else if (name.equalsIgnoreCase("layout")) {
            this.layout = new ArrayList(values);
        } else if (name.equalsIgnoreCase("spacing")) {
            this.spacing = (Spacing)((Object)values.get(0));
        }
    }

    @Override
    public Create create() {
        return new Create(null);
    }

    @Override
    public Create create(String name) {
        return new Create(name);
    }

    @Override
    public Clear clear() {
        return new Clear();
    }

    @Override
    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Relative
    extends io.intino.konos.model.graph.Relative
    implements Terminal {
        protected Template _template;

        public Relative(Node node) {
            super(node);
        }

        public String modelClass() {
            return this._template.modelClass();
        }

        public List<Layout> layout() {
            return this._template.layout();
        }

        public Spacing spacing() {
            return this._template.spacing();
        }

        public Relative modelClass(String value) {
            this._template.modelClass(value);
            return this;
        }

        public Relative layout(List<Layout> values) {
            this._template.layout(values);
            return this;
        }

        public Relative spacing(Spacing value) {
            this._template.spacing(value);
            return this;
        }

        public List<Component> componentList() {
            return this._template.componentList();
        }

        public Component componentList(int index) {
            return this._template.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._template.blockList();
        }

        public Block blockList(int index) {
            return this._template.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._template.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._template.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._template.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._template.notificationList().get(index);
        }

        public Template asTemplate() {
            return (Template)this.a$(Template.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Template) {
                this._template = (Template)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Relative.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Relative.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Relative.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Relative.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Relative.Create {
            public Create(String name) {
                super(name);
            }

            public Component component() {
                Component newElement = (Component)Relative.this.core$().graph().concept(Component.class).createNode(this.name, Relative.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Relative.this.core$().graph().concept(Block.class).createNode(this.name, Relative.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Relative.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Relative.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Relative.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Relative.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Absolute
    extends io.intino.konos.model.graph.Absolute
    implements Terminal {
        protected Template _template;

        public Absolute(Node node) {
            super(node);
        }

        public String modelClass() {
            return this._template.modelClass();
        }

        public List<Layout> layout() {
            return this._template.layout();
        }

        public Spacing spacing() {
            return this._template.spacing();
        }

        public Absolute modelClass(String value) {
            this._template.modelClass(value);
            return this;
        }

        public Absolute layout(List<Layout> values) {
            this._template.layout(values);
            return this;
        }

        public Absolute spacing(Spacing value) {
            this._template.spacing(value);
            return this;
        }

        public List<Component> componentList() {
            return this._template.componentList();
        }

        public Component componentList(int index) {
            return this._template.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._template.blockList();
        }

        public Block blockList(int index) {
            return this._template.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._template.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._template.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._template.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._template.notificationList().get(index);
        }

        public Template asTemplate() {
            return (Template)this.a$(Template.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Template) {
                this._template = (Template)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Absolute.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Absolute.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Absolute.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Absolute.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends Absolute.Create {
            public Create(String name) {
                super(Absolute.this, name);
            }

            public Component component() {
                Component newElement = (Component)Absolute.this.core$().graph().concept(Component.class).createNode(this.name, Absolute.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Absolute.this.core$().graph().concept(Block.class).createNode(this.name, Absolute.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Absolute.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Absolute.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Absolute.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Absolute.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Persistent
    extends Layer
    implements Terminal {
        protected Template _template;

        public Persistent(Node node) {
            super(node);
        }

        public String modelClass() {
            return this._template.modelClass();
        }

        public List<Layout> layout() {
            return this._template.layout();
        }

        public Spacing spacing() {
            return this._template.spacing();
        }

        public Persistent modelClass(String value) {
            this._template.modelClass(value);
            return this;
        }

        public Persistent layout(List<Layout> values) {
            this._template.layout(values);
            return this;
        }

        public Persistent spacing(Spacing value) {
            this._template.spacing(value);
            return this;
        }

        public List<Component> componentList() {
            return this._template.componentList();
        }

        public Component componentList(int index) {
            return this._template.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._template.blockList();
        }

        public Block blockList(int index) {
            return this._template.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._template.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._template.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._template.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._template.notificationList().get(index);
        }

        public Template asTemplate() {
            return (Template)this.a$(Template.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Template) {
                this._template = (Template)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Persistent.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Persistent.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Persistent.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Persistent.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Persistent.this.core$().graph().concept(Component.class).createNode(this.name, Persistent.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Persistent.this.core$().graph().concept(Block.class).createNode(this.name, Persistent.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Persistent.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Persistent.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Persistent.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Persistent.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class Responsible
    extends Layer
    implements Terminal {
        protected Template _template;

        public Responsible(Node node) {
            super(node);
        }

        public String modelClass() {
            return this._template.modelClass();
        }

        public List<Layout> layout() {
            return this._template.layout();
        }

        public Spacing spacing() {
            return this._template.spacing();
        }

        public Responsible modelClass(String value) {
            this._template.modelClass(value);
            return this;
        }

        public Responsible layout(List<Layout> values) {
            this._template.layout(values);
            return this;
        }

        public Responsible spacing(Spacing value) {
            this._template.spacing(value);
            return this;
        }

        public List<Component> componentList() {
            return this._template.componentList();
        }

        public Component componentList(int index) {
            return this._template.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._template.blockList();
        }

        public Block blockList(int index) {
            return this._template.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._template.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._template.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._template.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._template.notificationList().get(index);
        }

        public Template asTemplate() {
            return (Template)this.a$(Template.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Template) {
                this._template = (Template)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Responsible.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Responsible.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Responsible.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Responsible.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)Responsible.this.core$().graph().concept(Component.class).createNode(this.name, Responsible.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Responsible.this.core$().graph().concept(Block.class).createNode(this.name, Responsible.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Responsible.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Responsible.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Responsible.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Responsible.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public static class DrawerNavigable
    extends Layer
    implements Terminal {
        protected Direction direction;
        protected Mode mode;
        protected boolean hasMiniVariant;
        protected boolean underHeader;
        protected Template _template;

        public DrawerNavigable(Node node) {
            super(node);
        }

        public Direction direction() {
            return this.direction;
        }

        public Mode mode() {
            return this.mode;
        }

        public boolean hasMiniVariant() {
            return this.hasMiniVariant;
        }

        public boolean underHeader() {
            return this.underHeader;
        }

        public String modelClass() {
            return this._template.modelClass();
        }

        public List<Layout> layout() {
            return this._template.layout();
        }

        public Spacing spacing() {
            return this._template.spacing();
        }

        public DrawerNavigable direction(Direction value) {
            this.direction = value;
            return this;
        }

        public DrawerNavigable mode(Mode value) {
            this.mode = value;
            return this;
        }

        public DrawerNavigable hasMiniVariant(boolean value) {
            this.hasMiniVariant = value;
            return this;
        }

        public DrawerNavigable underHeader(boolean value) {
            this.underHeader = value;
            return this;
        }

        public DrawerNavigable modelClass(String value) {
            this._template.modelClass(value);
            return this;
        }

        public DrawerNavigable layout(List<Layout> values) {
            this._template.layout(values);
            return this;
        }

        public DrawerNavigable spacing(Spacing value) {
            this._template.spacing(value);
            return this;
        }

        public List<Component> componentList() {
            return this._template.componentList();
        }

        public Component componentList(int index) {
            return this._template.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._template.blockList();
        }

        public Block blockList(int index) {
            return this._template.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._template.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._template.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._template.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._template.notificationList().get(index);
        }

        public Template asTemplate() {
            return (Template)this.a$(Template.class);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("direction", new ArrayList<Direction>(Collections.singletonList(this.direction)));
            map.put("mode", new ArrayList<Mode>(Collections.singletonList(this.mode)));
            map.put("hasMiniVariant", new ArrayList<Boolean>(Collections.singletonList(this.hasMiniVariant)));
            map.put("underHeader", new ArrayList<Boolean>(Collections.singletonList(this.underHeader)));
            return map;
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("direction")) {
                this.direction = (Direction)((Object)WordLoader.load(values, Direction.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)WordLoader.load(values, Mode.class, (Layer)this).get(0));
            } else if (name.equalsIgnoreCase("hasMiniVariant")) {
                this.hasMiniVariant = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("underHeader")) {
                this.underHeader = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("direction")) {
                this.direction = (Direction)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("mode")) {
                this.mode = (Mode)((Object)values.get(0));
            } else if (name.equalsIgnoreCase("hasMiniVariant")) {
                this.hasMiniVariant = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("underHeader")) {
                this.underHeader = (Boolean)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Template) {
                this._template = (Template)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(DrawerNavigable.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(DrawerNavigable.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(DrawerNavigable.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(DrawerNavigable.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Component component() {
                Component newElement = (Component)DrawerNavigable.this.core$().graph().concept(Component.class).createNode(this.name, DrawerNavigable.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)DrawerNavigable.this.core$().graph().concept(Block.class).createNode(this.name, DrawerNavigable.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)DrawerNavigable.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, DrawerNavigable.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)DrawerNavigable.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, DrawerNavigable.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }

        public static enum Mode {
            Normal,
            Modal;

        }

        public static enum Direction {
            Left,
            Right,
            Top,
            Bottom;

        }
    }

    public static class Desktop
    extends Layer
    implements Terminal {
        protected OtherComponents.Header header;
        protected Template _template;

        public Desktop(Node node) {
            super(node);
        }

        public String modelClass() {
            return this._template.modelClass();
        }

        public List<Layout> layout() {
            return this._template.layout();
        }

        public Spacing spacing() {
            return this._template.spacing();
        }

        public Desktop modelClass(String value) {
            this._template.modelClass(value);
            return this;
        }

        public Desktop layout(List<Layout> values) {
            this._template.layout(values);
            return this;
        }

        public Desktop spacing(Spacing value) {
            this._template.spacing(value);
            return this;
        }

        public OtherComponents.Header header() {
            return this.header;
        }

        public List<Component> componentList() {
            return this._template.componentList();
        }

        public Component componentList(int index) {
            return this._template.componentList().get(index);
        }

        public List<Block> blockList() {
            return this._template.blockList();
        }

        public Block blockList(int index) {
            return this._template.blockList().get(index);
        }

        public List<PassiveView.Request> requestList() {
            return this._template.requestList();
        }

        public PassiveView.Request requestList(int index) {
            return this._template.requestList().get(index);
        }

        public List<PassiveView.Notification> notificationList() {
            return this._template.notificationList();
        }

        public PassiveView.Notification notificationList(int index) {
            return this._template.notificationList().get(index);
        }

        public Template asTemplate() {
            return (Template)this.a$(Template.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.header != null) {
                components.add(this.header.core$());
            }
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("OtherComponents$Header")) {
                this.header = (OtherComponents.Header)node.as(OtherComponents.Header.class);
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("OtherComponents$Header")) {
                this.header = null;
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Template) {
                this._template = (Template)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear {
            public void component(Predicate<Component> filter) {
                new ArrayList<Component>(Desktop.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void block(Predicate<Block> filter) {
                new ArrayList<Block>(Desktop.this.blockList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<PassiveView.Request> filter) {
                new ArrayList<PassiveView.Request>(Desktop.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<PassiveView.Notification> filter) {
                new ArrayList<PassiveView.Notification>(Desktop.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public OtherComponents.Header header() {
                OtherComponents.Header newElement = (OtherComponents.Header)Desktop.this.core$().graph().concept(OtherComponents.Header.class).createNode(this.name, Desktop.this.core$()).as(OtherComponents.Header.class);
                return newElement;
            }

            public Component component() {
                Component newElement = (Component)Desktop.this.core$().graph().concept(Component.class).createNode(this.name, Desktop.this.core$()).as(Component.class);
                return newElement;
            }

            public Block block() {
                Block newElement = (Block)Desktop.this.core$().graph().concept(Block.class).createNode(this.name, Desktop.this.core$()).as(Block.class);
                return newElement;
            }

            public PassiveView.Request request() {
                PassiveView.Request newElement = (PassiveView.Request)Desktop.this.core$().graph().concept(PassiveView.Request.class).createNode(this.name, Desktop.this.core$()).as(PassiveView.Request.class);
                return newElement;
            }

            public PassiveView.Notification notification() {
                PassiveView.Notification newElement = (PassiveView.Notification)Desktop.this.core$().graph().concept(PassiveView.Notification.class).createNode(this.name, Desktop.this.core$()).as(PassiveView.Notification.class);
                return newElement;
            }
        }
    }

    public class Clear
    extends Component.Clear {
        public Clear() {
            super(Template.this);
        }

        public void component(Predicate<Component> filter) {
            new ArrayList<Component>(Template.this.componentList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create
    extends Component.Create {
        public Create(String name) {
            super(Template.this, name);
        }

        public Component component() {
            Component newElement = (Component)Template.this.core$().graph().concept(Component.class).createNode(this.name, Template.this.core$()).as(Component.class);
            return newElement;
        }

        public InteractionComponents.SplitButton splitButton(String title, List<String> options, String defaultOption) {
            InteractionComponents.SplitButton newElement = (InteractionComponents.SplitButton)Template.this.core$().graph().concept(InteractionComponents.SplitButton.class).createNode(this.name, Template.this.core$()).as(InteractionComponents.SplitButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "options", options);
            newElement.core$().set((Layer)newElement, "defaultOption", Collections.singletonList(defaultOption));
            return newElement;
        }

        public VisualizationComponents.Stepper.Step step() {
            VisualizationComponents.Stepper.Step newElement = (VisualizationComponents.Stepper.Step)Template.this.core$().graph().concept(VisualizationComponents.Stepper.Step.class).createNode(this.name, Template.this.core$()).as(VisualizationComponents.Stepper.Step.class);
            return newElement;
        }

        public OtherComponents.CollectionDialog collectionDialog(String title) {
            OtherComponents.CollectionDialog newElement = (OtherComponents.CollectionDialog)Template.this.core$().graph().concept(OtherComponents.CollectionDialog.class).createNode(this.name, Template.this.core$()).as(OtherComponents.CollectionDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OtherComponents.User user() {
            OtherComponents.User newElement = (OtherComponents.User)Template.this.core$().graph().concept(OtherComponents.User.class).createNode(this.name, Template.this.core$()).as(OtherComponents.User.class);
            return newElement;
        }

        public OtherComponents.Tooltip tooltip() {
            OtherComponents.Tooltip newElement = (OtherComponents.Tooltip)Template.this.core$().graph().concept(OtherComponents.Tooltip.class).createNode(this.name, Template.this.core$()).as(OtherComponents.Tooltip.class);
            return newElement;
        }

        public InteractionComponents.Button button(String title) {
            InteractionComponents.Button newElement = (InteractionComponents.Button)Template.this.core$().graph().concept(InteractionComponents.Button.class).createNode(this.name, Template.this.core$()).as(InteractionComponents.Button.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public VisualizationComponents.Chart chart(Dataframe input, String query) {
            VisualizationComponents.Chart newElement = (VisualizationComponents.Chart)Template.this.core$().graph().concept(VisualizationComponents.Chart.class).createNode(this.name, Template.this.core$()).as(VisualizationComponents.Chart.class);
            newElement.core$().set((Layer)newElement, "input", Collections.singletonList(input));
            newElement.core$().set((Layer)newElement, "query", Collections.singletonList(query));
            return newElement;
        }

        public OtherComponents.OwnerTemplateStamp ownerTemplateStamp(Service.UI.Use owner, String template) {
            OtherComponents.OwnerTemplateStamp newElement = (OtherComponents.OwnerTemplateStamp)Template.this.core$().graph().concept(OtherComponents.OwnerTemplateStamp.class).createNode(this.name, Template.this.core$()).as(OtherComponents.OwnerTemplateStamp.class);
            newElement.core$().set((Layer)newElement, "owner", Collections.singletonList(owner));
            newElement.core$().set((Layer)newElement, "template", Collections.singletonList(template));
            return newElement;
        }

        public DataComponents.Text text() {
            DataComponents.Text newElement = (DataComponents.Text)Template.this.core$().graph().concept(DataComponents.Text.class).createNode(this.name, Template.this.core$()).as(DataComponents.Text.class);
            return newElement;
        }

        public OtherComponents.AlertDialog alertDialog(String title, String message) {
            OtherComponents.AlertDialog newElement = (OtherComponents.AlertDialog)Template.this.core$().graph().concept(OtherComponents.AlertDialog.class).createNode(this.name, Template.this.core$()).as(OtherComponents.AlertDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "message", Collections.singletonList(message));
            return newElement;
        }

        public InteractionComponents.Switch switch$(String title) {
            InteractionComponents.Switch newElement = (InteractionComponents.Switch)Template.this.core$().graph().concept(InteractionComponents.Switch.class).createNode(this.name, Template.this.core$()).as(InteractionComponents.Switch.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public InteractionComponents.IconToggle iconToggle(String title, String icon) {
            InteractionComponents.IconToggle newElement = (InteractionComponents.IconToggle)Template.this.core$().graph().concept(InteractionComponents.IconToggle.class).createNode(this.name, Template.this.core$()).as(InteractionComponents.IconToggle.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public CatalogComponents.Collection.Mold.Item item(int height) {
            CatalogComponents.Collection.Mold.Item newElement = (CatalogComponents.Collection.Mold.Item)Template.this.core$().graph().concept(CatalogComponents.Collection.Mold.Item.class).createNode(this.name, Template.this.core$()).as(CatalogComponents.Collection.Mold.Item.class);
            newElement.core$().set((Layer)newElement, "height", Collections.singletonList(height));
            return newElement;
        }

        public CatalogComponents.SearchBox searchBox(List<CatalogComponents.Collection> collections) {
            CatalogComponents.SearchBox newElement = (CatalogComponents.SearchBox)Template.this.core$().graph().concept(CatalogComponents.SearchBox.class).createNode(this.name, Template.this.core$()).as(CatalogComponents.SearchBox.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            return newElement;
        }

        public OtherComponents.Dialog dialog(String title) {
            OtherComponents.Dialog newElement = (OtherComponents.Dialog)Template.this.core$().graph().concept(OtherComponents.Dialog.class).createNode(this.name, Template.this.core$()).as(OtherComponents.Dialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OtherComponents.Icon icon(String icon) {
            OtherComponents.Icon newElement = (OtherComponents.Icon)Template.this.core$().graph().concept(OtherComponents.Icon.class).createNode(this.name, Template.this.core$()).as(OtherComponents.Icon.class);
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public InteractionComponents.AvatarIconButton avatarIconButton(String title) {
            InteractionComponents.AvatarIconButton newElement = (InteractionComponents.AvatarIconButton)Template.this.core$().graph().concept(InteractionComponents.AvatarIconButton.class).createNode(this.name, Template.this.core$()).as(InteractionComponents.AvatarIconButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OtherComponents.Chip chip() {
            OtherComponents.Chip newElement = (OtherComponents.Chip)Template.this.core$().graph().concept(OtherComponents.Chip.class).createNode(this.name, Template.this.core$()).as(OtherComponents.Chip.class);
            return newElement;
        }

        public VisualizationComponents.Spinner spinner() {
            VisualizationComponents.Spinner newElement = (VisualizationComponents.Spinner)Template.this.core$().graph().concept(VisualizationComponents.Spinner.class).createNode(this.name, Template.this.core$()).as(VisualizationComponents.Spinner.class);
            return newElement;
        }

        public HelperComponents.HelperComponent helperComponent() {
            HelperComponents.HelperComponent newElement = (HelperComponents.HelperComponent)Template.this.core$().graph().concept(HelperComponents.HelperComponent.class).createNode(this.name, Template.this.core$()).as(HelperComponents.HelperComponent.class);
            return newElement;
        }

        public OtherComponents.Selector selector() {
            OtherComponents.Selector newElement = (OtherComponents.Selector)Template.this.core$().graph().concept(OtherComponents.Selector.class).createNode(this.name, Template.this.core$()).as(OtherComponents.Selector.class);
            return newElement;
        }

        public CatalogComponents.Grouping grouping(List<CatalogComponents.Collection> collections) {
            CatalogComponents.Grouping newElement = (CatalogComponents.Grouping)Template.this.core$().graph().concept(CatalogComponents.Grouping.class).createNode(this.name, Template.this.core$()).as(CatalogComponents.Grouping.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            return newElement;
        }

        @Override
        public Block block() {
            Block newElement = (Block)Template.this.core$().graph().concept(Block.class).createNode(this.name, Template.this.core$()).as(Block.class);
            return newElement;
        }

        public OtherComponents.ProxyStamp proxyStamp(String proxy, Service.UI.Use from) {
            OtherComponents.ProxyStamp newElement = (OtherComponents.ProxyStamp)Template.this.core$().graph().concept(OtherComponents.ProxyStamp.class).createNode(this.name, Template.this.core$()).as(OtherComponents.ProxyStamp.class);
            newElement.core$().set((Layer)newElement, "proxy", Collections.singletonList(proxy));
            newElement.core$().set((Layer)newElement, "from", Collections.singletonList(from));
            return newElement;
        }

        public OtherComponents.Progress progress() {
            OtherComponents.Progress newElement = (OtherComponents.Progress)Template.this.core$().graph().concept(OtherComponents.Progress.class).createNode(this.name, Template.this.core$()).as(OtherComponents.Progress.class);
            return newElement;
        }

        public CatalogComponents.List list() {
            CatalogComponents.List newElement = (CatalogComponents.List)Template.this.core$().graph().concept(CatalogComponents.List.class).createNode(this.name, Template.this.core$()).as(CatalogComponents.List.class);
            return newElement;
        }

        public DataComponents.Date date() {
            DataComponents.Date newElement = (DataComponents.Date)Template.this.core$().graph().concept(DataComponents.Date.class).createNode(this.name, Template.this.core$()).as(DataComponents.Date.class);
            return newElement;
        }

        public VisualizationComponents.TemporalSlider temporalSlider(List<CatalogComponents.Collection> collections, List<VisualizationComponents.TemporalSlider.Scales> scales) {
            VisualizationComponents.TemporalSlider newElement = (VisualizationComponents.TemporalSlider)Template.this.core$().graph().concept(VisualizationComponents.TemporalSlider.class).createNode(this.name, Template.this.core$()).as(VisualizationComponents.TemporalSlider.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            newElement.core$().set((Layer)newElement, "scales", scales);
            return newElement;
        }

        public DataComponents.Image image() {
            DataComponents.Image newElement = (DataComponents.Image)Template.this.core$().graph().concept(DataComponents.Image.class).createNode(this.name, Template.this.core$()).as(DataComponents.Image.class);
            return newElement;
        }

        public HelperComponents.Row row(List<CatalogComponents.Collection.Mold.Item> items) {
            HelperComponents.Row newElement = (HelperComponents.Row)Template.this.core$().graph().concept(HelperComponents.Row.class).createNode(this.name, Template.this.core$()).as(HelperComponents.Row.class);
            newElement.core$().set((Layer)newElement, "items", items);
            return newElement;
        }

        public Template template() {
            Template newElement = (Template)Template.this.core$().graph().concept(Template.class).createNode(this.name, Template.this.core$()).as(Template.class);
            return newElement;
        }

        public OtherComponents.MaterialIcon materialIcon(String icon) {
            OtherComponents.MaterialIcon newElement = (OtherComponents.MaterialIcon)Template.this.core$().graph().concept(OtherComponents.MaterialIcon.class).createNode(this.name, Template.this.core$()).as(OtherComponents.MaterialIcon.class);
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public InteractionComponents.MaterialIconToggle materialIconToggle(String title, String icon) {
            InteractionComponents.MaterialIconToggle newElement = (InteractionComponents.MaterialIconToggle)Template.this.core$().graph().concept(InteractionComponents.MaterialIconToggle.class).createNode(this.name, Template.this.core$()).as(InteractionComponents.MaterialIconToggle.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public OtherComponents.HtmlViewer htmlViewer() {
            OtherComponents.HtmlViewer newElement = (OtherComponents.HtmlViewer)Template.this.core$().graph().concept(OtherComponents.HtmlViewer.class).createNode(this.name, Template.this.core$()).as(OtherComponents.HtmlViewer.class);
            return newElement;
        }

        public OtherComponents.Snackbar snackbar() {
            OtherComponents.Snackbar newElement = (OtherComponents.Snackbar)Template.this.core$().graph().concept(OtherComponents.Snackbar.class).createNode(this.name, Template.this.core$()).as(OtherComponents.Snackbar.class);
            return newElement;
        }

        public CatalogComponents.Sorting sorting(List<CatalogComponents.Collection> collections) {
            CatalogComponents.Sorting newElement = (CatalogComponents.Sorting)Template.this.core$().graph().concept(CatalogComponents.Sorting.class).createNode(this.name, Template.this.core$()).as(CatalogComponents.Sorting.class);
            newElement.core$().set((Layer)newElement, "collections", collections);
            return newElement;
        }

        public InteractionComponents.Toolbar toolbar() {
            InteractionComponents.Toolbar newElement = (InteractionComponents.Toolbar)Template.this.core$().graph().concept(InteractionComponents.Toolbar.class).createNode(this.name, Template.this.core$()).as(InteractionComponents.Toolbar.class);
            return newElement;
        }

        public OtherComponents.Header header() {
            OtherComponents.Header newElement = (OtherComponents.Header)Template.this.core$().graph().concept(OtherComponents.Header.class).createNode(this.name, Template.this.core$()).as(OtherComponents.Header.class);
            return newElement;
        }

        public CatalogComponents.GroupingToolbar groupingToolbar(List<CatalogComponents.Grouping> groupings) {
            CatalogComponents.GroupingToolbar newElement = (CatalogComponents.GroupingToolbar)Template.this.core$().graph().concept(CatalogComponents.GroupingToolbar.class).createNode(this.name, Template.this.core$()).as(CatalogComponents.GroupingToolbar.class);
            newElement.core$().set((Layer)newElement, "groupings", groupings);
            return newElement;
        }

        public CatalogComponents.Table table() {
            CatalogComponents.Table newElement = (CatalogComponents.Table)Template.this.core$().graph().concept(CatalogComponents.Table.class).createNode(this.name, Template.this.core$()).as(CatalogComponents.Table.class);
            return newElement;
        }

        public OtherComponents.MicroSite microSite(String site) {
            OtherComponents.MicroSite newElement = (OtherComponents.MicroSite)Template.this.core$().graph().concept(OtherComponents.MicroSite.class).createNode(this.name, Template.this.core$()).as(OtherComponents.MicroSite.class);
            newElement.core$().set((Layer)newElement, "site", Collections.singletonList(site));
            return newElement;
        }

        public VisualizationComponents.Slider slider() {
            VisualizationComponents.Slider newElement = (VisualizationComponents.Slider)Template.this.core$().graph().concept(VisualizationComponents.Slider.class).createNode(this.name, Template.this.core$()).as(VisualizationComponents.Slider.class);
            return newElement;
        }

        public CatalogComponents.Collection.Mold.Heading heading() {
            CatalogComponents.Collection.Mold.Heading newElement = (CatalogComponents.Collection.Mold.Heading)Template.this.core$().graph().concept(CatalogComponents.Collection.Mold.Heading.class).createNode(this.name, Template.this.core$()).as(CatalogComponents.Collection.Mold.Heading.class);
            return newElement;
        }

        public InteractionComponents.Link link(String title) {
            InteractionComponents.Link newElement = (InteractionComponents.Link)Template.this.core$().graph().concept(InteractionComponents.Link.class).createNode(this.name, Template.this.core$()).as(InteractionComponents.Link.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public InteractionComponents.IconButton iconButton(String title, String icon) {
            InteractionComponents.IconButton newElement = (InteractionComponents.IconButton)Template.this.core$().graph().concept(InteractionComponents.IconButton.class).createNode(this.name, Template.this.core$()).as(InteractionComponents.IconButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public VisualizationComponents.Dashboard dashboard() {
            VisualizationComponents.Dashboard newElement = (VisualizationComponents.Dashboard)Template.this.core$().graph().concept(VisualizationComponents.Dashboard.class).createNode(this.name, Template.this.core$()).as(VisualizationComponents.Dashboard.class);
            return newElement;
        }

        public VisualizationComponents.Stepper stepper() {
            VisualizationComponents.Stepper newElement = (VisualizationComponents.Stepper)Template.this.core$().graph().concept(VisualizationComponents.Stepper.class).createNode(this.name, Template.this.core$()).as(VisualizationComponents.Stepper.class);
            return newElement;
        }

        public InteractionComponents.Toggle toggle(String title) {
            InteractionComponents.Toggle newElement = (InteractionComponents.Toggle)Template.this.core$().graph().concept(InteractionComponents.Toggle.class).createNode(this.name, Template.this.core$()).as(InteractionComponents.Toggle.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OtherComponents.Divider divider() {
            OtherComponents.Divider newElement = (OtherComponents.Divider)Template.this.core$().graph().concept(OtherComponents.Divider.class).createNode(this.name, Template.this.core$()).as(OtherComponents.Divider.class);
            return newElement;
        }

        public CatalogComponents.DynamicTable dynamicTable() {
            CatalogComponents.DynamicTable newElement = (CatalogComponents.DynamicTable)Template.this.core$().graph().concept(CatalogComponents.DynamicTable.class).createNode(this.name, Template.this.core$()).as(CatalogComponents.DynamicTable.class);
            return newElement;
        }

        public OtherComponents.Card card() {
            OtherComponents.Card newElement = (OtherComponents.Card)Template.this.core$().graph().concept(OtherComponents.Card.class).createNode(this.name, Template.this.core$()).as(OtherComponents.Card.class);
            return newElement;
        }

        public DataComponents.Location location() {
            DataComponents.Location newElement = (DataComponents.Location)Template.this.core$().graph().concept(DataComponents.Location.class).createNode(this.name, Template.this.core$()).as(DataComponents.Location.class);
            return newElement;
        }

        public DataComponents.File file() {
            DataComponents.File newElement = (DataComponents.File)Template.this.core$().graph().concept(DataComponents.File.class).createNode(this.name, Template.this.core$()).as(DataComponents.File.class);
            return newElement;
        }

        public CatalogComponents.Magazine magazine() {
            CatalogComponents.Magazine newElement = (CatalogComponents.Magazine)Template.this.core$().graph().concept(CatalogComponents.Magazine.class).createNode(this.name, Template.this.core$()).as(CatalogComponents.Magazine.class);
            return newElement;
        }

        public InteractionComponents.MaterialIconButton materialIconButton(String title, String icon) {
            InteractionComponents.MaterialIconButton newElement = (InteractionComponents.MaterialIconButton)Template.this.core$().graph().concept(InteractionComponents.MaterialIconButton.class).createNode(this.name, Template.this.core$()).as(InteractionComponents.MaterialIconButton.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            newElement.core$().set((Layer)newElement, "icon", Collections.singletonList(icon));
            return newElement;
        }

        public OtherComponents.TemplateStamp templateStamp(Template template) {
            OtherComponents.TemplateStamp newElement = (OtherComponents.TemplateStamp)Template.this.core$().graph().concept(OtherComponents.TemplateStamp.class).createNode(this.name, Template.this.core$()).as(OtherComponents.TemplateStamp.class);
            newElement.core$().set((Layer)newElement, "template", Collections.singletonList(template));
            return newElement;
        }

        public DataComponents.Number number() {
            DataComponents.Number newElement = (DataComponents.Number)Template.this.core$().graph().concept(DataComponents.Number.class).createNode(this.name, Template.this.core$()).as(DataComponents.Number.class);
            return newElement;
        }

        public VisualizationComponents.KPI kPI() {
            VisualizationComponents.KPI newElement = (VisualizationComponents.KPI)Template.this.core$().graph().concept(VisualizationComponents.KPI.class).createNode(this.name, Template.this.core$()).as(VisualizationComponents.KPI.class);
            return newElement;
        }

        public CatalogComponents.Map map() {
            CatalogComponents.Map newElement = (CatalogComponents.Map)Template.this.core$().graph().concept(CatalogComponents.Map.class).createNode(this.name, Template.this.core$()).as(CatalogComponents.Map.class);
            return newElement;
        }

        public OtherComponents.DecisionDialog decisionDialog(String title) {
            OtherComponents.DecisionDialog newElement = (OtherComponents.DecisionDialog)Template.this.core$().graph().concept(OtherComponents.DecisionDialog.class).createNode(this.name, Template.this.core$()).as(OtherComponents.DecisionDialog.class);
            newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
            return newElement;
        }

        public OtherComponents.DisplayStamp displayStamp(Display display) {
            OtherComponents.DisplayStamp newElement = (OtherComponents.DisplayStamp)Template.this.core$().graph().concept(OtherComponents.DisplayStamp.class).createNode(this.name, Template.this.core$()).as(OtherComponents.DisplayStamp.class);
            newElement.core$().set((Layer)newElement, "display", Collections.singletonList(display));
            return newElement;
        }

        public OtherComponents.Frame frame(String url) {
            OtherComponents.Frame newElement = (OtherComponents.Frame)Template.this.core$().graph().concept(OtherComponents.Frame.class).createNode(this.name, Template.this.core$()).as(OtherComponents.Frame.class);
            newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
            return newElement;
        }
    }
}

