/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.CompilerConfiguration;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.ElementHelper;
import io.intino.konos.model.graph.CatalogComponents;
import io.intino.konos.model.graph.HelperComponents;
import io.intino.magritte.framework.Layer;
import java.io.File;
import java.util.Map;

public abstract class Renderer {
    protected final CompilationContext context;
    protected final ElementHelper elementHelper;
    protected final Target target;

    protected Renderer(CompilationContext context, Target target) {
        this.context = context;
        this.elementHelper = new ElementHelper();
        this.target = target;
    }

    public void execute() throws KonosException {
        this.render();
    }

    protected abstract void render() throws KonosException;

    public String project() {
        return this.context.project();
    }

    public String boxName() {
        return this.context.boxName();
    }

    protected CompilerConfiguration configuration() {
        return this.context.configuration();
    }

    protected String packageName() {
        return this.context.packageName();
    }

    protected String module() {
        return this.context.module();
    }

    protected String parent() {
        return this.context.parent();
    }

    protected File root() {
        return this.context.root(this.target);
    }

    protected File res() {
        return this.context.res(this.target);
    }

    protected File src() {
        return this.context.src(this.target);
    }

    protected File gen() {
        return this.context.gen(this.target);
    }

    protected Map<String, String> classes() {
        return this.context.classes();
    }

    public FrameBuilder buildBaseFrame() {
        return new FrameBuilder().add("box", (Object)this.boxName()).add("package", (Object)this.context.packageName());
    }

    protected boolean isRendered(Layer element) {
        if (element == null) {
            return false;
        }
        if (element.i$(CatalogComponents.Collection.Mold.Item.class)) {
            return false;
        }
        if (element.i$(HelperComponents.Row.class)) {
            return false;
        }
        return !this.context.cache().isModified(element);
    }

    protected boolean isRoot(Layer element) {
        return element.core$().owner() == null || element.core$().owner() == element.core$().model();
    }

    protected boolean isCustomParameter(String value) {
        return value != null && value.startsWith("{");
    }

    protected String customParameterValue(String value) {
        return value != null ? value.substring(1, value.length() - 1) : "";
    }
}

