/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration;

import cottons.utils.StringHelper;
import io.intino.itrules.Formatter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.helpers.Commons;

public class Formatters {
    public static Formatter validName() {
        return value -> StringHelper.snakeCaseToCamelCase((String)value.toString().replace(".", "-"));
    }

    public static Formatter snakeCaseToCamelCase() {
        return value -> StringHelper.snakeCaseToCamelCase((String)value.toString());
    }

    public static Formatter camelCaseToSnakeCase() {
        return value -> StringHelper.camelCaseToSnakeCase((String)value.toString());
    }

    public static Formatter returnType() {
        return value -> value.equals("Void") ? "void" : value;
    }

    public static String firstLowerCase(String value) {
        return value.substring(0, 1).toLowerCase() + value.substring(1);
    }

    public static String firstUpperCase(String value) {
        return value.substring(0, 1).toUpperCase() + value.substring(1);
    }

    public static Formatter returnTypeFormatter() {
        return value -> {
            if (value.equals("Void")) {
                return "void";
            }
            if (value.toString().contains(".")) {
                return Formatters.firstLowerCase(value.toString());
            }
            return value;
        };
    }

    public static Formatter quoted() {
        return value -> "\"" + value.toString() + "\"";
    }

    public static Formatter validPackage() {
        return value -> value.toString().replace("-", "").toLowerCase();
    }

    private static Formatter subPath() {
        return value -> {
            String path = value.toString();
            return path.contains(":") ? path.substring(0, path.indexOf(":")) : path;
        };
    }

    public static Formatter shortType() {
        return value -> {
            String type = value.toString();
            String[] s = type.split("\\.");
            return s[s.length - 1];
        };
    }

    public static Frame customize(String name, String value) {
        FrameBuilder builder = new FrameBuilder(new String[]{name});
        builder.add("name", (Object)value);
        builder.add("custom", Commons.extractParameters(value).stream().toArray(String[]::new));
        return builder.toFrame();
    }

    public static Template customize(Template template) {
        template.add("validname", Formatters.validName());
        template.add("snakeCaseToCamelCase", Formatters.snakeCaseToCamelCase());
        template.add("camelCaseToSnakeCase", Formatters.camelCaseToSnakeCase());
        template.add("returnType", Formatters.returnType());
        template.add("returnTypeFormatter", Formatters.returnTypeFormatter());
        template.add("quoted", Formatters.quoted());
        template.add("validPackage", Formatters.validPackage());
        template.add("subpath", Formatters.subPath());
        template.add("shortType", Formatters.shortType());
        template.add("quoted", Formatters.quoted());
        template.add("customParameter", Formatters.customParameter());
        return template;
    }

    private static Formatter customParameter() {
        return value -> value.toString().substring(1, value.toString().length() - 1);
    }
}

