/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.model.graph;

import io.intino.konos.model.graph.Exception;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Parameter;
import io.intino.konos.model.graph.Redirect;
import io.intino.konos.model.graph.Response;
import io.intino.konos.model.graph.Schema;
import io.intino.konos.model.graph.Template;
import io.intino.konos.model.graph.functions.HomesProvider;
import io.intino.konos.model.graph.functions.TemplatesProvider;
import io.intino.konos.model.graph.rules.ExceptionCodes;
import io.intino.magritte.framework.Layer;
import io.intino.magritte.framework.Node;
import io.intino.magritte.framework.loaders.BooleanLoader;
import io.intino.magritte.framework.loaders.FunctionLoader;
import io.intino.magritte.framework.loaders.NodeLoader;
import io.intino.magritte.framework.loaders.StringLoader;
import io.intino.magritte.framework.loaders.WordLoader;
import io.intino.magritte.framework.tags.Component;
import io.intino.magritte.framework.tags.Terminal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Service
extends Layer
implements Terminal {
    protected List<Schema> schemaList = new ArrayList<Schema>();
    protected List<Exception> exceptionList = new ArrayList<Exception>();
    protected REST _rEST;
    protected Soap _soap;
    protected JMX _jMX;
    protected Messaging _messaging;
    protected SlackBot _slackBot;
    protected RocketChatBot _rocketChatBot;
    protected UI _uI;
    protected Agenda _agenda;

    public Service(Node node) {
        super(node);
    }

    public List<Schema> schemaList() {
        return Collections.unmodifiableList(this.schemaList);
    }

    public Schema schema(int index) {
        return this.schemaList.get(index);
    }

    public List<Schema> schemaList(Predicate<Schema> predicate) {
        return this.schemaList().stream().filter(predicate).collect(Collectors.toList());
    }

    public List<Exception> exceptionList() {
        return Collections.unmodifiableList(this.exceptionList);
    }

    public Exception exception(int index) {
        return this.exceptionList.get(index);
    }

    public List<Exception> exceptionList(Predicate<Exception> predicate) {
        return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
    }

    public UI asUI() {
        return (UI)this.a$(UI.class);
    }

    public UI asUI(String port, String title, String favicon) {
        UI newElement = (UI)this.core$().addAspect(UI.class);
        newElement.core$().set((Layer)newElement, "port", Collections.singletonList(port));
        newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
        newElement.core$().set((Layer)newElement, "favicon", Collections.singletonList(favicon));
        return newElement;
    }

    public boolean isUI() {
        return this.core$().is(UI.class);
    }

    public void removeUI() {
        this.core$().removeAspect(UI.class);
    }

    public Soap asSoap() {
        return (Soap)this.a$(Soap.class);
    }

    public Soap asSoap(String host, String port) {
        Soap newElement = (Soap)this.core$().addAspect(Soap.class);
        newElement.core$().set((Layer)newElement, "host", Collections.singletonList(host));
        newElement.core$().set((Layer)newElement, "port", Collections.singletonList(port));
        return newElement;
    }

    public boolean isSoap() {
        return this.core$().is(Soap.class);
    }

    public void removeSoap() {
        this.core$().removeAspect(Soap.class);
    }

    public JMX asJMX() {
        Layer as = this.a$(JMX.class);
        return as != null ? (JMX)as : (JMX)this.core$().addAspect(JMX.class);
    }

    public boolean isJMX() {
        return this.core$().is(JMX.class);
    }

    public REST asREST() {
        return (REST)this.a$(REST.class);
    }

    public REST asREST(String host, String port) {
        REST newElement = (REST)this.core$().addAspect(REST.class);
        newElement.core$().set((Layer)newElement, "host", Collections.singletonList(host));
        newElement.core$().set((Layer)newElement, "port", Collections.singletonList(port));
        return newElement;
    }

    public boolean isREST() {
        return this.core$().is(REST.class);
    }

    public void removeREST() {
        this.core$().removeAspect(REST.class);
    }

    public RocketChatBot asRocketChatBot() {
        return (RocketChatBot)this.a$(RocketChatBot.class);
    }

    public RocketChatBot asRocketChatBot(String token) {
        RocketChatBot newElement = (RocketChatBot)this.core$().addAspect(RocketChatBot.class);
        newElement.core$().set((Layer)newElement, "token", Collections.singletonList(token));
        return newElement;
    }

    public boolean isRocketChatBot() {
        return this.core$().is(RocketChatBot.class);
    }

    public void removeRocketChatBot() {
        this.core$().removeAspect(RocketChatBot.class);
    }

    public Agenda asAgenda() {
        return (Agenda)this.a$(Agenda.class);
    }

    public Agenda asAgenda(String filePath) {
        Agenda newElement = (Agenda)this.core$().addAspect(Agenda.class);
        newElement.core$().set((Layer)newElement, "filePath", Collections.singletonList(filePath));
        return newElement;
    }

    public boolean isAgenda() {
        return this.core$().is(Agenda.class);
    }

    public void removeAgenda() {
        this.core$().removeAspect(Agenda.class);
    }

    public Messaging asMessaging() {
        return (Messaging)this.a$(Messaging.class);
    }

    public Messaging asMessaging(String context) {
        Messaging newElement = (Messaging)this.core$().addAspect(Messaging.class);
        newElement.core$().set((Layer)newElement, "context", Collections.singletonList(context));
        return newElement;
    }

    public boolean isMessaging() {
        return this.core$().is(Messaging.class);
    }

    public void removeMessaging() {
        this.core$().removeAspect(Messaging.class);
    }

    public SlackBot asSlackBot() {
        return (SlackBot)this.a$(SlackBot.class);
    }

    public SlackBot asSlackBot(String token) {
        SlackBot newElement = (SlackBot)this.core$().addAspect(SlackBot.class);
        newElement.core$().set((Layer)newElement, "token", Collections.singletonList(token));
        return newElement;
    }

    public boolean isSlackBot() {
        return this.core$().is(SlackBot.class);
    }

    public void removeSlackBot() {
        this.core$().removeAspect(SlackBot.class);
    }

    protected List<Node> componentList$() {
        LinkedHashSet components = new LinkedHashSet(super.componentList$());
        new ArrayList<Schema>(this.schemaList).forEach(c -> components.add(c.core$()));
        new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
        return new ArrayList<Node>(components);
    }

    protected Map<String, List<?>> variables$() {
        LinkedHashMap map = new LinkedHashMap();
        return map;
    }

    protected void addNode$(Node node) {
        super.addNode$(node);
        if (node.is("Schema")) {
            this.schemaList.add((Schema)node.as(Schema.class));
        }
        if (node.is("Exception")) {
            this.exceptionList.add((Exception)node.as(Exception.class));
        }
    }

    protected void removeNode$(Node node) {
        super.removeNode$(node);
        if (node.is("Schema")) {
            this.schemaList.remove(node.as(Schema.class));
        }
        if (node.is("Exception")) {
            this.exceptionList.remove(node.as(Exception.class));
        }
    }

    protected void load$(String name, List<?> values) {
        super.load$(name, values);
    }

    protected void set$(String name, List<?> values) {
        super.set$(name, values);
    }

    public Create create() {
        return new Create(null);
    }

    public Create create(String name) {
        return new Create(name);
    }

    public Clear clear() {
        return new Clear();
    }

    public KonosGraph graph() {
        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
    }

    public static class Agenda
    extends Layer
    implements Terminal {
        protected String filePath;
        protected String linkBasePath;
        protected List<Future> futureList = new ArrayList<Future>();
        protected Service _service;

        public Agenda(Node node) {
            super(node);
        }

        public String filePath() {
            return this.filePath;
        }

        public String linkBasePath() {
            return this.linkBasePath;
        }

        public Agenda filePath(String value) {
            this.filePath = value;
            return this;
        }

        public Agenda linkBasePath(String value) {
            this.linkBasePath = value;
            return this;
        }

        public List<Future> futureList() {
            return Collections.unmodifiableList(this.futureList);
        }

        public Future future(int index) {
            return this.futureList.get(index);
        }

        public List<Future> futureList(Predicate<Future> predicate) {
            return this.futureList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Schema> schemaList() {
            return this._service.schemaList();
        }

        public Schema schemaList(int index) {
            return this._service.schemaList().get(index);
        }

        public List<Exception> exceptionList() {
            return this._service.exceptionList();
        }

        public Exception exceptionList(int index) {
            return this._service.exceptionList().get(index);
        }

        public Service asService() {
            return (Service)this.a$(Service.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Future>(this.futureList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("filePath", new ArrayList<String>(Collections.singletonList(this.filePath)));
            map.put("linkBasePath", new ArrayList<String>(Collections.singletonList(this.linkBasePath)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Service$Agenda$Future")) {
                this.futureList.add((Future)node.as(Future.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Service$Agenda$Future")) {
                this.futureList.remove(node.as(Future.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("filePath")) {
                this.filePath = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("linkBasePath")) {
                this.linkBasePath = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("filePath")) {
                this.filePath = (String)values.get(0);
            } else if (name.equalsIgnoreCase("linkBasePath")) {
                this.linkBasePath = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Service) {
                this._service = (Service)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Future
        extends Layer
        implements Terminal {
            protected boolean timeout;
            protected List<Parameter> parameterList = new ArrayList<Parameter>();
            protected List<Option> optionList = new ArrayList<Option>();

            public Future(Node node) {
                super(node);
            }

            public boolean timeout() {
                return this.timeout;
            }

            public Future timeout(boolean value) {
                this.timeout = value;
                return this;
            }

            public List<Parameter> parameterList() {
                return Collections.unmodifiableList(this.parameterList);
            }

            public Parameter parameter(int index) {
                return this.parameterList.get(index);
            }

            public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Option> optionList() {
                return Collections.unmodifiableList(this.optionList);
            }

            public Option option(int index) {
                return this.optionList.get(index);
            }

            public List<Option> optionList(Predicate<Option> predicate) {
                return this.optionList().stream().filter(predicate).collect(Collectors.toList());
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
                new ArrayList<Option>(this.optionList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("timeout", new ArrayList<Boolean>(Collections.singletonList(this.timeout)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Parameter")) {
                    this.parameterList.add((Parameter)node.as(Parameter.class));
                }
                if (node.is("Service$Agenda$Future$Option")) {
                    this.optionList.add((Option)node.as(Option.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Parameter")) {
                    this.parameterList.remove(node.as(Parameter.class));
                }
                if (node.is("Service$Agenda$Future$Option")) {
                    this.optionList.remove(node.as(Option.class));
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("timeout")) {
                    this.timeout = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("timeout")) {
                    this.timeout = (Boolean)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Option
            extends Layer
            implements Terminal {
                protected List<Parameter> parameterList = new ArrayList<Parameter>();

                public Option(Node node) {
                    super(node);
                }

                public List<Parameter> parameterList() {
                    return Collections.unmodifiableList(this.parameterList);
                }

                public Parameter parameter(int index) {
                    return this.parameterList.get(index);
                }

                public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                    return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
                }

                protected List<Node> componentList$() {
                    LinkedHashSet components = new LinkedHashSet(super.componentList$());
                    new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
                    return new ArrayList<Node>(components);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    return map;
                }

                protected void addNode$(Node node) {
                    super.addNode$(node);
                    if (node.is("Parameter")) {
                        this.parameterList.add((Parameter)node.as(Parameter.class));
                    }
                }

                protected void removeNode$(Node node) {
                    super.removeNode$(node);
                    if (node.is("Parameter")) {
                        this.parameterList.remove(node.as(Parameter.class));
                    }
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Clear clear() {
                    return new Clear();
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Clear {
                    public void parameter(Predicate<Parameter> filter) {
                        new ArrayList<Parameter>(Option.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Parameter parameter() {
                        Parameter newElement = (Parameter)Option.this.core$().graph().concept(Parameter.class).createNode(this.name, Option.this.core$()).as(Parameter.class);
                        return newElement;
                    }

                    public REST.Notification.Parameter parameter(REST.Notification.Parameter.In in) {
                        REST.Notification.Parameter newElement = (REST.Notification.Parameter)Option.this.core$().graph().concept(REST.Notification.Parameter.class).createNode(this.name, Option.this.core$()).as(REST.Notification.Parameter.class);
                        newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                        return newElement;
                    }

                    public Soap.Operation.Input input(String xmlns) {
                        Soap.Operation.Input newElement = (Soap.Operation.Input)Option.this.core$().graph().concept(Soap.Operation.Input.class).createNode(this.name, Option.this.core$()).as(Soap.Operation.Input.class);
                        newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                        return newElement;
                    }

                    public REST.Resource.Parameter parameter(REST.Resource.Parameter.In in) {
                        REST.Resource.Parameter newElement = (REST.Resource.Parameter)Option.this.core$().graph().concept(REST.Resource.Parameter.class).createNode(this.name, Option.this.core$()).as(REST.Resource.Parameter.class);
                        newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                        return newElement;
                    }
                }
            }

            public class Clear {
                public void parameter(Predicate<Parameter> filter) {
                    new ArrayList<Parameter>(Future.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void option(Predicate<Option> filter) {
                    new ArrayList<Option>(Future.this.optionList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Parameter parameter() {
                    Parameter newElement = (Parameter)Future.this.core$().graph().concept(Parameter.class).createNode(this.name, Future.this.core$()).as(Parameter.class);
                    return newElement;
                }

                public Option option() {
                    Option newElement = (Option)Future.this.core$().graph().concept(Option.class).createNode(this.name, Future.this.core$()).as(Option.class);
                    return newElement;
                }

                public REST.Notification.Parameter parameter(REST.Notification.Parameter.In in) {
                    REST.Notification.Parameter newElement = (REST.Notification.Parameter)Future.this.core$().graph().concept(REST.Notification.Parameter.class).createNode(this.name, Future.this.core$()).as(REST.Notification.Parameter.class);
                    newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }

                public Soap.Operation.Input input(String xmlns) {
                    Soap.Operation.Input newElement = (Soap.Operation.Input)Future.this.core$().graph().concept(Soap.Operation.Input.class).createNode(this.name, Future.this.core$()).as(Soap.Operation.Input.class);
                    newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                    return newElement;
                }

                public REST.Resource.Parameter parameter(REST.Resource.Parameter.In in) {
                    REST.Resource.Parameter newElement = (REST.Resource.Parameter)Future.this.core$().graph().concept(REST.Resource.Parameter.class).createNode(this.name, Future.this.core$()).as(REST.Resource.Parameter.class);
                    newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }
            }
        }

        public class Clear {
            public void future(Predicate<Future> filter) {
                new ArrayList<Future>(Agenda.this.futureList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void schema(Predicate<Schema> filter) {
                new ArrayList<Schema>(Agenda.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(Agenda.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Future future(boolean timeout) {
                Future newElement = (Future)Agenda.this.core$().graph().concept(Future.class).createNode(this.name, Agenda.this.core$()).as(Future.class);
                newElement.core$().set((Layer)newElement, "timeout", Collections.singletonList(timeout));
                return newElement;
            }

            public Schema schema() {
                Schema newElement = (Schema)Agenda.this.core$().graph().concept(Schema.class).createNode(this.name, Agenda.this.core$()).as(Schema.class);
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Agenda.this.core$().graph().concept(Exception.class).createNode(this.name, Agenda.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }
    }

    public static class UI
    extends Layer
    implements Terminal {
        protected HomesProvider homeList;
        protected TemplatesProvider templates;
        protected String port;
        protected String title;
        protected String favicon;
        protected String googleApiKey;
        protected List<Use> useList = new ArrayList<Use>();
        protected Authentication authentication;
        protected Edition edition;
        protected List<Resource> resourceList = new ArrayList<Resource>();
        protected Service _service;

        public UI(Node node) {
            super(node);
        }

        public List<Resource> homeList() {
            return this.homeList.homeList();
        }

        public List<Template> templates() {
            return this.templates.templates();
        }

        public String port() {
            return this.port;
        }

        public String title() {
            return this.title;
        }

        public String favicon() {
            return this.favicon;
        }

        public String googleApiKey() {
            return this.googleApiKey;
        }

        public UI homeList(HomesProvider value) {
            this.homeList = (HomesProvider)FunctionLoader.load((Object)this.homeList, (Layer)this, HomesProvider.class);
            return this;
        }

        public UI templates(TemplatesProvider value) {
            this.templates = (TemplatesProvider)FunctionLoader.load((Object)this.templates, (Layer)this, TemplatesProvider.class);
            return this;
        }

        public UI port(String value) {
            this.port = value;
            return this;
        }

        public UI title(String value) {
            this.title = value;
            return this;
        }

        public UI favicon(String value) {
            this.favicon = value;
            return this;
        }

        public UI googleApiKey(String value) {
            this.googleApiKey = value;
            return this;
        }

        public List<Use> useList() {
            return Collections.unmodifiableList(this.useList);
        }

        public Use use(int index) {
            return this.useList.get(index);
        }

        public List<Use> useList(Predicate<Use> predicate) {
            return this.useList().stream().filter(predicate).collect(Collectors.toList());
        }

        public Authentication authentication() {
            return this.authentication;
        }

        public Edition edition() {
            return this.edition;
        }

        public List<Resource> resourceList() {
            return Collections.unmodifiableList(this.resourceList);
        }

        public Resource resource(int index) {
            return this.resourceList.get(index);
        }

        public List<Resource> resourceList(Predicate<Resource> predicate) {
            return this.resourceList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Schema> schemaList() {
            return this._service.schemaList();
        }

        public Schema schemaList(int index) {
            return this._service.schemaList().get(index);
        }

        public List<Exception> exceptionList() {
            return this._service.exceptionList();
        }

        public Exception exceptionList(int index) {
            return this._service.exceptionList().get(index);
        }

        public Service asService() {
            return (Service)this.a$(Service.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            new ArrayList<Use>(this.useList).forEach(c -> components.add(c.core$()));
            if (this.authentication != null) {
                components.add(this.authentication.core$());
            }
            if (this.edition != null) {
                components.add(this.edition.core$());
            }
            new ArrayList<Resource>(this.resourceList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("homeList", this.homeList != null ? new ArrayList<HomesProvider>(Collections.singletonList(this.homeList)) : Collections.emptyList());
            map.put("templates", this.templates != null ? new ArrayList<TemplatesProvider>(Collections.singletonList(this.templates)) : Collections.emptyList());
            map.put("port", new ArrayList<String>(Collections.singletonList(this.port)));
            map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
            map.put("favicon", new ArrayList<String>(Collections.singletonList(this.favicon)));
            map.put("googleApiKey", new ArrayList<String>(Collections.singletonList(this.googleApiKey)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Service$UI$Use")) {
                this.useList.add((Use)node.as(Use.class));
            }
            if (node.is("Service$UI$Authentication")) {
                this.authentication = (Authentication)node.as(Authentication.class);
            }
            if (node.is("Service$UI$Edition")) {
                this.edition = (Edition)node.as(Edition.class);
            }
            if (node.is("Service$UI$Resource")) {
                this.resourceList.add((Resource)node.as(Resource.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Service$UI$Use")) {
                this.useList.remove(node.as(Use.class));
            }
            if (node.is("Service$UI$Authentication")) {
                this.authentication = null;
            }
            if (node.is("Service$UI$Edition")) {
                this.edition = null;
            }
            if (node.is("Service$UI$Resource")) {
                this.resourceList.remove(node.as(Resource.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("homeList")) {
                this.homeList = (HomesProvider)FunctionLoader.load(values, (Layer)this, HomesProvider.class).get(0);
            } else if (name.equalsIgnoreCase("templates")) {
                this.templates = (TemplatesProvider)FunctionLoader.load(values, (Layer)this, TemplatesProvider.class).get(0);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("title")) {
                this.title = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("favicon")) {
                this.favicon = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("googleApiKey")) {
                this.googleApiKey = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("homeList")) {
                this.homeList = (HomesProvider)FunctionLoader.load(values.get(0), (Layer)this, HomesProvider.class);
            } else if (name.equalsIgnoreCase("templates")) {
                this.templates = (TemplatesProvider)FunctionLoader.load(values.get(0), (Layer)this, TemplatesProvider.class);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = (String)values.get(0);
            } else if (name.equalsIgnoreCase("title")) {
                this.title = (String)values.get(0);
            } else if (name.equalsIgnoreCase("favicon")) {
                this.favicon = (String)values.get(0);
            } else if (name.equalsIgnoreCase("googleApiKey")) {
                this.googleApiKey = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Service) {
                this._service = (Service)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Resource
        extends Layer
        implements Terminal {
            protected String path;
            protected List<Parameter> parameterList = new ArrayList<Parameter>();
            protected Main _main;
            protected Confidential _confidential;
            protected Page _page;

            public Resource(Node node) {
                super(node);
            }

            public String path() {
                return this.path;
            }

            public Resource path(String value) {
                this.path = value;
                return this;
            }

            public List<Parameter> parameterList() {
                return Collections.unmodifiableList(this.parameterList);
            }

            public Parameter parameter(int index) {
                return this.parameterList.get(index);
            }

            public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
            }

            public Page asPage() {
                return (Page)this.a$(Page.class);
            }

            public Page asPage(Template template) {
                Page newElement = (Page)this.core$().addAspect(Page.class);
                newElement.core$().set((Layer)newElement, "template", Collections.singletonList(template));
                return newElement;
            }

            public boolean isPage() {
                return this.core$().is(Page.class);
            }

            public void removePage() {
                this.core$().removeAspect(Page.class);
            }

            public Confidential asConfidential() {
                Layer as = this.a$(Confidential.class);
                return as != null ? (Confidential)as : (Confidential)this.core$().addAspect(Confidential.class);
            }

            public boolean isConfidential() {
                return this.core$().is(Confidential.class);
            }

            public Main asMain() {
                Layer as = this.a$(Main.class);
                return as != null ? (Main)as : (Main)this.core$().addAspect(Main.class);
            }

            public boolean isMain() {
                return this.core$().is(Main.class);
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Parameter")) {
                    this.parameterList.add((Parameter)node.as(Parameter.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Parameter")) {
                    this.parameterList.remove(node.as(Parameter.class));
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Page
            extends Layer
            implements Terminal {
                protected Template template;
                protected Resource _resource;

                public Page(Node node) {
                    super(node);
                }

                public Template template() {
                    return this.template;
                }

                public String path() {
                    return this._resource.path();
                }

                public Page template(Template value) {
                    this.template = value;
                    return this;
                }

                public Page path(String value) {
                    this._resource.path(value);
                    return this;
                }

                public List<Parameter> parameterList() {
                    return this._resource.parameterList();
                }

                public Parameter parameterList(int index) {
                    return this._resource.parameterList().get(index);
                }

                public Resource asResource() {
                    return (Resource)this.a$(Resource.class);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("template", this.template != null ? new ArrayList<Template>(Collections.singletonList(this.template)) : Collections.emptyList());
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("template")) {
                        this.template = (Template)((Object)NodeLoader.load(values, Template.class, (Layer)this).get(0));
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("template")) {
                        this.template = values.get(0) != null ? (Template)this.core$().graph().load(((Layer)values.get(0)).core$().id()).as(Template.class) : null;
                    }
                }

                protected void sync$(Layer layer) {
                    super.sync$(layer);
                    if (layer instanceof Resource) {
                        this._resource = (Resource)layer;
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Clear clear() {
                    return new Clear();
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Clear {
                    public void parameter(Predicate<Parameter> filter) {
                        new ArrayList<Parameter>(Page.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Parameter parameter() {
                        Parameter newElement = (Parameter)Page.this.core$().graph().concept(Parameter.class).createNode(this.name, Page.this.core$()).as(Parameter.class);
                        return newElement;
                    }
                }
            }

            public static class Confidential
            extends Layer
            implements Terminal {
                protected Resource _resource;

                public Confidential(Node node) {
                    super(node);
                }

                public String path() {
                    return this._resource.path();
                }

                public Confidential path(String value) {
                    this._resource.path(value);
                    return this;
                }

                public List<Parameter> parameterList() {
                    return this._resource.parameterList();
                }

                public Parameter parameterList(int index) {
                    return this._resource.parameterList().get(index);
                }

                public Resource asResource() {
                    return (Resource)this.a$(Resource.class);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                protected void sync$(Layer layer) {
                    super.sync$(layer);
                    if (layer instanceof Resource) {
                        this._resource = (Resource)layer;
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Clear clear() {
                    return new Clear();
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Clear {
                    public void parameter(Predicate<Parameter> filter) {
                        new ArrayList<Parameter>(Confidential.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Parameter parameter() {
                        Parameter newElement = (Parameter)Confidential.this.core$().graph().concept(Parameter.class).createNode(this.name, Confidential.this.core$()).as(Parameter.class);
                        return newElement;
                    }
                }
            }

            public static class Main
            extends Layer
            implements Terminal {
                protected Resource _resource;

                public Main(Node node) {
                    super(node);
                }

                public String path() {
                    return this._resource.path();
                }

                public Main path(String value) {
                    this._resource.path(value);
                    return this;
                }

                public List<Parameter> parameterList() {
                    return this._resource.parameterList();
                }

                public Parameter parameterList(int index) {
                    return this._resource.parameterList().get(index);
                }

                public Resource asResource() {
                    return (Resource)this.a$(Resource.class);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                protected void sync$(Layer layer) {
                    super.sync$(layer);
                    if (layer instanceof Resource) {
                        this._resource = (Resource)layer;
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Clear clear() {
                    return new Clear();
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Clear {
                    public void parameter(Predicate<Parameter> filter) {
                        new ArrayList<Parameter>(Main.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Parameter parameter() {
                        Parameter newElement = (Parameter)Main.this.core$().graph().concept(Parameter.class).createNode(this.name, Main.this.core$()).as(Parameter.class);
                        return newElement;
                    }
                }
            }

            public class Clear {
                public void parameter(Predicate<Parameter> filter) {
                    new ArrayList<Parameter>(Resource.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Parameter parameter() {
                    Parameter newElement = (Parameter)Resource.this.core$().graph().concept(Parameter.class).createNode(this.name, Resource.this.core$()).as(Parameter.class);
                    return newElement;
                }

                public REST.Notification.Parameter parameter(REST.Notification.Parameter.In in) {
                    REST.Notification.Parameter newElement = (REST.Notification.Parameter)Resource.this.core$().graph().concept(REST.Notification.Parameter.class).createNode(this.name, Resource.this.core$()).as(REST.Notification.Parameter.class);
                    newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }

                public Soap.Operation.Input input(String xmlns) {
                    Soap.Operation.Input newElement = (Soap.Operation.Input)Resource.this.core$().graph().concept(Soap.Operation.Input.class).createNode(this.name, Resource.this.core$()).as(Soap.Operation.Input.class);
                    newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                    return newElement;
                }

                public REST.Resource.Parameter parameter(REST.Resource.Parameter.In in) {
                    REST.Resource.Parameter newElement = (REST.Resource.Parameter)Resource.this.core$().graph().concept(REST.Resource.Parameter.class).createNode(this.name, Resource.this.core$()).as(REST.Resource.Parameter.class);
                    newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }
            }
        }

        public static class Edition
        extends Layer
        implements Terminal {
            protected String by;

            public Edition(Node node) {
                super(node);
            }

            public String by() {
                return this.by;
            }

            public Edition by(String value) {
                this.by = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("by", new ArrayList<String>(Collections.singletonList(this.by)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("by")) {
                    this.by = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("by")) {
                    this.by = (String)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Authentication
        extends Layer
        implements Terminal {
            protected String by;

            public Authentication(Node node) {
                super(node);
            }

            public String by() {
                return this.by;
            }

            public Authentication by(String value) {
                this.by = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("by", new ArrayList<String>(Collections.singletonList(this.by)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("by")) {
                    this.by = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("by")) {
                    this.by = (String)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Use
        extends Layer
        implements Terminal {
            protected String package$;
            protected String name;
            protected String service;
            protected String url;

            public Use(Node node) {
                super(node);
            }

            public String package$() {
                return this.package$;
            }

            public String name() {
                return this.name;
            }

            public String service() {
                return this.service;
            }

            public String url() {
                return this.url;
            }

            public Use package$(String value) {
                this.package$ = value;
                return this;
            }

            public Use name(String value) {
                this.name = value;
                return this;
            }

            public Use service(String value) {
                this.service = value;
                return this;
            }

            public Use url(String value) {
                this.url = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("package", new ArrayList<String>(Collections.singletonList(this.package$)));
                map.put("name", new ArrayList<String>(Collections.singletonList(this.name)));
                map.put("service", new ArrayList<String>(Collections.singletonList(this.service)));
                map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("package")) {
                    this.package$ = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("name")) {
                    this.name = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("service")) {
                    this.service = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("url")) {
                    this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("package")) {
                    this.package$ = (String)values.get(0);
                } else if (name.equalsIgnoreCase("name")) {
                    this.name = (String)values.get(0);
                } else if (name.equalsIgnoreCase("service")) {
                    this.service = (String)values.get(0);
                } else if (name.equalsIgnoreCase("url")) {
                    this.url = (String)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public class Clear {
            public void use(Predicate<Use> filter) {
                new ArrayList<Use>(UI.this.useList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void resource(Predicate<Resource> filter) {
                new ArrayList<Resource>(UI.this.resourceList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void schema(Predicate<Schema> filter) {
                new ArrayList<Schema>(UI.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(UI.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Use use(String package$, String name, String service) {
                Use newElement = (Use)UI.this.core$().graph().concept(Use.class).createNode(this.name, UI.this.core$()).as(Use.class);
                newElement.core$().set((Layer)newElement, "package", Collections.singletonList(package$));
                newElement.core$().set((Layer)newElement, "name", Collections.singletonList(name));
                newElement.core$().set((Layer)newElement, "service", Collections.singletonList(service));
                return newElement;
            }

            public Authentication authentication(String by) {
                Authentication newElement = (Authentication)UI.this.core$().graph().concept(Authentication.class).createNode(this.name, UI.this.core$()).as(Authentication.class);
                newElement.core$().set((Layer)newElement, "by", Collections.singletonList(by));
                return newElement;
            }

            public Edition edition(String by) {
                Edition newElement = (Edition)UI.this.core$().graph().concept(Edition.class).createNode(this.name, UI.this.core$()).as(Edition.class);
                newElement.core$().set((Layer)newElement, "by", Collections.singletonList(by));
                return newElement;
            }

            public Resource resource(String path) {
                Resource newElement = (Resource)UI.this.core$().graph().concept(Resource.class).createNode(this.name, UI.this.core$()).as(Resource.class);
                newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
                return newElement;
            }

            public Schema schema() {
                Schema newElement = (Schema)UI.this.core$().graph().concept(Schema.class).createNode(this.name, UI.this.core$()).as(Schema.class);
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)UI.this.core$().graph().concept(Exception.class).createNode(this.name, UI.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }
    }

    public static class RocketChatBot
    extends SlackBot
    implements Terminal {
        protected Service _service;

        public RocketChatBot(Node node) {
            super(node);
        }

        @Override
        public List<Schema> schemaList() {
            return this._service.schemaList();
        }

        @Override
        public Schema schemaList(int index) {
            return this._service.schemaList().get(index);
        }

        @Override
        public List<Exception> exceptionList() {
            return this._service.exceptionList();
        }

        @Override
        public Exception exceptionList(int index) {
            return this._service.exceptionList().get(index);
        }

        @Override
        public Service asService() {
            return (Service)this.a$(Service.class);
        }

        @Override
        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap(super.variables$());
            return map;
        }

        @Override
        protected void load$(String name, List<?> values) {
            super.load$(name, values);
        }

        @Override
        protected void set$(String name, List<?> values) {
            super.set$(name, values);
        }

        @Override
        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Service) {
                this._service = (Service)layer;
            }
        }

        @Override
        public Create create() {
            return new Create(null);
        }

        @Override
        public Create create(String name) {
            return new Create(name);
        }

        @Override
        public Clear clear() {
            return new Clear();
        }

        @Override
        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public class Clear
        extends SlackBot.Clear {
            @Override
            public void schema(Predicate<Schema> filter) {
                new ArrayList<Schema>(RocketChatBot.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
            }

            @Override
            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(RocketChatBot.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create
        extends SlackBot.Create {
            public Create(String name) {
                super(name);
            }

            @Override
            public Schema schema() {
                Schema newElement = (Schema)RocketChatBot.this.core$().graph().concept(Schema.class).createNode(this.name, RocketChatBot.this.core$()).as(Schema.class);
                return newElement;
            }

            @Override
            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)RocketChatBot.this.core$().graph().concept(Exception.class).createNode(this.name, RocketChatBot.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }
    }

    public static class SlackBot
    extends Layer
    implements Terminal {
        protected String token;
        protected List<Notification> notificationList = new ArrayList<Notification>();
        protected List<Request> requestList = new ArrayList<Request>();
        protected Service _service;

        public SlackBot(Node node) {
            super(node);
        }

        public String token() {
            return this.token;
        }

        public SlackBot token(String value) {
            this.token = value;
            return this;
        }

        public List<Notification> notificationList() {
            return Collections.unmodifiableList(this.notificationList);
        }

        public Notification notification(int index) {
            return this.notificationList.get(index);
        }

        public List<Notification> notificationList(Predicate<Notification> predicate) {
            return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Request> requestList() {
            return Collections.unmodifiableList(this.requestList);
        }

        public Request request(int index) {
            return this.requestList.get(index);
        }

        public List<Request> requestList(Predicate<Request> predicate) {
            return this.requestList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Schema> schemaList() {
            return this._service.schemaList();
        }

        public Schema schemaList(int index) {
            return this._service.schemaList().get(index);
        }

        public List<Exception> exceptionList() {
            return this._service.exceptionList();
        }

        public Exception exceptionList(int index) {
            return this._service.exceptionList().get(index);
        }

        public Service asService() {
            return (Service)this.a$(Service.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Notification>(this.notificationList).forEach(c -> components.add(c.core$()));
            new ArrayList<Request>(this.requestList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("token", new ArrayList<String>(Collections.singletonList(this.token)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Service$SlackBot$Notification")) {
                this.notificationList.add((Notification)node.as(Notification.class));
            }
            if (node.is("Service$SlackBot$Request")) {
                this.requestList.add((Request)node.as(Request.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Service$SlackBot$Notification")) {
                this.notificationList.remove(node.as(Notification.class));
            }
            if (node.is("Service$SlackBot$Request")) {
                this.requestList.remove(node.as(Request.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("token")) {
                this.token = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("token")) {
                this.token = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Service) {
                this._service = (Service)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Request
        extends Layer
        implements Terminal {
            protected String description;
            protected ResponseType responseType;
            protected List<Parameter> parameterList = new ArrayList<Parameter>();
            protected List<Request> requestList = new ArrayList<Request>();

            public Request(Node node) {
                super(node);
            }

            public String description() {
                return this.description;
            }

            public ResponseType responseType() {
                return this.responseType;
            }

            public Request description(String value) {
                this.description = value;
                return this;
            }

            public Request responseType(ResponseType value) {
                this.responseType = value;
                return this;
            }

            public List<Parameter> parameterList() {
                return Collections.unmodifiableList(this.parameterList);
            }

            public Parameter parameter(int index) {
                return this.parameterList.get(index);
            }

            public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Request> requestList() {
                return Collections.unmodifiableList(this.requestList);
            }

            public Request request(int index) {
                return this.requestList.get(index);
            }

            public List<Request> requestList(Predicate<Request> predicate) {
                return this.requestList().stream().filter(predicate).collect(Collectors.toList());
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
                new ArrayList<Request>(this.requestList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                map.put("responseType", new ArrayList<ResponseType>(Collections.singletonList(this.responseType)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Service$SlackBot$Request$Parameter")) {
                    this.parameterList.add((Parameter)node.as(Parameter.class));
                }
                if (node.is("Service$SlackBot$Request")) {
                    this.requestList.add((Request)node.as(Request.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Service$SlackBot$Request$Parameter")) {
                    this.parameterList.remove(node.as(Parameter.class));
                }
                if (node.is("Service$SlackBot$Request")) {
                    this.requestList.remove(node.as(Request.class));
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("responseType")) {
                    this.responseType = (ResponseType)((Object)WordLoader.load(values, ResponseType.class, (Layer)this).get(0));
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)values.get(0);
                } else if (name.equalsIgnoreCase("responseType")) {
                    this.responseType = (ResponseType)((Object)values.get(0));
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Parameter
            extends Layer
            implements Terminal {
                protected Type type;
                protected boolean multiple;

                public Parameter(Node node) {
                    super(node);
                }

                public Type type() {
                    return this.type;
                }

                public boolean multiple() {
                    return this.multiple;
                }

                public Parameter type(Type value) {
                    this.type = value;
                    return this;
                }

                public Parameter multiple(boolean value) {
                    this.multiple = value;
                    return this;
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("type", new ArrayList<Type>(Collections.singletonList(this.type)));
                    map.put("multiple", new ArrayList<Boolean>(Collections.singletonList(this.multiple)));
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("type")) {
                        this.type = (Type)((Object)WordLoader.load(values, Type.class, (Layer)this).get(0));
                    } else if (name.equalsIgnoreCase("multiple")) {
                        this.multiple = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("type")) {
                        this.type = (Type)((Object)values.get(0));
                    } else if (name.equalsIgnoreCase("multiple")) {
                        this.multiple = (Boolean)values.get(0);
                    }
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public static enum Type {
                    Boolean,
                    String,
                    Double,
                    Integer;

                }
            }

            public class Clear {
                public void parameter(Predicate<Parameter> filter) {
                    new ArrayList<Parameter>(Request.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void request(Predicate<Request> filter) {
                    new ArrayList<Request>(Request.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Parameter parameter(Parameter.Type type) {
                    Parameter newElement = (Parameter)Request.this.core$().graph().concept(Parameter.class).createNode(this.name, Request.this.core$()).as(Parameter.class);
                    newElement.core$().set((Layer)newElement, "type", Collections.singletonList(type));
                    return newElement;
                }

                public Request request(String description) {
                    Request newElement = (Request)Request.this.core$().graph().concept(Request.class).createNode(this.name, Request.this.core$()).as(Request.class);
                    newElement.core$().set((Layer)newElement, "description", Collections.singletonList(description));
                    return newElement;
                }
            }

            public static enum ResponseType {
                Text,
                Attachment;

            }
        }

        public static class Notification
        extends Layer
        implements Terminal {
            protected String channel;

            public Notification(Node node) {
                super(node);
            }

            public String channel() {
                return this.channel;
            }

            public Notification channel(String value) {
                this.channel = value;
                return this;
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("channel", new ArrayList<String>(Collections.singletonList(this.channel)));
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("channel")) {
                    this.channel = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("channel")) {
                    this.channel = (String)values.get(0);
                }
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public class Clear {
            public void notification(Predicate<Notification> filter) {
                new ArrayList<Notification>(SlackBot.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void request(Predicate<Request> filter) {
                new ArrayList<Request>(SlackBot.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void schema(Predicate<Schema> filter) {
                new ArrayList<Schema>(SlackBot.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(SlackBot.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Notification notification(String channel) {
                Notification newElement = (Notification)SlackBot.this.core$().graph().concept(Notification.class).createNode(this.name, SlackBot.this.core$()).as(Notification.class);
                newElement.core$().set((Layer)newElement, "channel", Collections.singletonList(channel));
                return newElement;
            }

            public Request request(String description) {
                Request newElement = (Request)SlackBot.this.core$().graph().concept(Request.class).createNode(this.name, SlackBot.this.core$()).as(Request.class);
                newElement.core$().set((Layer)newElement, "description", Collections.singletonList(description));
                return newElement;
            }

            public Schema schema() {
                Schema newElement = (Schema)SlackBot.this.core$().graph().concept(Schema.class).createNode(this.name, SlackBot.this.core$()).as(Schema.class);
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)SlackBot.this.core$().graph().concept(Exception.class).createNode(this.name, SlackBot.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }
    }

    public static class Messaging
    extends Layer
    implements Terminal {
        protected String context;
        protected SubscriptionModel subscriptionModel;
        protected List<Request> requestList = new ArrayList<Request>();
        protected Service _service;

        public Messaging(Node node) {
            super(node);
        }

        public String context() {
            return this.context;
        }

        public SubscriptionModel subscriptionModel() {
            return this.subscriptionModel;
        }

        public Messaging context(String value) {
            this.context = value;
            return this;
        }

        public Messaging subscriptionModel(SubscriptionModel value) {
            this.subscriptionModel = value;
            return this;
        }

        public List<Request> requestList() {
            return Collections.unmodifiableList(this.requestList);
        }

        public Request request(int index) {
            return this.requestList.get(index);
        }

        public List<Request> requestList(Predicate<Request> predicate) {
            return this.requestList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Schema> schemaList() {
            return this._service.schemaList();
        }

        public Schema schemaList(int index) {
            return this._service.schemaList().get(index);
        }

        public List<Exception> exceptionList() {
            return this._service.exceptionList();
        }

        public Exception exceptionList(int index) {
            return this._service.exceptionList().get(index);
        }

        public Service asService() {
            return (Service)this.a$(Service.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Request>(this.requestList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("context", new ArrayList<String>(Collections.singletonList(this.context)));
            map.put("subscriptionModel", new ArrayList<SubscriptionModel>(Collections.singletonList(this.subscriptionModel)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Service$Messaging$Request")) {
                this.requestList.add((Request)node.as(Request.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Service$Messaging$Request")) {
                this.requestList.remove(node.as(Request.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("context")) {
                this.context = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("subscriptionModel")) {
                this.subscriptionModel = (SubscriptionModel)((Object)WordLoader.load(values, SubscriptionModel.class, (Layer)this).get(0));
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("context")) {
                this.context = (String)values.get(0);
            } else if (name.equalsIgnoreCase("subscriptionModel")) {
                this.subscriptionModel = (SubscriptionModel)((Object)values.get(0));
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Service) {
                this._service = (Service)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Request
        extends Layer
        implements Terminal {
            protected String path;
            protected Parameter parameter;
            protected List<Exception> exceptionList = new ArrayList<Exception>();
            protected Response response;

            public Request(Node node) {
                super(node);
            }

            public String path() {
                return this.path;
            }

            public Request path(String value) {
                this.path = value;
                return this;
            }

            public Parameter parameter() {
                return this.parameter;
            }

            public List<Exception> exceptionList() {
                return Collections.unmodifiableList(this.exceptionList);
            }

            public Exception exception(int index) {
                return this.exceptionList.get(index);
            }

            public List<Exception> exceptionList(Predicate<Exception> predicate) {
                return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
            }

            public Response response() {
                return this.response;
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.parameter != null) {
                    components.add(this.parameter.core$());
                }
                new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
                if (this.response != null) {
                    components.add(this.response.core$());
                }
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Parameter")) {
                    this.parameter = (Parameter)node.as(Parameter.class);
                }
                if (node.is("Exception")) {
                    this.exceptionList.add((Exception)node.as(Exception.class));
                }
                if (node.is("Response")) {
                    this.response = (Response)node.as(Response.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Parameter")) {
                    this.parameter = null;
                }
                if (node.is("Exception")) {
                    this.exceptionList.remove(node.as(Exception.class));
                }
                if (node.is("Response")) {
                    this.response = null;
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void exception(Predicate<Exception> filter) {
                    new ArrayList<Exception>(Request.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Parameter parameter() {
                    Parameter newElement = (Parameter)Request.this.core$().graph().concept(Parameter.class).createNode(this.name, Request.this.core$()).as(Parameter.class);
                    return newElement;
                }

                public Exception exception(ExceptionCodes code) {
                    Exception newElement = (Exception)Request.this.core$().graph().concept(Exception.class).createNode(this.name, Request.this.core$()).as(Exception.class);
                    newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                    return newElement;
                }

                public Response response() {
                    Response newElement = (Response)Request.this.core$().graph().concept(Response.class).createNode(this.name, Request.this.core$()).as(Response.class);
                    return newElement;
                }

                public REST.Notification.Parameter parameter(REST.Notification.Parameter.In in) {
                    REST.Notification.Parameter newElement = (REST.Notification.Parameter)Request.this.core$().graph().concept(REST.Notification.Parameter.class).createNode(this.name, Request.this.core$()).as(REST.Notification.Parameter.class);
                    newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }

                public Soap.Operation.Input input(String xmlns) {
                    Soap.Operation.Input newElement = (Soap.Operation.Input)Request.this.core$().graph().concept(Soap.Operation.Input.class).createNode(this.name, Request.this.core$()).as(Soap.Operation.Input.class);
                    newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                    return newElement;
                }

                public REST.Resource.Parameter parameter(REST.Resource.Parameter.In in) {
                    REST.Resource.Parameter newElement = (REST.Resource.Parameter)Request.this.core$().graph().concept(REST.Resource.Parameter.class).createNode(this.name, Request.this.core$()).as(REST.Resource.Parameter.class);
                    newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }

                public Soap.Operation.Output output(String xmlns) {
                    Soap.Operation.Output newElement = (Soap.Operation.Output)Request.this.core$().graph().concept(Soap.Operation.Output.class).createNode(this.name, Request.this.core$()).as(Soap.Operation.Output.class);
                    newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                    return newElement;
                }

                public Redirect redirect() {
                    Redirect newElement = (Redirect)Request.this.core$().graph().concept(Redirect.class).createNode(this.name, Request.this.core$()).as(Redirect.class);
                    return newElement;
                }
            }
        }

        public class Clear {
            public void request(Predicate<Request> filter) {
                new ArrayList<Request>(Messaging.this.requestList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void schema(Predicate<Schema> filter) {
                new ArrayList<Schema>(Messaging.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(Messaging.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Request request(String path) {
                Request newElement = (Request)Messaging.this.core$().graph().concept(Request.class).createNode(this.name, Messaging.this.core$()).as(Request.class);
                newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
                return newElement;
            }

            public Schema schema() {
                Schema newElement = (Schema)Messaging.this.core$().graph().concept(Schema.class).createNode(this.name, Messaging.this.core$()).as(Schema.class);
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Messaging.this.core$().graph().concept(Exception.class).createNode(this.name, Messaging.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }

        public static enum SubscriptionModel {
            Queue,
            Topic;

        }
    }

    public static class JMX
    extends Layer
    implements Terminal {
        protected String path;
        protected List<Operation> operationList = new ArrayList<Operation>();
        protected List<Notification> notificationList = new ArrayList<Notification>();
        protected Service _service;

        public JMX(Node node) {
            super(node);
        }

        public String path() {
            return this.path;
        }

        public JMX path(String value) {
            this.path = value;
            return this;
        }

        public List<Operation> operationList() {
            return Collections.unmodifiableList(this.operationList);
        }

        public Operation operation(int index) {
            return this.operationList.get(index);
        }

        public List<Operation> operationList(Predicate<Operation> predicate) {
            return this.operationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Notification> notificationList() {
            return Collections.unmodifiableList(this.notificationList);
        }

        public Notification notification(int index) {
            return this.notificationList.get(index);
        }

        public List<Notification> notificationList(Predicate<Notification> predicate) {
            return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Schema> schemaList() {
            return this._service.schemaList();
        }

        public Schema schemaList(int index) {
            return this._service.schemaList().get(index);
        }

        public List<Exception> exceptionList() {
            return this._service.exceptionList();
        }

        public Exception exceptionList(int index) {
            return this._service.exceptionList().get(index);
        }

        public Service asService() {
            return (Service)this.a$(Service.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
            new ArrayList<Notification>(this.notificationList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Service$JMX$Operation")) {
                this.operationList.add((Operation)node.as(Operation.class));
            }
            if (node.is("Service$JMX$Notification")) {
                this.notificationList.add((Notification)node.as(Notification.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Service$JMX$Operation")) {
                this.operationList.remove(node.as(Operation.class));
            }
            if (node.is("Service$JMX$Notification")) {
                this.notificationList.remove(node.as(Notification.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("path")) {
                this.path = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Service) {
                this._service = (Service)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Notification
        extends Layer
        implements Terminal {
            public Notification(Node node) {
                super(node);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }
        }

        public static class Operation
        extends Layer
        implements Terminal {
            protected String description;
            protected List<Parameter> parameterList = new ArrayList<Parameter>();
            protected List<Exception> exceptionList = new ArrayList<Exception>();
            protected Response response;

            public Operation(Node node) {
                super(node);
            }

            public String description() {
                return this.description;
            }

            public Operation description(String value) {
                this.description = value;
                return this;
            }

            public List<Parameter> parameterList() {
                return Collections.unmodifiableList(this.parameterList);
            }

            public Parameter parameter(int index) {
                return this.parameterList.get(index);
            }

            public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Exception> exceptionList() {
                return Collections.unmodifiableList(this.exceptionList);
            }

            public Exception exception(int index) {
                return this.exceptionList.get(index);
            }

            public List<Exception> exceptionList(Predicate<Exception> predicate) {
                return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
            }

            public Response response() {
                return this.response;
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
                new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
                if (this.response != null) {
                    components.add(this.response.core$());
                }
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Parameter")) {
                    this.parameterList.add((Parameter)node.as(Parameter.class));
                }
                if (node.is("Exception")) {
                    this.exceptionList.add((Exception)node.as(Exception.class));
                }
                if (node.is("Response")) {
                    this.response = (Response)node.as(Response.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Parameter")) {
                    this.parameterList.remove(node.as(Parameter.class));
                }
                if (node.is("Exception")) {
                    this.exceptionList.remove(node.as(Exception.class));
                }
                if (node.is("Response")) {
                    this.response = null;
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public class Clear {
                public void parameter(Predicate<Parameter> filter) {
                    new ArrayList<Parameter>(Operation.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void exception(Predicate<Exception> filter) {
                    new ArrayList<Exception>(Operation.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Parameter parameter() {
                    Parameter newElement = (Parameter)Operation.this.core$().graph().concept(Parameter.class).createNode(this.name, Operation.this.core$()).as(Parameter.class);
                    return newElement;
                }

                public Exception exception(ExceptionCodes code) {
                    Exception newElement = (Exception)Operation.this.core$().graph().concept(Exception.class).createNode(this.name, Operation.this.core$()).as(Exception.class);
                    newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                    return newElement;
                }

                public Response response() {
                    Response newElement = (Response)Operation.this.core$().graph().concept(Response.class).createNode(this.name, Operation.this.core$()).as(Response.class);
                    return newElement;
                }

                public REST.Notification.Parameter parameter(REST.Notification.Parameter.In in) {
                    REST.Notification.Parameter newElement = (REST.Notification.Parameter)Operation.this.core$().graph().concept(REST.Notification.Parameter.class).createNode(this.name, Operation.this.core$()).as(REST.Notification.Parameter.class);
                    newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }

                public Soap.Operation.Input input(String xmlns) {
                    Soap.Operation.Input newElement = (Soap.Operation.Input)Operation.this.core$().graph().concept(Soap.Operation.Input.class).createNode(this.name, Operation.this.core$()).as(Soap.Operation.Input.class);
                    newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                    return newElement;
                }

                public REST.Resource.Parameter parameter(REST.Resource.Parameter.In in) {
                    REST.Resource.Parameter newElement = (REST.Resource.Parameter)Operation.this.core$().graph().concept(REST.Resource.Parameter.class).createNode(this.name, Operation.this.core$()).as(REST.Resource.Parameter.class);
                    newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }

                public Soap.Operation.Output output(String xmlns) {
                    Soap.Operation.Output newElement = (Soap.Operation.Output)Operation.this.core$().graph().concept(Soap.Operation.Output.class).createNode(this.name, Operation.this.core$()).as(Soap.Operation.Output.class);
                    newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                    return newElement;
                }

                public Redirect redirect() {
                    Redirect newElement = (Redirect)Operation.this.core$().graph().concept(Redirect.class).createNode(this.name, Operation.this.core$()).as(Redirect.class);
                    return newElement;
                }
            }
        }

        public class Clear {
            public void operation(Predicate<Operation> filter) {
                new ArrayList<Operation>(JMX.this.operationList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<Notification> filter) {
                new ArrayList<Notification>(JMX.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void schema(Predicate<Schema> filter) {
                new ArrayList<Schema>(JMX.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(JMX.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Operation operation(String description) {
                Operation newElement = (Operation)JMX.this.core$().graph().concept(Operation.class).createNode(this.name, JMX.this.core$()).as(Operation.class);
                newElement.core$().set((Layer)newElement, "description", Collections.singletonList(description));
                return newElement;
            }

            public Notification notification() {
                Notification newElement = (Notification)JMX.this.core$().graph().concept(Notification.class).createNode(this.name, JMX.this.core$()).as(Notification.class);
                return newElement;
            }

            public Schema schema() {
                Schema newElement = (Schema)JMX.this.core$().graph().concept(Schema.class).createNode(this.name, JMX.this.core$()).as(Schema.class);
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)JMX.this.core$().graph().concept(Exception.class).createNode(this.name, JMX.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }
    }

    public static class Soap
    extends Layer
    implements Terminal {
        protected String host;
        protected String port;
        protected String basePath;
        protected List<Operation> operationList = new ArrayList<Operation>();
        protected Service _service;

        public Soap(Node node) {
            super(node);
        }

        public String host() {
            return this.host;
        }

        public String port() {
            return this.port;
        }

        public String basePath() {
            return this.basePath;
        }

        public Soap host(String value) {
            this.host = value;
            return this;
        }

        public Soap port(String value) {
            this.port = value;
            return this;
        }

        public Soap basePath(String value) {
            this.basePath = value;
            return this;
        }

        public List<Operation> operationList() {
            return Collections.unmodifiableList(this.operationList);
        }

        public Operation operation(int index) {
            return this.operationList.get(index);
        }

        public List<Operation> operationList(Predicate<Operation> predicate) {
            return this.operationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Schema> schemaList() {
            return this._service.schemaList();
        }

        public Schema schemaList(int index) {
            return this._service.schemaList().get(index);
        }

        public List<Exception> exceptionList() {
            return this._service.exceptionList();
        }

        public Exception exceptionList(int index) {
            return this._service.exceptionList().get(index);
        }

        public Service asService() {
            return (Service)this.a$(Service.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet components = new LinkedHashSet(super.componentList$());
            new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("host", new ArrayList<String>(Collections.singletonList(this.host)));
            map.put("port", new ArrayList<String>(Collections.singletonList(this.port)));
            map.put("basePath", new ArrayList<String>(Collections.singletonList(this.basePath)));
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Service$Soap$Operation")) {
                this.operationList.add((Operation)node.as(Operation.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Service$Soap$Operation")) {
                this.operationList.remove(node.as(Operation.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("host")) {
                this.host = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("basePath")) {
                this.basePath = (String)StringLoader.load(values, (Layer)this).get(0);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("host")) {
                this.host = (String)values.get(0);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = (String)values.get(0);
            } else if (name.equalsIgnoreCase("basePath")) {
                this.basePath = (String)values.get(0);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Service) {
                this._service = (Service)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Operation
        extends Layer
        implements Terminal {
            protected String path;
            protected String description;
            protected Input input;
            protected Output output;

            public Operation(Node node) {
                super(node);
            }

            public String path() {
                return this.path;
            }

            public String description() {
                return this.description;
            }

            public Operation path(String value) {
                this.path = value;
                return this;
            }

            public Operation description(String value) {
                this.description = value;
                return this;
            }

            public Input input() {
                return this.input;
            }

            public Output output() {
                return this.output;
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.input != null) {
                    components.add(this.input.core$());
                }
                if (this.output != null) {
                    components.add(this.output.core$());
                }
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
                map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Service$Soap$Operation$Input")) {
                    this.input = (Input)node.as(Input.class);
                }
                if (node.is("Service$Soap$Operation$Output")) {
                    this.output = (Output)node.as(Output.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Service$Soap$Operation$Input")) {
                    this.input = null;
                }
                if (node.is("Service$Soap$Operation$Output")) {
                    this.output = null;
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (String)values.get(0);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Output
            extends Response
            implements Component,
            Terminal {
                protected String xmlns;

                public Output(Node node) {
                    super(node);
                }

                public String xmlns() {
                    return this.xmlns;
                }

                public Output xmlns(String value) {
                    this.xmlns = value;
                    return this;
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    map.put("xmlns", new ArrayList<String>(Collections.singletonList(this.xmlns)));
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("xmlns")) {
                        this.xmlns = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("xmlns")) {
                        this.xmlns = (String)values.get(0);
                    }
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public static class Input
            extends Parameter
            implements Component,
            Terminal {
                protected String xmlns;

                public Input(Node node) {
                    super(node);
                }

                public String xmlns() {
                    return this.xmlns;
                }

                public Input xmlns(String value) {
                    this.xmlns = value;
                    return this;
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    map.put("xmlns", new ArrayList<String>(Collections.singletonList(this.xmlns)));
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("xmlns")) {
                        this.xmlns = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("xmlns")) {
                        this.xmlns = (String)values.get(0);
                    }
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Input input(String xmlns) {
                    Input newElement = (Input)Operation.this.core$().graph().concept(Input.class).createNode(this.name, Operation.this.core$()).as(Input.class);
                    newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                    return newElement;
                }

                public Output output(String xmlns) {
                    Output newElement = (Output)Operation.this.core$().graph().concept(Output.class).createNode(this.name, Operation.this.core$()).as(Output.class);
                    newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                    return newElement;
                }
            }
        }

        public class Clear {
            public void operation(Predicate<Operation> filter) {
                new ArrayList<Operation>(Soap.this.operationList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void schema(Predicate<Schema> filter) {
                new ArrayList<Schema>(Soap.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(Soap.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Operation operation(String path) {
                Operation newElement = (Operation)Soap.this.core$().graph().concept(Operation.class).createNode(this.name, Soap.this.core$()).as(Operation.class);
                newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
                return newElement;
            }

            public Schema schema() {
                Schema newElement = (Schema)Soap.this.core$().graph().concept(Schema.class).createNode(this.name, Soap.this.core$()).as(Schema.class);
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)Soap.this.core$().graph().concept(Exception.class).createNode(this.name, Soap.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }
    }

    public static class REST
    extends Layer
    implements Terminal {
        protected String swagger;
        protected String host;
        protected String port;
        protected String title;
        protected String subtitle;
        protected String basePath;
        protected String logo;
        protected String favicon;
        protected String backgroundColor;
        protected String color;
        protected boolean generateDocs;
        protected List<Protocols> protocols = new ArrayList<Protocols>();
        protected Authentication authentication;
        protected Info info;
        protected List<Tag> tagList = new ArrayList<Tag>();
        protected List<Resource> resourceList = new ArrayList<Resource>();
        protected List<Notification> notificationList = new ArrayList<Notification>();
        protected Service _service;

        public REST(Node node) {
            super(node);
        }

        public String swagger() {
            return this.swagger;
        }

        public String host() {
            return this.host;
        }

        public String port() {
            return this.port;
        }

        public String title() {
            return this.title;
        }

        public String subtitle() {
            return this.subtitle;
        }

        public String basePath() {
            return this.basePath;
        }

        public String logo() {
            return this.logo;
        }

        public String favicon() {
            return this.favicon;
        }

        public String backgroundColor() {
            return this.backgroundColor;
        }

        public String color() {
            return this.color;
        }

        public boolean generateDocs() {
            return this.generateDocs;
        }

        public List<Protocols> protocols() {
            return this.protocols;
        }

        public REST swagger(String value) {
            this.swagger = value;
            return this;
        }

        public REST host(String value) {
            this.host = value;
            return this;
        }

        public REST port(String value) {
            this.port = value;
            return this;
        }

        public REST title(String value) {
            this.title = value;
            return this;
        }

        public REST subtitle(String value) {
            this.subtitle = value;
            return this;
        }

        public REST basePath(String value) {
            this.basePath = value;
            return this;
        }

        public REST logo(String value) {
            this.logo = value;
            return this;
        }

        public REST favicon(String value) {
            this.favicon = value;
            return this;
        }

        public REST backgroundColor(String value) {
            this.backgroundColor = value;
            return this;
        }

        public REST color(String value) {
            this.color = value;
            return this;
        }

        public REST generateDocs(boolean value) {
            this.generateDocs = value;
            return this;
        }

        public Authentication authentication() {
            return this.authentication;
        }

        public Info info() {
            return this.info;
        }

        public List<Tag> tagList() {
            return Collections.unmodifiableList(this.tagList);
        }

        public Tag tag(int index) {
            return this.tagList.get(index);
        }

        public List<Tag> tagList(Predicate<Tag> predicate) {
            return this.tagList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Resource> resourceList() {
            return Collections.unmodifiableList(this.resourceList);
        }

        public Resource resource(int index) {
            return this.resourceList.get(index);
        }

        public List<Resource> resourceList(Predicate<Resource> predicate) {
            return this.resourceList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Notification> notificationList() {
            return Collections.unmodifiableList(this.notificationList);
        }

        public Notification notification(int index) {
            return this.notificationList.get(index);
        }

        public List<Notification> notificationList(Predicate<Notification> predicate) {
            return this.notificationList().stream().filter(predicate).collect(Collectors.toList());
        }

        public List<Schema> schemaList() {
            return this._service.schemaList();
        }

        public Schema schemaList(int index) {
            return this._service.schemaList().get(index);
        }

        public List<Exception> exceptionList() {
            return this._service.exceptionList();
        }

        public Exception exceptionList(int index) {
            return this._service.exceptionList().get(index);
        }

        public Service asService() {
            return (Service)this.a$(Service.class);
        }

        protected List<Node> componentList$() {
            LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
            if (this.authentication != null) {
                components.add(this.authentication.core$());
            }
            if (this.info != null) {
                components.add(this.info.core$());
            }
            new ArrayList<Tag>(this.tagList).forEach(c -> components.add(c.core$()));
            new ArrayList<Resource>(this.resourceList).forEach(c -> components.add(c.core$()));
            new ArrayList<Notification>(this.notificationList).forEach(c -> components.add(c.core$()));
            return new ArrayList<Node>(components);
        }

        protected Map<String, List<?>> variables$() {
            LinkedHashMap map = new LinkedHashMap();
            map.put("swagger", new ArrayList<String>(Collections.singletonList(this.swagger)));
            map.put("host", new ArrayList<String>(Collections.singletonList(this.host)));
            map.put("port", new ArrayList<String>(Collections.singletonList(this.port)));
            map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
            map.put("subtitle", new ArrayList<String>(Collections.singletonList(this.subtitle)));
            map.put("basePath", new ArrayList<String>(Collections.singletonList(this.basePath)));
            map.put("logo", new ArrayList<String>(Collections.singletonList(this.logo)));
            map.put("favicon", new ArrayList<String>(Collections.singletonList(this.favicon)));
            map.put("backgroundColor", new ArrayList<String>(Collections.singletonList(this.backgroundColor)));
            map.put("color", new ArrayList<String>(Collections.singletonList(this.color)));
            map.put("generateDocs", new ArrayList<Boolean>(Collections.singletonList(this.generateDocs)));
            map.put("protocols", this.protocols);
            return map;
        }

        protected void addNode$(Node node) {
            super.addNode$(node);
            if (node.is("Service$REST$Authentication")) {
                this.authentication = (Authentication)node.as(Authentication.class);
            }
            if (node.is("Service$REST$Info")) {
                this.info = (Info)node.as(Info.class);
            }
            if (node.is("Service$REST$Tag")) {
                this.tagList.add((Tag)node.as(Tag.class));
            }
            if (node.is("Service$REST$Resource")) {
                this.resourceList.add((Resource)node.as(Resource.class));
            }
            if (node.is("Service$REST$Notification")) {
                this.notificationList.add((Notification)node.as(Notification.class));
            }
        }

        protected void removeNode$(Node node) {
            super.removeNode$(node);
            if (node.is("Service$REST$Authentication")) {
                this.authentication = null;
            }
            if (node.is("Service$REST$Info")) {
                this.info = null;
            }
            if (node.is("Service$REST$Tag")) {
                this.tagList.remove(node.as(Tag.class));
            }
            if (node.is("Service$REST$Resource")) {
                this.resourceList.remove(node.as(Resource.class));
            }
            if (node.is("Service$REST$Notification")) {
                this.notificationList.remove(node.as(Notification.class));
            }
        }

        protected void load$(String name, List<?> values) {
            super.load$(name, values);
            if (name.equalsIgnoreCase("swagger")) {
                this.swagger = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("host")) {
                this.host = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("title")) {
                this.title = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("subtitle")) {
                this.subtitle = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("basePath")) {
                this.basePath = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("logo")) {
                this.logo = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("favicon")) {
                this.favicon = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("backgroundColor")) {
                this.backgroundColor = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("color")) {
                this.color = (String)StringLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("generateDocs")) {
                this.generateDocs = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
            } else if (name.equalsIgnoreCase("protocols")) {
                this.protocols = WordLoader.load(values, Protocols.class, (Layer)this);
            }
        }

        protected void set$(String name, List<?> values) {
            super.set$(name, values);
            if (name.equalsIgnoreCase("swagger")) {
                this.swagger = (String)values.get(0);
            } else if (name.equalsIgnoreCase("host")) {
                this.host = (String)values.get(0);
            } else if (name.equalsIgnoreCase("port")) {
                this.port = (String)values.get(0);
            } else if (name.equalsIgnoreCase("title")) {
                this.title = (String)values.get(0);
            } else if (name.equalsIgnoreCase("subtitle")) {
                this.subtitle = (String)values.get(0);
            } else if (name.equalsIgnoreCase("basePath")) {
                this.basePath = (String)values.get(0);
            } else if (name.equalsIgnoreCase("logo")) {
                this.logo = (String)values.get(0);
            } else if (name.equalsIgnoreCase("favicon")) {
                this.favicon = (String)values.get(0);
            } else if (name.equalsIgnoreCase("backgroundColor")) {
                this.backgroundColor = (String)values.get(0);
            } else if (name.equalsIgnoreCase("color")) {
                this.color = (String)values.get(0);
            } else if (name.equalsIgnoreCase("generateDocs")) {
                this.generateDocs = (Boolean)values.get(0);
            } else if (name.equalsIgnoreCase("protocols")) {
                this.protocols = new ArrayList(values);
            }
        }

        protected void sync$(Layer layer) {
            super.sync$(layer);
            if (layer instanceof Service) {
                this._service = (Service)layer;
            }
        }

        public Create create() {
            return new Create(null);
        }

        public Create create(String name) {
            return new Create(name);
        }

        public Clear clear() {
            return new Clear();
        }

        public KonosGraph graph() {
            return (KonosGraph)this.core$().graph().as(KonosGraph.class);
        }

        public static class Notification
        extends Layer
        implements Terminal {
            protected String path;
            protected List<Parameter> parameterList = new ArrayList<Parameter>();

            public Notification(Node node) {
                super(node);
            }

            public String path() {
                return this.path;
            }

            public Notification path(String value) {
                this.path = value;
                return this;
            }

            public List<Parameter> parameterList() {
                return Collections.unmodifiableList(this.parameterList);
            }

            public Parameter parameter(int index) {
                return this.parameterList.get(index);
            }

            public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Service$REST$Notification$Parameter")) {
                    this.parameterList.add((Parameter)node.as(Parameter.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Service$REST$Notification$Parameter")) {
                    this.parameterList.remove(node.as(Parameter.class));
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Parameter
            extends io.intino.konos.model.graph.Parameter
            implements Component,
            Terminal {
                protected String description;
                protected In in;

                public Parameter(Node node) {
                    super(node);
                }

                public String description() {
                    return this.description;
                }

                public In in() {
                    return this.in;
                }

                public Parameter description(String value) {
                    this.description = value;
                    return this;
                }

                public Parameter in(In value) {
                    this.in = value;
                    return this;
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                    map.put("in", new ArrayList<In>(Collections.singletonList(this.in)));
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("description")) {
                        this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("in")) {
                        this.in = (In)((Object)WordLoader.load(values, In.class, (Layer)this).get(0));
                    }
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("description")) {
                        this.description = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("in")) {
                        this.in = (In)((Object)values.get(0));
                    }
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public static enum In {
                    body,
                    path,
                    form,
                    header,
                    query;

                }
            }

            public class Clear {
                public void parameter(Predicate<Parameter> filter) {
                    new ArrayList<Parameter>(Notification.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Parameter parameter(Parameter.In in) {
                    Parameter newElement = (Parameter)Notification.this.core$().graph().concept(Parameter.class).createNode(this.name, Notification.this.core$()).as(Parameter.class);
                    newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }
            }
        }

        public static class Resource
        extends Layer
        implements Terminal {
            protected String path;
            protected List<Parameter> parameterList = new ArrayList<Parameter>();
            protected List<Operation> operationList = new ArrayList<Operation>();
            protected List<Get> getList = new ArrayList<Get>();
            protected List<Post> postList = new ArrayList<Post>();
            protected List<Put> putList = new ArrayList<Put>();
            protected List<Delete> deleteList = new ArrayList<Delete>();
            protected List<Head> headList = new ArrayList<Head>();
            protected List<Options> optionsList = new ArrayList<Options>();
            protected List<Patch> patchList = new ArrayList<Patch>();

            public Resource(Node node) {
                super(node);
            }

            public String path() {
                return this.path;
            }

            public Resource path(String value) {
                this.path = value;
                return this;
            }

            public List<Parameter> parameterList() {
                return Collections.unmodifiableList(this.parameterList);
            }

            public Parameter parameter(int index) {
                return this.parameterList.get(index);
            }

            public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Operation> operationList() {
                return Collections.unmodifiableList(this.operationList);
            }

            public Operation operation(int index) {
                return this.operationList.get(index);
            }

            public List<Operation> operationList(Predicate<Operation> predicate) {
                return this.operationList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Get> getList() {
                return Collections.unmodifiableList(this.getList);
            }

            public Get get(int index) {
                return this.getList.get(index);
            }

            public List<Get> getList(Predicate<Get> predicate) {
                return this.getList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Post> postList() {
                return Collections.unmodifiableList(this.postList);
            }

            public Post post(int index) {
                return this.postList.get(index);
            }

            public List<Post> postList(Predicate<Post> predicate) {
                return this.postList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Put> putList() {
                return Collections.unmodifiableList(this.putList);
            }

            public Put put(int index) {
                return this.putList.get(index);
            }

            public List<Put> putList(Predicate<Put> predicate) {
                return this.putList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Delete> deleteList() {
                return Collections.unmodifiableList(this.deleteList);
            }

            public Delete delete(int index) {
                return this.deleteList.get(index);
            }

            public List<Delete> deleteList(Predicate<Delete> predicate) {
                return this.deleteList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Head> headList() {
                return Collections.unmodifiableList(this.headList);
            }

            public Head head(int index) {
                return this.headList.get(index);
            }

            public List<Head> headList(Predicate<Head> predicate) {
                return this.headList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Options> optionsList() {
                return Collections.unmodifiableList(this.optionsList);
            }

            public Options options(int index) {
                return this.optionsList.get(index);
            }

            public List<Options> optionsList(Predicate<Options> predicate) {
                return this.optionsList().stream().filter(predicate).collect(Collectors.toList());
            }

            public List<Patch> patchList() {
                return Collections.unmodifiableList(this.patchList);
            }

            public Patch patch(int index) {
                return this.patchList.get(index);
            }

            public List<Patch> patchList(Predicate<Patch> predicate) {
                return this.patchList().stream().filter(predicate).collect(Collectors.toList());
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
                new ArrayList<Operation>(this.operationList).forEach(c -> components.add(c.core$()));
                new ArrayList<Get>(this.getList).forEach(c -> components.add(c.core$()));
                new ArrayList<Post>(this.postList).forEach(c -> components.add(c.core$()));
                new ArrayList<Put>(this.putList).forEach(c -> components.add(c.core$()));
                new ArrayList<Delete>(this.deleteList).forEach(c -> components.add(c.core$()));
                new ArrayList<Head>(this.headList).forEach(c -> components.add(c.core$()));
                new ArrayList<Options>(this.optionsList).forEach(c -> components.add(c.core$()));
                new ArrayList<Patch>(this.patchList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("path", new ArrayList<String>(Collections.singletonList(this.path)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Service$REST$Resource$Parameter")) {
                    this.parameterList.add((Parameter)node.as(Parameter.class));
                }
                if (node.is("Service$REST$Resource$Operation")) {
                    this.operationList.add((Operation)node.as(Operation.class));
                }
                if (node.is("Service$REST$Resource$Get")) {
                    this.getList.add((Get)node.as(Get.class));
                }
                if (node.is("Service$REST$Resource$Post")) {
                    this.postList.add((Post)node.as(Post.class));
                }
                if (node.is("Service$REST$Resource$Put")) {
                    this.putList.add((Put)node.as(Put.class));
                }
                if (node.is("Service$REST$Resource$Delete")) {
                    this.deleteList.add((Delete)node.as(Delete.class));
                }
                if (node.is("Service$REST$Resource$Head")) {
                    this.headList.add((Head)node.as(Head.class));
                }
                if (node.is("Service$REST$Resource$Options")) {
                    this.optionsList.add((Options)node.as(Options.class));
                }
                if (node.is("Service$REST$Resource$Patch")) {
                    this.patchList.add((Patch)node.as(Patch.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Service$REST$Resource$Parameter")) {
                    this.parameterList.remove(node.as(Parameter.class));
                }
                if (node.is("Service$REST$Resource$Operation")) {
                    this.operationList.remove(node.as(Operation.class));
                }
                if (node.is("Service$REST$Resource$Get")) {
                    this.getList.remove(node.as(Get.class));
                }
                if (node.is("Service$REST$Resource$Post")) {
                    this.postList.remove(node.as(Post.class));
                }
                if (node.is("Service$REST$Resource$Put")) {
                    this.putList.remove(node.as(Put.class));
                }
                if (node.is("Service$REST$Resource$Delete")) {
                    this.deleteList.remove(node.as(Delete.class));
                }
                if (node.is("Service$REST$Resource$Head")) {
                    this.headList.remove(node.as(Head.class));
                }
                if (node.is("Service$REST$Resource$Options")) {
                    this.optionsList.remove(node.as(Options.class));
                }
                if (node.is("Service$REST$Resource$Patch")) {
                    this.patchList.remove(node.as(Patch.class));
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("path")) {
                    this.path = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Patch
            extends Operation
            implements Terminal {
                public Patch(Node node) {
                    super(node);
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                @Override
                public Create create() {
                    return new Create(null);
                }

                @Override
                public Create create(String name) {
                    return new Create(name);
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Create
                extends Operation.Create {
                    public Create(String name) {
                        super(name);
                    }

                    @Override
                    public Soap.Operation.Output output(String xmlns) {
                        Soap.Operation.Output newElement = (Soap.Operation.Output)Patch.this.core$().graph().concept(Soap.Operation.Output.class).createNode(this.name, Patch.this.core$()).as(Soap.Operation.Output.class);
                        newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                        return newElement;
                    }

                    @Override
                    public Redirect redirect() {
                        Redirect newElement = (Redirect)Patch.this.core$().graph().concept(Redirect.class).createNode(this.name, Patch.this.core$()).as(Redirect.class);
                        return newElement;
                    }
                }
            }

            public static class Options
            extends Operation
            implements Terminal {
                public Options(Node node) {
                    super(node);
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                @Override
                public Create create() {
                    return new Create(null);
                }

                @Override
                public Create create(String name) {
                    return new Create(name);
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Create
                extends Operation.Create {
                    public Create(String name) {
                        super(name);
                    }

                    @Override
                    public Soap.Operation.Output output(String xmlns) {
                        Soap.Operation.Output newElement = (Soap.Operation.Output)Options.this.core$().graph().concept(Soap.Operation.Output.class).createNode(this.name, Options.this.core$()).as(Soap.Operation.Output.class);
                        newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                        return newElement;
                    }

                    @Override
                    public Redirect redirect() {
                        Redirect newElement = (Redirect)Options.this.core$().graph().concept(Redirect.class).createNode(this.name, Options.this.core$()).as(Redirect.class);
                        return newElement;
                    }
                }
            }

            public static class Head
            extends Operation
            implements Terminal {
                public Head(Node node) {
                    super(node);
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                @Override
                public Create create() {
                    return new Create(null);
                }

                @Override
                public Create create(String name) {
                    return new Create(name);
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Create
                extends Operation.Create {
                    public Create(String name) {
                        super(name);
                    }

                    @Override
                    public Soap.Operation.Output output(String xmlns) {
                        Soap.Operation.Output newElement = (Soap.Operation.Output)Head.this.core$().graph().concept(Soap.Operation.Output.class).createNode(this.name, Head.this.core$()).as(Soap.Operation.Output.class);
                        newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                        return newElement;
                    }

                    @Override
                    public Redirect redirect() {
                        Redirect newElement = (Redirect)Head.this.core$().graph().concept(Redirect.class).createNode(this.name, Head.this.core$()).as(Redirect.class);
                        return newElement;
                    }
                }
            }

            public static class Delete
            extends Operation
            implements Terminal {
                public Delete(Node node) {
                    super(node);
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                @Override
                public Create create() {
                    return new Create(null);
                }

                @Override
                public Create create(String name) {
                    return new Create(name);
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Create
                extends Operation.Create {
                    public Create(String name) {
                        super(name);
                    }

                    @Override
                    public Soap.Operation.Output output(String xmlns) {
                        Soap.Operation.Output newElement = (Soap.Operation.Output)Delete.this.core$().graph().concept(Soap.Operation.Output.class).createNode(this.name, Delete.this.core$()).as(Soap.Operation.Output.class);
                        newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                        return newElement;
                    }

                    @Override
                    public Redirect redirect() {
                        Redirect newElement = (Redirect)Delete.this.core$().graph().concept(Redirect.class).createNode(this.name, Delete.this.core$()).as(Redirect.class);
                        return newElement;
                    }
                }
            }

            public static class Put
            extends Operation
            implements Terminal {
                public Put(Node node) {
                    super(node);
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                @Override
                public Create create() {
                    return new Create(null);
                }

                @Override
                public Create create(String name) {
                    return new Create(name);
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Create
                extends Operation.Create {
                    public Create(String name) {
                        super(name);
                    }

                    @Override
                    public Soap.Operation.Output output(String xmlns) {
                        Soap.Operation.Output newElement = (Soap.Operation.Output)Put.this.core$().graph().concept(Soap.Operation.Output.class).createNode(this.name, Put.this.core$()).as(Soap.Operation.Output.class);
                        newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                        return newElement;
                    }

                    @Override
                    public Redirect redirect() {
                        Redirect newElement = (Redirect)Put.this.core$().graph().concept(Redirect.class).createNode(this.name, Put.this.core$()).as(Redirect.class);
                        return newElement;
                    }
                }
            }

            public static class Post
            extends Operation
            implements Terminal {
                public Post(Node node) {
                    super(node);
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                @Override
                public Create create() {
                    return new Create(null);
                }

                @Override
                public Create create(String name) {
                    return new Create(name);
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Create
                extends Operation.Create {
                    public Create(String name) {
                        super(name);
                    }

                    @Override
                    public Soap.Operation.Output output(String xmlns) {
                        Soap.Operation.Output newElement = (Soap.Operation.Output)Post.this.core$().graph().concept(Soap.Operation.Output.class).createNode(this.name, Post.this.core$()).as(Soap.Operation.Output.class);
                        newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                        return newElement;
                    }

                    @Override
                    public Redirect redirect() {
                        Redirect newElement = (Redirect)Post.this.core$().graph().concept(Redirect.class).createNode(this.name, Post.this.core$()).as(Redirect.class);
                        return newElement;
                    }
                }
            }

            public static class Get
            extends Operation
            implements Terminal {
                public Get(Node node) {
                    super(node);
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                @Override
                public Create create() {
                    return new Create(null);
                }

                @Override
                public Create create(String name) {
                    return new Create(name);
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Create
                extends Operation.Create {
                    public Create(String name) {
                        super(name);
                    }

                    @Override
                    public Soap.Operation.Output output(String xmlns) {
                        Soap.Operation.Output newElement = (Soap.Operation.Output)Get.this.core$().graph().concept(Soap.Operation.Output.class).createNode(this.name, Get.this.core$()).as(Soap.Operation.Output.class);
                        newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                        return newElement;
                    }

                    @Override
                    public Redirect redirect() {
                        Redirect newElement = (Redirect)Get.this.core$().graph().concept(Redirect.class).createNode(this.name, Get.this.core$()).as(Redirect.class);
                        return newElement;
                    }
                }
            }

            public static abstract class Operation
            extends Layer
            implements Terminal {
                protected List<String> tags = new ArrayList<String>();
                protected String summary;
                protected String description;
                protected String externalDocumentationPath;
                protected boolean deprecated;
                protected List<Exception> exceptionRefs = new ArrayList<Exception>();
                protected List<Parameter> parameterList = new ArrayList<Parameter>();
                protected Response response;
                protected List<Exception> exceptionList = new ArrayList<Exception>();

                public Operation(Node node) {
                    super(node);
                }

                public List<String> tags() {
                    return this.tags;
                }

                public String tags(int index) {
                    return this.tags.get(index);
                }

                public List<String> tags(Predicate<String> predicate) {
                    return this.tags().stream().filter(predicate).collect(Collectors.toList());
                }

                public String summary() {
                    return this.summary;
                }

                public String description() {
                    return this.description;
                }

                public String externalDocumentationPath() {
                    return this.externalDocumentationPath;
                }

                public boolean deprecated() {
                    return this.deprecated;
                }

                public List<Exception> exceptionRefs() {
                    return this.exceptionRefs;
                }

                public Exception exceptionRefs(int index) {
                    return this.exceptionRefs.get(index);
                }

                public List<Exception> exceptionRefs(Predicate<Exception> predicate) {
                    return this.exceptionRefs().stream().filter(predicate).collect(Collectors.toList());
                }

                public Operation summary(String value) {
                    this.summary = value;
                    return this;
                }

                public Operation description(String value) {
                    this.description = value;
                    return this;
                }

                public Operation externalDocumentationPath(String value) {
                    this.externalDocumentationPath = value;
                    return this;
                }

                public Operation deprecated(boolean value) {
                    this.deprecated = value;
                    return this;
                }

                public List<Parameter> parameterList() {
                    return Collections.unmodifiableList(this.parameterList);
                }

                public Parameter parameter(int index) {
                    return this.parameterList.get(index);
                }

                public List<Parameter> parameterList(Predicate<Parameter> predicate) {
                    return this.parameterList().stream().filter(predicate).collect(Collectors.toList());
                }

                public Response response() {
                    return this.response;
                }

                public List<Exception> exceptionList() {
                    return Collections.unmodifiableList(this.exceptionList);
                }

                public Exception exception(int index) {
                    return this.exceptionList.get(index);
                }

                public List<Exception> exceptionList(Predicate<Exception> predicate) {
                    return this.exceptionList().stream().filter(predicate).collect(Collectors.toList());
                }

                protected List<Node> componentList$() {
                    LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                    new ArrayList<Parameter>(this.parameterList).forEach(c -> components.add(c.core$()));
                    if (this.response != null) {
                        components.add(this.response.core$());
                    }
                    new ArrayList<Exception>(this.exceptionList).forEach(c -> components.add(c.core$()));
                    return new ArrayList<Node>(components);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("tags", this.tags);
                    map.put("summary", new ArrayList<String>(Collections.singletonList(this.summary)));
                    map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                    map.put("externalDocumentationPath", new ArrayList<String>(Collections.singletonList(this.externalDocumentationPath)));
                    map.put("deprecated", new ArrayList<Boolean>(Collections.singletonList(this.deprecated)));
                    map.put("exceptionRefs", this.exceptionRefs);
                    return map;
                }

                protected void addNode$(Node node) {
                    super.addNode$(node);
                    if (node.is("Service$REST$Resource$Parameter")) {
                        this.parameterList.add((Parameter)node.as(Parameter.class));
                    }
                    if (node.is("Response")) {
                        this.response = (Response)node.as(Response.class);
                    }
                    if (node.is("Exception")) {
                        this.exceptionList.add((Exception)node.as(Exception.class));
                    }
                }

                protected void removeNode$(Node node) {
                    super.removeNode$(node);
                    if (node.is("Service$REST$Resource$Parameter")) {
                        this.parameterList.remove(node.as(Parameter.class));
                    }
                    if (node.is("Response")) {
                        this.response = null;
                    }
                    if (node.is("Exception")) {
                        this.exceptionList.remove(node.as(Exception.class));
                    }
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("tags")) {
                        this.tags = StringLoader.load(values, (Layer)this);
                    } else if (name.equalsIgnoreCase("summary")) {
                        this.summary = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("description")) {
                        this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("externalDocumentationPath")) {
                        this.externalDocumentationPath = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("deprecated")) {
                        this.deprecated = (Boolean)BooleanLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("exceptionRefs")) {
                        this.exceptionRefs = NodeLoader.load(values, Exception.class, (Layer)this);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("tags")) {
                        this.tags = new ArrayList(values);
                    } else if (name.equalsIgnoreCase("summary")) {
                        this.summary = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("description")) {
                        this.description = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("externalDocumentationPath")) {
                        this.externalDocumentationPath = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("deprecated")) {
                        this.deprecated = (Boolean)values.get(0);
                    } else if (name.equalsIgnoreCase("exceptionRefs")) {
                        this.exceptionRefs = values.stream().map(s -> (Exception)this.graph().core$().load(((Layer)s).core$().id()).as(Exception.class)).collect(Collectors.toList());
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Clear clear() {
                    return new Clear();
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public class Clear {
                    public void parameter(Predicate<Parameter> filter) {
                        new ArrayList<Parameter>(Operation.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                    }

                    public void exception(Predicate<Exception> filter) {
                        new ArrayList<Exception>(Operation.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public Parameter parameter(Parameter.In in) {
                        Parameter newElement = (Parameter)Operation.this.core$().graph().concept(Parameter.class).createNode(this.name, Operation.this.core$()).as(Parameter.class);
                        newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                        return newElement;
                    }

                    public Response response() {
                        Response newElement = (Response)Operation.this.core$().graph().concept(Response.class).createNode(this.name, Operation.this.core$()).as(Response.class);
                        return newElement;
                    }

                    public Exception exception(ExceptionCodes code) {
                        Exception newElement = (Exception)Operation.this.core$().graph().concept(Exception.class).createNode(this.name, Operation.this.core$()).as(Exception.class);
                        newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                        return newElement;
                    }

                    public Soap.Operation.Output output(String xmlns) {
                        Soap.Operation.Output newElement = (Soap.Operation.Output)Operation.this.core$().graph().concept(Soap.Operation.Output.class).createNode(this.name, Operation.this.core$()).as(Soap.Operation.Output.class);
                        newElement.core$().set((Layer)newElement, "xmlns", Collections.singletonList(xmlns));
                        return newElement;
                    }

                    public Redirect redirect() {
                        Redirect newElement = (Redirect)Operation.this.core$().graph().concept(Redirect.class).createNode(this.name, Operation.this.core$()).as(Redirect.class);
                        return newElement;
                    }
                }
            }

            public static class Parameter
            extends io.intino.konos.model.graph.Parameter
            implements Component,
            Terminal {
                protected String description;
                protected In in;

                public Parameter(Node node) {
                    super(node);
                }

                public String description() {
                    return this.description;
                }

                public In in() {
                    return this.in;
                }

                public Parameter description(String value) {
                    this.description = value;
                    return this;
                }

                public Parameter in(In value) {
                    this.in = value;
                    return this;
                }

                @Override
                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap(super.variables$());
                    map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                    map.put("in", new ArrayList<In>(Collections.singletonList(this.in)));
                    return map;
                }

                @Override
                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("description")) {
                        this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("in")) {
                        this.in = (In)((Object)WordLoader.load(values, In.class, (Layer)this).get(0));
                    }
                }

                @Override
                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("description")) {
                        this.description = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("in")) {
                        this.in = (In)((Object)values.get(0));
                    }
                }

                @Override
                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public static enum In {
                    body,
                    path,
                    form,
                    header,
                    query;

                }
            }

            public class Clear {
                public void parameter(Predicate<Parameter> filter) {
                    new ArrayList<Parameter>(Resource.this.parameterList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void get(Predicate<Get> filter) {
                    new ArrayList<Get>(Resource.this.getList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void post(Predicate<Post> filter) {
                    new ArrayList<Post>(Resource.this.postList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void put(Predicate<Put> filter) {
                    new ArrayList<Put>(Resource.this.putList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void delete(Predicate<Delete> filter) {
                    new ArrayList<Delete>(Resource.this.deleteList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void head(Predicate<Head> filter) {
                    new ArrayList<Head>(Resource.this.headList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void options(Predicate<Options> filter) {
                    new ArrayList<Options>(Resource.this.optionsList()).stream().filter(filter).forEach(Layer::delete$);
                }

                public void patch(Predicate<Patch> filter) {
                    new ArrayList<Patch>(Resource.this.patchList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Parameter parameter(Parameter.In in) {
                    Parameter newElement = (Parameter)Resource.this.core$().graph().concept(Parameter.class).createNode(this.name, Resource.this.core$()).as(Parameter.class);
                    newElement.core$().set((Layer)newElement, "in", Collections.singletonList(in));
                    return newElement;
                }

                public Get get() {
                    Get newElement = (Get)Resource.this.core$().graph().concept(Get.class).createNode(this.name, Resource.this.core$()).as(Get.class);
                    return newElement;
                }

                public Post post() {
                    Post newElement = (Post)Resource.this.core$().graph().concept(Post.class).createNode(this.name, Resource.this.core$()).as(Post.class);
                    return newElement;
                }

                public Put put() {
                    Put newElement = (Put)Resource.this.core$().graph().concept(Put.class).createNode(this.name, Resource.this.core$()).as(Put.class);
                    return newElement;
                }

                public Delete delete() {
                    Delete newElement = (Delete)Resource.this.core$().graph().concept(Delete.class).createNode(this.name, Resource.this.core$()).as(Delete.class);
                    return newElement;
                }

                public Head head() {
                    Head newElement = (Head)Resource.this.core$().graph().concept(Head.class).createNode(this.name, Resource.this.core$()).as(Head.class);
                    return newElement;
                }

                public Options options() {
                    Options newElement = (Options)Resource.this.core$().graph().concept(Options.class).createNode(this.name, Resource.this.core$()).as(Options.class);
                    return newElement;
                }

                public Patch patch() {
                    Patch newElement = (Patch)Resource.this.core$().graph().concept(Patch.class).createNode(this.name, Resource.this.core$()).as(Patch.class);
                    return newElement;
                }
            }
        }

        public static class Tag
        extends Layer
        implements Terminal {
            protected String description;
            protected List<Document> documentList = new ArrayList<Document>();

            public Tag(Node node) {
                super(node);
            }

            public String description() {
                return this.description;
            }

            public Tag description(String value) {
                this.description = value;
                return this;
            }

            public List<Document> documentList() {
                return Collections.unmodifiableList(this.documentList);
            }

            public Document document(int index) {
                return this.documentList.get(index);
            }

            public List<Document> documentList(Predicate<Document> predicate) {
                return this.documentList().stream().filter(predicate).collect(Collectors.toList());
            }

            protected List<Node> componentList$() {
                LinkedHashSet components = new LinkedHashSet(super.componentList$());
                new ArrayList<Document>(this.documentList).forEach(c -> components.add(c.core$()));
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Service$REST$Tag$Document")) {
                    this.documentList.add((Document)node.as(Document.class));
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Service$REST$Tag$Document")) {
                    this.documentList.remove(node.as(Document.class));
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("description")) {
                    this.description = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public Clear clear() {
                return new Clear();
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Document
            extends Layer
            implements Terminal {
                protected String description;
                protected String url;

                public Document(Node node) {
                    super(node);
                }

                public String description() {
                    return this.description;
                }

                public String url() {
                    return this.url;
                }

                public Document description(String value) {
                    this.description = value;
                    return this;
                }

                public Document url(String value) {
                    this.url = value;
                    return this;
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                    map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("description")) {
                        this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("url")) {
                        this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("description")) {
                        this.description = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("url")) {
                        this.url = (String)values.get(0);
                    }
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public class Clear {
                public void document(Predicate<Document> filter) {
                    new ArrayList<Document>(Tag.this.documentList()).stream().filter(filter).forEach(Layer::delete$);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Document document(String url) {
                    Document newElement = (Document)Tag.this.core$().graph().concept(Document.class).createNode(this.name, Tag.this.core$()).as(Document.class);
                    newElement.core$().set((Layer)newElement, "url", Collections.singletonList(url));
                    return newElement;
                }
            }
        }

        public static class Info
        extends Layer
        implements Terminal {
            protected String title;
            protected String version;
            protected String description;
            protected String termsOfService;
            protected Contact contact;
            protected License license;

            public Info(Node node) {
                super(node);
            }

            public String title() {
                return this.title;
            }

            public String version() {
                return this.version;
            }

            public String description() {
                return this.description;
            }

            public String termsOfService() {
                return this.termsOfService;
            }

            public Info title(String value) {
                this.title = value;
                return this;
            }

            public Info version(String value) {
                this.version = value;
                return this;
            }

            public Info description(String value) {
                this.description = value;
                return this;
            }

            public Info termsOfService(String value) {
                this.termsOfService = value;
                return this;
            }

            public Contact contact() {
                return this.contact;
            }

            public License license() {
                return this.license;
            }

            protected List<Node> componentList$() {
                LinkedHashSet<Node> components = new LinkedHashSet<Node>(super.componentList$());
                if (this.contact != null) {
                    components.add(this.contact.core$());
                }
                if (this.license != null) {
                    components.add(this.license.core$());
                }
                return new ArrayList<Node>(components);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                map.put("title", new ArrayList<String>(Collections.singletonList(this.title)));
                map.put("version", new ArrayList<String>(Collections.singletonList(this.version)));
                map.put("description", new ArrayList<String>(Collections.singletonList(this.description)));
                map.put("termsOfService", new ArrayList<String>(Collections.singletonList(this.termsOfService)));
                return map;
            }

            protected void addNode$(Node node) {
                super.addNode$(node);
                if (node.is("Service$REST$Info$Contact")) {
                    this.contact = (Contact)node.as(Contact.class);
                }
                if (node.is("Service$REST$Info$License")) {
                    this.license = (License)node.as(License.class);
                }
            }

            protected void removeNode$(Node node) {
                super.removeNode$(node);
                if (node.is("Service$REST$Info$Contact")) {
                    this.contact = null;
                }
                if (node.is("Service$REST$Info$License")) {
                    this.license = null;
                }
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (String)StringLoader.load(values, (Layer)this).get(0);
                } else if (name.equalsIgnoreCase("termsOfService")) {
                    this.termsOfService = (String)StringLoader.load(values, (Layer)this).get(0);
                }
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
                if (name.equalsIgnoreCase("title")) {
                    this.title = (String)values.get(0);
                } else if (name.equalsIgnoreCase("version")) {
                    this.version = (String)values.get(0);
                } else if (name.equalsIgnoreCase("description")) {
                    this.description = (String)values.get(0);
                } else if (name.equalsIgnoreCase("termsOfService")) {
                    this.termsOfService = (String)values.get(0);
                }
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class License
            extends Layer
            implements Terminal {
                protected String url;

                public License(Node node) {
                    super(node);
                }

                public String url() {
                    return this.url;
                }

                public License url(String value) {
                    this.url = value;
                    return this;
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("url")) {
                        this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("url")) {
                        this.url = (String)values.get(0);
                    }
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public static class Contact
            extends Layer
            implements Terminal {
                protected String url;
                protected String email;

                public Contact(Node node) {
                    super(node);
                }

                public String url() {
                    return this.url;
                }

                public String email() {
                    return this.email;
                }

                public Contact url(String value) {
                    this.url = value;
                    return this;
                }

                public Contact email(String value) {
                    this.email = value;
                    return this;
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("url", new ArrayList<String>(Collections.singletonList(this.url)));
                    map.put("email", new ArrayList<String>(Collections.singletonList(this.email)));
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("url")) {
                        this.url = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("email")) {
                        this.email = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("url")) {
                        this.url = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("email")) {
                        this.email = (String)values.get(0);
                    }
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }

                public Contact contact() {
                    Contact newElement = (Contact)Info.this.core$().graph().concept(Contact.class).createNode(this.name, Info.this.core$()).as(Contact.class);
                    return newElement;
                }

                public License license() {
                    License newElement = (License)Info.this.core$().graph().concept(License.class).createNode(this.name, Info.this.core$()).as(License.class);
                    return newElement;
                }
            }
        }

        public static class Authentication
        extends Layer
        implements Terminal {
            protected WithCertificate _withCertificate;
            protected Basic _basic;
            protected Bearer _bearer;

            public Authentication(Node node) {
                super(node);
            }

            public Bearer asBearer() {
                Layer as = this.a$(Bearer.class);
                return as != null ? (Bearer)as : (Bearer)this.core$().addAspect(Bearer.class);
            }

            public boolean isBearer() {
                return this.core$().is(Bearer.class);
            }

            public WithCertificate asWithCertificate() {
                return (WithCertificate)this.a$(WithCertificate.class);
            }

            public WithCertificate asWithCertificate(String store, String storePassword) {
                WithCertificate newElement = (WithCertificate)this.core$().addAspect(WithCertificate.class);
                newElement.core$().set((Layer)newElement, "store", Collections.singletonList(store));
                newElement.core$().set((Layer)newElement, "storePassword", Collections.singletonList(storePassword));
                return newElement;
            }

            public boolean isWithCertificate() {
                return this.core$().is(WithCertificate.class);
            }

            public void removeWithCertificate() {
                this.core$().removeAspect(WithCertificate.class);
            }

            public Basic asBasic() {
                Layer as = this.a$(Basic.class);
                return as != null ? (Basic)as : (Basic)this.core$().addAspect(Basic.class);
            }

            public boolean isBasic() {
                return this.core$().is(Basic.class);
            }

            protected Map<String, List<?>> variables$() {
                LinkedHashMap map = new LinkedHashMap();
                return map;
            }

            protected void load$(String name, List<?> values) {
                super.load$(name, values);
            }

            protected void set$(String name, List<?> values) {
                super.set$(name, values);
            }

            public Create create() {
                return new Create(null);
            }

            public Create create(String name) {
                return new Create(name);
            }

            public KonosGraph graph() {
                return (KonosGraph)this.core$().graph().as(KonosGraph.class);
            }

            public static class Bearer
            extends Layer
            implements Terminal {
                protected Authentication _authentication;

                public Bearer(Node node) {
                    super(node);
                }

                public Authentication asAuthentication() {
                    return (Authentication)this.a$(Authentication.class);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                protected void sync$(Layer layer) {
                    super.sync$(layer);
                    if (layer instanceof Authentication) {
                        this._authentication = (Authentication)layer;
                    }
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public static class Basic
            extends Layer
            implements Terminal {
                protected Authentication _authentication;

                public Basic(Node node) {
                    super(node);
                }

                public Authentication asAuthentication() {
                    return (Authentication)this.a$(Authentication.class);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    return map;
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                }

                protected void sync$(Layer layer) {
                    super.sync$(layer);
                    if (layer instanceof Authentication) {
                        this._authentication = (Authentication)layer;
                    }
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }
            }

            public static class WithCertificate
            extends Layer
            implements Terminal {
                protected String store;
                protected String storePassword;
                protected List<AllowedUsers> allowedUsersList = new ArrayList<AllowedUsers>();
                protected Authentication _authentication;

                public WithCertificate(Node node) {
                    super(node);
                }

                public String store() {
                    return this.store;
                }

                public String storePassword() {
                    return this.storePassword;
                }

                public WithCertificate store(String value) {
                    this.store = value;
                    return this;
                }

                public WithCertificate storePassword(String value) {
                    this.storePassword = value;
                    return this;
                }

                public List<AllowedUsers> allowedUsersList() {
                    return Collections.unmodifiableList(this.allowedUsersList);
                }

                public AllowedUsers allowedUsers(int index) {
                    return this.allowedUsersList.get(index);
                }

                public List<AllowedUsers> allowedUsersList(Predicate<AllowedUsers> predicate) {
                    return this.allowedUsersList().stream().filter(predicate).collect(Collectors.toList());
                }

                public Authentication asAuthentication() {
                    return (Authentication)this.a$(Authentication.class);
                }

                protected List<Node> componentList$() {
                    LinkedHashSet components = new LinkedHashSet(super.componentList$());
                    new ArrayList<AllowedUsers>(this.allowedUsersList).forEach(c -> components.add(c.core$()));
                    return new ArrayList<Node>(components);
                }

                protected Map<String, List<?>> variables$() {
                    LinkedHashMap map = new LinkedHashMap();
                    map.put("store", new ArrayList<String>(Collections.singletonList(this.store)));
                    map.put("storePassword", new ArrayList<String>(Collections.singletonList(this.storePassword)));
                    return map;
                }

                protected void addNode$(Node node) {
                    super.addNode$(node);
                    if (node.is("Service$REST$Authentication$WithCertificate$AllowedUsers")) {
                        this.allowedUsersList.add((AllowedUsers)node.as(AllowedUsers.class));
                    }
                }

                protected void removeNode$(Node node) {
                    super.removeNode$(node);
                    if (node.is("Service$REST$Authentication$WithCertificate$AllowedUsers")) {
                        this.allowedUsersList.remove(node.as(AllowedUsers.class));
                    }
                }

                protected void load$(String name, List<?> values) {
                    super.load$(name, values);
                    if (name.equalsIgnoreCase("store")) {
                        this.store = (String)StringLoader.load(values, (Layer)this).get(0);
                    } else if (name.equalsIgnoreCase("storePassword")) {
                        this.storePassword = (String)StringLoader.load(values, (Layer)this).get(0);
                    }
                }

                protected void set$(String name, List<?> values) {
                    super.set$(name, values);
                    if (name.equalsIgnoreCase("store")) {
                        this.store = (String)values.get(0);
                    } else if (name.equalsIgnoreCase("storePassword")) {
                        this.storePassword = (String)values.get(0);
                    }
                }

                protected void sync$(Layer layer) {
                    super.sync$(layer);
                    if (layer instanceof Authentication) {
                        this._authentication = (Authentication)layer;
                    }
                }

                public Create create() {
                    return new Create(null);
                }

                public Create create(String name) {
                    return new Create(name);
                }

                public Clear clear() {
                    return new Clear();
                }

                public KonosGraph graph() {
                    return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                }

                public static class AllowedUsers
                extends Layer
                implements Terminal {
                    protected List<String> certificate = new ArrayList<String>();

                    public AllowedUsers(Node node) {
                        super(node);
                    }

                    public List<String> certificate() {
                        return this.certificate;
                    }

                    public String certificate(int index) {
                        return this.certificate.get(index);
                    }

                    public List<String> certificate(Predicate<String> predicate) {
                        return this.certificate().stream().filter(predicate).collect(Collectors.toList());
                    }

                    protected Map<String, List<?>> variables$() {
                        LinkedHashMap map = new LinkedHashMap();
                        map.put("certificate", this.certificate);
                        return map;
                    }

                    protected void load$(String name, List<?> values) {
                        super.load$(name, values);
                        if (name.equalsIgnoreCase("certificate")) {
                            this.certificate = StringLoader.load(values, (Layer)this);
                        }
                    }

                    protected void set$(String name, List<?> values) {
                        super.set$(name, values);
                        if (name.equalsIgnoreCase("certificate")) {
                            this.certificate = new ArrayList(values);
                        }
                    }

                    public KonosGraph graph() {
                        return (KonosGraph)this.core$().graph().as(KonosGraph.class);
                    }
                }

                public class Clear {
                    public void allowedUsers(Predicate<AllowedUsers> filter) {
                        new ArrayList<AllowedUsers>(WithCertificate.this.allowedUsersList()).stream().filter(filter).forEach(Layer::delete$);
                    }
                }

                public class Create {
                    protected final String name;

                    public Create(String name) {
                        this.name = name;
                    }

                    public AllowedUsers allowedUsers(List<String> certificate) {
                        AllowedUsers newElement = (AllowedUsers)WithCertificate.this.core$().graph().concept(AllowedUsers.class).createNode(this.name, WithCertificate.this.core$()).as(AllowedUsers.class);
                        newElement.core$().set((Layer)newElement, "certificate", certificate);
                        return newElement;
                    }
                }
            }

            public class Create {
                protected final String name;

                public Create(String name) {
                    this.name = name;
                }
            }
        }

        public class Clear {
            public void tag(Predicate<Tag> filter) {
                new ArrayList<Tag>(REST.this.tagList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void resource(Predicate<Resource> filter) {
                new ArrayList<Resource>(REST.this.resourceList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void notification(Predicate<Notification> filter) {
                new ArrayList<Notification>(REST.this.notificationList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void schema(Predicate<Schema> filter) {
                new ArrayList<Schema>(REST.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
            }

            public void exception(Predicate<Exception> filter) {
                new ArrayList<Exception>(REST.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
            }
        }

        public class Create {
            protected final String name;

            public Create(String name) {
                this.name = name;
            }

            public Authentication authentication() {
                Authentication newElement = (Authentication)REST.this.core$().graph().concept(Authentication.class).createNode(this.name, REST.this.core$()).as(Authentication.class);
                return newElement;
            }

            public Info info(String title, String version) {
                Info newElement = (Info)REST.this.core$().graph().concept(Info.class).createNode(this.name, REST.this.core$()).as(Info.class);
                newElement.core$().set((Layer)newElement, "title", Collections.singletonList(title));
                newElement.core$().set((Layer)newElement, "version", Collections.singletonList(version));
                return newElement;
            }

            public Tag tag() {
                Tag newElement = (Tag)REST.this.core$().graph().concept(Tag.class).createNode(this.name, REST.this.core$()).as(Tag.class);
                return newElement;
            }

            public Resource resource(String path) {
                Resource newElement = (Resource)REST.this.core$().graph().concept(Resource.class).createNode(this.name, REST.this.core$()).as(Resource.class);
                newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
                return newElement;
            }

            public Notification notification(String path) {
                Notification newElement = (Notification)REST.this.core$().graph().concept(Notification.class).createNode(this.name, REST.this.core$()).as(Notification.class);
                newElement.core$().set((Layer)newElement, "path", Collections.singletonList(path));
                return newElement;
            }

            public Schema schema() {
                Schema newElement = (Schema)REST.this.core$().graph().concept(Schema.class).createNode(this.name, REST.this.core$()).as(Schema.class);
                return newElement;
            }

            public Exception exception(ExceptionCodes code) {
                Exception newElement = (Exception)REST.this.core$().graph().concept(Exception.class).createNode(this.name, REST.this.core$()).as(Exception.class);
                newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
                return newElement;
            }
        }

        public static enum Protocols {
            http,
            https,
            ws,
            wss;

        }
    }

    public class Clear {
        public void schema(Predicate<Schema> filter) {
            new ArrayList<Schema>(Service.this.schemaList()).stream().filter(filter).forEach(Layer::delete$);
        }

        public void exception(Predicate<Exception> filter) {
            new ArrayList<Exception>(Service.this.exceptionList()).stream().filter(filter).forEach(Layer::delete$);
        }
    }

    public class Create {
        protected final String name;

        public Create(String name) {
            this.name = name;
        }

        public Schema schema() {
            Schema newElement = (Schema)Service.this.core$().graph().concept(Schema.class).createNode(this.name, Service.this.core$()).as(Schema.class);
            return newElement;
        }

        public Exception exception(ExceptionCodes code) {
            Exception newElement = (Exception)Service.this.core$().graph().concept(Exception.class).createNode(this.name, Service.this.core$()).as(Exception.class);
            newElement.core$().set((Layer)newElement, "code", Collections.singletonList(code));
            return newElement;
        }
    }
}

