/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.analytic;

import io.intino.itrules.Rule;
import io.intino.itrules.RuleSet;
import io.intino.itrules.Template;

public class CubeTemplate
extends Template {
    public RuleSet ruleSet() {
        return new RuleSet().add(new Rule[]{this.rule().condition(this.type("cube"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("package ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".analytic.cubes.schemas;\n\nimport io.intino.alexandria.led.HeapLedStreamBuilder;\nimport io.intino.alexandria.led.Schema;\nimport io.intino.alexandria.led.LedReader;\nimport io.intino.alexandria.led.LedWriter;\nimport io.intino.alexandria.led.LedStream;\nimport io.intino.alexandria.led.Led;\nimport io.intino.alexandria.led.allocators.SchemaFactory;\nimport io.intino.alexandria.led.buffers.store.ByteStore;\nimport io.intino.alexandria.led.buffers.store.ByteBufferStore;\nimport io.intino.alexandria.Timetag;\n\nimport java.util.stream.*;\nimport java.util.List;\nimport java.util.Arrays;\nimport java.util.Comparator;\nimport java.io.File;\nimport java.util.UUID;\nimport ")}).output(new Rule.Output[]{this.mark("package", new String[]{"validPackage"})}).output(new Rule.Output[]{this.literal(".analytic.axes.*;\n\npublic class ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" extends Schema {\n\n\tpublic static final int SIZE = ")}).output(new Rule.Output[]{this.mark("size", new String[0])}).output(new Rule.Output[]{this.literal("; // Bytes\n    public static final UUID SERIAL_UUID = UUID.fromString(\"")}).output(new Rule.Output[]{this.mark("serialUUID", new String[0])}).output(new Rule.Output[]{this.literal("\");\n    public static final SchemaFactory<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> FACTORY = new SchemaFactory<>(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class) {\n        @Override\n        public ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(" newInstance(ByteStore store) {\n            return new ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("(store);\n        }\n    };\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("() {\n\t\tsuper(new ByteBufferStore(SIZE));\n\t}\n\n\tpublic ")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("(ByteStore store) {\n\t\tsuper(store);\n    }\n\n    @Override\n\tpublic long id() {\n\t\treturn bitBuffer.getAlignedLong(0);\n\t}\n\n    @Override\n\tpublic int size() {\n\t\treturn SIZE;\n\t}\n\n    @Override\n\tpublic UUID serialUUID() {\n\t    return SERIAL_UUID;\n\t}\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("column", new String[]{"getter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("column", new String[]{"setter"}).multiple("\n\n")})}).output(new Rule.Output[]{this.literal("\n\n    @Override\n    public String toString() {\n        return \"")}).output(new Rule.Output[]{this.mark("name", new String[]{"FirstUpperCase"})}).output(new Rule.Output[]{this.literal("{\"\n                + \"id=\" + id()\n                ")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("column", new String[]{"toString"}).multiple("\n")})}).output(new Rule.Output[]{this.literal("\n                + '}';\n    }\n\n\t")}).output(new Rule.Output[]{this.expression(new Rule.Output[0]).output(new Rule.Output[]{this.mark("split", new String[0])})}).output(new Rule.Output[]{this.literal("\n\n\n\tpublic static class Builder extends HeapLedStreamBuilder<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> {\n\n        public Builder() {\n            this(1_000_000);\n        }\n\n        public Builder(File tempDirectory) {\n            this(1_000_000, tempDirectory);\n        }\n\n        public Builder(int numSchemasPerBlock) {\n            this(numSchemasPerBlock, new File(System.getProperty(\"java.io.tmpdir\")));\n        }\n\n        public Builder(int numSchemasPerBlock, File tempDirectory) {\n            super(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class, numSchemasPerBlock, tempDirectory);\n        }\n    }\n\n    public static class Tank {\n\n        public static File get(File root) {\n            return new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal("\");\n        }\n\n        public static File get(File root, Divisiones.Component division) {\n            return new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id());\n        }\n\n        public static File on(File root, Timetag timetag) {\n            return new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal("/\" + timetag + \".led\");\n        }\n\n        public static File on(File root, Divisiones.Component division, Timetag timetag) {\n            return new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id() + \"/\" + timetag + \".led\");\n        }\n    }\n\n    public static class Reader {\n\n        public static List<LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(">> readAll(File root, Divisiones.Component division) {\n        \tFile[] leds = getLedFiles(new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id()));\n        \treturn Arrays.stream(leds).map(Reader::openLedStream).collect(Collectors.toList());\n        }\n\n        public static List<LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(">> read(File root, Divisiones.Component division, Timetag from, Timetag to) {\n        \tFile[] leds = getLedFiles(new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id()));\n        \treturn Arrays.stream(leds)\n        \t    .filter(led -> {\n        \t        final String name = led.getName();\n        \t        final Timetag timetag = Timetag.of(name.substring(0, name.indexOf('.')));\n        \t        return (timetag.equals(from) || timetag.isAfter(from)) && (timetag.equals(to) || timetag.isBefore(to));\n        \t    })\n        \t    .map(Reader::openLedStream)\n        \t    .collect(Collectors.toList());\n        }\n\n        public static LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> read(File root, Divisiones.Component division, Timetag timetag) {\n        \tFile[] leds = getLedFiles(new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id()));\n        \treturn Arrays.stream(leds)\n        \t    .filter(led -> {\n        \t        final String name = led.getName();\n        \t        final Timetag t = Timetag.of(name.substring(0, name.indexOf('.')));\n        \t        return t.equals(timetag);\n        \t    })\n        \t    .map(Reader::openLedStream)\n        \t    .findFirst().orElse(null);\n        }\n\n    \tpublic static LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> readFirst(File root, Divisiones.Component division) {\n        \tFile[] leds = getLedFiles(new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id()));\n        \tif(leds.length == 0) return LedStream.empty(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n            return openLedStream(leds[0]);\n        }\n\n    \tpublic static LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> readLast(File root, Divisiones.Component division) {\n            File[] leds = getLedFiles(new File(root, \"")}).output(new Rule.Output[]{this.mark("cube", new String[0])}).output(new Rule.Output[]{this.literal(".\" + division.id()));\n            if(leds.length == 0) return LedStream.empty(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n        \treturn openLedStream(leds[leds.length - 1]);\n    \t}\n\n    \tpublic static LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> readLedStream(File ledFile) {\n            return new LedReader(ledFile).read(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n        }\n\n        public static Led<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> readLed(File ledFile) {\n            return new LedReader(ledFile).readAll(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n        }\n\n        private static LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> openLedStream(File led) {\n        \tif(led == null || !led.exists()) return LedStream.empty(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n        \treturn new LedReader(led).read(")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal(".class);\n        }\n\n        private static File[] getLedFiles(File dir) {\n    \t\tFile[] leds = dir.listFiles(f -> f.getName().endsWith(\".led\"));\n    \t\tif(leds == null || leds.length == 0) return new File[0];\n    \t\tArrays.sort(leds, Comparator.comparing(File::getName));\n    \t\treturn leds;\n        }\n    }\n\n    public static class Writer {\n\n        public static void write(File file, LedStream.Builder<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> builder) {\n            write(file, builder.build());\n        }\n\n        public static void write(File file, LedStream<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> ledStream) {\n            new LedWriter(file).write(ledStream);\n        }\n\n        public static void write(File file, Led<")}).output(new Rule.Output[]{this.mark("name", new String[0])}).output(new Rule.Output[]{this.literal("> led) {\n            new LedWriter(file).write(led);\n        }\n    }\n}")}), this.rule().condition(this.trigger("axisimport"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("import ")}).output(new Rule.Output[]{this.mark("", new String[0])}).output(new Rule.Output[]{this.literal(".axis.*;")}), this.rule().condition(this.trigger("split"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("public enum Split {\n\t")}).output(new Rule.Output[]{this.mark("enum", new String[]{"asEnum"}).multiple(", ")}).output(new Rule.Output[]{this.literal(";\n\n\tpublic abstract String qn();\n\n\tpublic static Split splitByQn(String qn) {\n\t    for(Split split : values()) {\n\t        if(split.qn().equals(qn)) return split;\n\t    }\n\t    return null;\n\t}\n}")}), this.rule().condition(this.trigger("asenum"), new Rule.Condition[0]).output(new Rule.Output[]{this.mark("value", new String[]{"snakeCaseToCamelCase"})}).output(new Rule.Output[]{this.literal(" {\n\tpublic String qn() {\n\t\treturn \"")}).output(new Rule.Output[]{this.mark("qn", new String[0])}).output(new Rule.Output[]{this.literal("\";\n\t}\n}")}), this.rule().condition(this.trigger("nbits"), new Rule.Condition[0]).output(new Rule.Output[]{this.literal("NBits")})});
    }
}

