/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.accessor.ui;

import cottons.utils.StringHelper;
import io.intino.itrules.FrameBuilder;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.accessor.ui.templates.AppTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.templates.PassiveViewTemplate;
import io.intino.konos.builder.codegeneration.accessor.ui.templates.WebPackTemplate;
import io.intino.konos.builder.codegeneration.ui.UIRenderer;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.helpers.CodeGenerationHelper;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.Service;
import io.intino.konos.model.graph.Template;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class AppRenderer
extends UIRenderer {
    private final Service.UI service;

    protected AppRenderer(CompilationContext compilationContext, Service.UI service) {
        super(compilationContext, Target.Accessor);
        this.service = service;
    }

    @Override
    public void render() {
        this.writeApp();
        this.writePassiveView();
        this.writeWebPack();
    }

    private void writeApp() {
        CodeGenerationHelper.createIfNotExists(new File(this.gen() + File.separator + "apps"));
        this.resourcesWithTemplate().forEach(r -> {
            FrameBuilder builder = new FrameBuilder(new String[]{"app"});
            builder.add("page", (Object)new FrameBuilder(new String[]{"page"}).add("templateName", (Object)r.asPage().template().name$()).toFrame());
            builder.add("webModuleName", (Object)(this.context.webModuleDirectory() != null ? this.context.webModuleDirectory().getName() : ""));
            this.addPatterns(r.asPage().template(), builder);
            Commons.write(new File(this.gen() + File.separator + "apps" + File.separator + Formatters.firstUpperCase(r.asPage().template().name$()) + ".js").toPath(), this.setup(new AppTemplate()).render((Object)builder.toFrame()));
        });
    }

    private void addPatterns(Template template, FrameBuilder builder) {
        List patterns = this.service.resourceList().stream().filter(r -> r.isPage() && r.asPage().template() == template).map(this::patternOf).filter(p -> !p.isEmpty()).collect(Collectors.toList());
        patterns.stream().sorted((o1, o2) -> Integer.compare(o2.length(), o1.length())).forEach(p -> builder.add("pattern", (Object)new FrameBuilder(new String[]{"pattern"}).add("value", p)));
    }

    private void writePassiveView() {
        PassiveViewTemplate template = new PassiveViewTemplate();
        File notifiersFile = CodeGenerationHelper.createIfNotExists(new File(this.gen() + "/displays/notifiers"));
        File requestersFile = CodeGenerationHelper.createIfNotExists(new File(this.gen() + "/displays/requesters"));
        Commons.write(new File(notifiersFile + File.separator + "Notifier.js").toPath(), template.render(new FrameBuilder(new String[]{"notifier"})));
        Commons.write(new File(requestersFile + File.separator + "Requester.js").toPath(), template.render(new FrameBuilder(new String[]{"requester"})));
    }

    private void writeWebPack() {
        WebPackTemplate template = new WebPackTemplate();
        FrameBuilder builder = new FrameBuilder(new String[]{"webpack"});
        builder.add("outDirectory", this.normalize(this.context.configuration().outDirectory().getParentFile().getAbsolutePath()));
        builder.add("exclude", (Object)this.alexandriaFrame("exclude"));
        builder.add("alias", (Object)this.alexandriaFrame("alias"));
        builder.add("webModuleName", (Object)(this.context.webModuleDirectory() != null ? this.context.webModuleDirectory().getName() : ""));
        if (AppRenderer.isAlexandria(this.project())) {
            builder.add("alexandriaProject", (Object)"true");
        }
        this.resourcesWithTemplate().forEach(r -> builder.add("page", (Object)new FrameBuilder(new String[]{"page"}).add("templateName", (Object)r.asPage().template().name$()).toFrame()));
        Commons.write(new File(this.root(), "webpack.config.js").toPath(), this.setup(template).render((Object)builder.toFrame()));
    }

    private Object normalize(String path) {
        return path != null ? path.replaceAll("\\\\", "/").replaceAll("^.:", "") : path;
    }

    private FrameBuilder alexandriaFrame(String name) {
        FrameBuilder result = new FrameBuilder(new String[]{name});
        if (AppRenderer.isAlexandria(this.project())) {
            result.add("alexandriaProject");
        }
        result.add("use", (Object)"alexandria-ui-elements");
        this.service.useList().forEach(use -> result.add("use", (Object)StringHelper.camelCaseToSnakeCase((String)use.service())));
        return result;
    }

    public static boolean isAlexandria(String project) {
        return project != null && project.equalsIgnoreCase("alexandria");
    }

    public List<Service.UI.Resource> resourcesWithTemplate() {
        Map<Template, List<Service.UI.Resource>> result = this.service.resourceList().stream().filter(Service.UI.Resource::isPage).collect(Collectors.groupingBy(r -> r.asPage().template()));
        return result.values().stream().map(r -> (Service.UI.Resource)((Object)((Object)r.get(0)))).collect(Collectors.toList());
    }
}

