/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.bpm.parser;

import io.intino.konos.builder.codegeneration.bpm.parser.Link;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class State {
    private final String id;
    private final String label;
    private Type type;
    private TaskType taskType;
    private List<Link> links;
    private String comment;

    public State(String id, String label) {
        this.id = id;
        this.label = label;
        this.links = new ArrayList<Link>();
        this.type = Type.Intermediate;
        this.taskType = TaskType.Default;
    }

    public String id() {
        return this.id;
    }

    public Type type() {
        return this.type;
    }

    public void type(Type type) {
        this.type = type;
    }

    public TaskType taskType() {
        return this.taskType;
    }

    public State taskType(TaskType taskType) {
        this.taskType = taskType;
        return this;
    }

    public State link(State state, Link.Type type, boolean isDefault) {
        this.links.add(new Link().to(state).type(type).isDefault(isDefault));
        return this;
    }

    public List<Link> links() {
        return this.links;
    }

    public Link links(String name) {
        return this.links.stream().filter(ec -> ec.state().id().equals(name)).findFirst().orElse(null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        State state = (State)o;
        return Objects.equals(this.id, state.id);
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return this.label + ":" + this.type;
    }

    public String label() {
        return this.label;
    }

    public String comment() {
        return this.comment;
    }

    public void comment(String comment) {
        this.comment = comment;
    }

    public static enum TaskType {
        Default,
        User,
        Manual,
        Service,
        Script,
        BusinessRule,
        Send,
        Receive,
        CallActivity;

    }

    public static enum Type {
        Initial,
        Intermediate,
        Terminal;

    }
}

