/*
 * Decompiled with CFR 0.152.
 */
package io.intino.konos.builder.codegeneration.sentinel;

import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Template;
import io.intino.konos.builder.OutputItem;
import io.intino.konos.builder.codegeneration.Formatters;
import io.intino.konos.builder.codegeneration.Renderer;
import io.intino.konos.builder.codegeneration.Target;
import io.intino.konos.builder.codegeneration.action.WebHookActionRenderer;
import io.intino.konos.builder.codegeneration.sentinel.SentinelsTemplate;
import io.intino.konos.builder.context.CompilationContext;
import io.intino.konos.builder.context.KonosException;
import io.intino.konos.builder.helpers.Commons;
import io.intino.konos.model.graph.KonosGraph;
import io.intino.konos.model.graph.Sentinel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class SentinelsRenderer
extends Renderer {
    private final List<Sentinel> sentinels;

    public SentinelsRenderer(CompilationContext compilationContext, KonosGraph graph) {
        super(compilationContext, Target.Owner);
        this.sentinels = graph.sentinelList();
    }

    @Override
    public void render() throws KonosException {
        if (this.sentinels.isEmpty()) {
            return;
        }
        FrameBuilder builder = new FrameBuilder(new String[]{"Sentinels"}).add("package", (Object)this.packageName()).add("box", (Object)this.boxName()).add("sentinel", (Object)this.processSentinels());
        if (this.sentinels.stream().anyMatch(Sentinel::isWebHook)) {
            builder.add("hasWebhook", (Object)",");
        }
        Commons.writeFrame(this.gen(), "Sentinels", this.template().render((Object)builder.toFrame()));
        this.context.compiledFiles().add(new OutputItem(this.context.sourceFileOf(this.sentinels.get(0)), Commons.javaFile(this.gen(), "Sentinels").getAbsolutePath()));
    }

    private Frame[] processSentinels() throws KonosException {
        ArrayList list = new ArrayList();
        list.addAll(this.sentinels.stream().filter(t -> t.i$(Sentinel.SystemListener.class)).map(t -> (Sentinel.SystemListener)t.a$(Sentinel.SystemListener.class)).map(this::processSentinel).collect(Collectors.toList()));
        list.addAll(this.sentinels.stream().filter(t -> t.i$(Sentinel.FileListener.class)).map(t -> (Sentinel.FileListener)t.a$(Sentinel.FileListener.class)).map(this::processFileListenerSentinel).collect(Collectors.toList()));
        list.addAll(this.sentinels.stream().filter(t -> t.i$(Sentinel.WebHook.class)).map(t -> (Sentinel.WebHook)t.a$(Sentinel.WebHook.class)).map(this::processWebHookSentinel).collect(Collectors.toList()));
        for (Sentinel t2 : this.sentinels) {
            if (!t2.i$(Sentinel.WebHook.class)) continue;
            new WebHookActionRenderer(this.context, t2.asWebHook()).execute();
        }
        return list.toArray(new Frame[0]);
    }

    private Frame processWebHookSentinel(Sentinel.WebHook webHook) {
        FrameBuilder builder = new FrameBuilder(new String[]{"sentinel"}).add(((Object)((Object)webHook)).getClass().getSimpleName()).add("name", (Object)webHook.name$());
        builder.add("path", (Object)Formatters.customize("path", ("/webhook/" + webHook.path()).replace("//", "/")));
        builder.add("parameter", webHook.parameterList().stream().map(p -> new FrameBuilder(new String[]{"parameter"}).add("name", (Object)p.name$()).add("in", (Object)p.in().name()).toFrame()).toArray(Frame[]::new));
        return builder.toFrame();
    }

    private Frame processSentinel(Sentinel.SystemListener task) {
        FrameBuilder builder = new FrameBuilder().add("sentinel").add(((Object)((Object)task)).getClass().getSimpleName()).add("name", (Object)task.name$());
        builder.add("package", (Object)this.packageName());
        ArrayList<Frame> jobFrames = new ArrayList<Frame>();
        if (task.i$(Sentinel.ClockListener.class)) {
            Sentinel.ClockListener cron = (Sentinel.ClockListener)task.a$(Sentinel.ClockListener.class);
            FrameBuilder jobFrameBuilder = new FrameBuilder().add("job").add("Cron" + ((Object)((Object)task)).getClass().getSimpleName()).add("name", (Object)task.core$().id());
            jobFrameBuilder.add("cronTrigger").add("pattern", (Object)cron.pattern()).add("mean", (Object)cron.mean());
            if (cron.timeZone() != null) {
                jobFrameBuilder.add("timeZone", (Object)cron.timeZone());
            }
            jobFrames.add(jobFrameBuilder.toFrame());
        }
        if (task.i$(Sentinel.BootListener.class)) {
            FrameBuilder jobFrameBuilder = new FrameBuilder(new String[]{"onBootTrigger", "job", "Boot" + ((Object)((Object)task)).getClass().getSimpleName()}).add("name", (Object)task.core$().id());
            jobFrames.add(jobFrameBuilder.toFrame());
        }
        builder.add("job", (Object)jobFrames.toArray(new Frame[0]));
        return builder.toFrame();
    }

    private Frame processFileListenerSentinel(Sentinel.FileListener sentinel) {
        FrameBuilder builder = new FrameBuilder().add("sentinel").add(((Object)((Object)sentinel)).getClass().getSimpleName()).add("event", sentinel.events().stream().map(Enum::name).toArray(String[]::new)).add("file", (Object)Commons.fileFrame(sentinel.file(), this.packageName())).add("name", (Object)sentinel.name$()).add("package", (Object)this.packageName());
        return builder.toFrame();
    }

    private Template template() {
        return Formatters.customize(new SentinelsTemplate());
    }
}

